/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class CharacterSetAL16UTF16 extends CharacterSet
/*     */   implements CharacterRepConstants
/*     */ {
/* 217 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetAL16UTF16(int paramInt)
/*     */   {
/*  49 */     super(paramInt);
/*     */ 
/*  51 */     this.rep = 4;
/*     */   }
/*     */ 
/*     */   public boolean isLossyFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  60 */     return !paramCharacterSet.isUnicode();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  69 */     boolean bool = paramCharacterSet.rep <= 1024;
/*     */ 
/*  71 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean isUnicode()
/*     */   {
/*  78 */     return true;
/*     */   }
/*     */ 
/*     */   public String toStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*     */     try
/*     */     {
/*  92 */       char[] arrayOfChar = new char[paramInt2 >>> 1];
/*  93 */       int i = CharacterSet.convertAL16UTF16BytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, paramInt2, true);
/*     */ 
/*  96 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */ 
/* 102 */     return "";
/*     */   }
/*     */ 
/*     */   public String toString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 116 */       char[] arrayOfChar = new char[paramInt2 >>> 1];
/*     */ 
/* 121 */       int i = CharacterSet.convertAL16UTF16BytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, paramInt2, false);
/*     */ 
/* 124 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 128 */       failUTFConversion();
/*     */     }
/* 130 */     return "";
/*     */   }
/*     */ 
/*     */   public byte[] convert(String paramString)
/*     */     throws SQLException
/*     */   {
/* 138 */     return stringToAL16UTF16Bytes(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convertWithReplacement(String paramString)
/*     */   {
/* 145 */     return stringToAL16UTF16Bytes(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(CharacterSet paramCharacterSet, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     byte[] arrayOfByte;
/* 155 */     if (paramCharacterSet.rep == 4)
/*     */     {
/* 157 */       arrayOfByte = useOrCopy(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 161 */       String str = paramCharacterSet.toString(paramArrayOfByte, paramInt1, paramInt2);
/*     */ 
/* 163 */       arrayOfByte = stringToAL16UTF16Bytes(str);
/*     */     }
/*     */ 
/* 166 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 180 */     byte[] arrayOfByte = paramCharacterWalker.bytes;
/* 181 */     int k = paramCharacterWalker.next;
/* 182 */     int m = paramCharacterWalker.end;
/*     */ 
/* 185 */     if (k + 2 >= m)
/*     */     {
/* 187 */       failUTFConversion();
/*     */     }
/*     */ 
/* 190 */     int i = arrayOfByte[(k++)];
/* 191 */     int j = arrayOfByte[(k++)];
/* 192 */     int n = i << 8 & 0xFF00 | j;
/* 193 */     paramCharacterWalker.next = k;
/*     */ 
/* 195 */     return n;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 202 */     if (paramInt > 65535)
/*     */     {
/* 204 */       failUTFConversion();
/*     */     }
/*     */     else
/*     */     {
/* 208 */       need(paramCharacterBuffer, 2);
/*     */ 
/* 210 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> 8 & 0xFF));
/* 211 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt & 0xFF));
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetAL16UTF16
 * JD-Core Version:    0.6.2
 */