/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSet2ByteFixed extends CharacterSetWithConverter
/*     */ {
/*     */   static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter2ByteFixed";
/*     */   static final short MAX_7BIT = 127;
/*     */   static final short MIN_8BIT_SB = 161;
/*     */   static final short MAX_8BIT_SB = 223;
/*     */   static final short CHARLENGTH = 2;
/*     */   static Class m_charConvSuperclass;
/* 141 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSet2ByteFixed(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  81 */     super(paramInt, paramJdbcCharacterConverters);
/*     */   }
/*     */ 
/*     */   static CharacterSet2ByteFixed getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  93 */     if (paramJdbcCharacterConverters.getGroupId() == 6)
/*     */     {
/*  95 */       return new CharacterSet2ByteFixed(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/*  99 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 107 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/*     */ 
/* 109 */     paramCharacterWalker.next += 1;
/*     */ 
/* 112 */     if (paramCharacterWalker.bytes.length > paramCharacterWalker.next)
/*     */     {
/* 114 */       i = i << 8 | paramCharacterWalker.bytes[paramCharacterWalker.next];
/* 115 */       paramCharacterWalker.next += 1;
/*     */     }
/*     */     else
/*     */     {
/* 120 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182);
/* 121 */       localSQLException.fillInStackTrace();
/* 122 */       throw localSQLException;
/*     */     }
/*     */ 
/* 126 */     return i;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 133 */     need(paramCharacterBuffer, 2);
/*     */ 
/* 135 */     paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> 8 & 0xFF));
/* 136 */     paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt & 0xFF));
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSet2ByteFixed
 * JD-Core Version:    0.6.2
 */