/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.CharArrayReader;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Reader;
/*      */ import java.io.StringWriter;
/*      */ import java.io.Writer;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.LargeObjectAccessMode;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleClob;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class CLOB extends DatumWithConnection
/*      */   implements OracleClob
/*      */ {
/*      */   public static final int MAX_CHUNK_SIZE = 32768;
/*      */   public static final int DURATION_SESSION = 10;
/*      */   public static final int DURATION_CALL = 12;
/*      */   static final int OLD_WRONG_DURATION_SESSION = 1;
/*      */   static final int OLD_WRONG_DURATION_CALL = 2;
/*      */   public static final int MODE_READONLY = 0;
/*      */   public static final int MODE_READWRITE = 1;
/*      */   ClobDBAccess dbaccess;
/*   75 */   private int dbChunkSize = -1;
/*      */   private short csform;
/*   77 */   boolean isFree = false;
/*      */ 
/*   81 */   boolean fromObject = false;
/*      */ 
/*   86 */   long cachedLengthOfClobInChars = -1L;
/*      */ 
/*   91 */   char[] prefetchData = null;
/*      */ 
/*   93 */   int prefetchDataSize = 0;
/*      */ 
/*   97 */   boolean activePrefetch = false;
/*      */   static final int KDLCTLSIZE = 16;
/*      */   static final int KDF_FLAG = 88;
/*      */   static final int KDLIDDAT = 8;
/* 1858 */   transient CharacterSet dilCharacterSet = null;
/*      */   protected Object acProxy;
/* 2139 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   protected CLOB()
/*      */   {
/*      */   }
/*      */ 
/*      */   public CLOB(oracle.jdbc.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  115 */     this(paramOracleConnection, null);
/*      */   }
/*      */ 
/*      */   public CLOB(oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  127 */     this(paramOracleConnection, paramArrayOfByte);
/*      */ 
/*  129 */     this.fromObject = paramBoolean;
/*      */   }
/*      */ 
/*      */   public static final short getFormOfUseFromLocator(byte[] paramArrayOfByte)
/*      */   {
/*  139 */     short s = -1;
/*      */ 
/*  149 */     if ((paramArrayOfByte != null) && (paramArrayOfByte.length > 5))
/*      */     {
/*  151 */       if (((paramArrayOfByte[5] & 0x40) != 0) && ((paramArrayOfByte[5] & 0xFFFFFF80) == 0))
/*      */       {
/*  153 */         s = 2;
/*      */       }
/*  155 */       else s = 1;
/*      */     }
/*      */ 
/*  158 */     return s;
/*      */   }
/*      */ 
/*      */   public CLOB(oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  168 */     super(paramArrayOfByte);
/*      */ 
/*  171 */     if (paramArrayOfByte != null)
/*      */     {
/*  173 */       this.csform = getFormOfUseFromLocator(paramArrayOfByte);
/*      */     }
/*      */ 
/*  178 */     assertNotNull(paramOracleConnection);
/*  179 */     setPhysicalConnectionOf(paramOracleConnection);
/*      */ 
/*  181 */     this.dbaccess = ((oracle.jdbc.internal.OracleConnection)paramOracleConnection).createClobDBAccess();
/*      */ 
/*  185 */     this.dbaccess.incrementTempLobReferenceCount(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public CLOB(oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte, short paramShort)
/*      */     throws SQLException
/*      */   {
/*  193 */     this(paramOracleConnection, paramArrayOfByte);
/*      */ 
/*  195 */     short s = getFormOfUseFromLocator(paramArrayOfByte);
/*  196 */     if (s != -1)
/*      */     {
/*  198 */       if (paramShort != s)
/*      */       {
/*  203 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 184);
/*  204 */         localSQLException.fillInStackTrace();
/*  205 */         throw localSQLException;
/*      */       }
/*      */ 
/*  208 */       this.csform = s;
/*      */     }
/*      */     else {
/*  211 */       this.csform = paramShort;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isNCLOB()
/*      */   {
/*  227 */     return this.csform == 2;
/*      */   }
/*      */ 
/*      */   public long length()
/*      */     throws SQLException
/*      */   {
/*  251 */     if (this.isFree) {
/*  252 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  253 */       localSQLException.fillInStackTrace();
/*  254 */       throw localSQLException;
/*      */     }
/*      */ 
/*  259 */     long l = -1L;
/*  260 */     if ((this.activePrefetch) && (this.cachedLengthOfClobInChars != -1L))
/*  261 */       l = this.cachedLengthOfClobInChars;
/*  262 */     else if (canReadBasicLobDataInLocator())
/*      */     {
/*  264 */       l = dilGetChars().length;
/*      */     }
/*      */     else
/*  267 */       l = getDBAccess().length(this);
/*  268 */     return l;
/*      */   }
/*      */ 
/*      */   public String getSubString(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  302 */     if (this.isFree) {
/*  303 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  304 */       ((SQLException)localObject).fillInStackTrace();
/*  305 */       throw ((Throwable)localObject);
/*      */     }
/*  307 */     if ((paramInt < 0) || (paramLong < 1L))
/*      */     {
/*  310 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  311 */       ((SQLException)localObject).fillInStackTrace();
/*  312 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  316 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  318 */       return dilGetSubString(paramLong, paramInt);
/*      */     }
/*      */ 
/*  321 */     Object localObject = null;
/*      */ 
/*  323 */     if ((paramInt == 0) || ((this.activePrefetch) && ((this.cachedLengthOfClobInChars == 0L) || ((this.cachedLengthOfClobInChars > 0L) && (paramLong - 1L >= this.cachedLengthOfClobInChars)))))
/*      */     {
/*  331 */       localObject = new String();
/*      */     }
/*  334 */     else if ((this.prefetchData != null) && (this.prefetchDataSize > 0) && (this.cachedLengthOfClobInChars == this.prefetchDataSize) && (paramLong + paramInt - 1L <= this.cachedLengthOfClobInChars))
/*      */     {
/*  342 */       localObject = new String(this.prefetchData, (int)paramLong - 1, paramInt);
/*      */     }
/*      */     else
/*      */     {
/*  350 */       char[] arrayOfChar = getDBAccess().getCharBufferSync(paramInt);
/*      */ 
/*  354 */       int i = getChars(paramLong, paramInt, arrayOfChar);
/*      */ 
/*  356 */       if (i > 0)
/*      */       {
/*  358 */         localObject = new String(arrayOfChar, 0, i);
/*      */       }
/*      */       else
/*      */       {
/*  362 */         localObject = new String();
/*      */       }
/*      */ 
/*  365 */       getDBAccess().cacheBufferSync(arrayOfChar);
/*      */     }
/*      */ 
/*  368 */     return localObject;
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream()
/*      */     throws SQLException
/*      */   {
/*  389 */     if (this.isFree) {
/*  390 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  391 */       localSQLException.fillInStackTrace();
/*  392 */       throw localSQLException;
/*      */     }
/*  394 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  396 */       return dilGetCharacterStream(1L);
/*      */     }
/*      */ 
/*  399 */     return getDBAccess().newReader(this, getBufferSize(), 0L);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream()
/*      */     throws SQLException
/*      */   {
/*  420 */     if (this.isFree) {
/*  421 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  422 */       localSQLException.fillInStackTrace();
/*  423 */       throw localSQLException;
/*      */     }
/*  425 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  427 */       return dilGetAsciiStream(1L);
/*      */     }
/*      */ 
/*  430 */     return getDBAccess().newInputStream(this, getBufferSize(), 0L);
/*      */   }
/*      */ 
/*      */   public long position(String paramString, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  454 */     if (this.isFree) {
/*  455 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  456 */       localSQLException.fillInStackTrace();
/*  457 */       throw localSQLException;
/*      */     }
/*  459 */     return getDBAccess().position(this, paramString, paramLong);
/*      */   }
/*      */ 
/*      */   public long position(Clob paramClob, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  482 */     if (this.isFree) {
/*  483 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  484 */       localSQLException.fillInStackTrace();
/*  485 */       throw localSQLException;
/*      */     }
/*  487 */     return getDBAccess().position(this, (CLOB)paramClob, paramLong);
/*      */   }
/*      */ 
/*      */   public int getChars(long paramLong, int paramInt, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/*  512 */     if (this.isFree) {
/*  513 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  514 */       localSQLException.fillInStackTrace();
/*  515 */       throw localSQLException;
/*      */     }
/*  517 */     return getDBAccess().getChars(this, paramLong, paramInt, paramArrayOfChar);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Writer getCharacterOutputStream()
/*      */     throws SQLException
/*      */   {
/*  539 */     if (this.isFree) {
/*  540 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  541 */       localSQLException.fillInStackTrace();
/*  542 */       throw localSQLException;
/*      */     }
/*  544 */     return setCharacterStream(1L);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public OutputStream getAsciiOutputStream()
/*      */     throws SQLException
/*      */   {
/*  565 */     if (this.isFree) {
/*  566 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  567 */       localSQLException.fillInStackTrace();
/*  568 */       throw localSQLException;
/*      */     }
/*  570 */     return setAsciiStream(1L);
/*      */   }
/*      */ 
/*      */   public byte[] getLocator()
/*      */   {
/*  581 */     return getBytes();
/*      */   }
/*      */ 
/*      */   public void setLocator(byte[] paramArrayOfByte)
/*      */   {
/*  592 */     super.setBytes(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public int putChars(long paramLong, char[] paramArrayOfChar)
/*      */     throws SQLException
/*      */   {
/*  615 */     if (this.isFree) {
/*  616 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  617 */       localSQLException.fillInStackTrace();
/*  618 */       throw localSQLException;
/*      */     }
/*  620 */     return getDBAccess().putChars(this, paramLong, paramArrayOfChar, 0, paramArrayOfChar != null ? paramArrayOfChar.length : 0);
/*      */   }
/*      */ 
/*      */   public int putChars(long paramLong, char[] paramArrayOfChar, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  647 */     if (this.isFree) {
/*  648 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  649 */       localSQLException.fillInStackTrace();
/*  650 */       throw localSQLException;
/*      */     }
/*  652 */     return getDBAccess().putChars(this, paramLong, paramArrayOfChar, 0, paramInt);
/*      */   }
/*      */ 
/*      */   public int putChars(long paramLong, char[] paramArrayOfChar, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  677 */     if (this.isFree) {
/*  678 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  679 */       localSQLException.fillInStackTrace();
/*  680 */       throw localSQLException;
/*      */     }
/*  682 */     return getDBAccess().putChars(this, paramLong, paramArrayOfChar, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public int putString(long paramLong, String paramString)
/*      */     throws SQLException
/*      */   {
/*  704 */     if (this.isFree) {
/*  705 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  706 */       localSQLException.fillInStackTrace();
/*  707 */       throw localSQLException;
/*      */     }
/*  709 */     return setString(paramLong, paramString);
/*      */   }
/*      */ 
/*      */   public int getChunkSize()
/*      */     throws SQLException
/*      */   {
/*  730 */     if (this.isFree) {
/*  731 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  732 */       localSQLException.fillInStackTrace();
/*  733 */       throw localSQLException;
/*      */     }
/*  735 */     if (this.dbChunkSize <= 0)
/*      */     {
/*  737 */       this.dbChunkSize = getDBAccess().getChunkSize(this);
/*      */     }
/*      */ 
/*  740 */     return this.dbChunkSize;
/*      */   }
/*      */ 
/*      */   public int getBufferSize()
/*      */     throws SQLException
/*      */   {
/*  759 */     if (this.isFree) {
/*  760 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  761 */       localSQLException.fillInStackTrace();
/*  762 */       throw localSQLException;
/*      */     }
/*  764 */     int i = getChunkSize();
/*  765 */     int j = 0;
/*      */ 
/*  767 */     if ((i >= 32768) || (i <= 0))
/*      */     {
/*  769 */       j = 32768;
/*      */     }
/*      */     else
/*      */     {
/*  773 */       j = 32768 / i * i;
/*      */     }
/*  775 */     return j;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static CLOB empty_lob()
/*      */     throws SQLException
/*      */   {
/*  792 */     return getEmptyCLOB();
/*      */   }
/*      */ 
/*      */   public static CLOB getEmptyCLOB()
/*      */     throws SQLException
/*      */   {
/*  822 */     byte[] arrayOfByte = new byte[86];
/*      */ 
/*  824 */     arrayOfByte[1] = 84;
/*  825 */     arrayOfByte[5] = 24;
/*      */ 
/*  829 */     CLOB localCLOB = new CLOB();
/*      */ 
/*  831 */     localCLOB.setShareBytes(arrayOfByte);
/*      */ 
/*  833 */     return localCLOB;
/*      */   }
/*      */ 
/*      */   public boolean isEmptyLob()
/*      */     throws SQLException
/*      */   {
/*  858 */     if (this.isFree)
/*      */     {
/*  860 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  861 */       localSQLException.fillInStackTrace();
/*  862 */       throw localSQLException;
/*      */     }
/*      */ 
/*  865 */     return (shareBytes()[5] & 0x10) != 0;
/*      */   }
/*      */ 
/*      */   public boolean isSecureFile()
/*      */     throws SQLException
/*      */   {
/*  882 */     if (this.isFree) {
/*  883 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  884 */       localSQLException.fillInStackTrace();
/*  885 */       throw localSQLException;
/*      */     }
/*  887 */     boolean bool = (shareBytes()[7] & 0xFFFFFF80) != 0;
/*  888 */     return bool;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public OutputStream getAsciiOutputStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  909 */     if (this.isFree) {
/*  910 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  911 */       localSQLException.fillInStackTrace();
/*  912 */       throw localSQLException;
/*      */     }
/*  914 */     return getDBAccess().newOutputStream(this, getBufferSize(), paramLong, false);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Writer getCharacterOutputStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  935 */     if (this.isFree) {
/*  936 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  937 */       localSQLException.fillInStackTrace();
/*  938 */       throw localSQLException;
/*      */     }
/*  940 */     return getDBAccess().newWriter(this, getBufferSize(), paramLong, false);
/*      */   }
/*      */ 
/*      */   public InputStream getAsciiStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/*  959 */     if (this.isFree)
/*      */     {
/*  961 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  962 */       localSQLException.fillInStackTrace();
/*  963 */       throw localSQLException;
/*      */     }
/*      */ 
/*  966 */     if (paramLong == 0L)
/*      */     {
/*  968 */       if (!getPhysicalConnection().isLobStreamPosStandardCompliant())
/*      */       {
/*  970 */         paramLong = 1L;
/*      */       }
/*      */       else
/*      */       {
/*  975 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/*  976 */         localSQLException.fillInStackTrace();
/*  977 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  982 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  984 */       return dilGetAsciiStream(paramLong);
/*      */     }
/*      */ 
/*  987 */     return getDBAccess().newInputStream(this, getBufferSize(), paramLong);
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1007 */     if (this.isFree)
/*      */     {
/* 1009 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1010 */       localSQLException.fillInStackTrace();
/* 1011 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1014 */     if (paramLong == 0L)
/*      */     {
/* 1016 */       if (!getPhysicalConnection().isLobStreamPosStandardCompliant())
/*      */       {
/* 1018 */         paramLong = 1L;
/*      */       }
/*      */       else
/*      */       {
/* 1023 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1024 */         localSQLException.fillInStackTrace();
/* 1025 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1030 */     if (canReadBasicLobDataInLocator())
/*      */     {
/* 1032 */       return dilGetCharacterStream(paramLong);
/*      */     }
/*      */ 
/* 1035 */     return getDBAccess().newReader(this, getBufferSize(), paramLong);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void trim(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1056 */     if (this.isFree) {
/* 1057 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1058 */       localSQLException.fillInStackTrace();
/* 1059 */       throw localSQLException;
/*      */     }
/* 1061 */     truncate(paramLong);
/*      */   }
/*      */ 
/*      */   public static CLOB createTemporary(Connection paramConnection, boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1078 */     return createTemporary(paramConnection, paramBoolean, paramInt, (short)1);
/*      */   }
/*      */ 
/*      */   public static CLOB createTemporary(Connection paramConnection, boolean paramBoolean, int paramInt, short paramShort)
/*      */     throws SQLException
/*      */   {
/* 1098 */     int i = paramInt;
/*      */ 
/* 1100 */     if (paramInt == 1) {
/* 1101 */       i = 10;
/*      */     }
/* 1103 */     if (paramInt == 2) {
/* 1104 */       i = 12;
/*      */     }
/* 1106 */     if ((paramConnection == null) || ((i != 10) && (i != 12)))
/*      */     {
/* 1110 */       localObject = DatabaseError.createSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL");
/*      */ 
/* 1113 */       ((SQLException)localObject).fillInStackTrace();
/* 1114 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1118 */     Object localObject = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*      */ 
/* 1121 */     CLOB localCLOB = getDBAccess((Connection)localObject).createTemporaryClob((Connection)localObject, paramBoolean, i, paramShort);
/*      */ 
/* 1123 */     localCLOB.csform = getFormOfUseFromLocator(localCLOB.shareBytes());
/*      */ 
/* 1125 */     return localCLOB;
/*      */   }
/*      */ 
/*      */   public static void freeTemporary(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 1139 */     if (paramCLOB == null)
/* 1140 */       return;
/* 1141 */     paramCLOB.freeTemporary();
/*      */   }
/*      */ 
/*      */   public static boolean isTemporary(CLOB paramCLOB)
/*      */     throws SQLException
/*      */   {
/* 1157 */     if (paramCLOB == null) {
/* 1158 */       return false;
/*      */     }
/* 1160 */     return paramCLOB.isTemporary();
/*      */   }
/*      */ 
/*      */   public void freeTemporary()
/*      */     throws SQLException
/*      */   {
/* 1179 */     if (this.isFree) {
/* 1180 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1181 */       localSQLException.fillInStackTrace();
/* 1182 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1185 */     int i = getDBAccess().decrementTempLobReferenceCount(shareBytes());
/*      */ 
/* 1187 */     if (i == 0)
/* 1188 */       getDBAccess().freeTemporary(this, this.fromObject);
/*      */   }
/*      */ 
/*      */   public boolean isTemporary()
/*      */     throws SQLException
/*      */   {
/* 1208 */     if (this.isFree) {
/* 1209 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1210 */       localSQLException.fillInStackTrace();
/* 1211 */       throw localSQLException;
/*      */     }
/* 1213 */     return getDBAccess().isTemporary(this);
/*      */   }
/*      */ 
/*      */   public void open(LargeObjectAccessMode paramLargeObjectAccessMode)
/*      */     throws SQLException
/*      */   {
/* 1222 */     open(paramLargeObjectAccessMode.getCode());
/*      */   }
/*      */ 
/*      */   public void open(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1238 */     if (this.isFree) {
/* 1239 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1240 */       localSQLException.fillInStackTrace();
/* 1241 */       throw localSQLException;
/*      */     }
/* 1243 */     getDBAccess().open(this, paramInt);
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/* 1260 */     if (this.isFree) {
/* 1261 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1262 */       localSQLException.fillInStackTrace();
/* 1263 */       throw localSQLException;
/*      */     }
/* 1265 */     getDBAccess().close(this);
/*      */   }
/*      */ 
/*      */   public boolean isOpen()
/*      */     throws SQLException
/*      */   {
/* 1282 */     if (this.isFree) {
/* 1283 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1284 */       localSQLException.fillInStackTrace();
/* 1285 */       throw localSQLException;
/*      */     }
/* 1287 */     return getDBAccess().isOpen(this);
/*      */   }
/*      */ 
/*      */   public int setString(long paramLong, String paramString)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1319 */     if (this.isFree) {
/* 1320 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1321 */       localSQLException.fillInStackTrace();
/* 1322 */       throw localSQLException;
/*      */     }
/* 1324 */     if (paramLong < 1L)
/*      */     {
/* 1327 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
/* 1328 */       localSQLException.fillInStackTrace();
/* 1329 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1333 */     int i = 0;
/*      */ 
/* 1335 */     if ((paramString != null) && (paramString.length() != 0))
/* 1336 */       i = putChars(paramLong, paramString.toCharArray());
/* 1337 */     return i;
/*      */   }
/*      */ 
/*      */   public int setString(long paramLong, String paramString, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1373 */     if (this.isFree) {
/* 1374 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1375 */       localSQLException.fillInStackTrace();
/* 1376 */       throw localSQLException;
/*      */     }
/* 1378 */     if (paramLong < 1L)
/*      */     {
/* 1381 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
/* 1382 */       localSQLException.fillInStackTrace();
/* 1383 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1387 */     if (paramInt1 < 0)
/*      */     {
/* 1390 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0");
/* 1391 */       localSQLException.fillInStackTrace();
/* 1392 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1396 */     if (paramInt1 + paramInt2 > paramString.length())
/*      */     {
/* 1400 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ");
/* 1401 */       localSQLException.fillInStackTrace();
/* 1402 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1406 */     int i = 0;
/*      */ 
/* 1408 */     if ((paramString != null) && (paramString.length() != 0))
/* 1409 */       i = putChars(paramLong, paramString.toCharArray(), paramInt1, paramInt2);
/* 1410 */     return i;
/*      */   }
/*      */ 
/*      */   public OutputStream setAsciiStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1436 */     if (this.isFree) {
/* 1437 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1438 */       localSQLException.fillInStackTrace();
/* 1439 */       throw localSQLException;
/*      */     }
/* 1441 */     return getDBAccess().newOutputStream(this, getBufferSize(), paramLong, true);
/*      */   }
/*      */ 
/*      */   public Writer setCharacterStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1468 */     if (this.isFree) {
/* 1469 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1470 */       localSQLException.fillInStackTrace();
/* 1471 */       throw localSQLException;
/*      */     }
/* 1473 */     return getDBAccess().newWriter(this, getBufferSize(), paramLong, true);
/*      */   }
/*      */ 
/*      */   public void truncate(long paramLong)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1498 */     if (this.isFree) {
/* 1499 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1500 */       localSQLException.fillInStackTrace();
/* 1501 */       throw localSQLException;
/*      */     }
/* 1503 */     if (paramLong < 0L)
/*      */     {
/* 1506 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0");
/* 1507 */       localSQLException.fillInStackTrace();
/* 1508 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1512 */     getDBAccess().trim(this, paramLong);
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/* 1539 */     if (this.isFree) {
/* 1540 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1541 */       localSQLException.fillInStackTrace();
/* 1542 */       throw localSQLException;
/*      */     }
/* 1544 */     return this;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/* 1567 */     String str = paramClass.getName();
/*      */ 
/* 1569 */     return (str.compareTo("java.io.InputStream") == 0) || (str.compareTo("java.io.Reader") == 0);
/*      */   }
/*      */ 
/*      */   public Reader characterStreamValue()
/*      */     throws SQLException
/*      */   {
/* 1584 */     return getCharacterStream();
/*      */   }
/*      */ 
/*      */   public InputStream asciiStreamValue()
/*      */     throws SQLException
/*      */   {
/* 1598 */     return getAsciiStream();
/*      */   }
/*      */ 
/*      */   public InputStream binaryStreamValue()
/*      */     throws SQLException
/*      */   {
/* 1612 */     return getAsciiStream();
/*      */   }
/*      */ 
/*      */   public String stringValue()
/*      */     throws SQLException
/*      */   {
/* 1630 */     Reader localReader = getCharacterStream();
/* 1631 */     int i = getBufferSize();
/* 1632 */     int j = 0;
/* 1633 */     StringWriter localStringWriter = new StringWriter(i);
/* 1634 */     char[] arrayOfChar = new char[i];
/*      */     try
/*      */     {
/* 1638 */       while ((j = localReader.read(arrayOfChar)) != -1)
/*      */       {
/* 1640 */         localStringWriter.write(arrayOfChar, 0, j);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (IOException localIOException)
/*      */     {
/* 1646 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 1647 */       localSQLException.fillInStackTrace();
/* 1648 */       throw localSQLException;
/*      */     }
/*      */     catch (IndexOutOfBoundsException localIndexOutOfBoundsException)
/*      */     {
/* 1654 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 151);
/* 1655 */       localSQLException.fillInStackTrace();
/* 1656 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1660 */     return localStringWriter.getBuffer().substring(0);
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/* 1684 */     return new CLOB[paramInt];
/*      */   }
/*      */ 
/*      */   public ClobDBAccess getDBAccess()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1696 */     if (this.dbaccess == null)
/*      */     {
/* 1698 */       if (isEmptyLob())
/*      */       {
/* 1702 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 98);
/* 1703 */         localSQLException.fillInStackTrace();
/* 1704 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1708 */       this.dbaccess = getInternalConnection().createClobDBAccess();
/*      */     }
/*      */ 
/* 1711 */     if (getPhysicalConnection().isClosed())
/*      */     {
/* 1713 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1714 */       localSQLException.fillInStackTrace();
/* 1715 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1718 */     return this.dbaccess;
/*      */   }
/*      */ 
/*      */   public static ClobDBAccess getDBAccess(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1729 */     return ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().createClobDBAccess();
/*      */   }
/*      */ 
/*      */   public Connection getJavaSqlConnection()
/*      */     throws SQLException
/*      */   {
/* 1743 */     if (this.isFree) {
/* 1744 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1745 */       localSQLException.fillInStackTrace();
/* 1746 */       throw localSQLException;
/*      */     }
/* 1748 */     return super.getJavaSqlConnection();
/*      */   }
/*      */ 
/*      */   public final void setLength(long paramLong)
/*      */   {
/* 1759 */     this.cachedLengthOfClobInChars = paramLong;
/*      */   }
/*      */ 
/*      */   public final void setChunkSize(int paramInt)
/*      */   {
/* 1769 */     this.dbChunkSize = paramInt;
/*      */   }
/*      */ 
/*      */   public final void setPrefetchedData(char[] paramArrayOfChar)
/*      */   {
/* 1780 */     if (paramArrayOfChar == null)
/* 1781 */       setPrefetchedData(null, 0);
/*      */     else
/* 1783 */       setPrefetchedData(paramArrayOfChar, paramArrayOfChar.length);
/*      */   }
/*      */ 
/*      */   public final void setPrefetchedData(char[] paramArrayOfChar, int paramInt)
/*      */   {
/* 1794 */     this.prefetchData = paramArrayOfChar;
/* 1795 */     this.prefetchDataSize = paramInt;
/*      */   }
/*      */ 
/*      */   public final char[] getPrefetchedData()
/*      */   {
/* 1805 */     return this.prefetchData;
/*      */   }
/*      */ 
/*      */   public final int getPrefetchedDataSize()
/*      */   {
/* 1811 */     return this.prefetchDataSize;
/*      */   }
/*      */ 
/*      */   public final void setActivePrefetch(boolean paramBoolean)
/*      */   {
/* 1821 */     if ((this.activePrefetch) && (!paramBoolean))
/* 1822 */       clearCachedData();
/* 1823 */     this.activePrefetch = paramBoolean;
/*      */   }
/*      */ 
/*      */   public final void clearCachedData()
/*      */   {
/* 1833 */     this.cachedLengthOfClobInChars = -1L;
/* 1834 */     this.prefetchData = null;
/*      */   }
/*      */ 
/*      */   public final boolean isActivePrefetch()
/*      */   {
/* 1845 */     return this.activePrefetch;
/*      */   }
/*      */ 
/*      */   public boolean canReadBasicLobDataInLocator()
/*      */     throws SQLException
/*      */   {
/* 1868 */     byte[] arrayOfByte = shareBytes();
/* 1869 */     if ((arrayOfByte == null) || (arrayOfByte.length < 102))
/*      */     {
/* 1871 */       return false;
/*      */     }
/* 1873 */     if (!getPhysicalConnection().isDataInLocatorEnabled())
/*      */     {
/* 1875 */       return false;
/*      */     }
/* 1877 */     int i = arrayOfByte[6] & 0xFF;
/* 1878 */     int j = arrayOfByte[7] & 0xFF;
/* 1879 */     int k = (i & 0x8) == 8 ? 1 : 0;
/* 1880 */     int m = (j & 0xFFFFFF80) == -128 ? 1 : 0;
/* 1881 */     int n = 0;
/* 1882 */     if ((k != 0) && (m == 0))
/*      */     {
/* 1884 */       i1 = arrayOfByte[88] & 0xFF;
/* 1885 */       n = (i1 & 0x8) == 8 ? 1 : 0;
/*      */     }
/* 1887 */     int i1 = (k != 0) && (m == 0) && (n != 0) ? 1 : 0;
/* 1888 */     boolean bool = false;
/* 1889 */     if (i1 != 0)
/*      */     {
/* 1891 */       dilGetCharacterSet();
/* 1892 */       bool = !this.dilCharacterSet.isUnknown();
/*      */     }
/* 1894 */     return bool;
/*      */   }
/*      */ 
/*      */   int dilGetCharSetId()
/*      */     throws SQLException
/*      */   {
/* 1902 */     int i = shareBytes()[32];
/* 1903 */     int j = shareBytes()[33];
/* 1904 */     int k = (i & 0xFF) << 8 | j & 0xFF;
/* 1905 */     return k;
/*      */   }
/*      */ 
/*      */   boolean isMigratedAL16UTF16LE()
/*      */   {
/* 1911 */     int i = shareBytes()[7] & 0xFF;
/* 1912 */     return (i & 0x40) == 64;
/*      */   }
/*      */ 
/*      */   boolean isVariableWidth()
/*      */   {
/* 1917 */     int i = shareBytes()[6] & 0xFF;
/* 1918 */     int j = 128;
/* 1919 */     return (i & j) == j;
/*      */   }
/*      */ 
/*      */   void dilGetCharacterSet()
/*      */     throws SQLException
/*      */   {
/* 1925 */     if (this.dilCharacterSet == null)
/*      */     {
/* 1927 */       if (isMigratedAL16UTF16LE())
/*      */       {
/* 1929 */         this.dilCharacterSet = CharacterSet.make(2002);
/*      */       }
/* 1931 */       else if (isVariableWidth())
/*      */       {
/* 1933 */         this.dilCharacterSet = CharacterSet.make(2000);
/*      */       }
/*      */       else
/*      */       {
/* 1937 */         int i = dilGetCharSetId();
/* 1938 */         this.dilCharacterSet = CharacterSet.make(i);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   int dilLength()
/*      */   {
/* 1947 */     return shareBytes().length - 86 - 16;
/*      */   }
/*      */ 
/*      */   char[] dilGetChars()
/*      */     throws SQLException
/*      */   {
/* 1954 */     int i = dilLength();
/* 1955 */     byte[] arrayOfByte = new byte[i];
/* 1956 */     System.arraycopy(shareBytes(), 102, arrayOfByte, 0, i);
/* 1957 */     String str = this.dilCharacterSet.toStringWithReplacement(arrayOfByte, 0, i);
/* 1958 */     char[] arrayOfChar = str.toCharArray();
/* 1959 */     return arrayOfChar;
/*      */   }
/*      */ 
/*      */   InputStream dilGetAsciiStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1966 */     char[] arrayOfChar = dilGetChars();
/*      */     byte[] arrayOfByte;
/* 1968 */     if (paramLong - 1L > arrayOfChar.length)
/*      */     {
/* 1970 */       arrayOfByte = new byte[0];
/* 1971 */       return new ByteArrayInputStream(arrayOfByte);
/*      */     }
/*      */ 
/* 1976 */     if (dilGetCharSetId() == 1)
/*      */     {
/* 1978 */       arrayOfByte = new byte[arrayOfChar.length];
/* 1979 */       for (int i = 0; i < arrayOfChar.length; i++)
/* 1980 */         arrayOfByte[i] = ((byte)arrayOfChar[i]);
/*      */     }
/*      */     else
/*      */     {
/* 1984 */       CharacterSet localCharacterSet = CharacterSet.make(1);
/* 1985 */       arrayOfByte = localCharacterSet.convertWithReplacement(new String(arrayOfChar));
/*      */     }
/* 1987 */     return new ByteArrayInputStream(arrayOfByte);
/*      */   }
/*      */ 
/*      */   Reader dilGetCharacterStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1994 */     char[] arrayOfChar1 = dilGetChars();
/* 1995 */     int i = arrayOfChar1.length;
/*      */ 
/* 1997 */     if (paramLong - 1L > i)
/*      */     {
/* 1999 */       char[] arrayOfChar2 = new char[0];
/* 2000 */       return new CharArrayReader(arrayOfChar2);
/*      */     }
/*      */ 
/* 2003 */     return new CharArrayReader(arrayOfChar1, (int)(paramLong - 1L), 2147483647);
/*      */   }
/*      */ 
/*      */   String dilGetSubString(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2010 */     char[] arrayOfChar = dilGetChars();
/* 2011 */     if ((int)paramLong > arrayOfChar.length)
/*      */     {
/* 2013 */       return "";
/*      */     }
/* 2015 */     int i = (int)Math.min(paramInt, arrayOfChar.length - (paramLong - 1L));
/* 2016 */     if (i == 0)
/*      */     {
/* 2018 */       return "";
/*      */     }
/* 2020 */     return new String(arrayOfChar, (int)(paramLong - 1L), i);
/*      */   }
/*      */ 
/*      */   public void free()
/*      */     throws SQLException
/*      */   {
/* 2036 */     if (this.isFree) return;
/* 2037 */     if (isOpen()) close();
/* 2038 */     if (isTemporary()) freeTemporary();
/* 2039 */     this.isFree = true;
/* 2040 */     this.dbaccess = null;
/*      */   }
/*      */ 
/*      */   public Reader getCharacterStream(long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException1;
/* 2062 */     if (this.isFree)
/*      */     {
/* 2064 */       localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 2065 */       localSQLException1.fillInStackTrace();
/* 2066 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 2069 */     if (paramLong1 == 0L)
/*      */     {
/* 2071 */       if (!getPhysicalConnection().isLobStreamPosStandardCompliant())
/*      */       {
/* 2073 */         paramLong1 = 1L;
/*      */       }
/*      */       else
/*      */       {
/* 2078 */         localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2079 */         localSQLException1.fillInStackTrace();
/* 2080 */         throw localSQLException1;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2085 */     if (canReadBasicLobDataInLocator())
/*      */     {
/* 2087 */       return dilGetCharacterStream(paramLong1, paramLong2);
/*      */     }
/*      */ 
/* 2090 */     long l = length();
/* 2091 */     if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*      */     {
/* 2093 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2094 */       localSQLException2.fillInStackTrace();
/* 2095 */       throw localSQLException2;
/*      */     }
/* 2097 */     return getDBAccess().newReader(this, getChunkSize(), paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   Reader dilGetCharacterStream(long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 2103 */     if ((paramLong1 < 1L) || (paramLong2 < 0L))
/*      */     {
/* 2105 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2106 */       ((SQLException)localObject).fillInStackTrace();
/* 2107 */       throw ((Throwable)localObject);
/*      */     }
/* 2109 */     Object localObject = dilGetChars();
/* 2110 */     long l = localObject.length;
/* 2111 */     if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*      */     {
/* 2113 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 2114 */       localSQLException.fillInStackTrace();
/* 2115 */       throw localSQLException;
/*      */     }
/* 2117 */     return new CharArrayReader((char[])localObject, (int)(paramLong1 - 1L), (int)paramLong2);
/*      */   }
/*      */ 
/*      */   public void setBytes(byte[] paramArrayOfByte)
/*      */   {
/* 2123 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 2130 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 2135 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CLOB
 * JD-Core Version:    0.6.2
 */