/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.StringReader;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class CHAR extends Datum
/*     */ {
/*     */   static final long serialVersionUID = 5559010489982176244L;
/*  74 */   public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
/*     */   private CharacterSet charSet;
/*     */   private int oracleId;
/* 361 */   private static final byte[] empty = new byte[0];
/*     */ 
/* 925 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected CHAR()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CHAR(byte[] paramArrayOfByte, CharacterSet paramCharacterSet)
/*     */   {
/* 117 */     setValue(paramArrayOfByte, paramCharacterSet);
/*     */   }
/*     */ 
/*     */   public CHAR(byte[] paramArrayOfByte, int paramInt1, int paramInt2, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 139 */     if (paramArrayOfByte == null)
/*     */     {
/* 141 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 142 */       ((SQLException)localObject).fillInStackTrace();
/* 143 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 146 */     Object localObject = new byte[paramInt2];
/*     */ 
/* 148 */     System.arraycopy(paramArrayOfByte, paramInt1, localObject, 0, paramInt2);
/* 149 */     setValue((byte[])localObject, paramCharacterSet);
/*     */   }
/*     */ 
/*     */   public CHAR(String paramString, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 175 */     if (paramString == null)
/*     */     {
/* 177 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 178 */       localSQLException.fillInStackTrace();
/* 179 */       throw localSQLException;
/*     */     }
/*     */ 
/* 182 */     if (paramCharacterSet == null)
/*     */     {
/* 184 */       paramCharacterSet = DEFAULT_CHARSET;
/*     */     }
/*     */ 
/* 187 */     setValue(paramCharacterSet.convertWithReplacement(paramString), paramCharacterSet);
/*     */   }
/*     */ 
/*     */   public CHAR(Object paramObject, CharacterSet paramCharacterSet)
/*     */     throws SQLException
/*     */   {
/* 208 */     this(paramObject == null ? (String)null : paramObject.toString(), paramCharacterSet);
/*     */   }
/*     */ 
/*     */   public CharacterSet getCharacterSet()
/*     */   {
/* 225 */     if (this.charSet == null)
/*     */     {
/* 229 */       if (this.oracleId == 0)
/*     */       {
/* 231 */         this.oracleId = -1;
/*     */       }
/*     */ 
/* 234 */       if ((DEFAULT_CHARSET != null) && ((this.oracleId == -1) || (this.oracleId == DEFAULT_CHARSET.getOracleId())))
/*     */       {
/* 237 */         this.charSet = DEFAULT_CHARSET;
/*     */       }
/* 239 */       else this.charSet = CharacterSet.make(this.oracleId);
/*     */     }
/*     */ 
/* 242 */     return this.charSet;
/*     */   }
/*     */ 
/*     */   public int oracleId()
/*     */   {
/* 259 */     return this.oracleId;
/*     */   }
/*     */ 
/*     */   public String getString()
/*     */     throws SQLException
/*     */   {
/* 279 */     return getCharacterSet().toString(shareBytes(), 0, (int)getLength());
/*     */   }
/*     */ 
/*     */   public String getStringWithReplacement()
/*     */   {
/* 298 */     byte[] arrayOfByte = shareBytes();
/* 299 */     return getCharacterSet().toStringWithReplacement(arrayOfByte, 0, arrayOfByte.length);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 317 */     return getStringWithReplacement();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object paramObject)
/*     */   {
/* 328 */     boolean bool = this == paramObject;
/* 329 */     if ((!bool) && ((paramObject instanceof CHAR))) {
/* 330 */       CHAR localCHAR = (CHAR)paramObject;
/* 331 */       bool = (bytesEqual(localCHAR)) && (getCharacterSet().equals(localCHAR.getCharacterSet()));
/*     */     }
/*     */ 
/* 334 */     return bool;
/*     */   }
/*     */ 
/*     */   void setValue(byte[] paramArrayOfByte, CharacterSet paramCharacterSet)
/*     */   {
/* 350 */     this.charSet = (paramCharacterSet == null ? DEFAULT_CHARSET : paramCharacterSet);
/* 351 */     this.oracleId = this.charSet.getOracleId();
/*     */ 
/* 357 */     setShareBytes(paramArrayOfByte == null ? empty : paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */     throws SQLException
/*     */   {
/* 385 */     return stringValue();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 408 */     String str = paramClass.getName();
/* 409 */     return (str.compareTo("java.lang.String") == 0) || (str.compareTo("java.lang.Long") == 0) || (str.compareTo("java.math.BigDecimal") == 0) || (str.compareTo("java.io.InputStream") == 0) || (str.compareTo("java.sql.Date") == 0) || (str.compareTo("java.sql.Time") == 0) || (str.compareTo("java.sql.Timestamp") == 0) || (str.compareTo("java.io.Reader") == 0);
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 433 */     return toString();
/*     */   }
/*     */ 
/*     */   public boolean booleanValue()
/*     */     throws SQLException
/*     */   {
/* 476 */     String str = stringValue();
/*     */ 
/* 478 */     if ((str == null) || (str.trim().equals("0")) || (str.trim().compareToIgnoreCase("f") == 0) || (str.trim().compareToIgnoreCase("false") == 0) || (str.trim().compareToIgnoreCase("n") == 0) || (str.trim().compareToIgnoreCase("no") == 0))
/*     */     {
/* 485 */       return false;
/*     */     }
/* 487 */     if ((str.trim().equals("1")) || (str.trim().compareToIgnoreCase("t") == 0) || (str.trim().compareToIgnoreCase("true") == 0) || (str.trim().compareToIgnoreCase("y") == 0) || (str.trim().compareToIgnoreCase("yes") == 0))
/*     */     {
/* 493 */       return true;
/*     */     }
/*     */ 
/* 497 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 498 */     localSQLException.fillInStackTrace();
/* 499 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public int intValue()
/*     */     throws SQLException
/*     */   {
/* 518 */     long l = longValue();
/*     */ 
/* 520 */     if ((l > 2147483647L) || (l < -2147483648L))
/*     */     {
/* 523 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26);
/* 524 */       localSQLException.fillInStackTrace();
/* 525 */       throw localSQLException;
/*     */     }
/*     */ 
/* 528 */     return (int)l;
/*     */   }
/*     */ 
/*     */   public long longValue()
/*     */     throws SQLException
/*     */   {
/* 546 */     long l = 0L;
/*     */     try
/*     */     {
/* 550 */       l = Long.valueOf(stringValue().trim()).longValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 555 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 556 */       localSQLException.fillInStackTrace();
/* 557 */       throw localSQLException;
/*     */     }
/*     */ 
/* 560 */     return l;
/*     */   }
/*     */ 
/*     */   public float floatValue()
/*     */     throws SQLException
/*     */   {
/* 578 */     float f = 0.0F;
/*     */     try
/*     */     {
/* 582 */       f = Float.valueOf(stringValue().trim()).floatValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 587 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 588 */       localSQLException.fillInStackTrace();
/* 589 */       throw localSQLException;
/*     */     }
/*     */ 
/* 592 */     return f;
/*     */   }
/*     */ 
/*     */   public double doubleValue()
/*     */     throws SQLException
/*     */   {
/* 610 */     double d = 0.0D;
/*     */     try
/*     */     {
/* 614 */       d = Double.valueOf(stringValue().trim()).doubleValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 619 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59);
/* 620 */       localSQLException.fillInStackTrace();
/* 621 */       throw localSQLException;
/*     */     }
/*     */ 
/* 624 */     return d;
/*     */   }
/*     */ 
/*     */   public byte byteValue()
/*     */     throws SQLException
/*     */   {
/* 642 */     long l = longValue();
/*     */ 
/* 644 */     if ((l > 127L) || (l < -128L))
/*     */     {
/* 647 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26);
/* 648 */       localSQLException.fillInStackTrace();
/* 649 */       throw localSQLException;
/*     */     }
/*     */ 
/* 653 */     return (byte)(int)l;
/*     */   }
/*     */ 
/*     */   public Date dateValue()
/*     */     throws SQLException
/*     */   {
/* 671 */     return Date.valueOf(stringValue().trim());
/*     */   }
/*     */ 
/*     */   public Time timeValue()
/*     */     throws SQLException
/*     */   {
/* 689 */     return Time.valueOf(stringValue().trim());
/*     */   }
/*     */ 
/*     */   public Timestamp timestampValue()
/*     */     throws SQLException
/*     */   {
/* 707 */     return Timestamp.valueOf(stringValue().trim());
/*     */   }
/*     */ 
/*     */   public BigDecimal bigDecimalValue()
/*     */     throws SQLException
/*     */   {
/* 724 */     BigDecimal localBigDecimal = null;
/*     */     try
/*     */     {
/* 728 */       localBigDecimal = new BigDecimal(stringValue().trim());
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 733 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 12, "bigDecimalValue");
/* 734 */       localSQLException.fillInStackTrace();
/* 735 */       throw localSQLException;
/*     */     }
/*     */ 
/* 738 */     return localBigDecimal;
/*     */   }
/*     */ 
/*     */   public Reader characterStreamValue()
/*     */     throws SQLException
/*     */   {
/* 756 */     return new StringReader(getString());
/*     */   }
/*     */ 
/*     */   public InputStream asciiStreamValue()
/*     */     throws SQLException
/*     */   {
/* 774 */     return getStream();
/*     */   }
/*     */ 
/*     */   public InputStream binaryStreamValue()
/*     */     throws SQLException
/*     */   {
/* 792 */     return getStream();
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 815 */     return new String[paramInt];
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 830 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CHAR
 * JD-Core Version:    0.6.2
 */