/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.io.Reader;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import oracle.jdbc.LargeObjectAccessMode;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleBlob;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class BLOB extends DatumWithConnection
/*      */   implements OracleBlob
/*      */ {
/*      */   public static final int MAX_CHUNK_SIZE = 32768;
/*      */   public static final int DURATION_SESSION = 10;
/*      */   public static final int DURATION_CALL = 12;
/*      */   static final int OLD_WRONG_DURATION_SESSION = 1;
/*      */   static final int OLD_WRONG_DURATION_CALL = 2;
/*      */   public static final int MODE_READONLY = 0;
/*      */   public static final int MODE_READWRITE = 1;
/*      */   BlobDBAccess dbaccess;
/*   74 */   int dbChunkSize = -1;
/*   75 */   boolean isFree = false;
/*      */ 
/*   78 */   boolean fromObject = false;
/*      */ 
/*   81 */   private long cachedLobLength = -1L;
/*      */   private byte[] prefetchData;
/*   83 */   private int prefetchDataSize = 0;
/*   84 */   private boolean activePrefetch = false;
/*      */   static final int KDLCTLSIZE = 16;
/*      */   static final int KDF_FLAG = 88;
/*      */   static final int KDLIDDAT = 8;
/*      */   Object acProxy;
/* 1591 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   protected BLOB()
/*      */   {
/*      */   }
/*      */ 
/*      */   public BLOB(oracle.jdbc.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  102 */     this(paramOracleConnection, null);
/*      */   }
/*      */ 
/*      */   public BLOB(oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  117 */     this(paramOracleConnection, paramArrayOfByte);
/*      */ 
/*  119 */     this.fromObject = paramBoolean;
/*      */   }
/*      */ 
/*      */   public BLOB(oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  133 */     super(paramArrayOfByte);
/*      */ 
/*  135 */     assertNotNull(paramOracleConnection);
/*  136 */     setPhysicalConnectionOf(paramOracleConnection);
/*      */ 
/*  138 */     this.dbaccess = getPhysicalConnection().createBlobDBAccess();
/*      */ 
/*  141 */     this.dbaccess.incrementTempLobReferenceCount(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public long length()
/*      */     throws SQLException
/*      */   {
/*  161 */     if (this.isFree) {
/*  162 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  163 */       localSQLException.fillInStackTrace();
/*  164 */       throw localSQLException;
/*      */     }
/*  166 */     long l = -1L;
/*      */ 
/*  170 */     if ((this.activePrefetch) && (this.cachedLobLength != -1L))
/*  171 */       l = this.cachedLobLength;
/*  172 */     else if (canReadBasicLobDataInLocator())
/*  173 */       l = dilLength();
/*      */     else
/*  175 */       l = getDBAccess().length(this);
/*  176 */     return l;
/*      */   }
/*      */ 
/*      */   public byte[] getBytes(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  205 */     if (this.isFree) {
/*  206 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  207 */       ((SQLException)localObject).fillInStackTrace();
/*  208 */       throw ((Throwable)localObject);
/*      */     }
/*  210 */     if ((paramInt < 0) || (paramLong < 1L))
/*      */     {
/*  213 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getBytes()");
/*  214 */       ((SQLException)localObject).fillInStackTrace();
/*  215 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  219 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  221 */       return dilGetBytes(paramLong, paramInt);
/*      */     }
/*      */ 
/*  224 */     Object localObject = null;
/*      */ 
/*  226 */     if (paramInt == 0) {
/*  227 */       return new byte[0];
/*      */     }
/*  229 */     if ((this.activePrefetch) && ((this.cachedLobLength == 0L) || ((this.cachedLobLength > 0L) && (paramLong - 1L >= this.cachedLobLength))))
/*      */     {
/*  235 */       localObject = null;
/*      */     }
/*      */     else {
/*  238 */       long l = 0L;
/*      */       byte[] arrayOfByte;
/*  240 */       if ((this.activePrefetch) && (this.cachedLobLength != -1L))
/*  241 */         arrayOfByte = new byte[Math.min((int)this.cachedLobLength, paramInt)];
/*      */       else {
/*  243 */         arrayOfByte = new byte[paramInt];
/*      */       }
/*      */ 
/*  246 */       l = getBytes(paramLong, paramInt, arrayOfByte);
/*      */ 
/*  248 */       if (l > 0L)
/*      */       {
/*  250 */         if (l == paramInt)
/*      */         {
/*  252 */           localObject = arrayOfByte;
/*      */         }
/*      */         else
/*      */         {
/*  259 */           localObject = new byte[(int)l];
/*      */ 
/*  261 */           System.arraycopy(arrayOfByte, 0, localObject, 0, (int)l);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  266 */     return localObject;
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream()
/*      */     throws SQLException
/*      */   {
/*  285 */     if (this.isFree) {
/*  286 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  287 */       localSQLException.fillInStackTrace();
/*  288 */       throw localSQLException;
/*      */     }
/*  290 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  292 */       return dilGetBinaryStream(1L);
/*      */     }
/*  294 */     return getDBAccess().newInputStream(this, getBufferSize(), 0L);
/*      */   }
/*      */ 
/*      */   public long position(byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  317 */     if (this.isFree) {
/*  318 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  319 */       localSQLException.fillInStackTrace();
/*  320 */       throw localSQLException;
/*      */     }
/*  322 */     return getDBAccess().position(this, paramArrayOfByte, paramLong);
/*      */   }
/*      */ 
/*      */   public long position(Blob paramBlob, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  345 */     if (this.isFree) {
/*  346 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  347 */       localSQLException.fillInStackTrace();
/*  348 */       throw localSQLException;
/*      */     }
/*  350 */     return getDBAccess().position(this, (BLOB)paramBlob, paramLong);
/*      */   }
/*      */ 
/*      */   public int getBytes(long paramLong, int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/*  375 */     if (this.isFree) {
/*  376 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  377 */       localSQLException.fillInStackTrace();
/*  378 */       throw localSQLException;
/*      */     }
/*  380 */     if ((paramInt < 0) || (paramLong < 0L))
/*      */     {
/*  383 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getBytes()");
/*  384 */       localSQLException.fillInStackTrace();
/*  385 */       throw localSQLException;
/*      */     }
/*      */ 
/*  388 */     if (paramArrayOfByte.length < paramInt)
/*      */     {
/*  390 */       paramInt = paramArrayOfByte.length;
/*      */     }
/*  392 */     return getDBAccess().getBytes(this, paramLong, paramInt, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public int putBytes(long paramLong, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  416 */     if (this.isFree) {
/*  417 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  418 */       localSQLException.fillInStackTrace();
/*  419 */       throw localSQLException;
/*      */     }
/*  421 */     return setBytes(paramLong, paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public int putBytes(long paramLong, byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  448 */     if (this.isFree) {
/*  449 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  450 */       localSQLException.fillInStackTrace();
/*  451 */       throw localSQLException;
/*      */     }
/*  453 */     return setBytes(paramLong, paramArrayOfByte, 0, paramInt);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public OutputStream getBinaryOutputStream()
/*      */     throws SQLException
/*      */   {
/*  474 */     if (this.isFree) {
/*  475 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  476 */       localSQLException.fillInStackTrace();
/*  477 */       throw localSQLException;
/*      */     }
/*  479 */     return setBinaryStream(1L);
/*      */   }
/*      */ 
/*      */   public byte[] getLocator()
/*      */   {
/*  490 */     return getBytes();
/*      */   }
/*      */ 
/*      */   public void setLocator(byte[] paramArrayOfByte)
/*      */   {
/*  501 */     super.setBytes(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public int getChunkSize()
/*      */     throws SQLException
/*      */   {
/*  520 */     if (this.isFree) {
/*  521 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  522 */       localSQLException.fillInStackTrace();
/*  523 */       throw localSQLException;
/*      */     }
/*  525 */     if (this.dbChunkSize <= 0)
/*      */     {
/*  527 */       this.dbChunkSize = getDBAccess().getChunkSize(this);
/*      */     }
/*      */ 
/*  530 */     return this.dbChunkSize;
/*      */   }
/*      */ 
/*      */   public int getBufferSize()
/*      */     throws SQLException
/*      */   {
/*  549 */     if (this.isFree) {
/*  550 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  551 */       localSQLException.fillInStackTrace();
/*  552 */       throw localSQLException;
/*      */     }
/*  554 */     int i = getChunkSize();
/*  555 */     int j = i;
/*      */ 
/*  557 */     if ((i >= 32768) || (i <= 0))
/*      */     {
/*  559 */       j = 32768;
/*      */     }
/*      */     else
/*      */     {
/*  563 */       j = 32768 / i * i;
/*      */     }
/*      */ 
/*  566 */     return j;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static BLOB empty_lob()
/*      */     throws SQLException
/*      */   {
/*  583 */     return getEmptyBLOB();
/*      */   }
/*      */ 
/*      */   public static BLOB getEmptyBLOB()
/*      */     throws SQLException
/*      */   {
/*  614 */     byte[] arrayOfByte = new byte[86];
/*      */ 
/*  616 */     arrayOfByte[1] = 84;
/*  617 */     arrayOfByte[5] = 24;
/*      */ 
/*  622 */     BLOB localBLOB = new BLOB();
/*      */ 
/*  624 */     localBLOB.setShareBytes(arrayOfByte);
/*      */ 
/*  626 */     return localBLOB;
/*      */   }
/*      */ 
/*      */   public boolean isEmptyLob()
/*      */     throws SQLException
/*      */   {
/*  653 */     if (this.isFree) {
/*  654 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  655 */       localSQLException.fillInStackTrace();
/*  656 */       throw localSQLException;
/*      */     }
/*  658 */     boolean bool = (shareBytes()[5] & 0x10) != 0;
/*      */ 
/*  660 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean isSecureFile()
/*      */     throws SQLException
/*      */   {
/*  677 */     if (this.isFree) {
/*  678 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  679 */       localSQLException.fillInStackTrace();
/*  680 */       throw localSQLException;
/*      */     }
/*  682 */     boolean bool = (shareBytes()[7] & 0xFFFFFF80) != 0;
/*  683 */     return bool;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public OutputStream getBinaryOutputStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  705 */     if (this.isFree) {
/*  706 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  707 */       localSQLException.fillInStackTrace();
/*  708 */       throw localSQLException;
/*      */     }
/*  710 */     return getDBAccess().newOutputStream(this, getBufferSize(), paramLong, false);
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  730 */     if (this.isFree) {
/*  731 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  732 */       localSQLException.fillInStackTrace();
/*  733 */       throw localSQLException;
/*      */     }
/*  735 */     if (canReadBasicLobDataInLocator())
/*      */     {
/*  737 */       return dilGetBinaryStream(paramLong);
/*      */     }
/*  739 */     return getDBAccess().newInputStream(this, getBufferSize(), paramLong);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void trim(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  760 */     if (this.isFree) {
/*  761 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  762 */       localSQLException.fillInStackTrace();
/*  763 */       throw localSQLException;
/*      */     }
/*  765 */     truncate(paramLong);
/*      */   }
/*      */ 
/*      */   public static BLOB createTemporary(Connection paramConnection, boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  782 */     int i = paramInt;
/*      */ 
/*  784 */     if (paramInt == 1) {
/*  785 */       i = 10;
/*      */     }
/*  787 */     if (paramInt == 2) {
/*  788 */       i = 12;
/*      */     }
/*  790 */     if ((paramConnection == null) || ((i != 10) && (i != 12)))
/*      */     {
/*  795 */       localObject = DatabaseError.createSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or to DURATION_CALL");
/*      */ 
/*  798 */       ((SQLException)localObject).fillInStackTrace();
/*  799 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  803 */     Object localObject = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*      */ 
/*  806 */     return getDBAccess((Connection)localObject).createTemporaryBlob((Connection)localObject, paramBoolean, i);
/*      */   }
/*      */ 
/*      */   public static void freeTemporary(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/*  820 */     if (paramBLOB == null) {
/*  821 */       return;
/*      */     }
/*  823 */     paramBLOB.freeTemporary();
/*      */   }
/*      */ 
/*      */   public static boolean isTemporary(BLOB paramBLOB)
/*      */     throws SQLException
/*      */   {
/*  839 */     if (paramBLOB == null) {
/*  840 */       return false;
/*      */     }
/*  842 */     return paramBLOB.isTemporary();
/*      */   }
/*      */ 
/*      */   public void freeTemporary()
/*      */     throws SQLException
/*      */   {
/*  861 */     if (this.isFree) {
/*  862 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  863 */       localSQLException.fillInStackTrace();
/*  864 */       throw localSQLException;
/*      */     }
/*      */ 
/*  867 */     int i = getDBAccess().decrementTempLobReferenceCount(shareBytes());
/*      */ 
/*  869 */     if (i == 0)
/*  870 */       getDBAccess().freeTemporary(this, this.fromObject);
/*      */   }
/*      */ 
/*      */   public boolean isTemporary()
/*      */     throws SQLException
/*      */   {
/*  890 */     if (this.isFree) {
/*  891 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  892 */       localSQLException.fillInStackTrace();
/*  893 */       throw localSQLException;
/*      */     }
/*  895 */     return getDBAccess().isTemporary(this);
/*      */   }
/*      */ 
/*      */   public void open(LargeObjectAccessMode paramLargeObjectAccessMode)
/*      */     throws SQLException
/*      */   {
/*  904 */     open(paramLargeObjectAccessMode.getCode());
/*      */   }
/*      */ 
/*      */   public void open(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  920 */     if (this.isFree) {
/*  921 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  922 */       localSQLException.fillInStackTrace();
/*  923 */       throw localSQLException;
/*      */     }
/*  925 */     getDBAccess().open(this, paramInt);
/*      */   }
/*      */ 
/*      */   public void close()
/*      */     throws SQLException
/*      */   {
/*  941 */     if (this.isFree) {
/*  942 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  943 */       localSQLException.fillInStackTrace();
/*  944 */       throw localSQLException;
/*      */     }
/*  946 */     getDBAccess().close(this);
/*      */   }
/*      */ 
/*      */   public boolean isOpen()
/*      */     throws SQLException
/*      */   {
/*  963 */     if (this.isFree) {
/*  964 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/*  965 */       localSQLException.fillInStackTrace();
/*  966 */       throw localSQLException;
/*      */     }
/*  968 */     return getDBAccess().isOpen(this);
/*      */   }
/*      */ 
/*      */   public int setBytes(long paramLong, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  999 */     if (this.isFree) {
/* 1000 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1001 */       localSQLException.fillInStackTrace();
/* 1002 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1005 */     return getDBAccess().putBytes(this, paramLong, paramArrayOfByte, 0, paramArrayOfByte != null ? paramArrayOfByte.length : 0);
/*      */   }
/*      */ 
/*      */   public int setBytes(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1041 */     if (this.isFree) {
/* 1042 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1043 */       localSQLException.fillInStackTrace();
/* 1044 */       throw localSQLException;
/*      */     }
/* 1046 */     return getDBAccess().putBytes(this, paramLong, paramArrayOfByte, paramInt1, paramInt2);
/*      */   }
/*      */ 
/*      */   public OutputStream setBinaryStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1074 */     if (this.isFree) {
/* 1075 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1076 */       localSQLException.fillInStackTrace();
/* 1077 */       throw localSQLException;
/*      */     }
/* 1079 */     return getDBAccess().newOutputStream(this, getBufferSize(), paramLong, true);
/*      */   }
/*      */ 
/*      */   public void truncate(long paramLong)
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1103 */     if (this.isFree) {
/* 1104 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1105 */       localSQLException.fillInStackTrace();
/* 1106 */       throw localSQLException;
/*      */     }
/* 1108 */     if (paramLong < 0L)
/*      */     {
/* 1111 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "'len' should be >= 0. ");
/* 1112 */       localSQLException.fillInStackTrace();
/* 1113 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1116 */     getDBAccess().trim(this, paramLong);
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/* 1145 */     if (this.isFree) {
/* 1146 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1147 */       localSQLException.fillInStackTrace();
/* 1148 */       throw localSQLException;
/*      */     }
/* 1150 */     return this;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/* 1175 */     String str = paramClass.getName();
/*      */ 
/* 1177 */     return (str.compareTo("java.io.InputStream") == 0) || (str.compareTo("java.io.Reader") == 0);
/*      */   }
/*      */ 
/*      */   public Reader characterStreamValue()
/*      */     throws SQLException
/*      */   {
/* 1192 */     getInternalConnection(); return getDBAccess().newConversionReader(this, 8);
/*      */   }
/*      */ 
/*      */   public InputStream asciiStreamValue()
/*      */     throws SQLException
/*      */   {
/* 1207 */     getInternalConnection(); return getDBAccess().newConversionInputStream(this, 2);
/*      */   }
/*      */ 
/*      */   public InputStream binaryStreamValue()
/*      */     throws SQLException
/*      */   {
/* 1222 */     return getBinaryStream();
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/* 1244 */     return new BLOB[paramInt];
/*      */   }
/*      */ 
/*      */   public BlobDBAccess getDBAccess()
/*      */     throws SQLException
/*      */   {
/*      */     SQLException localSQLException;
/* 1255 */     if (this.dbaccess == null)
/*      */     {
/* 1257 */       if (isEmptyLob())
/*      */       {
/* 1260 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 98);
/* 1261 */         localSQLException.fillInStackTrace();
/* 1262 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1266 */       this.dbaccess = getInternalConnection().createBlobDBAccess();
/*      */     }
/*      */ 
/* 1269 */     if (getPhysicalConnection().isClosed())
/*      */     {
/* 1271 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 8);
/* 1272 */       localSQLException.fillInStackTrace();
/* 1273 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1276 */     return this.dbaccess;
/*      */   }
/*      */ 
/*      */   public static BlobDBAccess getDBAccess(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1287 */     return ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().createBlobDBAccess();
/*      */   }
/*      */ 
/*      */   public Connection getJavaSqlConnection()
/*      */     throws SQLException
/*      */   {
/* 1299 */     if (this.isFree) {
/* 1300 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1301 */       localSQLException.fillInStackTrace();
/* 1302 */       throw localSQLException;
/*      */     }
/* 1304 */     return super.getJavaSqlConnection();
/*      */   }
/*      */ 
/*      */   public final void setLength(long paramLong)
/*      */   {
/* 1315 */     this.cachedLobLength = paramLong;
/*      */   }
/*      */ 
/*      */   public final void setChunkSize(int paramInt)
/*      */   {
/* 1325 */     this.dbChunkSize = paramInt;
/*      */   }
/*      */ 
/*      */   public final void setPrefetchedData(byte[] paramArrayOfByte)
/*      */   {
/* 1336 */     if (paramArrayOfByte == null)
/* 1337 */       setPrefetchedData(null, 0);
/*      */     else
/* 1339 */       setPrefetchedData(paramArrayOfByte, paramArrayOfByte.length);
/*      */   }
/*      */ 
/*      */   public final void setPrefetchedData(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/* 1350 */     this.prefetchData = paramArrayOfByte;
/* 1351 */     this.prefetchDataSize = paramInt;
/*      */   }
/*      */ 
/*      */   public final byte[] getPrefetchedData()
/*      */   {
/* 1361 */     return this.prefetchData;
/*      */   }
/*      */ 
/*      */   public final int getPrefetchedDataSize()
/*      */   {
/* 1367 */     return this.prefetchDataSize;
/*      */   }
/*      */ 
/*      */   public final void setActivePrefetch(boolean paramBoolean)
/*      */   {
/* 1377 */     if ((this.activePrefetch) && (!paramBoolean))
/* 1378 */       clearCachedData();
/* 1379 */     this.activePrefetch = paramBoolean;
/*      */   }
/*      */ 
/*      */   public final void clearCachedData()
/*      */   {
/* 1389 */     this.cachedLobLength = -1L;
/* 1390 */     this.prefetchData = null;
/*      */   }
/*      */ 
/*      */   public final boolean isActivePrefetch()
/*      */   {
/* 1401 */     return this.activePrefetch;
/*      */   }
/*      */ 
/*      */   public boolean canReadBasicLobDataInLocator()
/*      */     throws SQLException
/*      */   {
/* 1422 */     byte[] arrayOfByte = shareBytes();
/* 1423 */     if ((arrayOfByte == null) || (arrayOfByte.length < 102))
/*      */     {
/* 1425 */       return false;
/*      */     }
/* 1427 */     if (!getPhysicalConnection().isDataInLocatorEnabled())
/*      */     {
/* 1429 */       return false;
/*      */     }
/* 1431 */     int i = arrayOfByte[6] & 0xFF;
/* 1432 */     int j = arrayOfByte[7] & 0xFF;
/* 1433 */     int k = (i & 0x8) == 8 ? 1 : 0;
/* 1434 */     int m = (j & 0xFFFFFF80) == -128 ? 1 : 0;
/* 1435 */     int n = 0;
/* 1436 */     if ((k != 0) && (m == 0))
/*      */     {
/* 1438 */       i1 = arrayOfByte[88] & 0xFF;
/* 1439 */       n = (i1 & 0x8) == 8 ? 1 : 0;
/*      */     }
/* 1441 */     int i1 = (k != 0) && (m == 0) && (n != 0) ? 1 : 0;
/* 1442 */     return i1;
/*      */   }
/*      */ 
/*      */   int dilLength()
/*      */   {
/* 1449 */     return shareBytes().length - 86 - 16;
/*      */   }
/*      */ 
/*      */   byte[] dilGetBytes(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1457 */     if (paramInt == 0)
/*      */     {
/* 1459 */       return new byte[0];
/*      */     }
/*      */ 
/* 1462 */     if (dilLength() == 0)
/*      */     {
/* 1464 */       return null;
/*      */     }
/* 1466 */     int i = (int)Math.min(paramInt, dilLength() - (paramLong - 1L));
/*      */ 
/* 1468 */     if (i <= 0)
/*      */     {
/* 1470 */       return null;
/*      */     }
/*      */ 
/* 1473 */     byte[] arrayOfByte = new byte[i];
/* 1474 */     System.arraycopy(shareBytes(), (int)(paramLong - 1L) + 86 + 16, arrayOfByte, 0, i);
/* 1475 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   InputStream dilGetBinaryStream(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1483 */     if (paramLong < 0L)
/*      */     {
/* 1485 */       throw new IllegalArgumentException("Illegal Arguments");
/*      */     }
/*      */ 
/* 1488 */     byte[] arrayOfByte = dilGetBytes(paramLong, dilLength());
/*      */ 
/* 1490 */     if (arrayOfByte == null)
/*      */     {
/* 1492 */       arrayOfByte = new byte[0];
/*      */     }
/*      */ 
/* 1495 */     return new ByteArrayInputStream(arrayOfByte);
/*      */   }
/*      */ 
/*      */   public void free()
/*      */     throws SQLException
/*      */   {
/* 1512 */     if (this.isFree) return;
/* 1513 */     if (isOpen()) close();
/* 1514 */     if (isTemporary()) freeTemporary();
/* 1515 */     this.isFree = true;
/* 1516 */     this.dbaccess = null;
/*      */   }
/*      */ 
/*      */   public InputStream getBinaryStream(long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 1538 */     if (this.isFree) {
/* 1539 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 192);
/* 1540 */       localSQLException1.fillInStackTrace();
/* 1541 */       throw localSQLException1;
/*      */     }
/* 1543 */     if (canReadBasicLobDataInLocator())
/*      */     {
/* 1545 */       return dilGetBinaryStream(paramLong1, paramLong2);
/*      */     }
/* 1547 */     long l = length();
/* 1548 */     if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > l) || (paramLong1 - 1L + paramLong2 > l))
/*      */     {
/* 1550 */       SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1551 */       localSQLException2.fillInStackTrace();
/* 1552 */       throw localSQLException2;
/*      */     }
/* 1554 */     return getDBAccess().newInputStream(this, getChunkSize(), paramLong1, paramLong2);
/*      */   }
/*      */ 
/*      */   InputStream dilGetBinaryStream(long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 1560 */     int i = dilLength();
/* 1561 */     if ((paramLong1 < 1L) || (paramLong2 < 0L) || (paramLong1 > i) || (paramLong1 - 1L + paramLong2 > i))
/*      */     {
/* 1563 */       localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 1564 */       ((SQLException)localObject).fillInStackTrace();
/* 1565 */       throw ((Throwable)localObject);
/*      */     }
/* 1567 */     Object localObject = dilGetBytes(paramLong1, i - (int)(paramLong1 - 1L));
/* 1568 */     return new ByteArrayInputStream((byte[])localObject, 0, (int)paramLong2);
/*      */   }
/*      */ 
/*      */   public void setBytes(byte[] paramArrayOfByte)
/*      */   {
/* 1575 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 1582 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 1587 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.BLOB
 * JD-Core Version:    0.6.2
 */