/*     */ package oracle.sql;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class BINARY_FLOAT extends Datum
/*     */ {
/*     */   static final long serialVersionUID = -4231112037190700631L;
/* 357 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public BINARY_FLOAT()
/*     */   {
/*     */   }
/*     */ 
/*     */   public BINARY_FLOAT(byte[] paramArrayOfByte)
/*     */   {
/*  47 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public BINARY_FLOAT(float paramFloat)
/*     */   {
/*  61 */     super(floatToCanonicalFormatBytes(paramFloat));
/*     */   }
/*     */ 
/*     */   public BINARY_FLOAT(Float paramFloat)
/*     */   {
/*  80 */     super(floatToCanonicalFormatBytes(paramFloat.floatValue()));
/*     */   }
/*     */ 
/*     */   public BINARY_FLOAT(String paramString)
/*     */     throws SQLException
/*     */   {
/* 100 */     this(stringToFloat(paramString));
/*     */   }
/*     */ 
/*     */   public BINARY_FLOAT(Boolean paramBoolean)
/*     */   {
/* 119 */     this(paramBoolean.booleanValue() ? 1 : 0);
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */     throws SQLException
/*     */   {
/* 146 */     return new Float(canonicalFormatBytesToFloat(getBytes()));
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 169 */     String str = paramClass.getName();
/*     */ 
/* 171 */     return (str.compareTo("java.lang.String") == 0) || (str.compareTo("java.lang.Float") == 0);
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 190 */     String str = Float.toString(canonicalFormatBytesToFloat(getBytes()));
/* 191 */     return str;
/*     */   }
/*     */ 
/*     */   public float floatValue()
/*     */     throws SQLException
/*     */   {
/* 210 */     return canonicalFormatBytesToFloat(getBytes());
/*     */   }
/*     */ 
/*     */   public double doubleValue()
/*     */     throws SQLException
/*     */   {
/* 228 */     return floatValue();
/*     */   }
/*     */ 
/*     */   public BigDecimal bigDecimalValue()
/*     */     throws SQLException
/*     */   {
/* 246 */     return new BigDecimal(floatValue());
/*     */   }
/*     */ 
/*     */   private static float stringToFloat(String paramString)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 257 */       return Float.valueOf(paramString).floatValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 262 */       SQLException localSQLException = DatabaseError.createSqlException(null, 59);
/* 263 */       localSQLException.fillInStackTrace();
/* 264 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 276 */     return new Float[paramInt];
/*     */   }
/*     */ 
/*     */   static byte[] floatToCanonicalFormatBytes(float paramFloat)
/*     */   {
/* 283 */     float f = paramFloat;
/*     */ 
/* 285 */     if (f == 0.0F)
/* 286 */       f = 0.0F;
/* 287 */     else if (f != f) {
/* 288 */       f = (0.0F / 0.0F);
/*     */     }
/* 290 */     int i = Float.floatToIntBits(f);
/* 291 */     byte[] arrayOfByte = new byte[4];
/*     */ 
/* 293 */     int j = i;
/*     */ 
/* 295 */     i >>= 8;
/*     */ 
/* 297 */     int k = i;
/*     */ 
/* 299 */     i >>= 8;
/*     */ 
/* 301 */     int m = i;
/*     */ 
/* 303 */     i >>= 8;
/*     */ 
/* 305 */     int n = i;
/*     */ 
/* 307 */     if ((n & 0x80) == 0) {
/* 308 */       n |= 128;
/*     */     }
/*     */     else {
/* 311 */       n ^= -1;
/* 312 */       m ^= -1;
/* 313 */       k ^= -1;
/* 314 */       j ^= -1;
/*     */     }
/*     */ 
/* 317 */     arrayOfByte[3] = ((byte)j);
/* 318 */     arrayOfByte[2] = ((byte)k);
/* 319 */     arrayOfByte[1] = ((byte)m);
/* 320 */     arrayOfByte[0] = ((byte)n);
/*     */ 
/* 322 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   static float canonicalFormatBytesToFloat(byte[] paramArrayOfByte)
/*     */   {
/* 330 */     int i = paramArrayOfByte[0];
/* 331 */     int j = paramArrayOfByte[1];
/* 332 */     int k = paramArrayOfByte[2];
/* 333 */     int m = paramArrayOfByte[3];
/*     */ 
/* 335 */     if ((i & 0x80) != 0)
/*     */     {
/* 337 */       i &= 127;
/* 338 */       j &= 255;
/* 339 */       k &= 255;
/* 340 */       m &= 255;
/*     */     }
/*     */     else
/*     */     {
/* 344 */       i = (i ^ 0xFFFFFFFF) & 0xFF;
/* 345 */       j = (j ^ 0xFFFFFFFF) & 0xFF;
/* 346 */       k = (k ^ 0xFFFFFFFF) & 0xFF;
/* 347 */       m = (m ^ 0xFFFFFFFF) & 0xFF;
/*     */     }
/*     */ 
/* 350 */     int n = i << 24 | j << 16 | k << 8 | m;
/*     */ 
/* 352 */     return Float.intBitsToFloat(n);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.BINARY_FLOAT
 * JD-Core Version:    0.6.2
 */