/*     */ package oracle.sql;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class BINARY_DOUBLE extends Datum
/*     */ {
/*     */   static final long serialVersionUID = 6718338151847341754L;
/* 378 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public BINARY_DOUBLE()
/*     */   {
/*     */   }
/*     */ 
/*     */   public BINARY_DOUBLE(byte[] paramArrayOfByte)
/*     */   {
/*  48 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public BINARY_DOUBLE(double paramDouble)
/*     */   {
/*  62 */     super(doubleToCanonicalFormatBytes(paramDouble));
/*     */   }
/*     */ 
/*     */   public BINARY_DOUBLE(Double paramDouble)
/*     */   {
/*  81 */     super(doubleToCanonicalFormatBytes(paramDouble.doubleValue()));
/*     */   }
/*     */ 
/*     */   public BINARY_DOUBLE(String paramString)
/*     */     throws SQLException
/*     */   {
/* 101 */     this(stringToDouble(paramString));
/*     */   }
/*     */ 
/*     */   public BINARY_DOUBLE(Boolean paramBoolean)
/*     */   {
/* 120 */     this(paramBoolean.booleanValue() ? 1 : 0);
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */     throws SQLException
/*     */   {
/* 147 */     return new Double(canonicalFormatBytesToDouble(getBytes()));
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 170 */     String str = paramClass.getName();
/*     */ 
/* 172 */     return (str.compareTo("java.lang.String") == 0) || (str.compareTo("java.lang.Double") == 0);
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 190 */     String str = Double.toString(canonicalFormatBytesToDouble(getBytes()));
/* 191 */     return str;
/*     */   }
/*     */ 
/*     */   public double doubleValue()
/*     */     throws SQLException
/*     */   {
/* 209 */     return canonicalFormatBytesToDouble(getBytes());
/*     */   }
/*     */ 
/*     */   public BigDecimal bigDecimalValue()
/*     */     throws SQLException
/*     */   {
/* 227 */     return new BigDecimal(canonicalFormatBytesToDouble(getBytes()));
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 238 */     return new Double[paramInt];
/*     */   }
/*     */ 
/*     */   private static double stringToDouble(String paramString)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 249 */       return Double.valueOf(paramString).doubleValue();
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 254 */       SQLException localSQLException = DatabaseError.createSqlException(null, 59);
/* 255 */       localSQLException.fillInStackTrace();
/* 256 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   static byte[] doubleToCanonicalFormatBytes(double paramDouble)
/*     */   {
/* 264 */     double d = paramDouble;
/*     */ 
/* 266 */     if (d == 0.0D)
/* 267 */       d = 0.0D;
/* 268 */     else if (d != d) {
/* 269 */       d = (0.0D / 0.0D);
/*     */     }
/* 271 */     long l = Double.doubleToLongBits(d);
/* 272 */     byte[] arrayOfByte = new byte[8];
/* 273 */     int i = (int)l;
/* 274 */     int j = (int)(l >> 32);
/*     */ 
/* 276 */     int k = i;
/*     */ 
/* 279 */     i >>= 8;
/*     */ 
/* 281 */     int m = i;
/*     */ 
/* 283 */     i >>= 8;
/*     */ 
/* 285 */     int n = i;
/*     */ 
/* 287 */     i >>= 8;
/*     */ 
/* 289 */     int i1 = i;
/*     */ 
/* 291 */     int i2 = j;
/*     */ 
/* 293 */     j >>= 8;
/*     */ 
/* 295 */     int i3 = j;
/*     */ 
/* 297 */     j >>= 8;
/*     */ 
/* 299 */     int i4 = j;
/*     */ 
/* 301 */     j >>= 8;
/*     */ 
/* 303 */     int i5 = j;
/*     */ 
/* 305 */     if ((i5 & 0x80) == 0)
/*     */     {
/* 307 */       i5 |= 128;
/*     */     }
/*     */     else
/*     */     {
/* 311 */       i5 ^= -1;
/* 312 */       i4 ^= -1;
/* 313 */       i3 ^= -1;
/* 314 */       i2 ^= -1;
/* 315 */       i1 ^= -1;
/* 316 */       n ^= -1;
/* 317 */       m ^= -1;
/* 318 */       k ^= -1;
/*     */     }
/*     */ 
/* 321 */     arrayOfByte[7] = ((byte)k);
/* 322 */     arrayOfByte[6] = ((byte)m);
/* 323 */     arrayOfByte[5] = ((byte)n);
/* 324 */     arrayOfByte[4] = ((byte)i1);
/* 325 */     arrayOfByte[3] = ((byte)i2);
/* 326 */     arrayOfByte[2] = ((byte)i3);
/* 327 */     arrayOfByte[1] = ((byte)i4);
/* 328 */     arrayOfByte[0] = ((byte)i5);
/*     */ 
/* 330 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   static double canonicalFormatBytesToDouble(byte[] paramArrayOfByte)
/*     */   {
/* 337 */     int i = paramArrayOfByte[0];
/* 338 */     int j = paramArrayOfByte[1];
/* 339 */     int k = paramArrayOfByte[2];
/* 340 */     int m = paramArrayOfByte[3];
/* 341 */     int n = paramArrayOfByte[4];
/* 342 */     int i1 = paramArrayOfByte[5];
/* 343 */     int i2 = paramArrayOfByte[6];
/* 344 */     int i3 = paramArrayOfByte[7];
/*     */ 
/* 346 */     if ((i & 0x80) != 0)
/*     */     {
/* 348 */       i &= 127;
/* 349 */       j &= 255;
/* 350 */       k &= 255;
/* 351 */       m &= 255;
/* 352 */       n &= 255;
/* 353 */       i1 &= 255;
/* 354 */       i2 &= 255;
/* 355 */       i3 &= 255;
/*     */     }
/*     */     else
/*     */     {
/* 359 */       i = (i ^ 0xFFFFFFFF) & 0xFF;
/* 360 */       j = (j ^ 0xFFFFFFFF) & 0xFF;
/* 361 */       k = (k ^ 0xFFFFFFFF) & 0xFF;
/* 362 */       m = (m ^ 0xFFFFFFFF) & 0xFF;
/* 363 */       n = (n ^ 0xFFFFFFFF) & 0xFF;
/* 364 */       i1 = (i1 ^ 0xFFFFFFFF) & 0xFF;
/* 365 */       i2 = (i2 ^ 0xFFFFFFFF) & 0xFF;
/* 366 */       i3 = (i3 ^ 0xFFFFFFFF) & 0xFF;
/*     */     }
/*     */ 
/* 369 */     int i4 = i << 24 | j << 16 | k << 8 | m;
/* 370 */     int i5 = n << 24 | i1 << 16 | i2 << 8 | i3;
/* 371 */     long l = i4 << 32 | i5 & 0xFFFFFFFF;
/*     */ 
/* 373 */     return Double.longBitsToDouble(l);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.BINARY_DOUBLE
 * JD-Core Version:    0.6.2
 */