/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLInput;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OraclePreparedStatement;
/*      */ import oracle.jdbc.OracleResultSet;
/*      */ import oracle.jdbc.OracleTypeMetaData.ArrayStorage;
/*      */ import oracle.jdbc.OracleTypeMetaData.Kind;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleTypeMetaData.Array;
/*      */ import oracle.jdbc.oracore.OracleNamedType;
/*      */ import oracle.jdbc.oracore.OracleType;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.jdbc.oracore.OracleTypeCOLLECTION;
/*      */ import oracle.jdbc.oracore.OracleTypeFLOAT;
/*      */ import oracle.jdbc.oracore.OracleTypeNUMBER;
/*      */ import oracle.jdbc.oracore.OracleTypeREF;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class ArrayDescriptor extends TypeDescriptor
/*      */   implements OracleTypeMetaData.Array, Serializable
/*      */ {
/*      */   public static final int TYPE_VARRAY = 3;
/*      */   public static final int TYPE_NESTED_TABLE = 2;
/*      */   public static final int CACHE_NONE = 0;
/*      */   public static final int CACHE_ALL = 1;
/*      */   public static final int CACHE_LAST = 2;
/*      */   static final long serialVersionUID = 3838105394346513809L;
/* 2003 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public static ArrayDescriptor createDescriptor(String paramString, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*   74 */     return createDescriptor(paramString, paramConnection, false, false);
/*      */   }
/*      */ 
/*      */   public static ArrayDescriptor createDescriptor(String paramString, Connection paramConnection, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*   95 */     if ((paramString == null) || (paramString.length() == 0) || (paramConnection == null))
/*      */     {
/*   98 */       localObject = DatabaseError.createSqlException(null, 60, "ArrayDescriptor.createDescriptor: Invalid argument,'name' should not be an empty string and 'conn' should not be null.");
/*      */ 
/*  100 */       ((SQLException)localObject).fillInStackTrace();
/*  101 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  106 */     Object localObject = new SQLName(paramString, (oracle.jdbc.OracleConnection)paramConnection);
/*  107 */     String str = ((SQLName)localObject).getName();
/*      */ 
/*  110 */     ArrayDescriptor localArrayDescriptor = null;
/*  111 */     if (!paramBoolean2) {
/*  112 */       localArrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)paramConnection).getDescriptor(str);
/*      */     }
/*      */ 
/*  115 */     if (localArrayDescriptor == null)
/*      */     {
/*  118 */       int i = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getVersionNumber();
/*  119 */       if (i >= 12000) {
/*  120 */         localArrayDescriptor = new ArrayDescriptor(paramString, paramConnection);
/*      */       }
/*      */       else {
/*  123 */         localArrayDescriptor = new ArrayDescriptor((SQLName)localObject, paramConnection);
/*      */       }
/*  125 */       if (paramBoolean1) localArrayDescriptor.initNamesRecursively();
/*      */ 
/*  127 */       ((oracle.jdbc.OracleConnection)paramConnection).putDescriptor(str, localArrayDescriptor);
/*      */     }
/*  129 */     return localArrayDescriptor;
/*      */   }
/*      */ 
/*      */   public static ArrayDescriptor createDescriptor(SQLName paramSQLName, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  147 */     return createDescriptor(paramSQLName, paramConnection, false, false);
/*      */   }
/*      */ 
/*      */   public static ArrayDescriptor createDescriptor(SQLName paramSQLName, Connection paramConnection, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  168 */     String str = paramSQLName.getName();
/*      */ 
/*  171 */     ArrayDescriptor localArrayDescriptor = null;
/*  172 */     if (!paramBoolean2) {
/*  173 */       localArrayDescriptor = (ArrayDescriptor)((oracle.jdbc.OracleConnection)paramConnection).getDescriptor(str);
/*      */     }
/*      */ 
/*  176 */     if (localArrayDescriptor == null)
/*      */     {
/*  178 */       localArrayDescriptor = new ArrayDescriptor(paramSQLName, paramConnection);
/*  179 */       if (paramBoolean1) localArrayDescriptor.initNamesRecursively();
/*  180 */       ((oracle.jdbc.OracleConnection)paramConnection).putDescriptor(str, localArrayDescriptor);
/*      */     }
/*  182 */     return localArrayDescriptor;
/*      */   }
/*      */ 
/*      */   public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION paramOracleTypeCOLLECTION)
/*      */     throws SQLException
/*      */   {
/*  197 */     String str = paramOracleTypeCOLLECTION.getFullName();
/*  198 */     oracle.jdbc.internal.OracleConnection localOracleConnection = paramOracleTypeCOLLECTION.getConnection();
/*  199 */     ArrayDescriptor localArrayDescriptor = (ArrayDescriptor)localOracleConnection.getDescriptor(str);
/*      */ 
/*  203 */     if (localArrayDescriptor == null)
/*      */     {
/*  205 */       SQLName localSQLName = new SQLName(paramOracleTypeCOLLECTION.getSchemaName(), paramOracleTypeCOLLECTION.getSimpleName(), paramOracleTypeCOLLECTION.getConnection());
/*      */ 
/*  207 */       localArrayDescriptor = new ArrayDescriptor(localSQLName, paramOracleTypeCOLLECTION, localOracleConnection);
/*  208 */       localOracleConnection.putDescriptor(str, localArrayDescriptor);
/*      */     }
/*  210 */     return localArrayDescriptor;
/*      */   }
/*      */ 
/*      */   public static ArrayDescriptor createDescriptor(SQLName paramSQLName, byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2, oracle.jdbc.internal.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  225 */     OracleTypeADT localOracleTypeADT = new OracleTypeADT(paramSQLName, paramArrayOfByte1, paramInt, paramArrayOfByte2, paramOracleConnection);
/*      */ 
/*  227 */     localOracleTypeADT.init(paramArrayOfByte2, paramOracleConnection);
/*  228 */     OracleTypeCOLLECTION localOracleTypeCOLLECTION = (OracleTypeCOLLECTION)localOracleTypeADT.cleanup();
/*  229 */     return new ArrayDescriptor(paramSQLName, localOracleTypeCOLLECTION, paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public ArrayDescriptor(String paramString, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  248 */     super((short)122, paramString, paramConnection);
/*      */ 
/*  250 */     initPickler();
/*      */   }
/*      */ 
/*      */   public ArrayDescriptor(SQLName paramSQLName, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  265 */     super((short)122, paramSQLName, paramConnection);
/*      */ 
/*  267 */     initPickler();
/*      */   }
/*      */ 
/*      */   public ArrayDescriptor(SQLName paramSQLName, OracleTypeCOLLECTION paramOracleTypeCOLLECTION, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  281 */     super((short)122, paramSQLName, paramOracleTypeCOLLECTION, paramConnection);
/*      */   }
/*      */ 
/*      */   public ArrayDescriptor(OracleTypeCOLLECTION paramOracleTypeCOLLECTION, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  296 */     super((short)122, paramOracleTypeCOLLECTION, paramConnection);
/*      */   }
/*      */ 
/*      */   ArrayDescriptor(byte[] paramArrayOfByte, int paramInt, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  308 */     super((short)122);
/*      */ 
/*  310 */     this.toid = paramArrayOfByte;
/*  311 */     this.toidVersion = paramInt;
/*  312 */     setPhysicalConnectionOf(paramConnection);
/*  313 */     initPickler();
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData.Kind getKind()
/*      */   {
/*  329 */     return OracleTypeMetaData.Kind.ARRAY;
/*      */   }
/*      */ 
/*      */   public int getBaseType()
/*      */     throws SQLException
/*      */   {
/*  351 */     return ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
/*      */   }
/*      */ 
/*      */   public String getBaseName()
/*      */     throws SQLException
/*      */   {
/*  370 */     String str = null;
/*      */     OracleNamedType localOracleNamedType;
/*  372 */     switch (getBaseType())
/*      */     {
/*      */     case 12:
/*  376 */       str = "VARCHAR";
/*      */ 
/*  378 */       break;
/*      */     case 1:
/*  381 */       str = "CHAR";
/*      */ 
/*  383 */       break;
/*      */     case -9:
/*  386 */       str = "NVARCHAR";
/*      */ 
/*  388 */       break;
/*      */     case -15:
/*  391 */       str = "NCHAR";
/*      */ 
/*  393 */       break;
/*      */     case -2:
/*  396 */       str = "RAW";
/*      */ 
/*  398 */       break;
/*      */     case 6:
/*  401 */       str = "FLOAT";
/*      */ 
/*  403 */       break;
/*      */     case 2:
/*  406 */       str = "NUMBER";
/*      */ 
/*  408 */       break;
/*      */     case 8:
/*  411 */       str = "DOUBLE";
/*      */ 
/*  413 */       break;
/*      */     case 3:
/*  416 */       str = "DECIMAL";
/*      */ 
/*  418 */       break;
/*      */     case 91:
/*  421 */       str = "DATE";
/*      */ 
/*  423 */       break;
/*      */     case 93:
/*  426 */       str = "TIMESTAMP";
/*      */ 
/*  428 */       break;
/*      */     case -101:
/*  431 */       str = "TIMESTAMP WITH TIME ZONE";
/*      */ 
/*  433 */       break;
/*      */     case -102:
/*  436 */       str = "TIMESTAMP WITH LOCAL TIME ZONE";
/*      */ 
/*  438 */       break;
/*      */     case 2004:
/*  441 */       str = "BLOB";
/*      */ 
/*  443 */       break;
/*      */     case 2005:
/*  446 */       str = "CLOB";
/*      */ 
/*  448 */       break;
/*      */     case 2011:
/*  451 */       str = "NCLOB";
/*      */ 
/*  453 */       break;
/*      */     case -13:
/*  456 */       str = "BFILE";
/*      */ 
/*  458 */       break;
/*      */     case 2002:
/*      */     case 2003:
/*      */     case 2007:
/*      */     case 2008:
/*  468 */       localOracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
/*      */ 
/*  471 */       str = localOracleNamedType.getFullName();
/*      */ 
/*  473 */       break;
/*      */     case 2006:
/*  478 */       localOracleNamedType = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
/*      */ 
/*  481 */       str = "REF " + ((OracleTypeREF)localOracleNamedType).getFullName();
/*      */ 
/*  483 */       break;
/*      */     case 100:
/*  486 */       str = "BINARY_FLOAT";
/*  487 */       break;
/*      */     case 101:
/*  489 */       str = "BINARY_DOUBLE";
/*  490 */       break;
/*      */     case -104:
/*  493 */       str = "INTERVALDS";
/*  494 */       break;
/*      */     case -103:
/*  497 */       str = "INTERVALYM";
/*  498 */       break;
/*      */     case 1111:
/*      */     default:
/*  503 */       str = null;
/*      */     }
/*      */ 
/*  507 */     return str;
/*      */   }
/*      */ 
/*      */   public OracleTypeCOLLECTION getOracleTypeCOLLECTION()
/*      */   {
/*  518 */     return (OracleTypeCOLLECTION)this.pickler;
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData.ArrayStorage getArrayStorage()
/*      */     throws SQLException
/*      */   {
/*  530 */     return OracleTypeMetaData.ArrayStorage.withCode(getArrayType());
/*      */   }
/*      */ 
/*      */   public int getArrayType()
/*      */     throws SQLException
/*      */   {
/*  547 */     return ((OracleTypeCOLLECTION)this.pickler).getUserCode();
/*      */   }
/*      */ 
/*      */   public long getMaxLength()
/*      */     throws SQLException
/*      */   {
/*  565 */     return getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
/*      */   }
/*      */ 
/*      */   public String descType()
/*      */     throws SQLException
/*      */   {
/*  584 */     StringBuffer localStringBuffer = new StringBuffer();
/*  585 */     return descType(localStringBuffer, 0);
/*      */   }
/*      */ 
/*      */   String descType(StringBuffer paramStringBuffer, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  592 */     String str1 = "";
/*      */ 
/*  594 */     for (int i = 0; i < paramInt; i++) {
/*  595 */       str1 = str1 + "  ";
/*      */     }
/*  597 */     String str2 = str1 + "  ";
/*      */ 
/*  599 */     paramStringBuffer.append(str1);
/*  600 */     paramStringBuffer.append(getTypeName());
/*  601 */     paramStringBuffer.append("\n");
/*      */ 
/*  603 */     int j = getBaseType();
/*      */     Object localObject;
/*  605 */     if ((j == 2002) || (j == 2008))
/*      */     {
/*  608 */       localObject = StructDescriptor.createDescriptor(getBaseName(), this.connection);
/*      */ 
/*  611 */       ((StructDescriptor)localObject).descType(paramStringBuffer, paramInt + 1);
/*      */     }
/*  613 */     else if (j == 2003)
/*      */     {
/*  615 */       localObject = createDescriptor(getBaseName(), this.connection);
/*      */ 
/*  618 */       ((ArrayDescriptor)localObject).descType(paramStringBuffer, paramInt + 1);
/*      */     }
/*  620 */     else if (j == 2007)
/*      */     {
/*  622 */       localObject = OpaqueDescriptor.createDescriptor(getBaseName(), this.connection);
/*      */ 
/*  625 */       ((OpaqueDescriptor)localObject).descType(paramStringBuffer, paramInt + 1);
/*      */     }
/*      */     else
/*      */     {
/*  629 */       paramStringBuffer.append(str2);
/*  630 */       paramStringBuffer.append(getBaseName());
/*  631 */       paramStringBuffer.append("\n");
/*      */     }
/*      */ 
/*  634 */     return paramStringBuffer.substring(0, paramStringBuffer.length());
/*      */   }
/*      */ 
/*      */   int toLength(ARRAY paramARRAY)
/*      */     throws SQLException
/*      */   {
/*  653 */     if (paramARRAY.numElems == -1)
/*      */     {
/*  655 */       if (paramARRAY.datumArray != null)
/*      */       {
/*  657 */         paramARRAY.numElems = paramARRAY.datumArray.length;
/*      */       }
/*  659 */       else if (paramARRAY.objArray != null)
/*      */       {
/*  661 */         if ((paramARRAY.objArray instanceof Object[]))
/*  662 */           paramARRAY.numElems = ((Object[])paramARRAY.objArray).length;
/*  663 */         else if ((paramARRAY.objArray instanceof int[]))
/*  664 */           paramARRAY.numElems = ((long[])paramARRAY.objArray).length;
/*  665 */         else if ((paramARRAY.objArray instanceof long[]))
/*  666 */           paramARRAY.numElems = ((float[])paramARRAY.objArray).length;
/*  667 */         else if ((paramARRAY.objArray instanceof float[]))
/*  668 */           paramARRAY.numElems = ((double[])paramARRAY.objArray).length;
/*  669 */         else if ((paramARRAY.objArray instanceof double[]))
/*  670 */           paramARRAY.numElems = ((boolean[])paramARRAY.objArray).length;
/*  671 */         else if ((paramARRAY.objArray instanceof boolean[]))
/*  672 */           paramARRAY.numElems = ((int[])paramARRAY.objArray).length;
/*  673 */         else if ((paramARRAY.objArray instanceof byte[]))
/*  674 */           paramARRAY.numElems = ((byte[])paramARRAY.objArray).length;
/*  675 */         else if ((paramARRAY.objArray instanceof short[]))
/*  676 */           paramARRAY.numElems = ((short[])paramARRAY.objArray).length;
/*  677 */         else if ((paramARRAY.objArray instanceof char[]))
/*  678 */           paramARRAY.numElems = ((char[])paramARRAY.objArray).length;
/*      */       }
/*  680 */       else if (paramARRAY.locator != null)
/*      */       {
/*  682 */         paramARRAY.numElems = toLengthFromLocator(paramARRAY.locator);
/*      */       }
/*      */       else
/*      */       {
/*      */         SQLException localSQLException;
/*  684 */         if (paramARRAY.shareBytes() != null)
/*      */         {
/*  686 */           this.pickler.unlinearize(paramARRAY.shareBytes(), paramARRAY.imageOffset, paramARRAY, 0, null);
/*      */ 
/*  689 */           if (paramARRAY.numElems == -1)
/*      */           {
/*  691 */             if (paramARRAY.locator != null) {
/*  692 */               paramARRAY.numElems = toLengthFromLocator(paramARRAY.locator);
/*      */             }
/*      */             else
/*      */             {
/*  696 */               localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unable to get array length");
/*  697 */               localSQLException.fillInStackTrace();
/*  698 */               throw localSQLException;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  706 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
/*  707 */           localSQLException.fillInStackTrace();
/*  708 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  713 */     return paramARRAY.numElems;
/*      */   }
/*      */ 
/*      */   byte[] toBytes(ARRAY paramARRAY, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  724 */     byte[] arrayOfByte = paramARRAY.shareBytes();
/*      */     Object localObject;
/*  726 */     if (arrayOfByte == null)
/*      */     {
/*  728 */       if ((paramARRAY.datumArray != null) || (paramARRAY.locator != null))
/*      */       {
/*  730 */         arrayOfByte = this.pickler.linearize(paramARRAY);
/*      */ 
/*  732 */         if (!paramBoolean) {
/*  733 */           paramARRAY.setShareBytes(null);
/*      */         }
/*      */       }
/*  736 */       else if (paramARRAY.objArray != null)
/*      */       {
/*  738 */         paramARRAY.datumArray = toOracleArray(paramARRAY.objArray, 1L, -1);
/*  739 */         arrayOfByte = this.pickler.linearize(paramARRAY);
/*      */ 
/*  741 */         if (!paramBoolean)
/*      */         {
/*  743 */           paramARRAY.datumArray = null;
/*      */ 
/*  745 */           paramARRAY.setShareBytes(null);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  752 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
/*  753 */         ((SQLException)localObject).fillInStackTrace();
/*  754 */         throw ((Throwable)localObject);
/*      */       }
/*      */ 
/*      */     }
/*  758 */     else if (paramARRAY.imageLength != 0L)
/*      */     {
/*  760 */       if ((paramARRAY.imageOffset != 0L) || (paramARRAY.imageLength != arrayOfByte.length))
/*      */       {
/*  762 */         localObject = new byte[(int)paramARRAY.imageLength];
/*      */ 
/*  764 */         System.arraycopy(arrayOfByte, (int)paramARRAY.imageOffset, localObject, 0, (int)paramARRAY.imageLength);
/*      */ 
/*  766 */         paramARRAY.setImage((byte[])localObject, 0L, 0L);
/*      */ 
/*  768 */         return localObject;
/*      */       }
/*      */     }
/*      */ 
/*  772 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   Datum[] toOracleArray(ARRAY paramARRAY, long paramLong, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  789 */     Datum[] arrayOfDatum1 = paramARRAY.datumArray;
/*      */ 
/*  791 */     if (arrayOfDatum1 == null)
/*      */     {
/*  793 */       if (paramARRAY.objArray != null)
/*      */       {
/*  795 */         arrayOfDatum1 = toOracleArray(paramARRAY.objArray, paramLong, paramInt);
/*      */       }
/*  798 */       else if (paramARRAY.locator != null)
/*      */       {
/*  800 */         arrayOfDatum1 = toOracleArrayFromLocator(paramARRAY.locator, paramLong, paramInt, null);
/*      */       }
/*  803 */       else if (paramARRAY.shareBytes() != null)
/*      */       {
/*  805 */         this.pickler.unlinearize(paramARRAY.shareBytes(), paramARRAY.imageOffset, paramARRAY, paramLong, paramInt, 1, null);
/*      */ 
/*  808 */         if (paramARRAY.locator != null)
/*      */         {
/*  811 */           arrayOfDatum1 = toOracleArrayFromLocator(paramARRAY.locator, paramLong, paramInt, null);
/*      */         }
/*      */         else
/*      */         {
/*  817 */           arrayOfDatum1 = paramARRAY.datumArray;
/*      */         }
/*      */ 
/*  820 */         if (!paramBoolean) {
/*  821 */           paramARRAY.datumArray = null;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  827 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.");
/*  828 */         localSQLException.fillInStackTrace();
/*  829 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  835 */       if (paramLong > arrayOfDatum1.length)
/*      */       {
/*  838 */         return new Datum[0];
/*      */       }
/*      */ 
/*  841 */       int i = (int)(paramInt == -1 ? arrayOfDatum1.length - paramLong + 1L : Math.min(arrayOfDatum1.length - paramLong + 1L, paramInt));
/*      */ 
/*  844 */       arrayOfDatum1 = new Datum[i];
/*      */ 
/*  846 */       System.arraycopy(paramARRAY.datumArray, (int)paramLong - 1, arrayOfDatum1, 0, i);
/*      */     }
/*      */ 
/*  849 */     Datum[] arrayOfDatum2 = null;
/*      */ 
/*  851 */     if (paramBoolean)
/*      */     {
/*  853 */       paramARRAY.datumArray = arrayOfDatum1;
/*  854 */       arrayOfDatum2 = (Datum[])arrayOfDatum1.clone();
/*      */     }
/*      */     else
/*      */     {
/*  858 */       arrayOfDatum2 = arrayOfDatum1;
/*      */     }
/*      */ 
/*  861 */     return arrayOfDatum2;
/*      */   }
/*      */ 
/*      */   Object[] toJavaArray(ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  878 */     Object[] arrayOfObject1 = null;
/*      */ 
/*  880 */     if (paramARRAY.objArray != null)
/*      */     {
/*  882 */       arrayOfObject1 = (Object[])((Object[])paramARRAY.objArray).clone();
/*      */ 
/*  884 */       int i = arrayOfObject1.length;
/*  885 */       int j = (int)(paramInt == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt));
/*      */ 
/*  888 */       if (j <= 0)
/*      */       {
/*  890 */         Object[] arrayOfObject2 = (Object[])makeJavaArray(j, getBaseType());
/*      */ 
/*  892 */         return arrayOfObject2;
/*      */       }
/*      */ 
/*  896 */       arrayOfObject1 = (Object[])makeJavaArray(j, getBaseType());
/*      */ 
/*  898 */       System.arraycopy(paramARRAY.objArray, (int)paramLong - 1, arrayOfObject1, 0, j);
/*      */     }
/*      */     else
/*      */     {
/*  903 */       if (paramARRAY.datumArray != null)
/*      */       {
/*  905 */         arrayOfObject1 = (Object[])toJavaArray(paramARRAY.datumArray, paramLong, paramInt, paramMap);
/*      */       }
/*  907 */       else if (paramARRAY.locator != null)
/*      */       {
/*  909 */         arrayOfObject1 = toArrayFromLocator(paramARRAY.locator, paramLong, paramInt, paramMap);
/*      */       }
/*  911 */       else if (paramARRAY.shareBytes() != null)
/*      */       {
/*  913 */         this.pickler.unlinearize(paramARRAY.shareBytes(), paramARRAY.imageOffset, paramARRAY, paramLong, paramInt, 2, paramMap);
/*      */ 
/*  916 */         if (paramARRAY.locator != null)
/*  917 */           arrayOfObject1 = toArrayFromLocator(paramARRAY.locator, paramLong, paramInt, paramMap);
/*      */         else {
/*  919 */           arrayOfObject1 = (Object[])paramARRAY.objArray;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  925 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
/*  926 */         localSQLException.fillInStackTrace();
/*  927 */         throw localSQLException;
/*      */       }
/*      */ 
/*  931 */       if ((paramBoolean) && (getBaseType() != 2002) && (getBaseType() != 2008) && (arrayOfObject1 != null))
/*      */       {
/*  933 */         paramARRAY.objArray = arrayOfObject1.clone();
/*      */       }
/*  935 */       else paramARRAY.objArray = null;
/*      */     }
/*      */ 
/*  938 */     return arrayOfObject1;
/*      */   }
/*      */ 
/*      */   private Datum[] toOracleArrayFromLocator(byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  947 */     int i = toLengthFromLocator(paramArrayOfByte);
/*  948 */     int j = (int)(paramInt == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt));
/*      */ 
/*  951 */     Datum[] arrayOfDatum = null;
/*      */ 
/*  953 */     if (j <= 0)
/*      */     {
/*  955 */       arrayOfDatum = new Datum[0];
/*      */     }
/*      */     else
/*      */     {
/*  959 */       arrayOfDatum = new Datum[j];
/*      */ 
/*  961 */       ResultSet localResultSet = toResultSetFromLocator(paramArrayOfByte, paramLong, paramInt, paramMap);
/*      */ 
/*  964 */       for (int k = 0; localResultSet.next(); k++) {
/*  965 */         arrayOfDatum[k] = ((OracleResultSet)localResultSet).getOracleObject(2);
/*      */       }
/*  967 */       localResultSet.close();
/*      */     }
/*      */ 
/*  970 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   private Object[] toArrayFromLocator(byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  980 */     int i = toLengthFromLocator(paramArrayOfByte);
/*  981 */     int j = (int)(paramInt == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt));
/*      */ 
/*  983 */     Object[] arrayOfObject = null;
/*      */ 
/*  985 */     if (j <= 0)
/*      */     {
/*  988 */       arrayOfObject = (Object[])makeJavaArray(0, getBaseType());
/*      */     }
/*      */     else
/*      */     {
/*  993 */       arrayOfObject = (Object[])makeJavaArray(j, getBaseType());
/*      */ 
/*  995 */       ResultSet localResultSet = toResultSetFromLocator(paramArrayOfByte, paramLong, paramInt, paramMap);
/*      */ 
/*  998 */       for (int k = 0; localResultSet.next(); k++) {
/*  999 */         arrayOfObject[k] = ((OracleResultSet)localResultSet).getObject(2, paramMap);
/*      */       }
/* 1001 */       localResultSet.close();
/*      */     }
/*      */ 
/* 1004 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   public ResultSet toResultSet(ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1018 */     ResultSet localResultSet = null;
/*      */     SQLException localSQLException;
/* 1020 */     if (paramARRAY.datumArray != null)
/*      */     {
/* 1022 */       localResultSet = toResultSet(paramARRAY.datumArray, paramLong, paramInt, paramMap);
/*      */     }
/* 1024 */     else if (paramARRAY.locator != null)
/*      */     {
/* 1026 */       localResultSet = toResultSetFromLocator(paramARRAY.locator, paramLong, paramInt, paramMap);
/*      */     }
/* 1028 */     else if (paramARRAY.objArray != null)
/*      */     {
/* 1030 */       localResultSet = toResultSet(toOracleArray(paramARRAY.objArray, paramLong, paramInt), 1L, -1, paramMap);
/*      */     }
/* 1033 */     else if (paramARRAY.shareBytes() != null)
/*      */     {
/* 1037 */       if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(paramARRAY.shareBytes(), (int)paramARRAY.imageOffset))
/*      */       {
/* 1040 */         localResultSet = toResultSetFromImage(paramARRAY, paramLong, paramInt, paramMap);
/*      */       }
/*      */       else
/*      */       {
/* 1044 */         this.pickler.unlinearize(paramARRAY.shareBytes(), paramARRAY.imageOffset, paramARRAY, 1, null);
/*      */ 
/* 1047 */         if (paramARRAY.locator != null) {
/* 1048 */           localResultSet = toResultSetFromLocator(paramARRAY.locator, paramLong, paramInt, paramMap);
/*      */         }
/*      */         else
/*      */         {
/* 1053 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status");
/* 1054 */           localSQLException.fillInStackTrace();
/* 1055 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1061 */     if (localResultSet == null)
/*      */     {
/* 1065 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet");
/* 1066 */       localSQLException.fillInStackTrace();
/* 1067 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1071 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet toResultSet(Datum[] paramArrayOfDatum, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1089 */     ResultSet localResultSet = null;
/*      */ 
/* 1091 */     if (paramInt == -1)
/* 1092 */       localResultSet = this.connection.newArrayDataResultSet(paramArrayOfDatum, paramLong, paramArrayOfDatum.length, paramMap);
/*      */     else
/* 1094 */       localResultSet = this.connection.newArrayDataResultSet(paramArrayOfDatum, paramLong, paramInt, paramMap);
/* 1095 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet toResultSetFromLocator(byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1113 */     ResultSet localResultSet = this.connection.newArrayLocatorResultSet(this, paramArrayOfByte, paramLong, paramInt, paramMap);
/*      */ 
/* 1116 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet toResultSetFromImage(ARRAY paramARRAY, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1124 */     ResultSet localResultSet = this.connection.newArrayDataResultSet(paramARRAY, paramLong, paramInt, paramMap);
/*      */ 
/* 1126 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   public static Object[] makeJavaArray(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1139 */     Object localObject = null;
/*      */ 
/* 1141 */     switch (paramInt2)
/*      */     {
/*      */     case -7:
/*      */     case -6:
/*      */     case -5:
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/* 1161 */       localObject = new BigDecimal[paramInt1];
/*      */ 
/* 1163 */       break;
/*      */     case -15:
/*      */     case -9:
/*      */     case 1:
/*      */     case 12:
/* 1170 */       localObject = new String[paramInt1];
/*      */ 
/* 1172 */       break;
/*      */     case -102:
/*      */     case -101:
/*      */     case 91:
/*      */     case 92:
/*      */     case 93:
/* 1183 */       localObject = new Timestamp[paramInt1];
/*      */ 
/* 1185 */       break;
/*      */     case 2002:
/*      */     case 2008:
/* 1190 */       localObject = new Object[paramInt1];
/*      */ 
/* 1192 */       break;
/*      */     case -13:
/* 1195 */       localObject = new BFILE[paramInt1];
/*      */ 
/* 1197 */       break;
/*      */     case 2004:
/* 1200 */       localObject = new BLOB[paramInt1];
/*      */ 
/* 1202 */       break;
/*      */     case 2005:
/*      */     case 2011:
/* 1206 */       localObject = new CLOB[paramInt1];
/*      */ 
/* 1208 */       break;
/*      */     case -3:
/*      */     case -2:
/* 1213 */       localObject = new byte[paramInt1][];
/*      */ 
/* 1215 */       break;
/*      */     case 2006:
/* 1218 */       localObject = new REF[paramInt1];
/*      */ 
/* 1220 */       break;
/*      */     case 2003:
/* 1223 */       localObject = new Object[paramInt1];
/*      */ 
/* 1225 */       break;
/*      */     case 100:
/* 1228 */       localObject = new Float[paramInt1];
/* 1229 */       break;
/*      */     case 101:
/* 1231 */       localObject = new Double[paramInt1];
/* 1232 */       break;
/*      */     case -104:
/* 1235 */       localObject = new INTERVALDS[paramInt1];
/* 1236 */       break;
/*      */     case -103:
/* 1239 */       localObject = new INTERVALYM[paramInt1];
/* 1240 */       break;
/*      */     default:
/* 1245 */       SQLException localSQLException = DatabaseError.createSqlException(null, 1, "makeJavaArray doesn't support type " + paramInt2);
/*      */ 
/* 1247 */       localSQLException.fillInStackTrace();
/* 1248 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1253 */     return localObject;
/*      */   }
/*      */ 
/*      */   private int toLengthFromLocator(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1266 */     ARRAY localARRAY = new ARRAY(this, this.connection, (byte[])null);
/*      */ 
/* 1268 */     localARRAY.setLocator(paramArrayOfByte);
/*      */ 
/* 1270 */     int i = 0;
/*      */ 
/* 1273 */     OraclePreparedStatement localOraclePreparedStatement = null;
/* 1274 */     OracleResultSet localOracleResultSet = null;
/*      */ 
/* 1276 */     localOraclePreparedStatement = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + getName() + ") )");
/*      */ 
/* 1280 */     localOraclePreparedStatement.setArray(1, localARRAY);
/*      */ 
/* 1282 */     localOracleResultSet = (OracleResultSet)localOraclePreparedStatement.executeQuery();
/*      */ 
/* 1284 */     if (localOracleResultSet.next()) {
/* 1285 */       i = localOracleResultSet.getInt(1);
/*      */     }
/*      */     else
/*      */     {
/* 1290 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table");
/* 1291 */       localSQLException.fillInStackTrace();
/* 1292 */       throw localSQLException;
/*      */     }
/*      */ 
/* 1296 */     localOracleResultSet.close();
/* 1297 */     localOraclePreparedStatement.close();
/*      */ 
/* 1299 */     return i;
/*      */   }
/*      */ 
/*      */   Datum[] toOracleArray(Object paramObject, long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1315 */     Datum[] arrayOfDatum = null;
/*      */ 
/* 1317 */     if (paramObject != null)
/*      */     {
/* 1319 */       OracleType localOracleType = getElementType();
/*      */ 
/* 1321 */       arrayOfDatum = localOracleType.toDatumArray(paramObject, this.connection, paramLong, paramInt);
/*      */     }
/*      */ 
/* 1324 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   private Object toJavaArray(Datum[] paramArrayOfDatum, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1332 */     int i = (int)(paramInt == -1 ? paramArrayOfDatum.length - paramLong + 1L : Math.min(paramArrayOfDatum.length - paramLong + 1L, paramInt));
/*      */ 
/* 1335 */     if (i < 0) {
/* 1336 */       i = 0;
/*      */     }
/* 1338 */     Object[] arrayOfObject = (Object[])makeJavaArray(i, getBaseType());
/*      */     Object localObject;
/*      */     int j;
/* 1340 */     if (getBaseType() == 2002)
/*      */     {
/* 1342 */       localObject = null;
/*      */ 
/* 1344 */       for (j = 0; j < i; j++)
/*      */       {
/* 1346 */         localObject = (STRUCT)paramArrayOfDatum[((int)paramLong + j - 1)];
/* 1347 */         arrayOfObject[j] = (localObject != null ? ((STRUCT)localObject).toJdbc(paramMap) : null);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 1352 */       localObject = null;
/*      */ 
/* 1354 */       for (j = 0; j < i; j++)
/*      */       {
/* 1356 */         localObject = paramArrayOfDatum[((int)paramLong + j - 1)];
/* 1357 */         arrayOfObject[j] = (localObject != null ? ((Datum)localObject).toJdbc() : null);
/*      */       }
/*      */     }
/*      */ 
/* 1361 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   private Object toNumericArray(Datum[] paramArrayOfDatum, long paramLong, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1369 */     Object localObject1 = null;
/*      */ 
/* 1371 */     int i = (int)(paramInt1 == -1 ? paramArrayOfDatum.length - paramLong + 1L : Math.min(paramArrayOfDatum.length - paramLong + 1L, paramInt1));
/*      */ 
/* 1374 */     if (i < 0)
/* 1375 */       i = 0;
/*      */     Object localObject2;
/*      */     int j;
/*      */     Datum localDatum;
/* 1377 */     switch (paramInt2)
/*      */     {
/*      */     case 4:
/* 1381 */       localObject2 = new int[i];
/*      */ 
/* 1383 */       for (j = 0; j < i; j++)
/*      */       {
/* 1385 */         localDatum = paramArrayOfDatum[((int)paramLong + j - 1)];
/*      */ 
/* 1387 */         if (localDatum != null) {
/* 1388 */           localObject2[j] = localDatum.intValue();
/*      */         }
/*      */       }
/* 1391 */       localObject1 = localObject2;
/* 1392 */       break;
/*      */     case 5:
/* 1397 */       localObject2 = new double[i];
/*      */ 
/* 1399 */       for (j = 0; j < i; j++)
/*      */       {
/* 1401 */         localDatum = paramArrayOfDatum[((int)paramLong + j - 1)];
/*      */ 
/* 1403 */         if (localDatum != null) {
/* 1404 */           localObject2[j] = localDatum.doubleValue();
/*      */         }
/*      */       }
/* 1407 */       localObject1 = localObject2;
/* 1408 */       break;
/*      */     case 6:
/* 1413 */       localObject2 = new float[i];
/*      */ 
/* 1415 */       for (j = 0; j < i; j++)
/*      */       {
/* 1417 */         localDatum = paramArrayOfDatum[((int)paramLong + j - 1)];
/*      */ 
/* 1419 */         if (localDatum != null) {
/* 1420 */           localObject2[j] = localDatum.floatValue();
/*      */         }
/*      */       }
/* 1423 */       localObject1 = localObject2;
/* 1424 */       break;
/*      */     case 7:
/* 1429 */       localObject2 = new long[i];
/*      */ 
/* 1431 */       for (j = 0; j < i; j++)
/*      */       {
/* 1433 */         localDatum = paramArrayOfDatum[((int)paramLong + j - 1)];
/*      */ 
/* 1435 */         if (localDatum != null) {
/* 1436 */           localObject2[j] = localDatum.longValue();
/*      */         }
/*      */       }
/* 1439 */       localObject1 = localObject2;
/* 1440 */       break;
/*      */     case 8:
/* 1445 */       localObject2 = new short[i];
/*      */ 
/* 1447 */       for (j = 0; j < i; j++)
/*      */       {
/* 1449 */         localDatum = paramArrayOfDatum[((int)paramLong + j - 1)];
/*      */ 
/* 1451 */         if (localDatum != null) {
/* 1452 */           localObject2[j] = ((NUMBER)localDatum).shortValue();
/*      */         }
/*      */       }
/* 1455 */       localObject1 = localObject2;
/* 1456 */       break;
/*      */     default:
/* 1463 */       localObject2 = DatabaseError.createUnsupportedFeatureSqlException();
/* 1464 */       ((SQLException)localObject2).fillInStackTrace();
/* 1465 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1469 */     return localObject1;
/*      */   }
/*      */ 
/*      */   private Object toNumericArrayFromLocator(byte[] paramArrayOfByte, long paramLong, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/* 1478 */     Object localObject1 = null;
/*      */ 
/* 1480 */     int i = toLengthFromLocator(paramArrayOfByte);
/*      */ 
/* 1482 */     ResultSet localResultSet = toResultSetFromLocator(paramArrayOfByte, paramLong, paramInt1, null);
/*      */ 
/* 1484 */     int j = 0;
/*      */     Object localObject2;
/* 1486 */     switch (paramInt2)
/*      */     {
/*      */     case 4:
/* 1490 */       localObject2 = new int[i];
/*      */ 
/* 1492 */       while ((localResultSet.next()) && (j < i)) {
/* 1493 */         localObject2[(j++)] = ((OracleResultSet)localResultSet).getInt(2);
/*      */       }
/* 1495 */       localResultSet.close();
/*      */ 
/* 1497 */       localObject1 = localObject2;
/* 1498 */       break;
/*      */     case 5:
/* 1503 */       localObject2 = new double[i];
/*      */ 
/* 1505 */       while ((localResultSet.next()) && (j < i)) {
/* 1506 */         localObject2[(j++)] = ((OracleResultSet)localResultSet).getDouble(2);
/*      */       }
/* 1508 */       localResultSet.close();
/*      */ 
/* 1510 */       localObject1 = localObject2;
/* 1511 */       break;
/*      */     case 6:
/* 1516 */       localObject2 = new float[i];
/*      */ 
/* 1518 */       while ((localResultSet.next()) && (j < i)) {
/* 1519 */         localObject2[(j++)] = ((OracleResultSet)localResultSet).getFloat(2);
/*      */       }
/* 1521 */       localResultSet.close();
/*      */ 
/* 1523 */       localObject1 = localObject2;
/* 1524 */       break;
/*      */     case 7:
/* 1529 */       localObject2 = new long[i];
/*      */ 
/* 1531 */       while ((localResultSet.next()) && (j < i)) {
/* 1532 */         localObject2[(j++)] = ((OracleResultSet)localResultSet).getLong(2);
/*      */       }
/* 1534 */       localResultSet.close();
/*      */ 
/* 1536 */       localObject1 = localObject2;
/* 1537 */       break;
/*      */     case 8:
/* 1542 */       localObject2 = new short[i];
/*      */ 
/* 1544 */       while ((localResultSet.next()) && (j < i)) {
/* 1545 */         localObject2[(j++)] = ((OracleResultSet)localResultSet).getShort(2);
/*      */       }
/* 1547 */       localResultSet.close();
/*      */ 
/* 1549 */       localObject1 = localObject2;
/* 1550 */       break;
/*      */     default:
/* 1556 */       localObject2 = DatabaseError.createUnsupportedFeatureSqlException();
/* 1557 */       ((SQLException)localObject2).fillInStackTrace();
/* 1558 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1561 */     return localObject1;
/*      */   }
/*      */ 
/*      */   Object toNumericArray(ARRAY paramARRAY, long paramLong, int paramInt1, int paramInt2, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1575 */     OracleType localOracleType = getElementType();
/* 1576 */     if ((!(localOracleType instanceof OracleTypeNUMBER)) && (!(localOracleType instanceof OracleTypeFLOAT)))
/*      */     {
/* 1581 */       localObject1 = DatabaseError.createUnsupportedFeatureSqlException();
/* 1582 */       ((SQLException)localObject1).fillInStackTrace();
/* 1583 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 1587 */     Object localObject1 = null;
/*      */ 
/* 1590 */     if (paramARRAY.objArray != null)
/*      */     {
/*      */       int i;
/*      */       Object localObject2;
/* 1592 */       if ((paramInt2 == 4) && ((paramARRAY.objArray instanceof int[])))
/*      */       {
/* 1594 */         i = ((int[])paramARRAY.objArray).length;
/*      */ 
/* 1596 */         if (paramLong > i) {
/* 1597 */           return new int[0];
/*      */         }
/* 1599 */         i = (int)(paramInt1 == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt1));
/*      */ 
/* 1602 */         localObject2 = new int[i];
/*      */ 
/* 1604 */         System.arraycopy(paramARRAY.objArray, (int)paramLong - 1, localObject2, 0, i);
/*      */ 
/* 1607 */         localObject1 = localObject2;
/*      */       }
/* 1609 */       else if ((paramInt2 == 5) && ((paramARRAY.objArray instanceof double[])))
/*      */       {
/* 1611 */         i = ((double[])paramARRAY.objArray).length;
/*      */ 
/* 1613 */         if (paramLong > i) {
/* 1614 */           return new double[0];
/*      */         }
/* 1616 */         i = (int)(paramInt1 == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt1));
/*      */ 
/* 1619 */         localObject2 = new double[i];
/*      */ 
/* 1621 */         System.arraycopy(paramARRAY.objArray, (int)paramLong - 1, localObject2, 0, i);
/*      */ 
/* 1624 */         localObject1 = localObject2;
/*      */       }
/* 1626 */       else if ((paramInt2 == 6) && ((paramARRAY.objArray instanceof float[])))
/*      */       {
/* 1628 */         i = ((float[])paramARRAY.objArray).length;
/*      */ 
/* 1630 */         if (paramLong > i) {
/* 1631 */           return new float[0];
/*      */         }
/* 1633 */         i = (int)(paramInt1 == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt1));
/*      */ 
/* 1636 */         localObject2 = new float[i];
/*      */ 
/* 1638 */         System.arraycopy(paramARRAY.objArray, (int)paramLong - 1, localObject2, 0, i);
/*      */ 
/* 1641 */         localObject1 = localObject2;
/*      */       }
/* 1643 */       else if ((paramInt2 == 7) && ((paramARRAY.objArray instanceof long[])))
/*      */       {
/* 1645 */         i = ((long[])paramARRAY.objArray).length;
/*      */ 
/* 1647 */         if (paramLong > i) {
/* 1648 */           return new long[0];
/*      */         }
/* 1650 */         i = (int)(paramInt1 == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt1));
/*      */ 
/* 1653 */         localObject2 = new long[i];
/*      */ 
/* 1655 */         System.arraycopy(paramARRAY.objArray, (int)paramLong - 1, localObject2, 0, i);
/*      */ 
/* 1658 */         localObject1 = localObject2;
/*      */       }
/* 1660 */       else if ((paramInt2 == 8) && ((paramARRAY.objArray instanceof short[])))
/*      */       {
/* 1662 */         i = ((short[])paramARRAY.objArray).length;
/*      */ 
/* 1664 */         if (paramLong > i) {
/* 1665 */           return new short[0];
/*      */         }
/* 1667 */         i = (int)(paramInt1 == -1 ? i - paramLong + 1L : Math.min(i - paramLong + 1L, paramInt1));
/*      */ 
/* 1670 */         localObject2 = new short[i];
/*      */ 
/* 1672 */         System.arraycopy(paramARRAY.objArray, (int)paramLong - 1, localObject2, 0, i);
/*      */ 
/* 1675 */         localObject1 = localObject2;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1682 */       if (paramARRAY.datumArray != null)
/*      */       {
/* 1684 */         localObject1 = toNumericArray(paramARRAY.datumArray, paramLong, paramInt1, paramInt2);
/*      */       }
/* 1687 */       else if (paramARRAY.locator != null)
/*      */       {
/* 1689 */         localObject1 = toNumericArrayFromLocator(paramARRAY.locator, paramLong, paramInt1, paramInt2);
/*      */       }
/* 1693 */       else if (paramARRAY.shareBytes() != null)
/*      */       {
/* 1695 */         this.pickler.unlinearize(paramARRAY.shareBytes(), paramARRAY.imageOffset, paramARRAY, paramLong, paramInt1, paramInt2, null);
/*      */ 
/* 1698 */         if (paramARRAY.locator != null)
/*      */         {
/* 1701 */           localObject1 = toNumericArrayFromLocator(paramARRAY.locator, paramLong, paramInt1, paramInt2);
/*      */         }
/*      */         else
/*      */         {
/* 1707 */           localObject1 = paramARRAY.objArray;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1715 */         SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 1716 */         localSQLException.fillInStackTrace();
/* 1717 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1721 */       if (!paramBoolean) {
/* 1722 */         paramARRAY.objArray = null;
/*      */       }
/*      */     }
/* 1725 */     return localObject1;
/*      */   }
/*      */ 
/*      */   private void initPickler()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 1734 */       OracleTypeADT localOracleTypeADT = new OracleTypeADT(getName(), this.connection);
/* 1735 */       localOracleTypeADT.init(this.connection);
/* 1736 */       this.pickler = ((OracleTypeCOLLECTION)localOracleTypeADT.cleanup());
/* 1737 */       this.toid = ((OracleTypeADT)this.pickler).getTOID();
/* 1738 */       this.pickler.setDescriptor(this);
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 1743 */       if ((localException instanceof SQLException))
/*      */       {
/* 1745 */         throw ((SQLException)localException);
/*      */       }
/*      */ 
/* 1750 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + getName() + "\"");
/*      */ 
/* 1752 */       localSQLException.fillInStackTrace();
/* 1753 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   private OracleType getElementType()
/*      */     throws SQLException
/*      */   {
/* 1769 */     OracleType localOracleType = ((OracleTypeCOLLECTION)this.pickler).getElementType();
/*      */ 
/* 1771 */     return localOracleType;
/*      */   }
/*      */ 
/*      */   public int getTypeCode()
/*      */     throws SQLException
/*      */   {
/* 1783 */     int i = 2003;
/* 1784 */     return i;
/*      */   }
/*      */ 
/*      */   public SQLInput toJdbcToSQLInput(ARRAY paramARRAY, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1798 */     return new OracleJdbc2SQLInput(toOracleArray(paramARRAY, 0L, paramARRAY.length(), false), paramMap, this.connection);
/*      */   }
/*      */ 
/*      */   public byte[] toBytes(Datum[] paramArrayOfDatum)
/*      */     throws SQLException
/*      */   {
/* 1822 */     ARRAY localARRAY = new ARRAY(this, this.connection, paramArrayOfDatum);
/*      */ 
/* 1824 */     return this.pickler.linearize(localARRAY);
/*      */   }
/*      */ 
/*      */   public byte[] toBytes(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/* 1843 */     Datum[] arrayOfDatum = toArray(paramArrayOfObject);
/* 1844 */     byte[] arrayOfByte = toBytes(arrayOfDatum);
/* 1845 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public int length(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1858 */     ARRAY localARRAY = new ARRAY(this, this.connection, paramArrayOfByte);
/* 1859 */     int i = toLength(localARRAY);
/*      */ 
/* 1861 */     return i;
/*      */   }
/*      */ 
/*      */   public Datum[] toArray(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1875 */     Datum[] arrayOfDatum = null;
/* 1876 */     if (paramArrayOfByte != null)
/*      */     {
/* 1878 */       ARRAY localARRAY = new ARRAY(this, this.connection, paramArrayOfByte);
/*      */ 
/* 1880 */       arrayOfDatum = toOracleArray(localARRAY, 1L, -1, false);
/*      */     }
/* 1882 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   public Datum[] toArray(Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 1898 */     Datum[] arrayOfDatum = toOracleArray(paramObject, 1L, -1);
/* 1899 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   public ResultSet toResultSet(byte[] paramArrayOfByte, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1914 */     ResultSet localResultSet = null;
/* 1915 */     if (paramArrayOfByte != null)
/*      */     {
/* 1917 */       ARRAY localARRAY = (ARRAY)this.pickler.unlinearize(paramArrayOfByte, 0L, null, 1, null);
/*      */ 
/* 1920 */       localResultSet = toResultSet(localARRAY, 1L, -1, paramMap, false);
/*      */     }
/* 1922 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   public ResultSet toResultSet(byte[] paramArrayOfByte, long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1939 */     ResultSet localResultSet = null;
/*      */ 
/* 1941 */     if (paramArrayOfByte != null)
/*      */     {
/* 1943 */       ARRAY localARRAY = (ARRAY)this.pickler.unlinearize(paramArrayOfByte, 0L, (ARRAY)null, 1, null);
/*      */ 
/* 1946 */       localResultSet = toResultSet(localARRAY, paramLong, paramInt, paramMap, false);
/*      */     }
/*      */ 
/* 1949 */     return localResultSet;
/*      */   }
/*      */ 
/*      */   String tagName()
/*      */   {
/* 1956 */     return "ArrayDescriptor";
/*      */   }
/*      */ 
/*      */   public static int getCacheStyle(ARRAY paramARRAY)
/*      */     throws SQLException
/*      */   {
/* 1967 */     int i = 2;
/*      */ 
/* 1969 */     if ((paramARRAY.getAutoIndexing()) && ((paramARRAY.getAccessDirection() == 2) || (paramARRAY.getAccessDirection() == 3)))
/*      */     {
/* 1972 */       i = 1;
/*      */     }
/*      */ 
/* 1975 */     return i;
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.ArrayDescriptor
 * JD-Core Version:    0.6.2
 */