/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.PrintWriter;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Array;
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.OracleTypeMetaData;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleArray;
/*      */ import oracle.jdbc.proxy.ProxyFactory;
/*      */ import oracle.jdbc.proxy._Proxy_;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class ARRAY extends DatumWithConnection
/*      */   implements OracleArray
/*      */ {
/*      */   static final byte KOPUP_INLINE_COLL = 1;
/*      */   ArrayDescriptor descriptor;
/*      */   Object objArray;
/*      */   Datum[] datumArray;
/*      */   byte[] locator;
/*      */   byte prefixFlag;
/*      */   byte[] prefixSegment;
/*   85 */   int numElems = -1;
/*      */ 
/*   87 */   boolean enableBuffering = false;
/*   88 */   boolean enableIndexing = false;
/*      */   public static final int ACCESS_FORWARD = 1;
/*      */   public static final int ACCESS_REVERSE = 2;
/*      */   public static final int ACCESS_UNKNOWN = 3;
/*   93 */   int accessDirection = 3;
/*      */   long lastIndex;
/*      */   long lastOffset;
/*      */   long[] indexArray;
/*      */   long imageOffset;
/*      */   long imageLength;
/* 1610 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */   Object acProxy;
/*      */ 
/*      */   public ARRAY(ArrayDescriptor paramArrayDescriptor, Connection paramConnection, Object paramObject)
/*      */     throws SQLException
/*      */   {
/*  117 */     assertNotNull(paramArrayDescriptor);
/*      */ 
/*  119 */     this.descriptor = paramArrayDescriptor;
/*      */ 
/*  121 */     assertNotNull(paramConnection);
/*      */ 
/*  123 */     if (!paramArrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin()))
/*      */     {
/*  126 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance,invalid connection");
/*      */ 
/*  128 */       localSQLException.fillInStackTrace();
/*  129 */       throw localSQLException;
/*      */     }
/*      */ 
/*  133 */     paramArrayDescriptor.setConnection(paramConnection);
/*  134 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  137 */     if (paramObject == null)
/*  138 */       this.datumArray = new Datum[0];
/*      */     else
/*  140 */       this.datumArray = this.descriptor.toOracleArray(paramObject, 1L, -1);
/*      */   }
/*      */ 
/*      */   public ARRAY(ArrayDescriptor paramArrayDescriptor, byte[] paramArrayOfByte, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  157 */     super(paramArrayOfByte);
/*      */ 
/*  161 */     assertNotNull(paramArrayDescriptor);
/*      */ 
/*  163 */     this.descriptor = paramArrayDescriptor;
/*      */ 
/*  165 */     assertNotNull(paramConnection);
/*      */ 
/*  167 */     if (!paramArrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin()))
/*      */     {
/*  170 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance,invalid connection");
/*      */ 
/*  172 */       localSQLException.fillInStackTrace();
/*  173 */       throw localSQLException;
/*      */     }
/*      */ 
/*  177 */     paramArrayDescriptor.setConnection(paramConnection);
/*  178 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  180 */     this.datumArray = null;
/*  181 */     this.locator = null;
/*      */   }
/*      */ 
/*      */   public static ARRAY toARRAY(Object paramObject, oracle.jdbc.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  200 */     ARRAY localARRAY = null;
/*      */ 
/*  202 */     if (paramObject != null)
/*  203 */       if ((paramObject instanceof ARRAY))
/*      */       {
/*  205 */         localARRAY = (ARRAY)paramObject;
/*      */       }
/*  207 */       else if ((paramObject instanceof ORAData))
/*      */       {
/*  209 */         localARRAY = (ARRAY)((ORAData)paramObject).toDatum(paramOracleConnection);
/*      */       }
/*      */       else
/*      */       {
/*      */         Object localObject;
/*  211 */         if ((paramObject instanceof OracleData))
/*      */         {
/*  214 */           localObject = ((OracleData)paramObject).toJDBCObject(paramOracleConnection);
/*      */ 
/*  218 */           if ((localObject instanceof _Proxy_))
/*      */           {
/*  220 */             _Proxy_ local_Proxy_ = (_Proxy_)localObject;
/*  221 */             localObject = AccessController.doPrivileged(new PrivilegedAction()
/*      */             {
/*      */               public Object run()
/*      */               {
/*  226 */                 return ProxyFactory.extractDelegate(this.val$proxiedJDBCObject);
/*      */               }
/*      */             });
/*      */           }
/*      */ 
/*  231 */           localARRAY = (ARRAY)localObject;
/*      */         }
/*  234 */         else if ((paramObject instanceof CustomDatum))
/*      */         {
/*  236 */           localARRAY = (ARRAY)paramOracleConnection.physicalConnectionWithin().toDatum((CustomDatum)paramObject);
/*      */         }
/*      */         else
/*      */         {
/*  243 */           localObject = DatabaseError.createSqlException(null, 59, paramObject);
/*  244 */           ((SQLException)localObject).fillInStackTrace();
/*  245 */           throw ((Throwable)localObject);
/*      */         }
/*      */       }
/*  248 */     return localARRAY;
/*      */   }
/*      */ 
/*      */   public String getBaseTypeName()
/*      */     throws SQLException
/*      */   {
/*  277 */     synchronized (getInternalConnection())
/*      */     {
/*  284 */       return this.descriptor.getBaseName();
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getBaseType()
/*      */     throws SQLException
/*      */   {
/*  303 */     synchronized (getInternalConnection())
/*      */     {
/*  310 */       return this.descriptor.getBaseType();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getArray()
/*      */     throws SQLException
/*      */   {
/*  328 */     synchronized (getInternalConnection())
/*      */     {
/*  335 */       return this.descriptor.toJavaArray(this, 1L, -1, getMap(), this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getArray(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  353 */     synchronized (getInternalConnection())
/*      */     {
/*  360 */       return this.descriptor.toJavaArray(this, 1L, -1, paramMap, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  382 */     synchronized (getInternalConnection())
/*      */     {
/*  390 */       if ((paramLong < 1L) || (paramInt < 0))
/*      */       {
/*  394 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "Invalid arguments,'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
/*      */ 
/*  396 */         localSQLException.fillInStackTrace();
/*  397 */         throw localSQLException;
/*      */       }
/*      */ 
/*  401 */       return this.descriptor.toJavaArray(this, paramLong, paramInt, getMap(), false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getArray(long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  424 */     synchronized (getInternalConnection())
/*      */     {
/*  432 */       if ((paramLong < 1L) || (paramInt < 0))
/*      */       {
/*  436 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "Invalid arguments,'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
/*      */ 
/*  438 */         localSQLException.fillInStackTrace();
/*  439 */         throw localSQLException;
/*      */       }
/*      */ 
/*  443 */       return this.descriptor.toJavaArray(this, paramLong, paramInt, paramMap, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getResultSet()
/*      */     throws SQLException
/*      */   {
/*  471 */     synchronized (getInternalConnection())
/*      */     {
/*  480 */       return getResultSet(getInternalConnection().getTypeMap());
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getResultSet(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  512 */     synchronized (getInternalConnection())
/*      */     {
/*  519 */       return this.descriptor.toResultSet(this, 1L, -1, paramMap, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getResultSet(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  555 */     synchronized (getInternalConnection())
/*      */     {
/*  564 */       return getResultSet(paramLong, paramInt, getInternalConnection().getTypeMap());
/*      */     }
/*      */   }
/*      */ 
/*      */   public ResultSet getResultSet(long paramLong, int paramInt, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  604 */     synchronized (getInternalConnection())
/*      */     {
/*  612 */       if ((paramLong < 1L) || (paramInt < -1))
/*      */       {
/*  615 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getResultSet()");
/*  616 */         localSQLException.fillInStackTrace();
/*  617 */         throw localSQLException;
/*      */       }
/*      */ 
/*  621 */       return this.descriptor.toResultSet(this, paramLong, paramInt, paramMap, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Datum[] getOracleArray()
/*      */     throws SQLException
/*      */   {
/*  641 */     synchronized (getInternalConnection())
/*      */     {
/*  648 */       return this.descriptor.toOracleArray(this, 1L, -1, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int length()
/*      */     throws SQLException
/*      */   {
/*  663 */     synchronized (getInternalConnection())
/*      */     {
/*  670 */       return this.descriptor.toLength(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Datum[] getOracleArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  688 */     synchronized (getInternalConnection())
/*      */     {
/*  696 */       if ((paramLong < 1L) || (paramInt < 0))
/*      */       {
/*  699 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, "getOracleArray()");
/*  700 */         localSQLException.fillInStackTrace();
/*  701 */         throw localSQLException;
/*      */       }
/*      */ 
/*  705 */       return this.descriptor.toOracleArray(this, paramLong, paramInt, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getSQLTypeName()
/*      */     throws SQLException
/*      */   {
/*  725 */     synchronized (getInternalConnection())
/*      */     {
/*  732 */       String str = null;
/*      */ 
/*  734 */       if (this.descriptor != null)
/*      */       {
/*  736 */         str = this.descriptor.getName();
/*      */       }
/*      */       else
/*      */       {
/*  741 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 61, "ARRAY");
/*  742 */         localSQLException.fillInStackTrace();
/*  743 */         throw localSQLException;
/*      */       }
/*      */ 
/*  747 */       return str;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map getMap()
/*      */     throws SQLException
/*      */   {
/*  760 */     return getInternalConnection().getTypeMap();
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData getOracleMetaData()
/*      */     throws SQLException
/*      */   {
/*  777 */     return getDescriptor();
/*      */   }
/*      */ 
/*      */   public ArrayDescriptor getDescriptor()
/*      */     throws SQLException
/*      */   {
/*  798 */     return this.descriptor;
/*      */   }
/*      */ 
/*      */   public byte[] toBytes()
/*      */     throws SQLException
/*      */   {
/*  810 */     synchronized (getInternalConnection())
/*      */     {
/*  812 */       return this.descriptor.toBytes(this, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDatumArray(Datum[] paramArrayOfDatum)
/*      */   {
/*  828 */     this.datumArray = paramArrayOfDatum;
/*      */   }
/*      */ 
/*      */   public void setObjArray(Object paramObject)
/*      */     throws SQLException
/*      */   {
/*  847 */     synchronized (getInternalConnection())
/*      */     {
/*  850 */       if (paramObject == null)
/*      */       {
/*  854 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Invalid argument,'oarray' should not be null. An exception is thrown.");
/*      */ 
/*  856 */         localSQLException.fillInStackTrace();
/*  857 */         throw localSQLException;
/*      */       }
/*      */ 
/*  861 */       this.objArray = paramObject;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setLocator(byte[] paramArrayOfByte)
/*      */   {
/*  879 */     if ((paramArrayOfByte != null) && (paramArrayOfByte.length != 0))
/*  880 */       this.locator = paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   public void setPrefixSegment(byte[] paramArrayOfByte)
/*      */   {
/*  894 */     if ((paramArrayOfByte != null) && (paramArrayOfByte.length != 0))
/*  895 */       this.prefixSegment = paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   public void setPrefixFlag(byte paramByte)
/*      */   {
/*  909 */     this.prefixFlag = paramByte;
/*      */   }
/*      */ 
/*      */   public byte[] getLocator()
/*      */   {
/*  922 */     return this.locator;
/*      */   }
/*      */ 
/*      */   public void setLength(int paramInt)
/*      */   {
/*  933 */     this.numElems = paramInt;
/*      */   }
/*      */ 
/*      */   public boolean hasDataSeg()
/*      */   {
/*  945 */     return this.locator == null;
/*      */   }
/*      */ 
/*      */   public boolean isInline()
/*      */   {
/*  957 */     return (this.prefixFlag & 0x1) == 1;
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/*  972 */     Map localMap = getMap();
/*  973 */     return toJdbc(localMap);
/*      */   }
/*      */ 
/*      */   public Object toJdbc(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  990 */     Object localObject = this;
/*  991 */     if (paramMap != null) {
/*  992 */       Class localClass = this.descriptor.getClass(paramMap);
/*  993 */       if (localClass != null)
/*  994 */         localObject = toClass(localClass, paramMap);
/*      */     }
/*  996 */     return localObject;
/*      */   }
/*      */ 
/*      */   Object toClass(Class paramClass, Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1021 */     Object localObject1 = null;
/*      */     try {
/* 1023 */       if ((paramClass == null) || (paramClass == ARRAY.class) || (paramClass == Array.class)) {
/* 1024 */         localObject1 = this;
/*      */       }
/*      */       else {
/* 1027 */         Object localObject2 = paramClass.newInstance();
/* 1028 */         if ((localObject2 instanceof ORADataFactory)) {
/* 1029 */           localObject3 = (ORADataFactory)localObject2;
/* 1030 */           localObject1 = ((ORADataFactory)localObject3).create(this, 2003);
/*      */         }
/* 1032 */         else if ((localObject2 instanceof OracleDataFactory)) {
/* 1033 */           localObject3 = (OracleDataFactory)localObject2;
/* 1034 */           localObject1 = ((OracleDataFactory)localObject3).create(this, 2003);
/*      */         }
/*      */         else
/*      */         {
/* 1038 */           localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
/* 1039 */           ((SQLException)localObject3).fillInStackTrace();
/* 1040 */           throw ((Throwable)localObject3);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (InstantiationException localInstantiationException)
/*      */     {
/* 1047 */       localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + localInstantiationException.getMessage());
/* 1048 */       ((SQLException)localObject3).fillInStackTrace();
/* 1049 */       throw ((Throwable)localObject3);
/*      */     }
/*      */     catch (IllegalAccessException localIllegalAccessException)
/*      */     {
/* 1054 */       Object localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + localIllegalAccessException.getMessage());
/* 1055 */       ((SQLException)localObject3).fillInStackTrace();
/* 1056 */       throw ((Throwable)localObject3);
/*      */     }
/*      */ 
/* 1059 */     return localObject1;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/* 1082 */     return false;
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/* 1093 */     return new Object[paramInt][];
/*      */   }
/*      */ 
/*      */   public int[] getIntArray()
/*      */     throws SQLException
/*      */   {
/* 1107 */     synchronized (getInternalConnection())
/*      */     {
/* 1114 */       return (int[])this.descriptor.toNumericArray(this, 1L, -1, 4, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int[] getIntArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1133 */     synchronized (getInternalConnection())
/*      */     {
/* 1140 */       return (int[])this.descriptor.toNumericArray(this, paramLong, paramInt, 4, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public double[] getDoubleArray()
/*      */     throws SQLException
/*      */   {
/* 1155 */     synchronized (getInternalConnection())
/*      */     {
/* 1162 */       return (double[])this.descriptor.toNumericArray(this, 1L, -1, 5, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public double[] getDoubleArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1181 */     synchronized (getInternalConnection())
/*      */     {
/* 1188 */       return (double[])this.descriptor.toNumericArray(this, paramLong, paramInt, 5, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public short[] getShortArray()
/*      */     throws SQLException
/*      */   {
/* 1203 */     synchronized (getInternalConnection())
/*      */     {
/* 1210 */       return (short[])this.descriptor.toNumericArray(this, 1L, -1, 8, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public short[] getShortArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1219 */     synchronized (getInternalConnection())
/*      */     {
/* 1226 */       return (short[])this.descriptor.toNumericArray(this, paramLong, paramInt, 8, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public long[] getLongArray()
/*      */     throws SQLException
/*      */   {
/* 1240 */     synchronized (getInternalConnection())
/*      */     {
/* 1247 */       return (long[])this.descriptor.toNumericArray(this, 1L, -1, 7, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public long[] getLongArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1264 */     synchronized (getInternalConnection())
/*      */     {
/* 1271 */       return (long[])this.descriptor.toNumericArray(this, paramLong, paramInt, 7, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public float[] getFloatArray()
/*      */     throws SQLException
/*      */   {
/* 1285 */     synchronized (getInternalConnection())
/*      */     {
/* 1292 */       return (float[])this.descriptor.toNumericArray(this, 1L, -1, 6, this.enableBuffering);
/*      */     }
/*      */   }
/*      */ 
/*      */   public float[] getFloatArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1309 */     synchronized (getInternalConnection())
/*      */     {
/* 1316 */       return (float[])this.descriptor.toNumericArray(this, paramLong, paramInt, 6, false);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setAutoBuffering(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1337 */     synchronized (getInternalConnection())
/*      */     {
/* 1344 */       this.enableBuffering = paramBoolean;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getAutoBuffering()
/*      */     throws SQLException
/*      */   {
/* 1367 */     return this.enableBuffering;
/*      */   }
/*      */ 
/*      */   public void setAutoIndexing(boolean paramBoolean, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1391 */     synchronized (getInternalConnection())
/*      */     {
/* 1398 */       this.enableIndexing = paramBoolean;
/* 1399 */       this.accessDirection = paramInt;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setAutoIndexing(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1419 */     synchronized (getInternalConnection())
/*      */     {
/* 1426 */       this.enableIndexing = paramBoolean;
/* 1427 */       this.accessDirection = 3;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getAutoIndexing()
/*      */     throws SQLException
/*      */   {
/* 1451 */     return this.enableIndexing;
/*      */   }
/*      */ 
/*      */   public int getAccessDirection()
/*      */     throws SQLException
/*      */   {
/* 1474 */     return this.accessDirection;
/*      */   }
/*      */ 
/*      */   public void setLastIndexOffset(long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 1491 */     this.lastIndex = paramLong1;
/* 1492 */     this.lastOffset = paramLong2;
/*      */   }
/*      */ 
/*      */   public void setIndexOffset(long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 1505 */     if (this.indexArray == null) {
/* 1506 */       this.indexArray = new long[this.numElems];
/*      */     }
/* 1508 */     this.indexArray[((int)paramLong1 - 1)] = paramLong2;
/*      */   }
/*      */ 
/*      */   public long getLastIndex()
/*      */     throws SQLException
/*      */   {
/* 1520 */     return this.lastIndex;
/*      */   }
/*      */ 
/*      */   public long getLastOffset()
/*      */     throws SQLException
/*      */   {
/* 1531 */     return this.lastOffset;
/*      */   }
/*      */ 
/*      */   public long getOffset(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1542 */     long l = -1L;
/*      */ 
/* 1544 */     if (this.indexArray != null) {
/* 1545 */       l = this.indexArray[((int)paramLong - 1)];
/*      */     }
/* 1547 */     return l;
/*      */   }
/*      */ 
/*      */   public void setImage(byte[] paramArrayOfByte, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/* 1564 */     setShareBytes(paramArrayOfByte);
/*      */ 
/* 1566 */     this.imageOffset = paramLong1;
/* 1567 */     this.imageLength = paramLong2;
/*      */   }
/*      */ 
/*      */   public void setImageLength(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1580 */     this.imageLength = paramLong;
/*      */   }
/*      */ 
/*      */   public long getImageOffset()
/*      */   {
/* 1593 */     return this.imageOffset;
/*      */   }
/*      */ 
/*      */   public long getImageLength()
/*      */   {
/* 1605 */     return this.imageLength;
/*      */   }
/*      */ 
/*      */   public String dump()
/*      */     throws SQLException
/*      */   {
/* 1627 */     return STRUCT.dump(this);
/*      */   }
/*      */ 
/*      */   public String stringValue()
/*      */     throws SQLException
/*      */   {
/* 1639 */     Datum[] arrayOfDatum = getOracleArray();
/* 1640 */     String str = "[";
/* 1641 */     for (int i = 0; i < arrayOfDatum.length; i++)
/*      */     {
/* 1643 */       if (i != 0)
/*      */       {
/* 1645 */         str = str + ", ";
/*      */       }
/* 1647 */       if (arrayOfDatum[i] == null)
/* 1648 */         str = str + "null";
/*      */       else
/* 1650 */         str = str + arrayOfDatum[i].stringValue();
/*      */     }
/* 1652 */     str = str + "]";
/* 1653 */     return str;
/*      */   }
/*      */ 
/*      */   static void dump(ARRAY paramARRAY, PrintWriter paramPrintWriter, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1660 */     if (paramInt > 0) paramPrintWriter.println();
/*      */ 
/* 1663 */     ArrayDescriptor localArrayDescriptor = paramARRAY.getDescriptor();
/* 1664 */     for (int j = 0; j < paramInt; j++) paramPrintWriter.print(' ');
/* 1665 */     paramPrintWriter.println("name = " + localArrayDescriptor.getName());
/*      */ 
/* 1667 */     for (j = 0; j < paramInt; j++) paramPrintWriter.print(' ');
/* 1668 */     paramPrintWriter.println("max length = " + localArrayDescriptor.getMaxLength());
/* 1669 */     Object[] arrayOfObject = (Object[])paramARRAY.getArray();
/* 1670 */     for (j = 0; j < paramInt; j++) paramPrintWriter.print(' ');
/*      */     int i;
/* 1671 */     paramPrintWriter.println("length = " + (i = arrayOfObject.length));
/* 1672 */     for (j = 0; j < i; j++)
/*      */     {
/* 1674 */       for (int k = 0; k < paramInt; k++) paramPrintWriter.print(' ');
/* 1675 */       paramPrintWriter.print("element[" + j + "] = ");
/* 1676 */       STRUCT.dump(arrayOfObject[j], paramPrintWriter, paramInt + 4);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void free()
/*      */     throws SQLException
/*      */   {
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 1698 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 1703 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.ARRAY
 * JD-Core Version:    0.6.2
 */