/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleData;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.driver.InternalFactory;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.oracore.PickleContext;
/*     */ import oracle.xdb.XMLType;
/*     */ 
/*     */ public class ANYDATA
/*     */   implements ORAData, OracleData
/*     */ {
/*     */   static final byte KAD_VSN = 1;
/*     */   static final byte KAD_VSN2 = 2;
/*     */   boolean isNull;
/*     */   byte[] data;
/*     */   TypeDescriptor type;
/* 139 */   boolean isREF = false;
/* 140 */   short serverCharsetId = 0;
/* 141 */   short serverNCharsetId = 0;
/*     */   OracleConnection connection;
/* 738 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   ANYDATA(TypeDescriptor paramTypeDescriptor, boolean paramBoolean1, byte[] paramArrayOfByte, boolean paramBoolean2)
/*     */   {
/* 150 */     this.type = paramTypeDescriptor;
/* 151 */     this.isNull = paramBoolean1;
/* 152 */     this.data = paramArrayOfByte;
/* 153 */     this.isREF = paramBoolean2;
/*     */   }
/*     */ 
/*     */   public ANYDATA(OPAQUE paramOPAQUE)
/*     */     throws SQLException
/*     */   {
/* 163 */     byte[] arrayOfByte = paramOPAQUE.getBytesValue();
/* 164 */     this.connection = paramOPAQUE.getPhysicalConnection();
/* 165 */     if (this.connection != null)
/*     */     {
/* 167 */       this.serverCharsetId = this.connection.getDbCsId();
/* 168 */       this.serverNCharsetId = this.connection.getNCharSet();
/*     */     }
/* 170 */     unpickle(arrayOfByte, 0);
/*     */   }
/*     */ 
/*     */   int unpickle(byte[] paramArrayOfByte, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 183 */     PickleContext localPickleContext = new PickleContext(paramArrayOfByte, paramInt);
/* 184 */     int i = localPickleContext.readByte();
/* 185 */     if (i == 2) {
/* 186 */       localPickleContext.skipBytes(4);
/*     */     }
/*     */ 
/* 199 */     short[] arrayOfShort = new short[1];
/* 200 */     this.type = TypeDescriptor.unpickleOpaqueTypeImage(localPickleContext, this.connection, arrayOfShort);
/* 201 */     if (localPickleContext.readByte() != 0)
/* 202 */       this.isNull = true;
/*     */     else
/* 204 */       this.isNull = false;
/* 205 */     if (!this.isNull)
/*     */     {
/* 207 */       j = (int)localPickleContext.readUB4();
/* 208 */       this.data = localPickleContext.readDataValue(j);
/*     */     }
/* 210 */     if (arrayOfShort[0] == 110)
/* 211 */       this.isREF = true;
/*     */     else
/* 213 */       this.isREF = false;
/* 214 */     int j = localPickleContext.offset();
/* 215 */     return j;
/*     */   }
/*     */ 
/*     */   int pickle(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 229 */     paramArrayOfByte[(paramInt++)] = 1;
/* 230 */     paramInt = this.type.pickleOpaqueTypeImage(paramArrayOfByte, paramInt, this.isREF);
/*     */ 
/* 232 */     if (this.isNull)
/* 233 */       paramArrayOfByte[(paramInt++)] = 1;
/*     */     else
/* 235 */       paramArrayOfByte[(paramInt++)] = 0;
/* 236 */     if (!this.isNull)
/*     */     {
/* 238 */       int i = this.data.length;
/* 239 */       paramArrayOfByte[(paramInt++)] = ((byte)((i & 0xFF000000) >> 24 & 0xFF));
/* 240 */       paramArrayOfByte[(paramInt++)] = ((byte)((i & 0xFF0000) >> 16 & 0xFF));
/* 241 */       paramArrayOfByte[(paramInt++)] = ((byte)((i & 0xFF00) >> 8 & 0xFF));
/* 242 */       paramArrayOfByte[(paramInt++)] = ((byte)(i & 0xFF));
/* 243 */       System.arraycopy(this.data, 0, paramArrayOfByte, paramInt, i);
/* 244 */       paramInt += i;
/*     */     }
/* 246 */     return paramInt;
/*     */   }
/*     */ 
/*     */   int getImageSize()
/*     */   {
/* 257 */     int i = this.type.getOpaqueImageTypeSize() + 1 + 1;
/*     */ 
/* 260 */     if (!this.isNull)
/* 261 */       i += 4 + this.data.length;
/* 262 */     return i;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 271 */     this.connection = ((OracleConnection)paramConnection);
/* 272 */     OpaqueDescriptor localOpaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", paramConnection);
/*     */ 
/* 274 */     byte[] arrayOfByte = new byte[getImageSize()];
/* 275 */     pickle(arrayOfByte, 0);
/* 276 */     OPAQUE localOPAQUE = new OPAQUE(localOpaqueDescriptor, this.connection, arrayOfByte);
/*     */ 
/* 284 */     localOPAQUE.setShareBytes(localOPAQUE.toBytes());
/* 285 */     return localOPAQUE;
/*     */   }
/*     */ 
/*     */   public Object toJDBCObject(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 292 */     return toDatum(paramConnection);
/*     */   }
/*     */ 
/*     */   public static ANYDATA convertDatum(Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 329 */     ANYDATA localANYDATA = null;
/*     */ 
/* 331 */     if (paramDatum != null)
/*     */     {
/* 333 */       if ((paramDatum instanceof STRUCT)) {
/* 334 */         localANYDATA = new ANYDATA(((STRUCT)paramDatum).getDescriptor(), false, ((STRUCT)paramDatum).toBytes(), false);
/* 335 */       } else if ((paramDatum instanceof ARRAY)) {
/* 336 */         localANYDATA = new ANYDATA(((ARRAY)paramDatum).getDescriptor(), false, ((ARRAY)paramDatum).toBytes(), false);
/* 337 */       } else if ((paramDatum instanceof REF)) {
/* 338 */         localANYDATA = new ANYDATA(((REF)paramDatum).getDescriptor(), false, ((REF)paramDatum).getBytes(), true);
/* 339 */       } else if ((paramDatum instanceof OPAQUE)) {
/* 340 */         localANYDATA = new ANYDATA(((OPAQUE)paramDatum).getDescriptor(), false, ((OPAQUE)paramDatum).toBytes(), false);
/*     */       }
/*     */       else {
/* 343 */         TypeDescriptor localTypeDescriptor = null;
/* 344 */         if ((paramDatum instanceof NUMBER))
/* 345 */           localTypeDescriptor = new TypeDescriptor((short)2);
/* 346 */         else if ((paramDatum instanceof DATE))
/* 347 */           localTypeDescriptor = new TypeDescriptor((short)12);
/* 348 */         else if ((paramDatum instanceof INTERVALDS))
/* 349 */           localTypeDescriptor = new TypeDescriptor((short)190);
/* 350 */         else if ((paramDatum instanceof INTERVALYM))
/* 351 */           localTypeDescriptor = new TypeDescriptor((short)189);
/* 352 */         else if ((paramDatum instanceof TIMESTAMPTZ))
/* 353 */           localTypeDescriptor = new TypeDescriptor((short)188);
/* 354 */         else if ((paramDatum instanceof TIMESTAMPLTZ))
/* 355 */           localTypeDescriptor = new TypeDescriptor((short)232);
/* 356 */         else if ((paramDatum instanceof TIMESTAMP))
/* 357 */           localTypeDescriptor = new TypeDescriptor((short)187);
/* 358 */         else if ((paramDatum instanceof NCLOB))
/*     */         {
/* 360 */           localTypeDescriptor = new TypeDescriptor((short)288);
/* 361 */         } else if ((paramDatum instanceof CLOB))
/* 362 */           localTypeDescriptor = new TypeDescriptor((short)112);
/* 363 */         else if ((paramDatum instanceof BLOB))
/* 364 */           localTypeDescriptor = new TypeDescriptor((short)113);
/* 365 */         else if ((paramDatum instanceof BFILE))
/* 366 */           localTypeDescriptor = new TypeDescriptor((short)114);
/* 367 */         else if ((paramDatum instanceof RAW))
/* 368 */           localTypeDescriptor = new TypeDescriptor((short)95);
/* 369 */         else if ((paramDatum instanceof BINARY_DOUBLE))
/* 370 */           localTypeDescriptor = new TypeDescriptor((short)101);
/* 371 */         else if ((paramDatum instanceof BINARY_FLOAT))
/* 372 */           localTypeDescriptor = new TypeDescriptor((short)100);
/* 373 */         else if ((paramDatum instanceof ROWID))
/* 374 */           localTypeDescriptor = new TypeDescriptor((short)104);
/* 375 */         else if ((paramDatum instanceof CHAR)) {
/* 376 */           localTypeDescriptor = new TypeDescriptor((short)96);
/*     */         }
/* 378 */         if ((paramDatum instanceof ROWID))
/*     */         {
/* 380 */           byte[] arrayOfByte1 = paramDatum.shareBytes();
/*     */ 
/* 385 */           long[] arrayOfLong = InternalFactory.rowid2urowid(arrayOfByte1, 0, arrayOfByte1.length);
/* 386 */           byte[] arrayOfByte2 = new byte[13];
/*     */ 
/* 389 */           arrayOfByte2[0] = 1;
/* 390 */           arrayOfByte2[1] = ((byte)(int)((arrayOfLong[0] & 0xFF000000) >> 24));
/* 391 */           arrayOfByte2[2] = ((byte)(int)((arrayOfLong[0] & 0xFF0000) >> 16));
/* 392 */           arrayOfByte2[3] = ((byte)(int)((arrayOfLong[0] & 0xFF00) >> 8));
/* 393 */           arrayOfByte2[4] = ((byte)(int)(arrayOfLong[0] & 0xFF));
/* 394 */           arrayOfByte2[5] = ((byte)(int)((arrayOfLong[1] & 0xFF00) >> 8));
/* 395 */           arrayOfByte2[6] = ((byte)(int)(arrayOfLong[1] & 0xFF));
/* 396 */           arrayOfByte2[7] = ((byte)(int)((arrayOfLong[2] & 0xFF000000) >> 24));
/* 397 */           arrayOfByte2[8] = ((byte)(int)((arrayOfLong[2] & 0xFF0000) >> 16));
/* 398 */           arrayOfByte2[9] = ((byte)(int)((arrayOfLong[2] & 0xFF00) >> 8));
/* 399 */           arrayOfByte2[10] = ((byte)(int)(arrayOfLong[2] & 0xFF));
/* 400 */           arrayOfByte2[11] = ((byte)(int)((arrayOfLong[3] & 0xFF00) >> 8));
/* 401 */           arrayOfByte2[12] = ((byte)(int)(arrayOfLong[3] & 0xFF));
/* 402 */           localANYDATA = new ANYDATA(localTypeDescriptor, false, arrayOfByte2, false);
/*     */         }
/*     */         else {
/* 405 */           localANYDATA = new ANYDATA(localTypeDescriptor, false, paramDatum.shareBytes(), false);
/*     */         }
/*     */       }
/*     */ 
/* 409 */       if ((paramDatum instanceof DatumWithConnection))
/* 410 */         localANYDATA.connection = ((DatumWithConnection)paramDatum).getInternalConnection();
/*     */     }
/* 412 */     return localANYDATA;
/*     */   }
/*     */ 
/*     */   public TypeDescriptor getTypeDescriptor()
/*     */   {
/* 422 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean isNull()
/*     */   {
/* 433 */     return this.isNull;
/*     */   }
/*     */ 
/*     */   public byte[] getData()
/*     */   {
/* 444 */     return this.data;
/*     */   }
/*     */ 
/*     */   public boolean isREF()
/*     */   {
/* 453 */     return this.isREF;
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */     throws SQLException
/*     */   {
/* 478 */     return stringValue(this.connection);
/*     */   }
/*     */ 
/*     */   public String stringValue(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 509 */     String str1 = null;
/*     */ 
/* 511 */     str1 = "ANYDATA TypeCode: \"" + getTypeDescriptor().getTypeCodeName();
/* 512 */     if (this.isREF)
/* 513 */       str1 = str1 + "(REF)";
/* 514 */     str1 = str1 + "\" - ANYDATA Value: \"";
/*     */ 
/* 516 */     Datum localDatum = accessDatum();
/* 517 */     int i = 0;
/*     */     try
/*     */     {
/* 520 */       str1 = str1 + localDatum.stringValue();
/* 521 */       i = 1;
/*     */     }
/*     */     catch (SQLException localSQLException) {
/*     */     }
/* 525 */     if (i == 0)
/*     */     {
/* 527 */       if (((this.type.getInternalTypeCode() == 108) || (this.type.getInternalTypeCode() == 110)) && (!this.type.isTransient()))
/*     */       {
/* 530 */         str1 = str1 + ((StructDescriptor)this.type).getName() + "(...)";
/* 531 */       } else if ((this.type.getInternalTypeCode() == 122) && (!this.type.isTransient()))
/*     */       {
/* 533 */         str1 = str1 + ((ArrayDescriptor)this.type).getName() + "(...)";
/*     */       }
/*     */       else
/*     */       {
/*     */         Object localObject1;
/* 536 */         switch (this.type.getInternalTypeCode())
/*     */         {
/*     */         case 113:
/* 541 */           localObject1 = ((BLOB)localDatum).getBinaryStream();
/*     */           try
/*     */           {
/* 544 */             String str3 = "";
/*     */             int j;
/* 545 */             while ((j = ((InputStream)localObject1).read()) != -1)
/* 546 */               str3 = str3 + Integer.toHexString(j);
/* 547 */             str1 = str1 + str3; } catch (IOException localIOException2) { } finally {
/*     */             try {
/* 549 */               ((InputStream)localObject1).close(); } catch (IOException localIOException4) {  }
/*     */           }
/* 551 */           break;
/*     */         case 188:
/* 557 */           if (paramConnection == null)
/* 558 */             str1 = str1 + "?";
/*     */           else {
/* 560 */             str1 = str1 + ((TIMESTAMPTZ)localDatum).stringValue(paramConnection);
/*     */           }
/* 562 */           break;
/*     */         case 232:
/* 568 */           if (paramConnection == null)
/* 569 */             str1 = str1 + "?";
/*     */           else {
/* 571 */             str1 = str1 + ((TIMESTAMPLTZ)localDatum).stringValue(paramConnection);
/*     */           }
/* 573 */           break;
/*     */         case 114:
/* 576 */           str1 = str1 + "bfile_dir=" + ((BFILE)localDatum).getDirAlias() + " bfile_name=" + ((BFILE)localDatum).getName();
/*     */ 
/* 579 */           break;
/*     */         case 58:
/* 581 */           localObject1 = (OPAQUE)localDatum;
/* 582 */           String str2 = ((OPAQUE)localObject1).getSQLTypeName();
/* 583 */           str1 = str1 + "OPAQUE(" + str2 + ")";
/* 584 */           if (str2.compareTo("SYS.XMLTYPE") == 0)
/*     */           {
/* 586 */             str1 = str1 + ":";
/* 587 */             XMLType localXMLType = XMLType.createXML((OPAQUE)localObject1);
/* 588 */             str1 = str1 + localXMLType.getStringVal();
/*     */           }
/*     */           break;
/*     */         }
/*     */       }
/*     */     }
/* 594 */     str1 = str1 + "\"";
/*     */ 
/* 596 */     return str1;
/*     */   }
/*     */ 
/*     */   public Datum accessDatum()
/*     */     throws SQLException
/*     */   {
/* 608 */     Object localObject = null;
/* 609 */     if (!this.isNull)
/*     */     {
/* 611 */       int i = this.type.getInternalTypeCode();
/* 612 */       switch (i)
/*     */       {
/*     */       case 58:
/* 615 */         localObject = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
/* 616 */         break;
/*     */       case 108:
/* 618 */         if ((this.type instanceof OpaqueDescriptor))
/* 619 */           localObject = new OPAQUE((OpaqueDescriptor)this.type, this.data, this.connection);
/* 620 */         else if (!this.isREF)
/* 621 */           localObject = new STRUCT((StructDescriptor)this.type, this.data, this.connection);
/*     */         else
/* 623 */           localObject = new REF((StructDescriptor)this.type, this.connection, this.data);
/* 624 */         break;
/*     */       case 122:
/* 626 */         localObject = new ARRAY((ArrayDescriptor)this.type, this.data, this.connection);
/* 627 */         break;
/*     */       case 110:
/* 629 */         localObject = new REF((StructDescriptor)this.type, this.connection, this.data);
/* 630 */         break;
/*     */       case 2:
/* 632 */         localObject = new NUMBER(this.data);
/* 633 */         break;
/*     */       case 12:
/* 635 */         localObject = new DATE(this.data);
/* 636 */         break;
/*     */       case 190:
/* 638 */         localObject = new INTERVALDS(this.data);
/* 639 */         break;
/*     */       case 189:
/* 641 */         localObject = new INTERVALYM(this.data);
/* 642 */         break;
/*     */       case 188:
/* 644 */         localObject = new TIMESTAMPTZ(this.data);
/* 645 */         break;
/*     */       case 232:
/* 647 */         localObject = new TIMESTAMPLTZ(this.data);
/* 648 */         break;
/*     */       case 187:
/* 650 */         localObject = new TIMESTAMP(this.data);
/* 651 */         break;
/*     */       case 112:
/* 653 */         localObject = new CLOB(this.connection, this.data);
/* 654 */         break;
/*     */       case 288:
/* 656 */         localObject = new NCLOB(this.connection, this.data);
/* 657 */         break;
/*     */       case 113:
/* 659 */         localObject = new BLOB(this.connection, this.data);
/* 660 */         break;
/*     */       case 114:
/* 662 */         localObject = new BFILE(this.connection, this.data);
/* 663 */         break;
/*     */       case 95:
/* 665 */         localObject = new RAW(this.data);
/* 666 */         break;
/*     */       case 101:
/* 668 */         localObject = new BINARY_DOUBLE(this.data);
/* 669 */         break;
/*     */       case 100:
/* 671 */         localObject = new BINARY_FLOAT(this.data);
/* 672 */         break;
/*     */       case 104:
/* 675 */         long l1 = (this.data[1] & 0xFF) << 24 | (this.data[2] & 0xFF) << 16 | (this.data[3] & 0xFF) << 8 | this.data[4] & 0xFF;
/*     */ 
/* 679 */         long l2 = (this.data[5] & 0xFF) << 8 | this.data[6] & 0xFF;
/*     */ 
/* 681 */         long l3 = (this.data[7] & 0xFF) << 24 | (this.data[8] & 0xFF) << 16 | (this.data[9] & 0xFF) << 8 | this.data[10] & 0xFF;
/*     */ 
/* 685 */         long l4 = (this.data[11] & 0xFF) << 8 | this.data[12] & 0xFF;
/*     */ 
/* 687 */         long[] arrayOfLong = new long[4];
/* 688 */         arrayOfLong[0] = l1;
/* 689 */         arrayOfLong[1] = l2;
/* 690 */         arrayOfLong[2] = l3;
/* 691 */         arrayOfLong[3] = l4;
/* 692 */         byte[] arrayOfByte = InternalFactory.urowid2rowid(arrayOfLong);
/* 693 */         localObject = new ROWID(arrayOfByte);
/* 694 */         break;
/*     */       case 1:
/*     */       case 9:
/*     */       case 96:
/* 698 */         if (this.serverCharsetId != 0)
/* 699 */           localObject = new CHAR(this.data, CharacterSet.make(this.serverCharsetId));
/*     */         else
/* 701 */           localObject = new CHAR(this.data, null);
/* 702 */         break;
/*     */       case 286:
/*     */       case 287:
/* 705 */         if (this.serverNCharsetId != 0)
/* 706 */           localObject = new CHAR(this.data, CharacterSet.make(this.serverNCharsetId));
/*     */         else
/* 708 */           localObject = new CHAR(this.data, null);
/* 709 */         break;
/*     */       default:
/* 711 */         String str = "internal typecode: " + i;
/*     */ 
/* 713 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, str);
/* 714 */         localSQLException.fillInStackTrace();
/* 715 */         throw localSQLException;
/*     */       }
/*     */     }
/*     */ 
/* 719 */     return localObject;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 733 */     return this.connection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.ANYDATA
 * JD-Core Version:    0.6.2
 */