package oracle.security.o5logon;

import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.o3logon.O3LoginProtocolHelper;

public final class O5Logon
{
  public static final int AUTH_FLAG_O5LOGON = 0;
  public static final int AUTH_FLAG_NONO5LOGON = 1;
  private static final char[] a = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };
  private static final SecureRandom b = a();
  private final MessageDigest c = b();
  private final MessageDigest d = c();
  private final MessageDigest e = d();
  private byte[] f = null;
  private String g = null;
  private String h = null;

  private static final SecureRandom a()
  {
    SecureRandom localSecureRandom = null;
    try
    {
      localSecureRandom = SecureRandom.getInstance("SHA1PRNG");
      byte[] arrayOfByte = new byte[32];
      localSecureRandom.nextBytes(arrayOfByte);
    }
    catch (Exception localException)
    {
    }
    return localSecureRandom;
  }

  private static MessageDigest b()
  {
    MessageDigest localMessageDigest = null;
    try
    {
      localMessageDigest = MessageDigest.getInstance("MD5");
    }
    catch (Exception localException)
    {
    }
    return localMessageDigest;
  }

  private static MessageDigest c()
  {
    MessageDigest localMessageDigest = null;
    try
    {
      localMessageDigest = MessageDigest.getInstance("SHA1");
    }
    catch (Exception localException)
    {
    }
    return localMessageDigest;
  }

  private static MessageDigest d()
  {
    MessageDigest localMessageDigest = null;
    try
    {
      localMessageDigest = MessageDigest.getInstance("SHA-512");
    }
    catch (Exception localException)
    {
    }
    return localMessageDigest;
  }

  private final byte[] a(int paramInt, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
  {
    byte[] arrayOfByte = null;
    switch (paramInt)
    {
    case 2361:
    case 40674:
    case 59694:
      arrayOfByte = new byte[16];
      for (paramInt = 0; paramInt < 16; paramInt++)
        arrayOfByte[paramInt] = ((byte)(paramArrayOfByte1[(paramInt + 16)] ^ paramArrayOfByte2[(paramInt + 16)]));
      this.c.reset();
      paramInt = this.c.digest(arrayOfByte);
      break;
    case 6949:
    case 45394:
      arrayOfByte = new byte[24];
      for (paramInt = 0; paramInt < 24; paramInt++)
        arrayOfByte[paramInt] = ((byte)(paramArrayOfByte1[(paramInt + 16)] ^ paramArrayOfByte2[(paramInt + 16)]));
      paramInt = new byte[24];
      this.c.reset();
      this.c.update(arrayOfByte, 0, 16);
      System.arraycopy(this.c.digest(), 0, paramInt, 0, 16);
      this.c.reset();
      this.c.update(arrayOfByte, 16, 8);
      System.arraycopy(this.c.digest(), 0, paramInt, 16, 8);
      break;
    case 18453:
      arrayOfByte = new byte[32];
      for (paramInt = 0; paramInt < 32; paramInt++)
        arrayOfByte[paramInt] = ((byte)(paramArrayOfByte1[(paramInt + 16)] ^ paramArrayOfByte2[(paramInt + 16)]));
      paramInt = new byte[32];
      this.c.reset();
      this.c.update(arrayOfByte, 0, 16);
      System.arraycopy(this.c.digest(), 0, paramInt, 0, 16);
      this.c.reset();
      this.c.update(arrayOfByte, 16, 16);
      System.arraycopy(this.c.digest(), 0, paramInt, 16, 16);
      break;
    default:
      paramInt = new byte[0];
    }
    return paramInt;
  }

  public final byte[] getDerivedKey(byte[] paramArrayOfByte, int paramInt)
  {
    paramInt = this.f;
    StringBuffer localStringBuffer = new StringBuffer(paramInt.length << 1);
    for (int i = 0; i < paramInt.length; i++)
      for (int j = 1; j >= 0; j--)
        localStringBuffer.append(a[(paramInt[i] >> (j << 2) & 0xF)]);
    paramInt = localStringBuffer.toString();
    PBEKeySpec localPBEKeySpec = new PBEKeySpec(paramInt.toCharArray(), paramArrayOfByte, 1000, 160);
    paramArrayOfByte = (PBEKey)SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1").generateSecret(localPBEKeySpec);
    return new SecretKeySpec(paramArrayOfByte.getEncoded(), "AES").getEncoded();
  }

  public final boolean validateServerIdentity(String paramString)
  {
    boolean bool = false;
    try
    {
      String str2 = this.h;
      String str1 = paramString;
      paramString = this;
      paramString = a(this.f, str1, str2);
      bool = new String(paramString, 16, paramString.length - 16, "US-ASCII").compareTo("SERVER_TO_CLIENT") == 0;
    }
    catch (Exception localException)
    {
    }
    return bool;
  }

  private static byte[] a(byte[] paramArrayOfByte, String paramString1, String paramString2)
  {
    if (paramArrayOfByte == null)
      return new byte[0];
    byte[] arrayOfByte = new byte[16];
    for (int j = 0; j < arrayOfByte.length; j++)
      arrayOfByte[0] = 0;
    paramString1 = a(paramString1);
    int i;
    if (paramArrayOfByte.length == 16)
      i = 1;
    else if (paramArrayOfByte.length == 24)
      i = 2;
    else
      i = 3;
    if (paramString2.endsWith("PKCS5Padding"))
      paramString2 = 2;
    else
      paramString2 = 0;
    (paramString2 = new a(i, paramString2)).a(paramArrayOfByte);
    return paramString2.b(paramString1);
  }

  private final byte[] a(byte[] paramArrayOfByte, String paramString)
  {
    return a(this.f, paramArrayOfByte, paramString);
  }

  private static byte[] a(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, String paramString)
  {
    if (paramArrayOfByte1 == null)
      return new byte[0];
    byte[] arrayOfByte = new byte[16];
    for (int j = 0; j < arrayOfByte.length; j++)
      arrayOfByte[0] = 0;
    int i;
    if (paramArrayOfByte1.length == 16)
      i = 1;
    else if (paramArrayOfByte1.length == 24)
      i = 2;
    else
      i = 3;
    if (paramString.endsWith("PKCS5Padding"))
      paramString = 2;
    else
      paramString = 0;
    (paramString = new a(i, paramString)).a(paramArrayOfByte1);
    return paramString.c(paramArrayOfByte2);
  }

  public final void generateOAuthResponse(int paramInt, byte[] arg2, String paramString1, String arg4, byte[] paramArrayOfByte2, byte[] paramArrayOfByte3, byte[] paramArrayOfByte4, byte[] paramArrayOfByte5, int[] paramArrayOfInt, boolean paramBoolean, byte paramByte)
  {
    if ((b == null) || (this.d == null) || (this.c == null) || (this.e == null))
      throw new Exception("Resource A missing.");
    if (paramArrayOfInt.length != 1)
      throw new Exception("Resource B missing.");
    if (paramInt == 2361)
    {
      this.g = "AES/CBC/NoPadding";
      this.h = "AES/CBC/PKCS5Padding";
      paramString1 = new O3LoginProtocolHelper().getVerifier(paramString1, ???, Boolean.valueOf(paramBoolean));
      ??? = new byte[16];
      System.arraycopy(paramString1, 0, ???, 0, 8);
      for (??? = 8; ??? < 16; ???++)
        ???[???] = 0;
    }
    else if ((paramInt == 6949) || (paramInt == 45394))
    {
      if ((paramByte & 0x2) != 0)
        this.g = "AES/CBC/NoPadding";
      else
        this.g = "AES/CBC/PKCS5Padding";
      this.h = "AES/CBC/PKCS5Padding";
      this.d.reset();
      this.d.update(???.getBytes("UTF-8"));
      if ((paramInt == 6949) && (??? != null))
        this.d.update(a(new String(???, "US-ASCII")));
      paramByte = this.d.digest();
      ??? = new byte[24];
      for (paramString1 = 0; paramString1 < ???.length; paramString1++)
        ???[paramString1] = 0;
      System.arraycopy(paramByte, 0, ???, 0, paramByte.length);
    }
    else if ((paramInt == 40674) || (paramInt == 59694))
    {
      this.g = "AES/CBC/NoPadding";
      this.h = "AES/CBC/PKCS5Padding";
      this.c.reset();
      this.c.update(???.getBytes("UTF-8"));
      if (paramInt == 59694)
        this.c.update(a(new String(???, "US-ASCII")));
      ??? = this.c.digest();
    }
    else if (paramInt == 18453)
    {
      this.g = "AES/CBC/NoPadding";
      this.h = "AES/CBC/PKCS5Padding";
      this.e.reset();
      this.e.update(???.getBytes("UTF-8"));
      if (??? != null)
        this.e.update(a(new String(???, "US-ASCII")));
      paramByte = this.e.digest();
      ??? = new byte[32];
      for (paramString1 = 0; paramString1 < ???.length; paramString1++)
        ???[paramString1] = 0;
      System.arraycopy(paramByte, 0, ???, 0, ???.length);
    }
    else
    {
      throw new Exception("Resource C missing.");
    }
    paramString1 = new byte[(paramByte = a(???, new String(paramArrayOfByte3, "US-ASCII"), this.g)).length];
    synchronized (b)
    {
      b.nextBytes(paramString1);
    }
    ??? = a(???, paramString1, this.g);
    if ((paramArrayOfByte4 == null) || (paramArrayOfByte4.length != paramArrayOfByte3.length))
      throw new Exception("Resource D missing.");
    a(???, paramArrayOfByte4);
    this.f = a(paramInt, paramByte, paramString1);
    paramInt = new byte[16];
    synchronized (b)
    {
      b.nextBytes(paramInt);
    }
    if (paramArrayOfByte5 == null)
      throw new Exception("Resource E missing.");
    ??? = new byte[16 + paramArrayOfByte2.length];
    System.arraycopy(paramInt, 0, ???, 0, 16);
    System.arraycopy(paramArrayOfByte2, 0, ???, 16, paramArrayOfByte2.length);
    paramInt = a(???, this.h);
    paramArrayOfInt[0] = a(paramInt, paramArrayOfByte5);
  }

  private static byte a(byte paramByte)
  {
    return (byte)((paramByte = (byte)(paramByte & 0xF)) < 10 ? paramByte + 48 : paramByte - 10 + 65);
  }

  private static int a(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
  {
    for (int i = 0; i < paramArrayOfByte1.length; i++)
    {
      paramArrayOfByte2[(i << 1)] = a((byte)((paramArrayOfByte1[i] & 0xF0) >> 4));
      paramArrayOfByte2[((i << 1) + 1)] = a((byte)(paramArrayOfByte1[i] & 0xF));
    }
    return i << 1;
  }

  private static byte[] a(String paramString)
  {
    byte[] arrayOfByte = new byte[paramString.length() / 2];
    for (int i = 0; i < paramString.length() / 2; i++)
    {
      int j = Byte.parseByte(paramString.substring(2 * i, 2 * i + 1), 16);
      j = Byte.parseByte(paramString.substring(2 * i + 1, 2 * i + 2), 16) | j << 4;
      arrayOfByte[i] = ((byte)j);
    }
    return arrayOfByte;
  }
}

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.security.o5logon.O5Logon
 * JD-Core Version:    0.6.2
 */