/*     */ package oracle.net.resolver;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NLParamParser;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class TNSNamesNamingAdapter
/*     */   implements NamingAdapterInterface
/*     */ {
/*     */   private NLParamParser tnsEntriesHdl;
/*     */   private String tnsDir;
/*     */   private long lastModifiedTime;
/*     */   private long nextPollTime;
/*     */   private static final String TNSFILE = "tnsnames.ora";
/*     */   private static final long REFRESH_INTERVAL = 0L;
/*     */ 
/*     */   public TNSNamesNamingAdapter(String paramString)
/*     */   {
/*  74 */     this.tnsDir = paramString;
/*     */ 
/*  77 */     resetAttr();
/*     */   }
/*     */ 
/*     */   private void resetAttr()
/*     */   {
/*  85 */     this.tnsEntriesHdl = null;
/*  86 */     this.lastModifiedTime = 0L;
/*  87 */     this.nextPollTime = 0L;
/*     */   }
/*     */ 
/*     */   public String resolve(String paramString)
/*     */     throws NetException
/*     */   {
/* 105 */     NVPair localNVPair = null;
/*     */ 
/* 107 */     synchronized (this)
/*     */     {
/* 110 */       checkAndReload();
/*     */ 
/* 114 */       localNVPair = this.tnsEntriesHdl.getNLPListElement(paramString);
/*     */     }
/*     */ 
/* 117 */     if (localNVPair == null)
/*     */     {
/* 119 */       throw new NetException(122, "\"" + paramString + "\"");
/*     */     }
/*     */ 
/* 122 */     return localNVPair.valueToString();
/*     */   }
/*     */ 
/*     */   private void loadFile()
/*     */     throws NetException
/*     */   {
/* 136 */     File localFile = new File(this.tnsDir, "tnsnames.ora");
/* 137 */     String str = localFile.getAbsolutePath();
/*     */ 
/* 150 */     if ((!localFile.isFile()) || (!localFile.canRead()))
/*     */     {
/* 153 */       resetAttr();
/*     */ 
/* 155 */       throw new NetException(123, ": " + str);
/*     */     }
/*     */ 
/* 161 */     long l = localFile.lastModified();
/* 162 */     if (this.lastModifiedTime != l)
/*     */     {
/*     */       try
/*     */       {
/* 166 */         this.tnsEntriesHdl = new NLParamParser(str, (byte)1);
/*     */ 
/* 171 */         this.lastModifiedTime = l;
/*     */       }
/*     */       catch (IOException localIOException)
/*     */       {
/* 184 */         resetAttr();
/*     */ 
/* 186 */         throw new NetException(123, ": " + str);
/*     */       }
/*     */       catch (NLException localNLException)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void checkAndReload()
/*     */     throws NetException
/*     */   {
/* 225 */     long l = System.currentTimeMillis();
/*     */ 
/* 237 */     if (l > this.nextPollTime)
/*     */     {
/* 239 */       this.nextPollTime = (l + 0L);
/* 240 */       loadFile();
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.resolver.TNSNamesNamingAdapter
 * JD-Core Version:    0.6.2
 */