/*     */ package oracle.net.resolver;
/*     */ 
/*     */ import java.util.Vector;
/*     */ import oracle.net.jdbc.TNSAddress.Description;
/*     */ import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.ConnStrategy;
/*     */ 
/*     */ public class NavDescription extends Description
/*     */   implements NavSchemaObject
/*     */ {
/*     */   private Vector activeChildren;
/*     */   private int descProcessed;
/*     */   private boolean done;
/*     */ 
/*     */   public NavDescription(SchemaObjectFactoryInterface paramSchemaObjectFactoryInterface)
/*     */   {
/*  66 */     super(paramSchemaObjectFactoryInterface);
/*  67 */     this.activeChildren = new Vector(1, 10);
/*  68 */     this.done = false;
/*     */   }
/*     */ 
/*     */   public void navigate(ConnStrategy paramConnStrategy, StringBuffer paramStringBuffer)
/*     */   {
/*  79 */     paramStringBuffer.setLength(0);
/*  80 */     paramStringBuffer.append("(DESCRIPTION=");
/*     */     try
/*     */     {
/*  83 */       if (this.SDU != null)
/*  84 */         paramConnStrategy.sdu = Integer.parseInt(this.SDU);
/*  85 */       if (this.TDU != null) {
/*  86 */         paramConnStrategy.tdu = Integer.parseInt(this.TDU);
/*     */       }
/*  88 */       if (this.connectTimeout != null)
/*  89 */         paramConnStrategy.connectTimeout = (Integer.parseInt(this.connectTimeout) * 1000);
/*  90 */       if (this.retryCount != null) {
/*  91 */         paramConnStrategy.retryCount = Integer.parseInt(this.retryCount);
/*     */       }
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/*  98 */     paramConnStrategy.addSocketOptions(this.keepAlive);
/*     */     int i;
/* 103 */     if (this.sourceRoute)
/*     */     {
/* 106 */       if (!backwardCompatibilityCase(this.children, paramConnStrategy))
/*     */       {
/* 108 */         this.activeChildren = this.children;
/*     */ 
/* 110 */         ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(paramConnStrategy, paramStringBuffer);
/*     */ 
/* 112 */         for (i = 1; i < this.activeChildren.size(); i++)
/* 113 */           ((NavSchemaObject)this.activeChildren.elementAt(i)).addToString(paramConnStrategy);
/*     */       }
/*     */       else
/*     */       {
/* 117 */         setConnectionOption(paramConnStrategy, paramStringBuffer);
/*     */       }
/*     */ 
/* 121 */       closeNVPair(paramConnStrategy);
/*     */     }
/*     */     else
/*     */     {
/* 127 */       this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
/*     */ 
/* 131 */       for (i = 0; i < this.activeChildren.size(); i++)
/*     */       {
/* 133 */         ((NavSchemaObject)this.activeChildren.elementAt(i)).navigate(paramConnStrategy, paramStringBuffer);
/*     */       }
/* 135 */       closeNVPair(paramConnStrategy);
/*     */     }
/* 137 */     this.done = true;
/*     */   }
/*     */ 
/*     */   public void closeNVPair(ConnStrategy paramConnStrategy)
/*     */   {
/* 146 */     for (int i = paramConnStrategy.cOpts.size() - 1; 
/* 147 */       (i >= 0) && (!((ConnOption)paramConnStrategy.cOpts.elementAt(i)).done); i--)
/*     */     {
/* 149 */       ConnOption localConnOption = (ConnOption)paramConnStrategy.cOpts.elementAt(i);
/*     */ 
/* 151 */       if (this.sourceRoute)
/*     */       {
/* 153 */         localConnOption.conn_data.append("(SOURCE_ROUTE=yes)");
/*     */       }
/*     */ 
/* 158 */       if (this.connectData == null) {
/* 159 */         this.connectData = "(SERVICE_NAME=)";
/*     */       }
/* 161 */       localConnOption.conn_data.append("(CONNECT_DATA=");
/* 162 */       localConnOption.conn_data.append("(CID=(PROGRAM=");
/* 163 */       localConnOption.conn_data.append(paramConnStrategy.getProgramName());
/* 164 */       localConnOption.conn_data.append(")(HOST=__jdbc__)(USER=");
/* 165 */       localConnOption.conn_data.append(paramConnStrategy.getOSUsername());
/* 166 */       localConnOption.conn_data.append("))");
/* 167 */       localConnOption.conn_data.append(this.connectData);
/* 168 */       localConnOption.conn_data.append(")");
/*     */ 
/* 170 */       if (this.SID != null)
/* 171 */         localConnOption.sid = this.SID;
/* 172 */       if (this.serviceName != null)
/* 173 */         localConnOption.service_name = this.serviceName;
/* 174 */       if (this.instanceName != null)
/* 175 */         localConnOption.instance_name = this.instanceName;
/* 176 */       if (this.sslServerCertDN != null) {
/* 177 */         localConnOption.sslServerCertDN = this.sslServerCertDN;
/*     */       }
/*     */ 
/* 181 */       localConnOption.conn_data.append(")");
/* 182 */       localConnOption.done = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addToString(ConnStrategy paramConnStrategy)
/*     */   {
/*     */   }
/*     */ 
/*     */   private boolean backwardCompatibilityCase(Vector paramVector, ConnStrategy paramConnStrategy)
/*     */   {
/* 198 */     if ((paramVector.size() == 1) && (((NavSchemaObject)paramVector.elementAt(0)).isA() == 1) && (!((NavAddressList)paramVector.elementAt(0)).sourceRoute))
/*     */     {
/* 202 */       NavAddressList localNavAddressList = (NavAddressList)paramVector.elementAt(0);
/* 203 */       int i = localNavAddressList.getChildrenSize();
/*     */ 
/* 205 */       if (i == 0) {
/* 206 */         return false;
/*     */       }
/*     */ 
/* 211 */       for (int j = 0; j < i; j++)
/*     */       {
/* 215 */         if (localNavAddressList.getChildrenType(j) != 0)
/* 216 */           return false;
/*     */       }
/* 218 */       return true;
/*     */     }
/* 220 */     return false;
/*     */   }
/*     */ 
/*     */   private void setConnectionOption(ConnStrategy paramConnStrategy, StringBuffer paramStringBuffer)
/*     */   {
/* 234 */     paramStringBuffer.append("(ADDRESS_LIST=");
/*     */ 
/* 237 */     NavAddressList localNavAddressList = (NavAddressList)this.children.elementAt(0);
/* 238 */     NavAddress localNavAddress = localNavAddressList.getChild(0);
/* 239 */     int i = localNavAddressList.getChildrenSize();
/*     */ 
/* 242 */     localNavAddress.navigate(paramConnStrategy, paramStringBuffer);
/*     */ 
/* 245 */     for (int j = 1; j < i; j++)
/*     */     {
/* 247 */       localNavAddressList.getChild(j).addToString(paramConnStrategy);
/*     */     }
/*     */ 
/* 250 */     ((ConnOption)paramConnStrategy.cOpts.elementAt(0)).conn_data.append(")");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.resolver.NavDescription
 * JD-Core Version:    0.6.2
 */