/*     */ package oracle.net.resolver;
/*     */ 
/*     */ import java.util.Vector;
/*     */ import oracle.net.jdbc.TNSAddress.AddressList;
/*     */ import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.ConnStrategy;
/*     */ 
/*     */ public class NavAddressList extends AddressList
/*     */   implements NavSchemaObject
/*     */ {
/*     */   private Vector activeChildren;
/*     */   private int sBuflength;
/*     */ 
/*     */   public NavAddressList(SchemaObjectFactoryInterface paramSchemaObjectFactoryInterface)
/*     */   {
/*  55 */     super(paramSchemaObjectFactoryInterface);
/*  56 */     this.activeChildren = new Vector(1, 10);
/*     */   }
/*     */ 
/*     */   public void navigate(ConnStrategy paramConnStrategy, StringBuffer paramStringBuffer)
/*     */   {
/*  67 */     navigate2(paramConnStrategy, paramStringBuffer, 0);
/*     */   }
/*     */ 
/*     */   private void navigate2(ConnStrategy paramConnStrategy, StringBuffer paramStringBuffer, int paramInt)
/*     */   {
/*  72 */     int i = 0;
/*     */ 
/*  74 */     paramInt++;
/*  75 */     this.sBuflength = paramStringBuffer.length();
/*  76 */     paramStringBuffer.append("(ADDRESS_LIST=");
/*     */     int j;
/*  77 */     if (this.sourceRoute)
/*     */     {
/*  79 */       this.activeChildren = this.children;
/*  80 */       ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(paramConnStrategy, paramStringBuffer);
/*     */ 
/*  82 */       for (j = 1; j < this.activeChildren.size(); j++)
/*  83 */         ((NavSchemaObject)this.activeChildren.elementAt(j)).addToString(paramConnStrategy);
/*     */     }
/*     */     else
/*     */     {
/*  87 */       this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
/*     */ 
/*  90 */       for (j = 0; j < this.activeChildren.size(); j++)
/*     */       {
/*  92 */         if (getChildrenType(j) == 1)
/*     */         {
/*  94 */           i = 1;
/*  95 */           ((NavAddressList)this.activeChildren.elementAt(j)).navigate2(paramConnStrategy, paramStringBuffer, paramInt);
/*     */         }
/*     */         else
/*     */         {
/*  99 */           ((NavSchemaObject)this.activeChildren.elementAt(j)).navigate(paramConnStrategy, paramStringBuffer);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 104 */     paramInt--;
/*     */ 
/* 106 */     if (((paramInt != 0) || (i == 0)) && (!this.sourceRoute))
/*     */     {
/* 109 */       closeNVPair(paramConnStrategy, false);
/*     */     }
/*     */     else
/*     */     {
/* 115 */       closeNVPair(paramConnStrategy, true);
/*     */     }
/* 117 */     paramStringBuffer.setLength(this.sBuflength);
/*     */   }
/*     */ 
/*     */   public void addToString(ConnStrategy paramConnStrategy)
/*     */   {
/* 127 */     String str = toString();
/*     */ 
/* 129 */     for (int i = paramConnStrategy.cOpts.size() - 1; 
/* 130 */       (i >= 0) && (!((ConnOption)paramConnStrategy.cOpts.elementAt(i)).done); i--)
/*     */     {
/* 132 */       ((ConnOption)paramConnStrategy.cOpts.elementAt(i)).conn_data.append(str);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 142 */     String str = "";
/* 143 */     str = str + "(ADDRESS_LIST=";
/*     */ 
/* 145 */     for (int i = 0; i < this.children.size(); i++) {
/* 146 */       str = str + ((NavSchemaObject)this.children.elementAt(i)).toString();
/*     */     }
/* 148 */     if (this.sourceRoute) str = str + "(SOURCE_ROUTE=yes)(HOP_COUNT=0)";
/* 149 */     if (this.loadBalance) str = str + "(LOAD_BALANCE=yes)";
/* 150 */     if (!this.failover) str = str + "(FAILOVER=false)";
/*     */ 
/* 152 */     str = str + ")";
/*     */ 
/* 154 */     return str;
/*     */   }
/*     */ 
/*     */   public int getChildrenSize()
/*     */   {
/* 162 */     return this.children.size();
/*     */   }
/*     */ 
/*     */   public int getChildrenType(int paramInt)
/*     */   {
/* 170 */     return ((NavSchemaObject)this.children.elementAt(paramInt)).isA();
/*     */   }
/*     */ 
/*     */   public NavAddress getChild(int paramInt)
/*     */   {
/* 178 */     return (NavAddress)this.children.elementAt(paramInt);
/*     */   }
/*     */ 
/*     */   private void closeNVPair(ConnStrategy paramConnStrategy, boolean paramBoolean)
/*     */   {
/* 187 */     for (int i = paramConnStrategy.cOpts.size() - 1; 
/* 188 */       (i >= 0) && (!((ConnOption)paramConnStrategy.cOpts.elementAt(i)).done); i--)
/*     */     {
/* 191 */       if ((!paramBoolean) && (paramConnStrategy.cOpts.size() - 1 - i >= getChildrenSize())) {
/*     */         break;
/*     */       }
/* 194 */       if (this.sourceRoute)
/*     */       {
/* 196 */         ((ConnOption)paramConnStrategy.cOpts.elementAt(i)).conn_data.append("(SOURCE_ROUTE=yes)");
/* 197 */         ((ConnOption)paramConnStrategy.cOpts.elementAt(i)).conn_data.append("(HOP_COUNT=0)");
/*     */       }
/*     */ 
/* 200 */       ((ConnOption)paramConnStrategy.cOpts.elementAt(i)).conn_data.append(")");
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.resolver.NavAddressList
 * JD-Core Version:    0.6.2
 */