/*     */ package oracle.net.resolver;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Hashtable;
/*     */ import oracle.net.jdbc.nl.InvalidSyntaxException;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class NameResolver
/*     */ {
/*     */   private String tnsAdmin;
/*     */   private String[] readPath;
/*     */   private Hashtable adapterHash;
/*     */   String osuser;
/*     */   String programName;
/*     */   private static final boolean DEBUG = false;
/*  71 */   private static final String[] DEFAULT_SEARCH_PATH = { "TNSNAMES", "HOSTNAME" };
/*     */   private static final String TNS_ADMIN_PROPERTY = "oracle.net.tns_admin";
/*     */   private static final String READ_PATH_PROPERTY = "oracle.net.names.directory_path";
/*     */ 
/*     */   private NameResolver()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected NameResolver(String paramString1, String paramString2, String paramString3)
/*     */     throws NetException
/*     */   {
/*  91 */     this.tnsAdmin = paramString1;
/*  92 */     bootNameResolver();
/*  93 */     this.osuser = paramString2;
/*  94 */     this.programName = paramString3;
/*     */   }
/*     */ 
/*     */   public String resolveName(String paramString)
/*     */     throws NetException
/*     */   {
/* 112 */     if (paramString == null) {
/* 113 */       throw new NetException(120);
/*     */     }
/* 115 */     String str1 = paramString.trim();
/* 116 */     if (str1.length() == 0) {
/* 117 */       throw new NetException(120);
/*     */     }
/* 119 */     String str2 = null;
/*     */ 
/* 128 */     if (this.tnsAdmin == null)
/*     */     {
/* 130 */       localObject = new HostnameNamingAdapter(this.osuser, this.programName);
/* 131 */       str2 = ((HostnameNamingAdapter)localObject).resolve(str1);
/* 132 */       return str2;
/*     */     }
/*     */ 
/* 146 */     Object localObject = null;
/*     */ 
/* 148 */     for (int i = 0; (str2 == null) && (i < this.readPath.length); 
/* 149 */       i++)
/*     */     {
/* 158 */       localObject = (NamingAdapterInterface)this.adapterHash.get(this.readPath[i]);
/*     */       try
/*     */       {
/* 161 */         str2 = ((NamingAdapterInterface)localObject).resolve(str1);
/*     */       }
/*     */       catch (NetException localNetException)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 177 */     if (str2 == null)
/*     */     {
/* 179 */       throw new NetException(122, "\"" + paramString + "\"");
/*     */     }
/*     */ 
/* 186 */     return str2;
/*     */   }
/*     */ 
/*     */   private void addAdapters()
/*     */   {
/* 194 */     if (this.adapterHash == null) {
/* 195 */       this.adapterHash = new Hashtable();
/*     */     }
/* 197 */     this.adapterHash.put("TNSNAMES", new TNSNamesNamingAdapter(this.tnsAdmin));
/* 198 */     this.adapterHash.put("HOSTNAME", new HostnameNamingAdapter(this.osuser, this.programName));
/*     */   }
/*     */ 
/*     */   private void bootNameResolver()
/*     */     throws NetException
/*     */   {
/* 214 */     if (this.tnsAdmin != null)
/*     */     {
/* 216 */       setReadPath();
/* 217 */       addAdapters();
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean checkForValidAdapter(String paramString)
/*     */   {
/* 227 */     int j = DEFAULT_SEARCH_PATH.length;
/*     */ 
/* 229 */     for (int i = 0; i < j; i++)
/*     */     {
/* 231 */       if (DEFAULT_SEARCH_PATH[i].equalsIgnoreCase(paramString))
/* 232 */         return true;
/*     */     }
/* 234 */     return false;
/*     */   }
/*     */ 
/*     */   private void setDefaultPath()
/*     */   {
/* 241 */     this.readPath = DEFAULT_SEARCH_PATH;
/*     */   }
/*     */ 
/*     */   private void setReadPath()
/*     */     throws NetException
/*     */   {
/* 250 */     int i = 0;
/*     */ 
/* 257 */     String[] arrayOfString = getUserReadPath();
/*     */ 
/* 259 */     if (arrayOfString == null)
/*     */     {
/* 265 */       setDefaultPath();
/* 266 */       return;
/*     */     }
/*     */ 
/* 269 */     ArrayList localArrayList = new ArrayList();
/*     */ 
/* 271 */     for (i = 0; i < arrayOfString.length; i++)
/*     */     {
/* 273 */       if (checkForValidAdapter(arrayOfString[i]) == true)
/*     */       {
/* 275 */         String str = arrayOfString[i];
/* 276 */         str = str.toUpperCase();
/* 277 */         if (!localArrayList.contains(str)) {
/* 278 */           localArrayList.add(arrayOfString[i].toUpperCase());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 292 */     int j = localArrayList.size();
/*     */ 
/* 295 */     if (j == 0)
/*     */     {
/* 304 */       throw new NetException(121, " The Read path did not contain any valid adapters.");
/*     */     }
/*     */ 
/* 308 */     this.readPath = new String[j];
/* 309 */     localArrayList.toArray(this.readPath);
/*     */   }
/*     */ 
/*     */   private String[] getUserReadPath()
/*     */     throws NetException
/*     */   {
/* 326 */     Object localObject = null;
/*     */ 
/* 329 */     String str1 = System.getProperty("oracle.net.names.directory_path");
/*     */ 
/* 331 */     if (str1 == null)
/*     */     {
/* 337 */       return null;
/*     */     }
/*     */ 
/* 348 */     str1 = str1.trim();
/* 349 */     if (str1.length() == 0) {
/* 350 */       return null;
/*     */     }
/* 352 */     StringBuffer localStringBuffer = new StringBuffer(str1);
/*     */ 
/* 357 */     if (localStringBuffer.charAt(0) == '(')
/* 358 */       localStringBuffer.insert(0, "(path=").append(')');
/*     */     else {
/* 360 */       localStringBuffer.insert(0, "(path=(").append("))");
/*     */     }
/* 362 */     String str2 = localStringBuffer.toString();
/*     */ 
/* 364 */     NVFactory localNVFactory = new NVFactory();
/* 365 */     NVPair localNVPair = null;
/*     */     try
/*     */     {
/* 372 */       localNVPair = localNVFactory.createNVPair(str2);
/* 373 */       if ((localNVPair.getRHSType() != NVPair.RHS_LIST) || (localNVPair.getListType() != NVPair.LIST_COMMASEP))
/*     */       {
/* 376 */         throw new NetException(121, " Read path specified is " + str1);
/*     */       }
/*     */ 
/* 380 */       int i = localNVPair.getListSize();
/* 381 */       String[] arrayOfString = new String[i];
/*     */ 
/* 384 */       for (int j = 0; j < i; j++)
/*     */       {
/* 386 */         arrayOfString[j] = localNVPair.getListElement(j).getName();
/*     */       }
/* 388 */       localObject = arrayOfString;
/*     */     }
/*     */     catch (InvalidSyntaxException localInvalidSyntaxException)
/*     */     {
/* 400 */       throw new NetException(121, " Read path specified is " + str1);
/*     */     }
/*     */     catch (NLException localNLException)
/*     */     {
/* 409 */       throw new NetException(121, " Read path specified is " + str2);
/*     */     }
/*     */ 
/* 412 */     return localObject;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.resolver.NameResolver
 * JD-Core Version:    0.6.2
 */