/*     */ package oracle.net.resolver;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class HostnameNamingAdapter
/*     */   implements NamingAdapterInterface
/*     */ {
/*     */   public static final int DEFAULT_DATABASE_PORT = 1521;
/*     */   public static final String DEFAULT_PROTOCOL = "TCP";
/*     */   String osuser;
/*     */   String programName;
/*     */ 
/*     */   private HostnameNamingAdapter()
/*     */   {
/*     */   }
/*     */ 
/*     */   public HostnameNamingAdapter(String paramString1, String paramString2)
/*     */   {
/*  70 */     this.osuser = paramString1;
/*  71 */     this.programName = paramString2;
/*     */   }
/*     */ 
/*     */   public String resolve(String paramString)
/*     */     throws NetException
/*     */   {
/*  95 */     int j = 0;
/*  96 */     int k = 0;
/*  97 */     int m = 0;
/*  98 */     int n = 0;
/*  99 */     int i1 = 0;
/*     */ 
/* 102 */     if (paramString.startsWith("//") == true) {
/* 103 */       paramString = paramString.substring(2);
/*     */     }
/* 105 */     if (paramString.charAt(0) == '[')
/*     */     {
/* 107 */       i1 = 1;
/* 108 */       n = paramString.indexOf(']');
/* 109 */       if (n != -1) {
/* 110 */         j = paramString.indexOf(':', n);
/*     */       }
/* 112 */       if ((n == -1) || ((j != -1) && (j != n + 1)))
/*     */       {
/* 114 */         throw new NetException(117);
/*     */       }
/* 116 */       m = 1;
/* 117 */       k = paramString.indexOf('/', n);
/*     */     }
/*     */     else
/*     */     {
/* 121 */       m = 0;
/* 122 */       j = paramString.indexOf(':');
/* 123 */       k = paramString.indexOf('/', m);
/*     */     }
/*     */ 
/* 128 */     if (((k != -1) && (j > k)) || (paramString.endsWith("/")) || (paramString.endsWith(":")))
/*     */     {
/* 131 */       throw new NetException(117);
/*     */     }
/*     */     String str3;
/*     */     try
/*     */     {
/*     */       String str1;
/* 138 */       if (i1 != 0) {
/* 139 */         str1 = paramString.substring(m, n);
/*     */       }
/* 142 */       else if (j != -1)
/* 143 */         str1 = paramString.substring(m, j);
/* 144 */       else if (k != -1)
/* 145 */         str1 = paramString.substring(m, k);
/*     */       else
/* 147 */         str1 = paramString.substring(m);
/*     */       int i;
/* 150 */       if (j != -1)
/*     */       {
/* 152 */         if (k != -1)
/* 153 */           i = Integer.parseInt(paramString.substring(j + 1, k));
/*     */         else
/* 155 */           i = Integer.parseInt(paramString.substring(j + 1));
/*     */       }
/*     */       else {
/* 158 */         i = 1521;
/*     */       }
/* 160 */       boolean bool = false;
/*     */       String str2;
/* 161 */       if (k != -1)
/*     */       {
/* 163 */         int i2 = paramString.indexOf(':', k + 1);
/* 164 */         if (i2 != -1)
/*     */         {
/* 166 */           bool = "POOLED".equalsIgnoreCase(paramString.substring(i2 + 1));
/*     */         }
/*     */ 
/* 169 */         if (bool)
/* 170 */           str2 = paramString.substring(k + 1, i2);
/*     */         else {
/* 172 */           str2 = paramString.substring(k + 1);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 177 */         str2 = "";
/*     */       }
/*     */ 
/* 180 */       InetAddress[] arrayOfInetAddress = InetAddress.getAllByName(str1);
/*     */ 
/* 183 */       StringBuilder localStringBuilder = new StringBuilder();
/* 184 */       for (int i3 = 0; i3 < arrayOfInetAddress.length; i3++)
/*     */       {
/* 186 */         str1 = arrayOfInetAddress[i3].getHostAddress();
/* 187 */         localStringBuilder.append(String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", new Object[] { "TCP", str1, Integer.valueOf(i) }));
/*     */       }
/*     */ 
/* 194 */       str3 = String.format("(DESCRIPTION=%s%s)", new Object[] { String.format("(CONNECT_DATA=%s%s%s)", new Object[] { String.format("(SERVICE_NAME=%s)", new Object[] { str2 }), bool ? "(SERVER=POOLED)" : "", "" }), localStringBuilder.toString() });
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/* 203 */       throw new NetException(116);
/*     */     }
/*     */     catch (UnknownHostException localUnknownHostException)
/*     */     {
/* 207 */       throw new NetException(118);
/*     */     }
/* 209 */     return str3;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.resolver.HostnameNamingAdapter
 * JD-Core Version:    0.6.2
 */