/*     */ package oracle.net.resolver;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.SocketException;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import java.util.Vector;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import oracle.net.jdbc.TNSAddress.SOException;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.jndi.JndiAttrs;
/*     */ import oracle.net.ns.NetException;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.ConnStrategy;
/*     */ 
/*     */ public class AddrResolution
/*     */ {
/*     */   private ConnStrategy cs;
/*     */   private Properties up;
/*     */   private static final String default_proxy_rules = "__jdbc__";
/*     */   private static final String service_alias_name = "ora-net-service-alias";
/*     */   private static final String service_attr_name = "orclnetdescstring";
/*     */   private static final int length_of_alias_prefix = 6;
/*     */   public static final int DEFAULT_DATABASE_PORT = 1521;
/*     */   public static final String DEFAULT_CONNECT_PROTOCOL = "TCP";
/* 128 */   private boolean newSyntax = true;
/* 129 */   public boolean connection_revised = false;
/* 130 */   public boolean connection_redirected = false;
/*     */   private String TNSAddress;
/* 230 */   private static final Pattern pattern = Pattern.compile("(?=ldaps?://)");
/*     */   static final String ADDRESS_FORMAT = "(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))";
/*     */   static final String CID_FORMAT = "(CID=(PROGRAM=%s)(HOST=__jdbc__)(USER=%s))";
/*     */   static final String CONNECT_DATA_FORMAT = "(CONNECT_DATA=%s%s%s)";
/*     */   static final String DESCRIPTION_FORMAT = "(DESCRIPTION=%s%s)";
/*     */   static final String DRCP_ENABLED = "(SERVER=POOLED)";
/*     */   static final String EMPTY_STRING = "";
/*     */   static final String SID_KEY = "(SID=%s)";
/*     */   static final String SERVICE_NAME_KEY = "(SERVICE_NAME=%s)";
/*     */ 
/*     */   public AddrResolution(String paramString, Properties paramProperties)
/*     */     throws NetException
/*     */   {
/* 172 */     this.up = paramProperties;
/* 173 */     this.TNSAddress = paramString;
/*     */ 
/* 175 */     if ((this.up.containsKey("java.naming.provider.url")) || (paramString.startsWith("ldap:")) || (paramString.startsWith("ldaps:")))
/*     */     {
/* 178 */       int i = 0;
/* 179 */       Vector localVector1 = null;
/*     */ 
/* 182 */       if ((paramString.startsWith("ldap:")) || (paramString.startsWith("ldaps:")))
/*     */       {
/* 184 */         localVector1 = computeLdapList(paramString);
/* 185 */         if (localVector1.size() > 1) {
/* 186 */           i = 1;
/*     */         }
/*     */         else
/*     */         {
/*     */           int j;
/* 191 */           if ((j = paramString.lastIndexOf(47)) == -1) {
/* 192 */             throw new NetException(124);
/*     */           }
/* 194 */           this.up.put("java.naming.provider.url", paramString.substring(0, j));
/* 195 */           this.TNSAddress = paramString.substring(j + 1, paramString.length());
/*     */         }
/*     */       }
/*     */ 
/* 199 */       if (i == 0) {
/* 200 */         String[] arrayOfString = new String[1];
/*     */ 
/* 204 */         JndiAttrs localJndiAttrs = new JndiAttrs(this.up);
/* 205 */         arrayOfString[0] = "orclnetdescstring";
/* 206 */         Vector localVector2 = null;
/*     */         try
/*     */         {
/* 209 */           localVector2 = localJndiAttrs.getAttrs(this.TNSAddress, arrayOfString);
/*     */         }
/*     */         finally {
/* 212 */           localJndiAttrs.close();
/*     */         }
/* 214 */         this.TNSAddress = ((String)localVector2.firstElement());
/* 215 */         this.connection_revised = true;
/*     */       }
/*     */       else
/*     */       {
/* 221 */         processLdapFailoverLoadblance(localVector1);
/*     */       }
/*     */     }
/*     */ 
/* 225 */     if (this.up.getProperty("oracle.net.oldSyntax") == "YES")
/* 226 */       this.newSyntax = false;
/*     */   }
/*     */ 
/*     */   private Vector<String> computeLdapList(String paramString)
/*     */   {
/* 242 */     String[] arrayOfString = pattern.split(paramString);
/*     */ 
/* 244 */     int i = 0;
/* 245 */     for (int j = 0; j < arrayOfString.length; j++)
/*     */     {
/* 247 */       arrayOfString[j] = arrayOfString[j].trim();
/* 248 */       if (arrayOfString[j].length() != 0) {
/* 249 */         i++;
/*     */       }
/*     */     }
/* 252 */     Vector localVector = new Vector(i);
/* 253 */     for (int k = 0; k < arrayOfString.length; k++) {
/* 254 */       if (arrayOfString[k].length() != 0)
/* 255 */         localVector.add(arrayOfString[k]);
/*     */     }
/* 257 */     return localVector;
/*     */   }
/*     */ 
/*     */   private void processLdapFailoverLoadblance(Vector<String> paramVector)
/*     */     throws NetException
/*     */   {
/* 263 */     int i = 0;
/*     */ 
/* 267 */     if (paramVector.size() <= 1) {
/* 268 */       throw new NetException(124);
/*     */     }
/*     */ 
/* 271 */     boolean bool1 = true;
/* 272 */     boolean bool2 = true;
/*     */     String str2;
/* 275 */     if ((str2 = this.up.getProperty("oracle.net.ldap_failover")) != null)
/*     */     {
/* 277 */       if ((str2.equalsIgnoreCase("OFF")) || (str2.equalsIgnoreCase("FALSE")) || (str2.equalsIgnoreCase("NO")))
/*     */       {
/* 280 */         bool1 = false;
/*     */       }
/*     */     }
/* 283 */     if ((str2 = this.up.getProperty("oracle.net.ldap_loadbalance")) != null)
/*     */     {
/* 285 */       if ((str2.equalsIgnoreCase("OFF")) || (str2.equalsIgnoreCase("FALSE")) || (str2.equalsIgnoreCase("NO")))
/*     */       {
/* 288 */         bool2 = false;
/*     */       }
/*     */     }
/* 291 */     if (paramVector.size() > 1)
/*     */     {
/* 294 */       paramVector = NavDescriptionList.setActiveChildren(paramVector, bool1, bool2);
/*     */     }
/*     */ 
/* 299 */     StringBuilder localStringBuilder = new StringBuilder();
/*     */ 
/* 301 */     int j = paramVector.size();
/*     */ 
/* 304 */     Hashtable localHashtable = new Hashtable(j);
/*     */ 
/* 306 */     for (int k = 0; k < j; k++)
/*     */     {
/* 312 */       String str1 = (String)paramVector.elementAt(k);
/*     */       int m;
/* 313 */       if ((m = str1.lastIndexOf(47)) == -1) {
/* 314 */         throw new NetException(124);
/*     */       }
/* 316 */       str4 = str1.substring(0, m);
/* 317 */       localObject1 = str1.substring(m + 1, str1.length());
/*     */ 
/* 319 */       localStringBuilder.append(str4);
/* 320 */       if (k < j - 1) localStringBuilder.append(' ');
/*     */ 
/* 326 */       localHashtable.put(str4.substring(str4.indexOf(47)), localObject1);
/*     */     }
/*     */ 
/* 329 */     String str3 = new String(localStringBuilder);
/*     */ 
/* 333 */     this.up.put("java.naming.provider.url", str3);
/* 334 */     JndiAttrs localJndiAttrs = new JndiAttrs(this.up);
/*     */ 
/* 337 */     String str4 = localJndiAttrs.getLdapUrlUsed();
/* 338 */     this.TNSAddress = ((String)localHashtable.get(str4.substring(str4.indexOf(47))));
/*     */ 
/* 341 */     Object localObject1 = null;
/* 342 */     String[] arrayOfString = new String[1];
/* 343 */     arrayOfString[0] = "orclnetdescstring";
/*     */     try
/*     */     {
/* 347 */       localObject1 = localJndiAttrs.getAttrs(this.TNSAddress, arrayOfString);
/*     */     }
/*     */     finally
/*     */     {
/* 351 */       localJndiAttrs.close();
/*     */     }
/*     */ 
/* 354 */     this.TNSAddress = ((String)((Vector)localObject1).firstElement());
/* 355 */     this.connection_revised = true;
/*     */   }
/*     */ 
/*     */   public String getTNSAddress()
/*     */   {
/* 364 */     return this.TNSAddress.toUpperCase();
/*     */   }
/*     */ 
/*     */   public ConnOption resolveAndExecute(String paramString)
/*     */     throws NetException, IOException
/*     */   {
/* 381 */     ConnStrategy localConnStrategy = this.cs;
/*     */ 
/* 383 */     if (paramString != null) {
/* 384 */       this.cs = new ConnStrategy(this.up);
/*     */ 
/* 386 */       if (this.connection_redirected) {
/* 387 */         this.cs.sdu = localConnStrategy.sdu;
/* 388 */         this.cs.tdu = localConnStrategy.tdu;
/* 389 */         this.cs.retryCount = localConnStrategy.retryCount;
/*     */ 
/* 391 */         this.cs.socketOptions = localConnStrategy.socketOptions;
/* 392 */         this.cs.reuseOpt = true;
/*     */       }
/*     */ 
/* 395 */       if (paramString.indexOf(41) == -1)
/*     */       {
/* 410 */         paramString = paramString.trim();
/* 411 */         if ((paramString.startsWith("//")) || (paramString.matches("[\\w]*")) || (paramString.matches("[\\[[\\w:]*\\]]")) || (paramString.matches("[[\\w-]\\.]*:[\\d]*/[[\\w\\$\\#]\\.]*(?i)(:pooled)?(?-i)")))
/*     */         {
/* 420 */           String str = System.getProperty("oracle.net.tns_admin");
/* 421 */           NameResolver localNameResolver = NameResolverFactory.getNameResolver(str, this.cs.getOSUsername(), this.cs.getProgramName());
/*     */ 
/* 427 */           paramString = paramString.replaceAll("#", "\\\\#");
/*     */ 
/* 430 */           if (this.up.containsKey("oracle.jdbc.targetInstanceName")) {
/* 431 */             this.TNSAddress = appendInstanceName(localNameResolver.resolveName(paramString), this.up.getProperty("oracle.jdbc.targetInstanceName"));
/*     */           }
/*     */           else {
/* 434 */             this.TNSAddress = localNameResolver.resolveName(paramString);
/*     */           }
/* 436 */           resolveAddrTree(this.TNSAddress);
/*     */         }
/*     */         else
/*     */         {
/* 441 */           this.TNSAddress = resolveSimple(paramString);
/*     */         }
/*     */ 
/*     */       }
/* 446 */       else if (this.newSyntax)
/*     */       {
/* 448 */         if (this.up.containsKey("oracle.jdbc.targetInstanceName")) {
/* 449 */           paramString = appendInstanceName(paramString, this.up.getProperty("oracle.jdbc.targetInstanceName"));
/*     */         }
/* 451 */         resolveAddrTree(paramString);
/*     */       }
/*     */       else {
/* 454 */         resolveAddr(paramString);
/*     */       }
/*     */ 
/*     */     }
/* 459 */     else if ((this.cs == null) || (!this.cs.hasMoreOptions())) {
/* 460 */       return null;
/*     */     }
/*     */ 
/* 464 */     return this.cs.execute();
/*     */   }
/*     */ 
/*     */   private String resolveSimple(String paramString)
/*     */     throws NetException
/*     */   {
/* 487 */     ConnOption localConnOption = new ConnOption();
/* 488 */     int i = 0;
/* 489 */     int j = 0;
/* 490 */     int k = 0;
/* 491 */     int m = 0;
/*     */ 
/* 495 */     int n = 0;
/* 496 */     int i1 = 0;
/* 497 */     boolean bool = false;
/* 498 */     if (paramString.startsWith("["))
/*     */     {
/* 500 */       n = paramString.indexOf(93);
/* 501 */       if (n == -1)
/* 502 */         throw new NetException(115);
/* 503 */       i1 = 1;
/*     */     }
/*     */ 
/* 507 */     if (((i = paramString.indexOf(58, n)) == -1) || ((j = paramString.indexOf(58, i + 1)) == -1))
/*     */     {
/* 510 */       throw new NetException(115);
/*     */     }
/*     */ 
/* 513 */     m = paramString.indexOf(58, j + 1);
/* 514 */     if ((m != -1) && (paramString.length() > m + 6))
/*     */     {
/* 516 */       String str = paramString.substring(m + 1);
/* 517 */       bool = "POOLED".equalsIgnoreCase(str);
/* 518 */       if (bool)
/*     */       {
/* 520 */         localConnOption.sid = paramString.substring(j + 1, m);
/* 521 */         m = paramString.indexOf(58, m + 1);
/*     */       }
/*     */       else {
/* 524 */         localConnOption.sid = paramString.substring(j + 1);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 529 */       localConnOption.sid = paramString.substring(j + 1);
/*     */     }
/*     */ 
/* 533 */     if (m != -1)
/*     */     {
/* 535 */       throw new NetException(115);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 542 */       if (i1 != 0)
/* 543 */         localConnOption.host = paramString.substring(1, i - 1);
/*     */       else
/* 545 */         localConnOption.host = paramString.substring(0, i);
/* 546 */       localConnOption.port = Integer.parseInt(paramString.substring(i + 1, j));
/* 547 */       localConnOption.addr = String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", new Object[] { "TCP", localConnOption.host, Integer.valueOf(localConnOption.port) });
/*     */ 
/* 550 */       localConnOption.conn_data.append(String.format("(DESCRIPTION=%s%s)", new Object[] { String.format("(CONNECT_DATA=%s%s%s)", new Object[] { String.format("(SID=%s)", new Object[] { localConnOption.sid }), bool ? "(SERVER=POOLED)" : "", String.format("(CID=(PROGRAM=%s)(HOST=__jdbc__)(USER=%s))", new Object[] { this.cs.getProgramName(), this.cs.getOSUsername() }) }), localConnOption.addr }));
/*     */ 
/* 560 */       localConnOption.protocol = "TCP";
/* 561 */       this.cs.addOption(localConnOption);
/* 562 */       return String.format("(DESCRIPTION=%s%s)", new Object[] { String.format("(CONNECT_DATA=%s%s%s)", new Object[] { String.format("(SID=%s)", new Object[] { localConnOption.sid }), bool ? "(SERVER=POOLED)" : "", "" }), localConnOption.addr });
/*     */     }
/*     */     catch (NumberFormatException localNumberFormatException)
/*     */     {
/*     */     }
/*     */ 
/* 571 */     throw new NetException(116);
/*     */   }
/*     */ 
/*     */   private void resolveAddr(String paramString)
/*     */     throws NetException
/*     */   {
/* 582 */     if (paramString.startsWith("alias=")) {
/* 583 */       localObject = paramString;
/* 584 */       paramString = ((String)localObject).substring(((String)localObject).indexOf("alias=") + 6, ((String)localObject).length());
/*     */     }
/*     */ 
/* 588 */     Object localObject = new ConnOption();
/* 589 */     NVFactory localNVFactory = new NVFactory();
/* 590 */     NVNavigator localNVNavigator = new NVNavigator();
/* 591 */     NVPair localNVPair1 = null;
/* 592 */     NVPair localNVPair2 = null;
/*     */     try
/*     */     {
/* 596 */       localNVPair1 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "CID");
/*     */ 
/* 598 */       localNVPair2 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "address");
/*     */     }
/*     */     catch (NLException localNLException1)
/*     */     {
/* 604 */       System.err.println(localNLException1.getMessage());
/*     */     }
/* 606 */     NVPair localNVPair3 = localNVNavigator.findNVPair(localNVPair2, "protocol");
/* 607 */     if (localNVPair3 == null) {
/* 608 */       throw new NetException(100);
/*     */     }
/*     */ 
/* 612 */     ((ConnOption)localObject).protocol = localNVPair3.getAtom();
/* 613 */     if ((!((ConnOption)localObject).protocol.equals("TCP")) && (!((ConnOption)localObject).protocol.equals("tcp")) && (!((ConnOption)localObject).protocol.equals("SSL")) && (!((ConnOption)localObject).protocol.equals("ssl")) && (!((ConnOption)localObject).protocol.equals("ANO")) && (!((ConnOption)localObject).protocol.equals("ano")))
/*     */     {
/* 616 */       throw new NetException(102);
/*     */     }
/*     */ 
/* 620 */     localNVPair3 = localNVNavigator.findNVPair(localNVPair2, "Host");
/* 621 */     if (localNVPair3 == null) {
/* 622 */       throw new NetException(103);
/*     */     }
/* 624 */     ((ConnOption)localObject).host = localNVPair3.getAtom();
/*     */ 
/* 627 */     localNVPair3 = localNVNavigator.findNVPair(localNVPair2, "Port");
/* 628 */     if (localNVPair3 == null) {
/* 629 */       throw new NetException(104);
/*     */     }
/* 631 */     ((ConnOption)localObject).port = Integer.parseInt(localNVPair3.getAtom());
/*     */ 
/* 634 */     localNVPair3 = localNVNavigator.findNVPair(localNVPair2, "sduSize");
/* 635 */     if (localNVPair3 != null) {
/* 636 */       ((ConnOption)localObject).sdu = Integer.parseInt(localNVPair3.getAtom());
/*     */     }
/*     */ 
/* 639 */     localNVPair3 = localNVNavigator.findNVPair(localNVPair2, "tduSize");
/* 640 */     if (localNVPair3 != null) {
/* 641 */       ((ConnOption)localObject).tdu = Integer.parseInt(localNVPair3.getAtom());
/*     */     }
/*     */ 
/* 644 */     NVPair localNVPair4 = null;
/*     */     try
/*     */     {
/* 648 */       localNVPair4 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "connect_data");
/*     */     }
/*     */     catch (NLException localNLException2)
/*     */     {
/* 654 */       System.err.println(localNLException2.getMessage());
/*     */     }
/*     */ 
/* 657 */     ((ConnOption)localObject).conn_data = (localNVPair4 != null ? insertCID(paramString) : new StringBuilder(paramString));
/*     */ 
/* 659 */     ((ConnOption)localObject).addr = String.format("(ADDRESS=(PROTOCOL=%s)(HOST=%s)(PORT=%s))", new Object[] { "TCP", ((ConnOption)localObject).host, Integer.valueOf(((ConnOption)localObject).port) });
/*     */ 
/* 663 */     this.cs.addOption((ConnOption)localObject);
/*     */   }
/*     */ 
/*     */   private void resolveAddrTree(String paramString)
/*     */     throws NetException
/*     */   {
/* 677 */     NavSchemaObjectFactory localNavSchemaObjectFactory = new NavSchemaObjectFactory();
/* 678 */     NavServiceAlias localNavServiceAlias = (NavServiceAlias)localNavSchemaObjectFactory.create(4);
/*     */     try
/*     */     {
/* 681 */       String str = paramString.startsWith("alias=") ? paramString : new StringBuilder().append("alias=").append(paramString).toString();
/*     */ 
/* 683 */       localNavServiceAlias.initFromString(str);
/*     */     }
/*     */     catch (NLException localNLException) {
/* 686 */       throw new NetException(501);
/*     */     }
/*     */     catch (SOException localSOException) {
/* 689 */       throw new NetException(502, localSOException.getMessage());
/*     */     }
/* 691 */     localNavServiceAlias.navigate(this.cs, null);
/*     */   }
/*     */ 
/*     */   private StringBuilder insertCID(String paramString)
/*     */     throws NetException
/*     */   {
/* 703 */     NVFactory localNVFactory = new NVFactory();
/* 704 */     NVNavigator localNVNavigator = new NVNavigator();
/*     */ 
/* 706 */     StringBuilder localStringBuilder = new StringBuilder(2048);
/* 707 */     NVPair localNVPair1 = null;
/* 708 */     NVPair localNVPair2 = null;
/* 709 */     NVPair localNVPair3 = null;
/* 710 */     NVPair localNVPair4 = null;
/* 711 */     NVPair localNVPair5 = null;
/*     */     try
/*     */     {
/* 716 */       localNVPair1 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "description");
/*     */ 
/* 718 */       localNVPair2 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "address_list");
/*     */ 
/* 720 */       localNVPair3 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "address");
/*     */ 
/* 722 */       localNVPair4 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "connect_data");
/*     */ 
/* 724 */       localNVPair5 = localNVNavigator.findNVPairRecurse(localNVFactory.createNVPair(paramString), "source_route");
/*     */     }
/*     */     catch (NLException localNLException)
/*     */     {
/* 730 */       System.err.println(localNLException.getMessage());
/*     */     }
/* 732 */     NVPair localNVPair6 = null;
/* 733 */     NVPair localNVPair7 = null;
/* 734 */     NVPair localNVPair8 = null;
/* 735 */     NVPair localNVPair9 = null;
/*     */ 
/* 738 */     if (localNVPair4 != null) {
/* 739 */       localNVPair6 = localNVNavigator.findNVPair(localNVPair4, "SID");
/* 740 */       localNVPair7 = localNVNavigator.findNVPair(localNVPair4, "CID");
/* 741 */       localNVPair8 = localNVNavigator.findNVPair(localNVPair4, "SERVICE_NAME");
/* 742 */       localNVPair9 = localNVNavigator.findNVPair(localNVPair4, "SERVER");
/*     */     }
/*     */     else {
/* 745 */       throw new NetException(105);
/*     */     }
/* 747 */     if ((localNVPair6 == null) && (localNVPair8 == null)) {
/* 748 */       throw new NetException(106);
/*     */     }
/* 750 */     localStringBuilder.append("(DESCRIPTION=");
/* 751 */     if ((localNVPair2 != null) && (localNVPair2.getListSize() > 0))
/*     */     {
/* 753 */       for (int i = 0; i < localNVPair2.getListSize(); i++)
/*     */       {
/* 755 */         NVPair localNVPair10 = localNVPair2.getListElement(i);
/* 756 */         localStringBuilder.append(localNVPair10.toString());
/*     */       }
/*     */ 
/*     */     }
/* 760 */     else if (localNVPair3 != null)
/* 761 */       localStringBuilder.append(localNVPair3.toString());
/*     */     else {
/* 763 */       throw new NetException(107);
/*     */     }
/*     */ 
/* 768 */     localStringBuilder.append(String.format("(CONNECT_DATA=%s%s%s)", new Object[] { (localNVPair8 != null ? localNVPair8 : localNVPair6).toString(), localNVPair9 != null ? localNVPair9.toString() : "", this.cs.getProgramName(), this.cs.getOSUsername() }));
/*     */ 
/* 774 */     if (localNVPair5 != null) {
/* 775 */       localStringBuilder.append(localNVPair5.toString());
/*     */     }
/* 777 */     localStringBuilder.append(")");
/* 778 */     return localStringBuilder;
/*     */   }
/*     */ 
/*     */   public Properties getUp()
/*     */   {
/* 786 */     return this.up;
/*     */   }
/*     */ 
/*     */   public boolean isConnectionSocketKeepAlive()
/*     */     throws SocketException
/*     */   {
/* 806 */     return this.cs.isConnectionSocketKeepAlive();
/*     */   }
/*     */ 
/*     */   private String appendInstanceName(String paramString1, String paramString2)
/*     */   {
/* 813 */     Pattern localPattern = Pattern.compile("CONNECT_DATA=([^)]+)\\)", 2);
/*     */ 
/* 815 */     Matcher localMatcher = localPattern.matcher(paramString1);
/* 816 */     StringBuffer localStringBuffer = new StringBuffer();
/* 817 */     boolean bool = localMatcher.find();
/* 818 */     while (bool) {
/* 819 */       localMatcher.appendReplacement(localStringBuffer, new StringBuilder().append(localMatcher.group()).append("(INSTANCE_NAME=").append(paramString2).append(")").toString());
/* 820 */       bool = localMatcher.find();
/*     */     }
/* 822 */     localMatcher.appendTail(localStringBuffer);
/* 823 */     return localStringBuffer.toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.resolver.AddrResolution
 * JD-Core Version:    0.6.2
 */