/*     */ package oracle.net.nt;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.security.Principal;
/*     */ import java.security.cert.X509Certificate;
/*     */ import java.util.Properties;
/*     */ import javax.net.ssl.SSLSession;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class TcpsNTAdapter extends TcpNTAdapter
/*     */ {
/*     */   String matchSSLServerCertDNWith;
/*     */   boolean fullDNMatch;
/*     */   SSLSocketFactory l_sslSockFac;
/*  69 */   Socket underlyingSocket = null;
/*     */   SSLSocket socketWithListener;
/*     */ 
/*     */   public TcpsNTAdapter(String paramString, Properties paramProperties)
/*     */     throws NLException
/*     */   {
/*  92 */     super(paramString, paramProperties);
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws IOException
/*     */   {
/* 115 */     this.l_sslSockFac = CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions);
/*     */ 
/* 122 */     this.underlyingSocket = new Socket();
/*     */ 
/* 124 */     String str2 = (String)this.socketOptions.get(Integer.valueOf(2));
/*     */ 
/* 128 */     int i = str2 == null ? 0 : Integer.parseInt(str2);
/*     */ 
/* 131 */     boolean bool = Boolean.parseBoolean((String)this.socketOptions.get(Integer.valueOf(18)));
/*     */ 
/* 134 */     InetAddress[] arrayOfInetAddress = InetAddress.getAllByName(this.host);
/*     */ 
/* 136 */     if ((bool) && (arrayOfInetAddress.length > 1))
/*     */     {
/* 138 */       arrayOfInetAddress = getAddressesInCircularOrder(this.host, arrayOfInetAddress);
/*     */     }
/*     */ 
/* 141 */     int j = arrayOfInetAddress.length;
/*     */ 
/* 143 */     int k = 0;
/*     */     do
/*     */     {
/* 147 */       InetAddress localInetAddress = arrayOfInetAddress[k];
/* 148 */       InetSocketAddress localInetSocketAddress = new InetSocketAddress(localInetAddress, this.port);
/* 149 */       k++;
/* 150 */       j--;
/* 151 */       this.underlyingSocket = new Socket();
/*     */       try
/*     */       {
/* 156 */         this.underlyingSocket.connect(localInetSocketAddress, i);
/*     */ 
/* 163 */         this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
/*     */         String str1;
/* 166 */         if ((str1 = (String)this.socketOptions.get(Integer.valueOf(3))) != null)
/*     */         {
/* 169 */           setOption(3, str1);
/*     */         }
/*     */ 
/* 172 */         setSSLSocketOptions();
/*     */       }
/*     */       catch (IOException localIOException)
/*     */       {
/*     */         try
/*     */         {
/* 179 */           if (this.underlyingSocket != null) {
/* 180 */             this.underlyingSocket.close();
/*     */           }
/* 182 */           if (this.socket != null) {
/* 183 */             this.socket.close();
/*     */           }
/*     */         }
/*     */         catch (Exception localException)
/*     */         {
/*     */         }
/*     */ 
/* 190 */         if (j <= 0)
/*     */         {
/* 196 */           throw localIOException;
/*     */         }
/*     */       }
/*     */       catch (NumberFormatException localNumberFormatException)
/*     */       {
/* 201 */         throw new NetException(505);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 206 */     while (k < arrayOfInetAddress.length);
/*     */   }
/*     */ 
/*     */   public void renegotiateSession()
/*     */     throws IOException
/*     */   {
/* 219 */     this.socketWithListener = ((SSLSocket)this.socket);
/*     */ 
/* 223 */     this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
/*     */     String str;
/* 226 */     if ((str = (String)this.socketOptions.get(Integer.valueOf(3))) != null)
/*     */     {
/* 228 */       setOption(3, str);
/*     */     }
/*     */ 
/* 231 */     setSSLSocketOptions();
/*     */   }
/*     */ 
/*     */   public void setSSLSocketOptions()
/*     */     throws IOException
/*     */   {
/* 247 */     super.setSocketOptions();
/* 248 */     SSLSocket localSSLSocket = (SSLSocket)this.socket;
/*     */ 
/* 250 */     localSSLSocket.setUseClientMode(true);
/*     */ 
/* 253 */     TcpsConfigure.configureVersion(localSSLSocket, (String)this.socketOptions.get(Integer.valueOf(6)));
/*     */ 
/* 258 */     TcpsConfigure.configureCipherSuites(localSSLSocket, (String)this.socketOptions.get(Integer.valueOf(7)));
/*     */   }
/*     */ 
/*     */   public void setOption(int paramInt, Object paramObject)
/*     */     throws IOException, NetException
/*     */   {
/* 277 */     SSLSocket localSSLSocket = (SSLSocket)this.socket;
/* 278 */     switch (paramInt)
/*     */     {
/*     */     case 8:
/* 281 */       setServerDNMatchValue((String[])paramObject);
/* 282 */       break;
/*     */     case 7:
/* 285 */       if (((String)paramObject).equalsIgnoreCase("TRUE"))
/* 286 */         this.fullDNMatch = true;
/*     */       else
/* 288 */         this.fullDNMatch = false;
/* 289 */       break;
/*     */     default:
/* 292 */       super.setOption(paramInt, paramObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getOption(int paramInt)
/*     */     throws IOException, NetException
/*     */   {
/* 313 */     SSLSocket localSSLSocket = (SSLSocket)this.socket;
/* 314 */     switch (paramInt)
/*     */     {
/*     */     case 2:
/* 317 */       String str1 = localSSLSocket.getSession().getCipherSuite();
/*     */ 
/* 321 */       if ((str1 != null) && (str1.indexOf("NULL") == -1))
/* 322 */         return "TRUE";
/* 323 */       return "FALSE";
/*     */     case 5:
/* 326 */       return localSSLSocket.getSession().getCipherSuite();
/*     */     case 3:
/* 329 */       X509Certificate localX509Certificate1 = (X509Certificate)localSSLSocket.getSession().getPeerCertificates()[0];
/*     */ 
/* 331 */       return localX509Certificate1.getSubjectDN().getName();
/*     */     case 4:
/* 334 */       return localSSLSocket.getSession().getPeerCertificateChain();
/*     */     case 6:
/* 337 */       String str2 = (String)this.socketOptions.get(Integer.valueOf(4));
/*     */ 
/* 342 */       if (str2 == null) {
/* 343 */         str2 = System.getProperty("oracle.net.ssl_server_dn_match", "false");
/*     */       }
/*     */ 
/* 346 */       if ((str2.equalsIgnoreCase("YES")) || (str2.equalsIgnoreCase("ON")) || (str2.equalsIgnoreCase("TRUE")))
/*     */       {
/* 350 */         X509Certificate localX509Certificate2 = (X509Certificate)localSSLSocket.getSession().getPeerCertificates()[0];
/*     */ 
/* 353 */         String str3 = localX509Certificate2.getSubjectDN().getName();
/*     */ 
/* 355 */         if (TcpsConfigure.matchServerDN(str3, this.matchSSLServerCertDNWith, this.fullDNMatch))
/*     */         {
/* 357 */           return "TRUE";
/*     */         }
/* 359 */         return "FALSE";
/*     */       }
/* 361 */       return "TRUE";
/*     */     }
/*     */ 
/* 364 */     return super.getOption(paramInt);
/*     */   }
/*     */ 
/*     */   public void setServerDNMatchValue(String[] paramArrayOfString)
/*     */   {
/* 379 */     String str1 = paramArrayOfString[0];
/* 380 */     String str2 = paramArrayOfString[1];
/* 381 */     String str3 = paramArrayOfString[2];
/* 382 */     if (str1 != null)
/*     */     {
/* 384 */       this.matchSSLServerCertDNWith = str1;
/* 385 */       this.fullDNMatch = true;
/*     */     }
/* 387 */     else if (str2 != null)
/*     */     {
/* 389 */       if (str2.indexOf(46) != -1) {
/* 390 */         this.matchSSLServerCertDNWith = ("CN=" + str2.substring(0, str2.indexOf(46)));
/*     */       }
/*     */       else
/* 393 */         this.matchSSLServerCertDNWith = ("CN=" + str2.trim());
/* 394 */     } else if (str3 != null)
/*     */     {
/* 396 */       if (str3.indexOf(46) != -1) {
/* 397 */         this.matchSSLServerCertDNWith = ("CN=" + str3.substring(0, str3.indexOf(46)));
/*     */       }
/*     */       else
/* 400 */         this.matchSSLServerCertDNWith = ("CN=" + str3.trim());
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.nt.TcpsNTAdapter
 * JD-Core Version:    0.6.2
 */