/*     */ package oracle.net.nt;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.net.ssl.SSLSocket;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class TcpsConfigure
/*     */ {
/*     */   static final boolean DEBUG = false;
/*  56 */   public static final String[] VALID_SSL_VERSION_STRINGS = { "0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3" };
/*     */ 
/*  77 */   public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS = { { "TLSv1", "SSLv3", "SSLv2Hello" }, { "SSLv2Hello" }, { "SSLv3" }, { "TLSv1" }, { "TLSv1", "SSLv3" } };
/*     */ 
/*  89 */   public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP = { 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4 };
/*     */ 
/*     */   public static void configureVersion(SSLSocket paramSSLSocket, String paramString)
/*     */     throws NetException, IOException
/*     */   {
/* 133 */     if (paramString == null) {
/* 134 */       paramString = System.getProperty("oracle.net.ssl_version");
/*     */     }
/*     */ 
/* 139 */     int i = 0;
/* 140 */     if (paramString != null)
/*     */     {
/* 144 */       if ((paramString.startsWith("(")) && (paramString.endsWith(")")))
/* 145 */         paramString = "(ssl_version=" + paramString.substring(1);
/*     */       else
/* 147 */         paramString = "(ssl_version=" + paramString + ")";
/*     */       try {
/* 149 */         NVPair localNVPair = new NVFactory().createNVPair(paramString);
/* 150 */         String str = localNVPair.getAtom();
/*     */ 
/* 153 */         for (int j = 0; j < VALID_SSL_VERSION_STRINGS.length; j++)
/*     */         {
/* 155 */           if (str.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[j]))
/*     */           {
/* 157 */             i = j;
/* 158 */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (NLException localNLException)
/*     */       {
/* 164 */         throw ((NetException)new NetException(400, paramString).initCause(localNLException));
/*     */       }
/*     */     }
/*     */ 
/* 168 */     if (i >= VALID_SSL_VERSION_STRINGS.length) {
/* 169 */       throw new NetException(400);
/*     */     }
/* 171 */     String[] arrayOfString = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[i]];
/*     */     try
/*     */     {
/* 175 */       paramSSLSocket.setEnabledProtocols(arrayOfString);
/*     */     }
/*     */     catch (IllegalArgumentException localIllegalArgumentException)
/*     */     {
/* 179 */       throw ((NetException)new NetException(401).initCause(localIllegalArgumentException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void configureCipherSuites(SSLSocket paramSSLSocket, String paramString)
/*     */     throws NetException, IOException
/*     */   {
/* 205 */     if (paramString == null)
/* 206 */       paramString = System.getProperty("oracle.net.ssl_cipher_suites");
/* 207 */     if (paramString == null) {
/* 208 */       return;
/*     */     }
/*     */ 
/* 213 */     if ((paramString.startsWith("(")) && (paramString.endsWith(")")))
/* 214 */       paramString = "(cipher_suites=" + paramString + ")";
/*     */     else
/* 216 */       paramString = "(cipher_suites=(" + paramString + "))";
/*     */     try {
/* 218 */       NVPair localNVPair = new NVFactory().createNVPair(paramString);
/* 219 */       String[] arrayOfString = new String[localNVPair.getListSize()];
/* 220 */       if ((localNVPair.getRHSType() == NVPair.LIST_COMMASEP) || (localNVPair.getRHSType() == NVPair.RHS_LIST))
/*     */       {
/* 225 */         for (int i = 0; i < localNVPair.getListSize(); i++) {
/* 226 */           arrayOfString[i] = localNVPair.getListElement(i).getName();
/*     */         }
/*     */       }
/*     */       else {
/* 230 */         throw new NetException(403, paramString);
/*     */       }
/*     */ 
/* 233 */       paramSSLSocket.setEnabledCipherSuites(arrayOfString);
/*     */     }
/*     */     catch (NLException localNLException)
/*     */     {
/* 237 */       throw new NetException(403, paramString);
/*     */     }
/*     */     catch (IllegalArgumentException localIllegalArgumentException)
/*     */     {
/* 243 */       throw ((NetException)new NetException(404).initCause(localIllegalArgumentException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static boolean matchServerDN(String paramString1, String paramString2, boolean paramBoolean)
/*     */   {
/* 262 */     paramString1 = normalizeDN(paramString1);
/* 263 */     if (paramString1 == null)
/* 264 */       return false;
/* 265 */     if (paramBoolean)
/*     */     {
/* 267 */       paramString2 = normalizeDN(paramString2);
/* 268 */       if (paramString2 == null)
/* 269 */         return false;
/* 270 */       if (paramString2.equals(paramString1)) {
/* 271 */         return true;
/*     */       }
/*     */ 
/* 274 */       paramString1 = reverseDN(paramString1);
/* 275 */       if (paramString2.equals(paramString1)) {
/* 276 */         return true;
/*     */       }
/* 278 */       return false;
/*     */     }
/* 280 */     int i = paramString1.indexOf("CN=");
/* 281 */     if (i != -1)
/*     */     {
/* 283 */       if (paramString1.indexOf(44, i) != -1) {
/* 284 */         paramString1 = paramString1.substring(i, paramString1.indexOf(44, i));
/*     */       }
/*     */       else
/* 287 */         paramString1 = paramString1.substring(i);
/* 288 */       if (paramString2.equals(paramString1))
/* 289 */         return true;
/*     */     }
/* 291 */     return false;
/*     */   }
/*     */ 
/*     */   public static String normalizeDN(String paramString)
/*     */   {
/* 310 */     StringBuffer localStringBuffer = new StringBuffer();
/* 311 */     String str1 = null;
/* 312 */     String str2 = null;
/* 313 */     int i = 0;
/* 314 */     int j = 0;
/* 315 */     paramString = paramString.trim();
/*     */ 
/* 319 */     while ((i = paramString.indexOf(61, i)) != -1)
/*     */     {
/* 321 */       str1 = paramString.substring(j, i);
/* 322 */       str1 = str1.trim();
/* 323 */       localStringBuffer.append(str1.toUpperCase());
/* 324 */       localStringBuffer.append('=');
/* 325 */       j = i;
/* 326 */       if (j >= paramString.length() - 1)
/* 327 */         return null;
/* 328 */       i = paramString.indexOf(44, i);
/* 329 */       if (i == -1)
/*     */       {
/* 331 */         str2 = paramString.substring(j + 1);
/* 332 */         localStringBuffer.append(str2.trim());
/* 333 */         break;
/*     */       }
/* 335 */       str2 = paramString.substring(j + 1, i);
/* 336 */       localStringBuffer.append(str2.trim());
/* 337 */       localStringBuffer.append(',');
/* 338 */       if (i >= paramString.length() - 1) {
/* 339 */         return null;
/*     */       }
/* 341 */       j = i + 1;
/*     */     }
/* 343 */     return localStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   public static String reverseDN(String paramString)
/*     */   {
/* 360 */     StringBuffer localStringBuffer = new StringBuffer();
/* 361 */     String str = null;
/* 362 */     int i = paramString.length();
/* 363 */     int j = i;
/*     */     do
/*     */     {
/* 366 */       i = paramString.lastIndexOf(44, i);
/* 367 */       if (i == -1) {
/* 368 */         localStringBuffer.append(paramString.substring(0, j));
/* 369 */         break;
/*     */       }
/* 371 */       str = paramString.substring(i + 1, j);
/* 372 */       localStringBuffer.append(str);
/* 373 */       localStringBuffer.append(',');
/* 374 */       j = i;
/* 375 */       i--;
/* 376 */     }while (i != -1);
/* 377 */     return localStringBuffer.toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.nt.TcpsConfigure
 * JD-Core Version:    0.6.2
 */