/*     */ package oracle.net.nt;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketException;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class TcpNTAdapter
/*     */   implements NTAdapter
/*     */ {
/*     */   static final boolean DEBUG = false;
/*     */   int port;
/*     */   String host;
/*     */   private SocketChannel socketChannel;
/*     */   protected Socket socket;
/*     */   protected int sockTimeout;
/*     */   protected Properties socketOptions;
/* 398 */   private static Hashtable<String, InetAddress[]> inetaddressesCache = new Hashtable();
/* 399 */   private static Hashtable<String, Integer> circularOffsets = new Hashtable();
/*     */ 
/*     */   public TcpNTAdapter(String paramString, Properties paramProperties)
/*     */     throws NLException
/*     */   {
/*  50 */     this.socketOptions = paramProperties;
/*     */ 
/*  52 */     NVNavigator localNVNavigator = new NVNavigator();
/*  53 */     NVPair localNVPair1 = new NVFactory().createNVPair(paramString);
/*     */ 
/*  55 */     NVPair localNVPair2 = localNVNavigator.findNVPair(localNVPair1, "HOST");
/*  56 */     NVPair localNVPair3 = localNVNavigator.findNVPair(localNVPair1, "PORT");
/*     */ 
/*  59 */     if (localNVPair2 == null)
/*  60 */       throw new NLException("NoNVPair-04614", "HOST");
/*  61 */     this.host = localNVPair2.getAtom();
/*     */ 
/*  63 */     if (localNVPair3 != null) {
/*     */       try
/*     */       {
/*  66 */         this.port = Integer.parseInt(localNVPair3.getAtom());
/*     */       } catch (Exception localException) {
/*  68 */         throw ((NLException)new NLException(new NetException(116).getMessage()).initCause(localException));
/*     */       }
/*     */     }
/*     */     else {
/*  72 */       this.port = 1521;
/*     */     }
/*  74 */     if ((this.port < 0) || (this.port > 65535))
/*  75 */       throw new NLException(new NetException(116).getMessage());
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws IOException
/*     */   {
/* 105 */     String str = (String)this.socketOptions.get(Integer.valueOf(2));
/*     */ 
/* 109 */     boolean bool = Boolean.parseBoolean((String)this.socketOptions.get(Integer.valueOf(18)));
/*     */ 
/* 117 */     InetAddress[] arrayOfInetAddress = InetAddress.getAllByName(this.host);
/*     */ 
/* 119 */     if ((bool) && (arrayOfInetAddress.length > 1))
/*     */     {
/* 122 */       arrayOfInetAddress = getAddressesInCircularOrder(this.host, arrayOfInetAddress);
/*     */     }
/*     */ 
/* 125 */     int i = arrayOfInetAddress.length;
/*     */ 
/* 127 */     int j = 0;
/* 128 */     Boolean localBoolean = Boolean.valueOf(Boolean.parseBoolean((String)this.socketOptions.get(Integer.valueOf(20))));
/*     */     do
/*     */     {
/* 132 */       InetAddress localInetAddress = arrayOfInetAddress[j];
/* 133 */       j++;
/* 134 */       i--;
/* 135 */       if (!localBoolean.booleanValue())
/*     */       {
/* 140 */         this.socket = new Socket();
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 153 */         if (localBoolean.booleanValue())
/*     */         {
/* 156 */           this.socketChannel = SocketChannel.open(new InetSocketAddress(localInetAddress, this.port));
/*     */ 
/* 158 */           this.socket = this.socketChannel.socket();
/*     */         }
/*     */         else
/*     */         {
/* 162 */           this.socket.connect(new InetSocketAddress(localInetAddress, this.port), Integer.parseInt(str));
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException localIOException)
/*     */       {
/*     */         try
/*     */         {
/* 178 */           if (this.socket != null) {
/* 179 */             this.socket.close();
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception localException)
/*     */         {
/*     */         }
/*     */ 
/* 193 */         if (i <= 0)
/*     */         {
/* 199 */           throw localIOException;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 206 */     while (j < arrayOfInetAddress.length);
/*     */ 
/* 208 */     setOption(3, str);
/*     */ 
/* 210 */     setSocketOptions();
/*     */   }
/*     */ 
/*     */   public void setSocketOptions()
/*     */     throws IOException
/*     */   {
/*     */     String str;
/* 230 */     if ((str = (String)this.socketOptions.get(Integer.valueOf(0))) != null)
/*     */     {
/* 232 */       setOption(0, str);
/* 233 */     }if ((str = (String)this.socketOptions.get(Integer.valueOf(1))) != null)
/*     */     {
/* 235 */       setOption(1, str);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void disconnect()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 246 */       this.socket.close();
/*     */     } finally {
/* 248 */       this.socket = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */     throws IOException
/*     */   {
/* 267 */     return this.socket.getInputStream();
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */     throws IOException
/*     */   {
/* 277 */     return this.socket.getOutputStream();
/*     */   }
/*     */ 
/*     */   public void setOption(int paramInt, Object paramObject)
/*     */     throws IOException, NetException
/*     */   {
/*     */     String str;
/* 286 */     switch (paramInt)
/*     */     {
/*     */     case 0:
/* 290 */       str = (String)paramObject;
/* 291 */       this.socket.setTcpNoDelay(str.equals("YES"));
/*     */ 
/* 293 */       break;
/*     */     case 1:
/* 297 */       str = (String)paramObject;
/* 298 */       if (str.equals("YES")) {
/* 299 */         this.socket.setKeepAlive(true);
/*     */       }
/* 301 */       break;
/*     */     case 3:
/* 304 */       this.sockTimeout = Integer.parseInt((String)paramObject);
/* 305 */       this.socket.setSoTimeout(this.sockTimeout);
/* 306 */       break;
/*     */     case 2:
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getOption(int paramInt)
/*     */     throws IOException, NetException
/*     */   {
/* 319 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 322 */       return "" + this.sockTimeout;
/*     */     case 3:
/* 325 */       return Integer.toString(this.socket.getSoTimeout());
/*     */     }
/*     */ 
/* 328 */     return null;
/*     */   }
/*     */ 
/*     */   public void abort()
/*     */     throws NetException, IOException
/*     */   {
/*     */     try
/*     */     {
/* 341 */       this.socket.setSoLinger(true, 0);
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/* 346 */     this.socket.close();
/*     */   }
/*     */ 
/*     */   public void sendUrgentByte(int paramInt)
/*     */     throws IOException
/*     */   {
/* 355 */     this.socket.sendUrgentData(paramInt);
/*     */   }
/*     */ 
/*     */   public boolean isCharacteristicUrgentSupported() throws IOException
/*     */   {
/*     */     try {
/* 361 */       return !this.socket.getOOBInline();
/*     */     }
/*     */     catch (IOException localIOException) {
/*     */     }
/* 365 */     return false;
/*     */   }
/*     */ 
/*     */   public void setReadTimeoutIfRequired(Properties paramProperties)
/*     */     throws IOException, NetException
/*     */   {
/* 382 */     String str = (String)paramProperties.get("oracle.net.READ_TIMEOUT");
/* 383 */     if (str == null) {
/* 384 */       str = "0";
/*     */     }
/* 386 */     setOption(3, str);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 391 */     return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
/*     */   }
/*     */ 
/*     */   static final synchronized InetAddress[] getAddressesInCircularOrder(String paramString, InetAddress[] paramArrayOfInetAddress)
/*     */   {
/* 425 */     InetAddress[] arrayOfInetAddress1 = (InetAddress[])inetaddressesCache.get(paramString);
/* 426 */     Integer localInteger = (Integer)circularOffsets.get(paramString);
/* 427 */     if ((arrayOfInetAddress1 == null) || (!areEquals(arrayOfInetAddress1, paramArrayOfInetAddress)))
/*     */     {
/* 429 */       localInteger = new Integer(0);
/* 430 */       arrayOfInetAddress1 = paramArrayOfInetAddress;
/* 431 */       inetaddressesCache.put(paramString, paramArrayOfInetAddress);
/* 432 */       circularOffsets.put(paramString, localInteger);
/*     */     }
/* 434 */     InetAddress[] arrayOfInetAddress2 = getCopyAddresses(arrayOfInetAddress1, localInteger.intValue());
/* 435 */     circularOffsets.put(paramString, new Integer((localInteger.intValue() + 1) % arrayOfInetAddress1.length));
/* 436 */     return arrayOfInetAddress2;
/*     */   }
/*     */ 
/*     */   private static final boolean areEquals(InetAddress[] paramArrayOfInetAddress1, InetAddress[] paramArrayOfInetAddress2)
/*     */   {
/* 445 */     if (paramArrayOfInetAddress1.length != paramArrayOfInetAddress2.length)
/* 446 */       return false;
/* 447 */     for (int i = 0; i < paramArrayOfInetAddress1.length; i++)
/* 448 */       if (!paramArrayOfInetAddress1[i].equals(paramArrayOfInetAddress2[i]))
/* 449 */         return false;
/* 450 */     return true;
/*     */   }
/*     */ 
/*     */   private static final InetAddress[] getCopyAddresses(InetAddress[] paramArrayOfInetAddress, int paramInt)
/*     */   {
/* 459 */     InetAddress[] arrayOfInetAddress = new InetAddress[paramArrayOfInetAddress.length];
/* 460 */     for (int i = 0; i < paramArrayOfInetAddress.length; i++)
/* 461 */       arrayOfInetAddress[i] = paramArrayOfInetAddress[((i + paramInt) % paramArrayOfInetAddress.length)];
/* 462 */     return arrayOfInetAddress;
/*     */   }
/*     */ 
/*     */   public boolean isConnectionSocketKeepAlive()
/*     */     throws SocketException
/*     */   {
/* 472 */     return this.socket.getKeepAlive();
/*     */   }
/*     */ 
/*     */   public SocketChannel getSocketChannel()
/*     */   {
/* 477 */     return this.socketChannel;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.nt.TcpNTAdapter
 * JD-Core Version:    0.6.2
 */