/*     */ package oracle.net.nt;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.InetAddress;
/*     */ import java.net.InetSocketAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketException;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class SdpNTAdapter
/*     */   implements NTAdapter
/*     */ {
/*     */   static final boolean DEBUG = false;
/*     */   static final String SDP_SOCKET_CLASS_NAME = "com.oracle.net.Sdp";
/*  37 */   static Method OPEN_SOCKET = null;
/*  38 */   static Method OPEN_SOCKET_CHANNEL = null;
/*     */   private SocketChannel socketChannel;
/*     */   int port;
/*     */   String host;
/*     */   protected Socket socket;
/*     */   protected int sockTimeout;
/*     */   protected Properties socketOptions;
/* 435 */   private static Hashtable<String, InetAddress[]> inetaddressesCache = new Hashtable();
/* 436 */   private static Hashtable<String, Integer> circularOffsets = new Hashtable();
/*     */ 
/*     */   private static Socket getSDPSocket()
/*     */     throws IOException
/*     */   {
/*  44 */     if (OPEN_SOCKET == null)
/*     */       try {
/*  46 */         Class localClass = Class.forName("com.oracle.net.Sdp");
/*  47 */         OPEN_SOCKET = localClass.getMethod("openSocket", new Class[0]);
/*     */       }
/*     */       catch (ClassNotFoundException localClassNotFoundException) {
/*  50 */         throw new IOException("SDP enabled, but SDP socket class not in classpath", localClassNotFoundException);
/*     */       }
/*     */       catch (NoSuchMethodException localNoSuchMethodException) {
/*  53 */         throw new IOException("SDP enabled but unable to get SDP socket class", localNoSuchMethodException);
/*     */       }
/*     */     try
/*     */     {
/*  57 */       return (Socket)OPEN_SOCKET.invoke(null, new Object[0]);
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException) {
/*  60 */       throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", localIllegalAccessException);
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException) {
/*  63 */       throw new IOException("SDP enabled, but SDP.openSocket raised an exception", localInvocationTargetException);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static SocketChannel getSDPSocketChannel() throws IOException {
/*  68 */     if (OPEN_SOCKET_CHANNEL == null)
/*     */       try {
/*  70 */         Class localClass = Class.forName("com.oracle.net.Sdp");
/*  71 */         OPEN_SOCKET_CHANNEL = localClass.getMethod("openSocketChannel", new Class[0]);
/*     */       }
/*     */       catch (ClassNotFoundException localClassNotFoundException) {
/*  74 */         throw new IOException("SDP enabled, but SDP socket class not in classpath", localClassNotFoundException);
/*     */       }
/*     */       catch (NoSuchMethodException localNoSuchMethodException) {
/*  77 */         throw new IOException("SDP enabled but unable to get SDP socket class", localNoSuchMethodException);
/*     */       }
/*     */     try
/*     */     {
/*  81 */       return (SocketChannel)OPEN_SOCKET_CHANNEL.invoke(null, new Object[0]);
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException) {
/*  84 */       throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", localIllegalAccessException);
/*     */     }
/*     */     catch (InvocationTargetException localInvocationTargetException) {
/*  87 */       throw new IOException("SDP enabled, but SDP.openSocket raised an exception", localInvocationTargetException);
/*     */     }
/*     */   }
/*     */ 
/*     */   public SdpNTAdapter(String paramString, Properties paramProperties)
/*     */     throws NLException
/*     */   {
/* 103 */     this.socketOptions = paramProperties;
/*     */ 
/* 105 */     NVNavigator localNVNavigator = new NVNavigator();
/* 106 */     NVPair localNVPair1 = new NVFactory().createNVPair(paramString);
/*     */ 
/* 108 */     NVPair localNVPair2 = localNVNavigator.findNVPair(localNVPair1, "HOST");
/* 109 */     NVPair localNVPair3 = localNVNavigator.findNVPair(localNVPair1, "PORT");
/*     */ 
/* 112 */     if (localNVPair2 == null)
/* 113 */       throw new NLException("NoNVPair-04614", "HOST");
/* 114 */     this.host = localNVPair2.getAtom();
/*     */ 
/* 116 */     if (localNVPair3 != null) {
/*     */       try
/*     */       {
/* 119 */         this.port = Integer.parseInt(localNVPair3.getAtom());
/*     */       } catch (Exception localException) {
/* 121 */         throw ((NLException)new NLException(new NetException(116).getMessage()).initCause(localException));
/*     */       }
/*     */     }
/*     */     else {
/* 125 */       this.port = 1521;
/*     */     }
/* 127 */     if ((this.port < 0) || (this.port > 65535))
/* 128 */       throw new NLException(new NetException(116).getMessage());
/*     */   }
/*     */ 
/*     */   public void connect()
/*     */     throws IOException
/*     */   {
/* 158 */     String str = (String)this.socketOptions.get(Integer.valueOf(2));
/*     */ 
/* 162 */     boolean bool = Boolean.parseBoolean((String)this.socketOptions.get(Integer.valueOf(18)));
/*     */ 
/* 165 */     Boolean localBoolean = Boolean.valueOf(Boolean.parseBoolean((String)this.socketOptions.get(Integer.valueOf(20))));
/*     */ 
/* 167 */     InetAddress[] arrayOfInetAddress = InetAddress.getAllByName(this.host);
/* 168 */     if ((bool) && (arrayOfInetAddress.length > 1))
/*     */     {
/* 171 */       arrayOfInetAddress = getAddressesInCircularOrder(this.host, arrayOfInetAddress);
/*     */     }
/*     */ 
/* 174 */     int i = arrayOfInetAddress.length;
/*     */ 
/* 176 */     int j = 0;
/*     */     do
/*     */     {
/* 180 */       InetAddress localInetAddress = arrayOfInetAddress[j];
/* 181 */       j++;
/* 182 */       i--;
/* 183 */       if (!localBoolean.booleanValue()) {
/* 184 */         this.socket = getSDPSocket();
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 196 */         if (localBoolean.booleanValue())
/*     */         {
/* 199 */           this.socketChannel = getSDPSocketChannel();
/* 200 */           this.socket = this.socketChannel.socket();
/*     */         }
/*     */         else
/*     */         {
/* 204 */           this.socket.connect(new InetSocketAddress(localInetAddress, this.port), Integer.parseInt(str));
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException localIOException)
/*     */       {
/*     */         try
/*     */         {
/* 220 */           if (this.socket != null) {
/* 221 */             this.socket.close();
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (Exception localException)
/*     */         {
/*     */         }
/*     */ 
/* 235 */         if (i <= 0)
/*     */         {
/* 241 */           throw localIOException;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 247 */     while (j < arrayOfInetAddress.length);
/*     */ 
/* 249 */     setOption(3, str);
/*     */ 
/* 251 */     setSocketOptions();
/*     */   }
/*     */ 
/*     */   public void setSocketOptions()
/*     */     throws IOException
/*     */   {
/*     */     String str;
/* 271 */     if ((str = (String)this.socketOptions.get(Integer.valueOf(0))) != null)
/*     */     {
/* 273 */       setOption(0, str);
/* 274 */     }if ((str = (String)this.socketOptions.get(Integer.valueOf(1))) != null)
/*     */     {
/* 276 */       setOption(1, str);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void disconnect()
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 287 */       this.socket.close();
/*     */     } finally {
/* 289 */       this.socket = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */     throws IOException
/*     */   {
/* 308 */     return this.socket.getInputStream();
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */     throws IOException
/*     */   {
/* 318 */     return this.socket.getOutputStream();
/*     */   }
/*     */ 
/*     */   public void setOption(int paramInt, Object paramObject)
/*     */     throws IOException, NetException
/*     */   {
/*     */     String str;
/* 327 */     switch (paramInt)
/*     */     {
/*     */     case 0:
/* 331 */       str = (String)paramObject;
/* 332 */       this.socket.setTcpNoDelay(str.equals("YES"));
/*     */ 
/* 334 */       break;
/*     */     case 1:
/* 338 */       str = (String)paramObject;
/* 339 */       if (str.equals("YES")) {
/* 340 */         this.socket.setKeepAlive(true);
/*     */       }
/* 342 */       break;
/*     */     case 3:
/* 345 */       this.sockTimeout = Integer.parseInt((String)paramObject);
/* 346 */       this.socket.setSoTimeout(this.sockTimeout);
/* 347 */       break;
/*     */     case 2:
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getOption(int paramInt)
/*     */     throws IOException, NetException
/*     */   {
/* 360 */     switch (paramInt)
/*     */     {
/*     */     case 1:
/* 363 */       return "" + this.sockTimeout;
/*     */     }
/* 365 */     return null;
/*     */   }
/*     */ 
/*     */   public void abort()
/*     */     throws NetException, IOException
/*     */   {
/*     */     try
/*     */     {
/* 378 */       this.socket.setSoLinger(true, 0);
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/* 383 */     this.socket.close();
/*     */   }
/*     */ 
/*     */   public void sendUrgentByte(int paramInt)
/*     */     throws IOException
/*     */   {
/* 392 */     this.socket.sendUrgentData(paramInt);
/*     */   }
/*     */ 
/*     */   public boolean isCharacteristicUrgentSupported() throws IOException
/*     */   {
/*     */     try {
/* 398 */       return !this.socket.getOOBInline();
/*     */     }
/*     */     catch (IOException localIOException) {
/*     */     }
/* 402 */     return false;
/*     */   }
/*     */ 
/*     */   public void setReadTimeoutIfRequired(Properties paramProperties)
/*     */     throws IOException, NetException
/*     */   {
/* 419 */     String str = (String)paramProperties.get("oracle.net.READ_TIMEOUT");
/* 420 */     if (str == null) {
/* 421 */       str = "0";
/*     */     }
/* 423 */     setOption(3, str);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 428 */     return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
/*     */   }
/*     */ 
/*     */   private static final synchronized InetAddress[] getAddressesInCircularOrder(String paramString, InetAddress[] paramArrayOfInetAddress)
/*     */   {
/* 462 */     InetAddress[] arrayOfInetAddress1 = (InetAddress[])inetaddressesCache.get(paramString);
/* 463 */     Integer localInteger = (Integer)circularOffsets.get(paramString);
/* 464 */     if ((arrayOfInetAddress1 == null) || (!areEquals(arrayOfInetAddress1, paramArrayOfInetAddress)))
/*     */     {
/* 466 */       localInteger = new Integer(0);
/* 467 */       arrayOfInetAddress1 = paramArrayOfInetAddress;
/* 468 */       inetaddressesCache.put(paramString, paramArrayOfInetAddress);
/* 469 */       circularOffsets.put(paramString, localInteger);
/*     */     }
/* 471 */     InetAddress[] arrayOfInetAddress2 = getCopyAddresses(arrayOfInetAddress1, localInteger.intValue());
/* 472 */     circularOffsets.put(paramString, new Integer((localInteger.intValue() + 1) % arrayOfInetAddress1.length));
/* 473 */     return arrayOfInetAddress2;
/*     */   }
/*     */ 
/*     */   private static final boolean areEquals(InetAddress[] paramArrayOfInetAddress1, InetAddress[] paramArrayOfInetAddress2)
/*     */   {
/* 482 */     if (paramArrayOfInetAddress1.length != paramArrayOfInetAddress2.length)
/* 483 */       return false;
/* 484 */     for (int i = 0; i < paramArrayOfInetAddress1.length; i++)
/* 485 */       if (!paramArrayOfInetAddress1[i].equals(paramArrayOfInetAddress2[i]))
/* 486 */         return false;
/* 487 */     return true;
/*     */   }
/*     */ 
/*     */   private static final InetAddress[] getCopyAddresses(InetAddress[] paramArrayOfInetAddress, int paramInt)
/*     */   {
/* 496 */     InetAddress[] arrayOfInetAddress = new InetAddress[paramArrayOfInetAddress.length];
/* 497 */     for (int i = 0; i < paramArrayOfInetAddress.length; i++)
/* 498 */       arrayOfInetAddress[i] = paramArrayOfInetAddress[((i + paramInt) % paramArrayOfInetAddress.length)];
/* 499 */     return arrayOfInetAddress;
/*     */   }
/*     */ 
/*     */   public boolean isConnectionSocketKeepAlive()
/*     */     throws SocketException
/*     */   {
/* 510 */     return this.socket.getKeepAlive();
/*     */   }
/*     */ 
/*     */   public SocketChannel getSocketChannel()
/*     */   {
/* 515 */     return this.socketChannel;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.nt.SdpNTAdapter
 * JD-Core Version:    0.6.2
 */