/*     */ package oracle.net.nt;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.security.KeyStore;
/*     */ import java.security.Security;
/*     */ import java.util.Properties;
/*     */ import javax.net.ssl.KeyManager;
/*     */ import javax.net.ssl.KeyManagerFactory;
/*     */ import javax.net.ssl.SSLContext;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import javax.net.ssl.TrustManager;
/*     */ import javax.net.ssl.TrustManagerFactory;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class CustomSSLSocketFactory
/*     */ {
/*     */   static final boolean DEBUG = false;
/*     */   public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
/*     */   public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
/*     */   public static final String SSO_WALLET_TYPE = "SSO";
/*     */   public static final String PKCS12_WALLET_TYPE = "PKCS12";
/*     */   public static final String SUPPORTED_METHOD_TYPE = "FILE";
/*     */   public static SSLSocketFactory defSSLFactory;
/*  79 */   public static String defPropString = getDefaultPropertiesString();
/*     */   public static boolean initDefFactory;
/*     */ 
/*     */   public static SSLSocketFactory getSSLSocketFactory(Properties paramProperties)
/*     */     throws IOException
/*     */   {
/*     */     String str1;
/*     */     Object localObject2;
/* 118 */     Object localObject1 = localObject2 = str1 = null;
/*     */     String str2;
/*     */     Object localObject4;
/* 120 */     Object localObject3 = localObject4 = str2 = null;
/* 121 */     String str3 = null;
/* 122 */     String str4 = null;
/* 123 */     String str5 = null;
/* 124 */     String str6 = null;
/* 125 */     String str7 = null;
/* 126 */     String str8 = null;
/* 127 */     SSLSocketFactory localSSLSocketFactory = null;
/*     */ 
/* 133 */     str7 = (String)paramProperties.get(Integer.valueOf(5));
/*     */ 
/* 135 */     str8 = (String)paramProperties.get(Integer.valueOf(16));
/*     */     Object localObject5;
/* 145 */     if (str7 == null)
/*     */     {
/* 147 */       localObject1 = (String)paramProperties.get(Integer.valueOf(8));
/*     */ 
/* 149 */       if (localObject1 != null)
/*     */       {
/* 151 */         str1 = (String)paramProperties.get(Integer.valueOf(9));
/*     */ 
/* 153 */         if (str1 == null)
/* 154 */           str1 = KeyStore.getDefaultType();
/* 155 */         localObject2 = (String)paramProperties.get(Integer.valueOf(10));
/*     */ 
/* 157 */         if (localObject2 == null) {
/* 158 */           localObject2 = "";
/*     */         }
/* 160 */         str3 = (String)paramProperties.get(Integer.valueOf(14));
/*     */ 
/* 162 */         if (str3 == null) {
/* 163 */           str3 = Security.getProperty("ssl.keyManagerFactory.algorithm");
/*     */         }
/* 165 */         if (str3 == null) {
/* 166 */           str3 = KeyManagerFactory.getDefaultAlgorithm();
/*     */         }
/*     */       }
/* 169 */       localObject3 = (String)paramProperties.get(Integer.valueOf(11));
/*     */ 
/* 171 */       if (localObject3 != null)
/*     */       {
/* 173 */         str2 = (String)paramProperties.get(Integer.valueOf(12));
/*     */ 
/* 175 */         if (str2 == null) {
/* 176 */           str2 = KeyStore.getDefaultType();
/*     */         }
/* 178 */         localObject4 = (String)paramProperties.get(Integer.valueOf(13));
/*     */ 
/* 180 */         if (localObject4 == null) {
/* 181 */           localObject4 = "";
/*     */         }
/* 183 */         str4 = (String)paramProperties.get(Integer.valueOf(15));
/*     */ 
/* 185 */         if (str4 == null) {
/* 186 */           str4 = Security.getProperty("ssl.trustManagerFactory.algorithm");
/*     */         }
/* 188 */         if (str4 == null) {
/* 189 */           str4 = TrustManagerFactory.getDefaultAlgorithm();
/*     */         }
/*     */       }
/* 192 */       str5 = (String)localObject1 + "#" + str1 + "#" + (String)localObject2 + "#" + (String)localObject3 + "#" + str2 + "#" + (String)localObject4 + "#" + str3 + "#" + str4;
/*     */     }
/*     */     else
/*     */     {
/* 201 */       int i = 0;
/*     */ 
/* 204 */       if (str7.startsWith("(")) {
/* 205 */         str6 = processWalletLocation(str7);
/* 206 */       } else if (str7.startsWith("file:"))
/*     */       {
/* 208 */         str6 = str7.substring("file:".length());
/* 209 */         localObject5 = new File(str6);
/* 210 */         if (!((File)localObject5).exists())
/* 211 */           throw new NetException(407, "Couldn't find file at " + str6);
/* 212 */         if (!((File)localObject5).isDirectory())
/* 213 */           i = 1;
/*     */       }
/*     */       else
/*     */       {
/* 217 */         throw new NetException(412, "Location: " + str7);
/*     */       }
/*     */ 
/* 222 */       if (str8 == null)
/*     */       {
/* 225 */         if (i == 0) {
/* 226 */           localObject1 = str6 + System.getProperty("file.separator") + "cwallet.sso";
/*     */         }
/*     */         else {
/* 229 */           localObject1 = str6;
/*     */         }
/* 231 */         str1 = "SSO";
/* 232 */         localObject2 = "";
/* 233 */         str3 = KeyManagerFactory.getDefaultAlgorithm();
/*     */ 
/* 235 */         localObject3 = localObject1;
/* 236 */         str2 = "SSO";
/* 237 */         localObject4 = "";
/* 238 */         str4 = TrustManagerFactory.getDefaultAlgorithm();
/*     */       }
/*     */       else
/*     */       {
/* 243 */         if (i == 0) {
/* 244 */           localObject1 = str6 + System.getProperty("file.separator") + "ewallet.p12";
/*     */         }
/*     */         else {
/* 247 */           localObject1 = str6;
/*     */         }
/* 249 */         str1 = "PKCS12";
/* 250 */         localObject2 = str8;
/* 251 */         str3 = KeyManagerFactory.getDefaultAlgorithm();
/*     */ 
/* 253 */         localObject3 = localObject1;
/* 254 */         str2 = "PKCS12";
/* 255 */         localObject4 = str8;
/* 256 */         str4 = TrustManagerFactory.getDefaultAlgorithm();
/*     */       }
/*     */ 
/* 259 */       str5 = str7 + "#" + str3 + "#" + str4;
/*     */     }
/*     */     Object localObject6;
/* 263 */     if (str5.equals(defPropString))
/*     */     {
/* 265 */       if (initDefFactory) {
/* 266 */         return defSSLFactory;
/*     */       }
/* 268 */       synchronized (CustomSSLSocketFactory.class)
/*     */       {
/* 270 */         if (!initDefFactory) {
/*     */           try
/*     */           {
/* 273 */             localObject5 = null;
/* 274 */             localObject6 = null;
/*     */ 
/* 276 */             if (localObject1 != null) {
/* 277 */               localObject5 = getKeyManagerArray((String)localObject1, (String)localObject2, str1, str3);
/*     */             }
/*     */ 
/* 280 */             if (localObject3 != null) {
/* 281 */               localObject6 = getTrustManagerArray((String)localObject3, (String)localObject4, str2, str4);
/*     */             }
/*     */ 
/* 284 */             SSLContext localSSLContext = SSLContext.getInstance("SSL");
/* 285 */             localSSLContext.init((KeyManager[])localObject5, (TrustManager[])localObject6, null);
/* 286 */             defSSLFactory = localSSLContext.getSocketFactory();
/* 287 */             if (defSSLFactory != null) {
/* 288 */               initDefFactory = true;
/*     */             }
/*     */ 
/*     */           }
/*     */           catch (Exception localException2)
/*     */           {
/* 294 */             throw ((NetException)new NetException(410).initCause(localException2));
/*     */           }
/*     */         }
/* 297 */         return defSSLFactory;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 302 */       ??? = null;
/* 303 */       TrustManager[] arrayOfTrustManager = null;
/*     */ 
/* 305 */       if (localObject1 != null) {
/* 306 */         ??? = getKeyManagerArray((String)localObject1, (String)localObject2, str1, str3);
/*     */       }
/* 308 */       if (localObject3 != null) {
/* 309 */         arrayOfTrustManager = getTrustManagerArray((String)localObject3, (String)localObject4, str2, str4);
/*     */       }
/* 311 */       localObject6 = SSLContext.getInstance("SSL");
/* 312 */       ((SSLContext)localObject6).init((KeyManager[])???, arrayOfTrustManager, null);
/*     */ 
/* 314 */       return ((SSLContext)localObject6).getSocketFactory();
/*     */     }
/*     */     catch (Exception localException1)
/*     */     {
/* 325 */       throw ((NetException)new NetException(410).initCause(localException1));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static KeyManager[] getKeyManagerArray(String paramString1, String paramString2, String paramString3, String paramString4)
/*     */     throws IOException
/*     */   {
/* 347 */     FileInputStream localFileInputStream = null;
/*     */     try
/*     */     {
/* 355 */       KeyStore localKeyStore = KeyStore.getInstance(paramString3);
/* 356 */       localFileInputStream = new FileInputStream(paramString1);
/*     */ 
/* 358 */       localKeyStore.load(localFileInputStream, paramString2.toCharArray());
/* 359 */       KeyManagerFactory localKeyManagerFactory = KeyManagerFactory.getInstance(paramString4);
/*     */ 
/* 361 */       localKeyManagerFactory.init(localKeyStore, paramString2.toCharArray());
/*     */ 
/* 363 */       return localKeyManagerFactory.getKeyManagers();
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 367 */       throw ((NetException)new NetException(408).initCause(localException));
/*     */     } finally {
/* 369 */       if (localFileInputStream != null)
/* 370 */         localFileInputStream.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static TrustManager[] getTrustManagerArray(String paramString1, String paramString2, String paramString3, String paramString4)
/*     */     throws IOException
/*     */   {
/* 392 */     FileInputStream localFileInputStream = null;
/*     */     try
/*     */     {
/* 401 */       KeyStore localKeyStore = KeyStore.getInstance(paramString3);
/* 402 */       localFileInputStream = new FileInputStream(paramString1);
/*     */ 
/* 404 */       localKeyStore.load(localFileInputStream, paramString2.toCharArray());
/* 405 */       TrustManagerFactory localTrustManagerFactory = TrustManagerFactory.getInstance(paramString4);
/*     */ 
/* 407 */       localTrustManagerFactory.init(localKeyStore);
/* 408 */       return localTrustManagerFactory.getTrustManagers();
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 413 */       throw ((NetException)new NetException(409).initCause(localException));
/*     */     }
/*     */     finally {
/* 416 */       if (localFileInputStream != null)
/* 417 */         localFileInputStream.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String processWalletLocation(String paramString)
/*     */     throws NetException
/*     */   {
/* 438 */     String str1 = null;
/*     */     try {
/* 440 */       NVNavigator localNVNavigator = new NVNavigator();
/* 441 */       NVPair localNVPair1 = new NVFactory().createNVPair(paramString);
/*     */ 
/* 443 */       NVPair localNVPair2 = localNVNavigator.findNVPair(localNVPair1, "METHOD");
/* 444 */       NVPair localNVPair3 = localNVNavigator.findNVPair(localNVPair1, "METHOD_DATA");
/* 445 */       NVPair localNVPair4 = localNVNavigator.findNVPair(localNVPair3, "DIRECTORY");
/* 446 */       str1 = localNVPair2.getAtom();
/*     */ 
/* 452 */       if (str1.equalsIgnoreCase("FILE")) {
/* 453 */         return localNVPair4.getAtom();
/*     */       }
/*     */ 
/* 457 */       throw new NetException(412, str1);
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 463 */       throw ((NetException)new NetException(407).initCause(localException));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String getDefaultPropertiesString()
/*     */   {
/* 477 */     Object localObject1 = null;
/* 478 */     String str1 = null;
/* 479 */     Object localObject2 = null;
/* 480 */     String str2 = null;
/* 481 */     String str3 = null;
/*     */ 
/* 485 */     str1 = System.getProperty("oracle.net.wallet_location");
/*     */ 
/* 488 */     if (str1 != null)
/* 489 */       localObject1 = str1;
/*     */     else {
/* 491 */       localObject1 = System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
/*     */     }
/*     */ 
/* 506 */     if (str2 == null)
/* 507 */       str2 = KeyManagerFactory.getDefaultAlgorithm();
/* 508 */     if (str3 == null)
/* 509 */       str3 = TrustManagerFactory.getDefaultAlgorithm();
/* 510 */     return (String)localObject1 + "#" + str2 + "#" + str3;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.nt.CustomSSLSocketFactory
 * JD-Core Version:    0.6.2
 */