/*     */ package oracle.net.nt;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.SocketException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ import java.util.Vector;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class ConnStrategy
/*     */ {
/*     */   static final boolean DEBUG = false;
/*  92 */   private boolean optFound = false;
/*  93 */   public boolean reuseOpt = false;
/*     */   private ConnOption copt;
/*     */   public int sdu;
/*     */   public int tdu;
/*     */   public int nextOptToTry;
/*  96 */   public Properties socketOptions = new Properties();
/*     */   private String osuser;
/*     */   private String programName;
/* 101 */   public int connectTimeout = -1;
/* 102 */   public int retryCount = 0;
/* 103 */   private int lastRetryCounter = 0;
/*     */ 
/* 105 */   public Vector cOpts = new Vector(10, 10);
/*     */ 
/*     */   public ConnStrategy(Properties paramProperties)
/*     */   {
/* 113 */     this.nextOptToTry = 0;
/* 114 */     this.osuser = paramProperties.getProperty("oracle.jdbc.v$session.osuser");
/* 115 */     this.programName = paramProperties.getProperty("oracle.jdbc.v$session.program");
/* 116 */     createSocketOptions(paramProperties);
/*     */   }
/*     */ 
/*     */   public String getOSUsername()
/*     */   {
/* 121 */     return this.osuser;
/*     */   }
/*     */ 
/*     */   public String getProgramName() {
/* 125 */     return this.programName;
/*     */   }
/*     */ 
/*     */   public void createSocketOptions(Properties paramProperties) {
/* 129 */     String str1 = null;
/* 130 */     String str2 = null;
/* 131 */     int i = 0;
/*     */ 
/* 137 */     Enumeration localEnumeration = paramProperties.keys();
/* 138 */     while (localEnumeration.hasMoreElements())
/*     */     {
/* 140 */       str1 = (String)localEnumeration.nextElement();
/*     */ 
/* 142 */       if (str1.equalsIgnoreCase("TCP.NODELAY"))
/*     */       {
/* 144 */         i = 1;
/* 145 */         str2 = paramProperties.getProperty("TCP.NODELAY").toUpperCase();
/* 146 */         if (str2.equals("NO"))
/* 147 */           this.socketOptions.put(Integer.valueOf(0), "NO");
/*     */         else
/* 149 */           this.socketOptions.put(Integer.valueOf(0), "YES");
/*     */       }
/* 151 */       else if (str1.equalsIgnoreCase("oracle.net.READ_TIMEOUT"))
/*     */       {
/* 153 */         str2 = paramProperties.getProperty("oracle.net.READ_TIMEOUT");
/* 154 */         this.socketOptions.put(Integer.valueOf(3), str2);
/*     */       }
/* 156 */       else if (str1.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT"))
/*     */       {
/* 158 */         str2 = paramProperties.getProperty("oracle.net.CONNECT_TIMEOUT");
/* 159 */         this.socketOptions.put(Integer.valueOf(2), str2);
/*     */       }
/* 161 */       else if (str1.equalsIgnoreCase("oracle.net.ssl_server_dn_match"))
/*     */       {
/* 163 */         str2 = paramProperties.getProperty("oracle.net.ssl_server_dn_match");
/* 164 */         this.socketOptions.put(Integer.valueOf(4), str2);
/*     */       }
/* 167 */       else if (str1.equalsIgnoreCase("oracle.net.wallet_location"))
/*     */       {
/* 170 */         str2 = paramProperties.getProperty("oracle.net.wallet_location");
/* 171 */         this.socketOptions.put(Integer.valueOf(5), str2);
/*     */       }
/* 175 */       else if (str1.equalsIgnoreCase("oracle.net.wallet_password"))
/*     */       {
/* 178 */         str2 = paramProperties.getProperty("oracle.net.wallet_password");
/* 179 */         this.socketOptions.put(Integer.valueOf(16), str2);
/*     */       }
/* 183 */       else if (str1.equalsIgnoreCase("oracle.net.ssl_version"))
/*     */       {
/* 185 */         str2 = paramProperties.getProperty("oracle.net.ssl_version");
/* 186 */         this.socketOptions.put(Integer.valueOf(6), str2);
/*     */       }
/* 189 */       else if (str1.equalsIgnoreCase("oracle.net.ssl_cipher_suites"))
/*     */       {
/* 191 */         str2 = paramProperties.getProperty("oracle.net.ssl_cipher_suites");
/* 192 */         this.socketOptions.put(Integer.valueOf(7), str2);
/*     */       }
/* 195 */       else if (str1.equalsIgnoreCase("javax.net.ssl.keyStore"))
/*     */       {
/* 198 */         str2 = paramProperties.getProperty("javax.net.ssl.keyStore");
/* 199 */         this.socketOptions.put(Integer.valueOf(8), str2);
/*     */       }
/* 202 */       else if (str1.equalsIgnoreCase("javax.net.ssl.keyStoreType"))
/*     */       {
/* 205 */         str2 = paramProperties.getProperty("javax.net.ssl.keyStoreType");
/* 206 */         this.socketOptions.put(Integer.valueOf(9), str2);
/*     */       }
/* 210 */       else if (str1.equalsIgnoreCase("javax.net.ssl.keyStorePassword"))
/*     */       {
/* 213 */         str2 = paramProperties.getProperty("javax.net.ssl.keyStorePassword");
/*     */ 
/* 215 */         this.socketOptions.put(Integer.valueOf(10), str2);
/*     */       }
/* 219 */       else if (str1.equalsIgnoreCase("javax.net.ssl.trustStore"))
/*     */       {
/* 222 */         str2 = paramProperties.getProperty("javax.net.ssl.trustStore");
/* 223 */         this.socketOptions.put(Integer.valueOf(11), str2);
/*     */       }
/* 226 */       else if (str1.equalsIgnoreCase("javax.net.ssl.trustStoreType"))
/*     */       {
/* 229 */         str2 = paramProperties.getProperty("javax.net.ssl.trustStoreType");
/*     */ 
/* 231 */         this.socketOptions.put(Integer.valueOf(12), str2);
/*     */       }
/* 235 */       else if (str1.equalsIgnoreCase("javax.net.ssl.trustStorePassword"))
/*     */       {
/* 238 */         str2 = paramProperties.getProperty("javax.net.ssl.trustStorePassword");
/*     */ 
/* 240 */         this.socketOptions.put(Integer.valueOf(13), str2);
/*     */       }
/* 244 */       else if (str1.equalsIgnoreCase("ssl.keyManagerFactory.algorithm"))
/*     */       {
/* 247 */         str2 = paramProperties.getProperty("ssl.keyManagerFactory.algorithm");
/*     */ 
/* 249 */         this.socketOptions.put(Integer.valueOf(14), str2);
/*     */       }
/* 253 */       else if (str1.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING"))
/*     */       {
/* 256 */         str2 = paramProperties.getProperty("FORCE_DNS_LOAD_BALANCING");
/*     */ 
/* 258 */         this.socketOptions.put(Integer.valueOf(18), str2);
/*     */       }
/* 262 */       else if (str1.equalsIgnoreCase("oracle.net.keepAlive"))
/*     */       {
/* 264 */         str2 = paramProperties.getProperty("oracle.net.keepAlive");
/*     */ 
/* 270 */         if (Boolean.parseBoolean(str2))
/* 271 */           this.socketOptions.put(Integer.valueOf(1), "YES");
/*     */         else {
/* 273 */           this.socketOptions.put(Integer.valueOf(1), "NO");
/*     */         }
/*     */       }
/* 276 */       else if (str1.equalsIgnoreCase("oracle.jdbc.useNio"))
/*     */       {
/* 278 */         str2 = paramProperties.getProperty("oracle.jdbc.useNio");
/*     */ 
/* 280 */         this.socketOptions.put(Integer.valueOf(20), str2);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 290 */     if ((i == 0) && (!this.reuseOpt))
/* 291 */       this.socketOptions.put(Integer.valueOf(0), "YES");
/*     */   }
/*     */ 
/*     */   public void addSocketOptions(boolean paramBoolean)
/*     */   {
/* 299 */     if (paramBoolean) {
/* 300 */       this.socketOptions.put(Integer.valueOf(1), "YES");
/*     */     }
/* 302 */     else if ((!this.reuseOpt) && (!this.socketOptions.containsKey(Integer.valueOf(1))))
/*     */     {
/* 305 */       this.socketOptions.put(Integer.valueOf(1), "NO");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addOption(ConnOption paramConnOption)
/*     */   {
/* 318 */     this.cOpts.addElement(paramConnOption);
/*     */   }
/*     */ 
/*     */   public boolean hasMoreOptions()
/*     */   {
/* 329 */     if (this.nextOptToTry < this.cOpts.size()) {
/* 330 */       return true;
/*     */     }
/* 332 */     return false;
/*     */   }
/*     */ 
/*     */   public ConnOption execute()
/*     */     throws NetException
/*     */   {
/* 358 */     Object localObject = null;
/*     */ 
/* 360 */     if (this.connectTimeout == -1)
/*     */     {
/* 364 */       if (this.socketOptions.get(Integer.valueOf(2)) == null)
/*     */       {
/* 367 */         this.socketOptions.put(Integer.valueOf(2), Integer.toString(60000));
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 376 */       this.socketOptions.put(Integer.valueOf(2), Integer.toString(this.connectTimeout));
/*     */     }
/*     */ 
/* 380 */     if (this.retryCount < 0)
/*     */     {
/* 383 */       this.retryCount = 0;
/*     */     }
/*     */ 
/* 386 */     this.socketOptions.put(Integer.valueOf(17), Integer.toString(this.retryCount));
/*     */ 
/* 396 */     for (int i = this.lastRetryCounter; i <= this.retryCount; i++)
/*     */     {
/* 398 */       while (this.nextOptToTry < this.cOpts.size())
/*     */       {
/*     */         try
/*     */         {
/* 402 */           this.copt = ((ConnOption)this.cOpts.elementAt(this.nextOptToTry));
/*     */ 
/* 411 */           this.copt.connect(this.socketOptions);
/*     */ 
/* 416 */           this.copt.sdu = this.sdu;
/* 417 */           this.copt.tdu = this.tdu;
/* 418 */           this.optFound = true;
/*     */ 
/* 421 */           this.nextOptToTry += 1;
/* 422 */           this.lastRetryCounter = i;
/*     */ 
/* 424 */           return this.copt;
/*     */         }
/*     */         catch (IOException localIOException)
/*     */         {
/* 431 */           this.nextOptToTry += 1;
/* 432 */           localObject = localIOException;
/*     */         }
/*     */       }
/* 435 */       this.nextOptToTry = 0;
/*     */     }
/*     */ 
/* 439 */     if (localObject == null)
/*     */     {
/* 441 */       throw new NetException(20);
/*     */     }
/*     */ 
/* 445 */     throw ((NetException)new NetException(20).initCause(localObject));
/*     */   }
/*     */ 
/*     */   public boolean optAvailable()
/*     */   {
/* 451 */     return this.optFound;
/*     */   }
/*     */ 
/*     */   public void clearElements() {
/* 455 */     this.cOpts.removeAllElements();
/*     */   }
/*     */ 
/*     */   public ConnOption getOption()
/*     */   {
/* 460 */     return this.copt;
/*     */   }
/*     */ 
/*     */   public boolean isConnectionSocketKeepAlive()
/*     */     throws SocketException
/*     */   {
/* 470 */     return this.copt.isConnectionSocketKeepAlive();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.nt.ConnStrategy
 * JD-Core Version:    0.6.2
 */