/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import oracle.net.ano.Ano;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.NTAdapter;
/*     */ import oracle.net.nt.TcpsNTAdapter;
/*     */ 
/*     */ public class SessionAtts
/*     */   implements SQLnetDef
/*     */ {
/*     */   protected NSProtocol ns;
/*     */   protected NTAdapter nt;
/*     */   protected InputStream ntInputStream;
/*     */   protected OutputStream ntOutputStream;
/*     */   protected NetInputStream nsInputStream;
/*     */   protected NetOutputStream nsOutputStream;
/*     */   private int sdu;
/*     */   private int tdu;
/*     */   protected ConnOption cOption;
/*     */   protected boolean dataEOF;
/*     */   protected boolean connected;
/*     */   public boolean onBreakReset;
/*     */   public ClientProfile profile;
/*     */   public Ano ano;
/*     */   public boolean anoEnabled;
/*     */   public boolean isEncryptionActive;
/*     */   public boolean isChecksumActive;
/*     */   public boolean areEncryptionAndChecksumActive;
/*     */   boolean noAnoServices;
/*     */   int negotiatedOptions;
/*  96 */   public boolean poolEnabled = false;
/*     */   protected byte[] sessionId;
/*     */   protected int timeout;
/*     */   protected int tick;
/*     */   protected byte[] reconnectAddress;
/*     */   protected long timestampLastIO;
/* 110 */   protected boolean attemptingReconnect = false;
/*     */   public boolean anoActive;
/* 116 */   protected boolean isLargeSDU = false;
/*     */ 
/* 120 */   protected int negotiatedSDU = -1;
/*     */ 
/* 123 */   protected boolean redirecting = false;
/*     */   SocketChannel socketChannel;
/*     */   public NIONSDataChannel dataChannel;
/*     */   NIOMarkerPacket markerPacket;
/*     */   NIODataDescriptorPacket ddPacket;
/* 142 */   public ByteBuffer buffer = null;
/*     */ 
/* 145 */   ByteBuffer payloadBuffer = null;
/* 146 */   ByteBuffer headerBuffer = null;
/*     */ 
/* 150 */   public ByteBuffer payloadDataBuffer = null;
/*     */ 
/* 153 */   boolean useNativeBuffers = false;
/*     */   String traceId;
/*     */ 
/*     */   public SessionAtts(NSProtocol paramNSProtocol, int paramInt1, int paramInt2, boolean paramBoolean1, boolean paramBoolean2)
/*     */   {
/* 160 */     this.sdu = paramInt1;
/* 161 */     this.tdu = paramInt2;
/* 162 */     this.ns = paramNSProtocol;
/* 163 */     this.anoActive = false;
/* 164 */     this.connected = false;
/*     */ 
/* 166 */     if (paramBoolean1)
/*     */     {
/* 168 */       this.dataChannel = new NIONSDataChannel(this);
/* 169 */       this.markerPacket = new NIOMarkerPacket(this);
/* 170 */       this.ddPacket = new NIODataDescriptorPacket(this);
/* 171 */       this.useNativeBuffers = paramBoolean2;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initializeBuffer(int paramInt)
/*     */   {
/* 182 */     if (this.useNativeBuffers)
/* 183 */       this.buffer = ByteBuffer.allocateDirect(paramInt);
/*     */     else {
/* 185 */       this.buffer = ByteBuffer.allocate(paramInt);
/*     */     }
/*     */ 
/* 188 */     this.buffer.limit(8);
/* 189 */     this.headerBuffer = this.buffer.slice();
/* 190 */     this.buffer.clear();
/* 191 */     this.buffer.position(8);
/* 192 */     this.payloadBuffer = this.buffer.slice();
/* 193 */     this.buffer.clear();
/* 194 */     this.buffer.position(10);
/* 195 */     this.payloadDataBuffer = this.buffer.slice();
/*     */   }
/*     */ 
/*     */   public void setSDU(int paramInt)
/*     */   {
/* 204 */     if (paramInt <= 0)
/* 205 */       this.sdu = 8192;
/* 206 */     else if (paramInt > 2097152)
/* 207 */       this.sdu = 2097152;
/* 208 */     else if (paramInt < 512)
/* 209 */       this.sdu = 512;
/*     */     else
/* 211 */       this.sdu = paramInt;
/*     */   }
/*     */ 
/*     */   public int getSDU()
/*     */   {
/* 219 */     return this.sdu;
/*     */   }
/*     */ 
/*     */   public void setTDU(int paramInt)
/*     */   {
/* 227 */     if (paramInt <= 0)
/* 228 */       this.tdu = 2097152;
/* 229 */     else if (paramInt > 2097152)
/* 230 */       this.tdu = 2097152;
/* 231 */     else if (paramInt < 255)
/* 232 */       this.tdu = 255;
/*     */     else
/* 234 */       this.tdu = paramInt;
/*     */   }
/*     */ 
/*     */   public int getTDU()
/*     */   {
/* 242 */     return this.tdu;
/*     */   }
/*     */ 
/*     */   void setNegotiatedSDUAndTDU(int paramInt1, int paramInt2)
/*     */   {
/* 253 */     setTDU(paramInt2);
/*     */ 
/* 255 */     if (paramInt2 < paramInt1)
/* 256 */       setSDU(paramInt2);
/*     */     else {
/* 258 */       setSDU(paramInt1);
/*     */     }
/*     */ 
/* 261 */     this.negotiatedSDU = this.sdu;
/*     */ 
/* 263 */     initializeBuffer(getSDU());
/*     */   }
/*     */ 
/*     */   public NTAdapter getNTAdapter()
/*     */   {
/* 271 */     return this.nt;
/*     */   }
/*     */ 
/*     */   void renegotiateSSLSession()
/*     */     throws IOException
/*     */   {
/* 282 */     ((TcpsNTAdapter)this.nt).renegotiateSession();
/* 283 */     this.ntInputStream = this.nt.getInputStream();
/* 284 */     this.ntOutputStream = this.nt.getOutputStream();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 294 */     return "Session Attributes: \nsdu=" + this.sdu + ", tdu=" + this.tdu + "\nnt: " + this.nt + "\n\nntInputStream : " + this.ntInputStream + "\nntOutputStream: " + this.ntOutputStream + "\nnsInputStream : " + this.nsInputStream + "\nnsOutputStream: " + this.nsOutputStream + "\n\nClient Profile: " + this.profile + "\n\nConnection Options: " + this.cOption + "\n\nonBreakReset=" + this.onBreakReset + ", dataEOF=" + this.dataEOF + ", negotiatedOptions=0x" + Integer.toHexString(this.negotiatedOptions) + ", connected=" + this.connected;
/*     */   }
/*     */ 
/*     */   public void turnEncryptionOn(NetInputStream paramNetInputStream, NetOutputStream paramNetOutputStream)
/*     */     throws NetException
/*     */   {
/* 318 */     if ((paramNetInputStream != null) && (paramNetOutputStream != null))
/*     */     {
/* 320 */       this.nsInputStream = paramNetInputStream;
/* 321 */       this.nsOutputStream = paramNetOutputStream;
/* 322 */       this.anoActive = true;
/*     */     }
/*     */     else {
/* 325 */       throw new NetException(300);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void turnEncryptionOn(NIONSDataChannel paramNIONSDataChannel)
/*     */     throws NetException
/*     */   {
/* 334 */     if (paramNIONSDataChannel != null)
/*     */     {
/* 336 */       this.dataChannel = paramNIONSDataChannel;
/* 337 */       this.anoActive = true;
/*     */     }
/*     */     else {
/* 340 */       throw new NetException(300);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getANOFlags()
/*     */   {
/* 348 */     int i = 1;
/*     */ 
/* 350 */     if (this.ano != null) {
/* 351 */       i = this.ano.getNAFlags();
/*     */     }
/* 353 */     return i;
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */   {
/* 361 */     return this.nsOutputStream;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */   {
/* 369 */     return this.nsInputStream;
/*     */   }
/*     */ 
/*     */   public void setNegotiatedOptions(int paramInt)
/*     */   {
/* 395 */     this.negotiatedOptions = paramInt;
/*     */   }
/*     */ 
/*     */   public int getNegotiatedOptions() {
/* 399 */     return this.negotiatedOptions;
/*     */   }
/*     */ 
/*     */   public ConnOption getcOption() {
/* 403 */     return this.cOption;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.SessionAtts
 * JD-Core Version:    0.6.2
 */