/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import oracle.net.jdbc.nl.RepConversion;
/*     */ 
/*     */ public class Packet
/*     */   implements SQLnetDef
/*     */ {
/*     */   private int buffer2send;
/*     */   protected int sdu;
/*     */   protected int tdu;
/*     */   protected int length;
/*     */   public int type;
/*     */   protected int flags;
/*     */   protected int dataLen;
/*     */   protected int dataOff;
/*     */   protected String data;
/*     */   protected byte[] buffer;
/* 113 */   protected int leftOverFromPreviousRead = 0;
/*     */ 
/* 119 */   protected int nextPacketOffset = 0;
/*     */   public SessionAtts sAtts;
/* 591 */   StringBuilder sb = null;
/* 592 */   StringBuilder tmpBuf = null;
/*     */ 
/* 665 */   public static final String[] toHex = { " 00", " 01", " 02", " 03", " 04", " 05", " 06", " 07", " 08", " 09", " 0A", " 0B", " 0C", " 0D", " 0E", " 0F", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 1A", " 1B", " 1C", " 1D", " 1E", " 1F", " 20", " 21", " 22", " 23", " 24", " 25", " 26", " 27", " 28", " 29", " 2A", " 2B", " 2C", " 2D", " 2E", " 2F", " 30", " 31", " 32", " 33", " 34", " 35", " 36", " 37", " 38", " 39", " 3A", " 3B", " 3C", " 3D", " 3E", " 3F", " 40", " 41", " 42", " 43", " 44", " 45", " 46", " 47", " 48", " 49", " 4A", " 4B", " 4C", " 4D", " 4E", " 4F", " 50", " 51", " 52", " 53", " 54", " 55", " 56", " 57", " 58", " 59", " 5A", " 5B", " 5C", " 5D", " 5E", " 5F", " 60", " 61", " 62", " 63", " 64", " 65", " 66", " 67", " 68", " 69", " 6A", " 6B", " 6C", " 6D", " 6E", " 6F", " 70", " 71", " 72", " 73", " 74", " 75", " 76", " 77", " 78", " 79", " 7A", " 7B", " 7C", " 7D", " 7E", " 7F", " 80", " 81", " 82", " 83", " 84", " 85", " 86", " 87", " 88", " 89", " 8A", " 8B", " 8C", " 8D", " 8E", " 8F", " 90", " 91", " 92", " 93", " 94", " 95", " 96", " 97", " 98", " 99", " 9A", " 9B", " 9C", " 9D", " 9E", " 9F", " A0", " A1", " A2", " A3", " A4", " A5", " A6", " A7", " A8", " A9", " AA", " AB", " AC", " AD", " AE", " AF", " B0", " B1", " B2", " B3", " B4", " B5", " B6", " B7", " B8", " B9", " BA", " BB", " BC", " BD", " BE", " BF", " C0", " C1", " C2", " C3", " C4", " C5", " C6", " C7", " C8", " C9", " CA", " CB", " CC", " CD", " CE", " CF", " D0", " D1", " D2", " D3", " D4", " D5", " D6", " D7", " D8", " D9", " DA", " DB", " DC", " DD", " DE", " DF", " E0", " E1", " E2", " E3", " E4", " E5", " E6", " E7", " E8", " E9", " EA", " EB", " EC", " ED", " EE", " EF", " F0", " F1", " F2", " F3", " F4", " F5", " F6", " F7", " F8", " F9", " FA", " FB", " FC", " FD", " FE", " FF" };
/*     */ 
/* 691 */   public static final char[] toChar = { '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '!', '"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.' };
/*     */   public static final String DIVIDER = "     |";
/*     */   public static final String BLANK_SPACE = "   ";
/* 744 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public Packet(SessionAtts paramSessionAtts)
/*     */   {
/* 133 */     this.sAtts = paramSessionAtts;
/* 134 */     this.sdu = paramSessionAtts.getSDU();
/* 135 */     this.tdu = paramSessionAtts.getTDU();
/*     */   }
/*     */ 
/*     */   public Packet(SessionAtts paramSessionAtts, int paramInt)
/*     */   {
/* 147 */     this(paramSessionAtts);
/* 148 */     createBuffer(paramInt);
/*     */   }
/*     */ 
/*     */   public Packet(SessionAtts paramSessionAtts, int paramInt1, int paramInt2, int paramInt3)
/*     */   {
/* 160 */     this(paramSessionAtts);
/* 161 */     createBuffer(paramInt1, paramInt2, paramInt3);
/*     */   }
/*     */ 
/*     */   public Packet(Packet paramPacket)
/*     */   {
/* 171 */     this(paramPacket.sAtts);
/*     */ 
/* 173 */     this.length = paramPacket.length;
/* 174 */     this.type = paramPacket.type;
/* 175 */     this.flags = paramPacket.flags;
/* 176 */     this.dataLen = paramPacket.dataLen;
/* 177 */     this.dataOff = paramPacket.dataOff;
/* 178 */     this.buffer = paramPacket.buffer;
/*     */ 
/* 180 */     this.leftOverFromPreviousRead = paramPacket.leftOverFromPreviousRead;
/* 181 */     this.nextPacketOffset = paramPacket.nextPacketOffset;
/*     */   }
/*     */ 
/*     */   protected void createBuffer(int paramInt)
/*     */   {
/* 190 */     this.buffer = new byte[paramInt];
/*     */ 
/* 194 */     if ((this.sAtts.isLargeSDU) && ((this.type == 6) || (this.type == 12) || (this.type == 15))) {
/* 195 */       this.buffer[3] = ((byte)(paramInt & 0xFF));
/* 196 */       this.buffer[2] = ((byte)(paramInt >> 8 & 0xFF));
/* 197 */       this.buffer[1] = ((byte)(paramInt >> 16 & 0xFF));
/* 198 */       this.buffer[0] = ((byte)(paramInt >> 24 & 0xFF));
/*     */     }
/*     */     else {
/* 201 */       this.buffer[0] = ((byte)(paramInt / 256));
/* 202 */       this.buffer[1] = ((byte)(paramInt % 256));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void createBuffer(int paramInt1, int paramInt2, int paramInt3)
/*     */   {
/* 214 */     this.type = paramInt2;
/* 215 */     createBuffer(paramInt1);
/* 216 */     this.buffer[5] = ((byte)paramInt3);
/* 217 */     this.buffer[4] = ((byte)paramInt2);
/*     */   }
/*     */ 
/*     */   protected void receive()
/*     */     throws IOException, NetException
/*     */   {
/* 260 */     int i = 0;
/* 261 */     int j = 0;
/* 262 */     int k = this.sdu;
/*     */ 
/* 264 */     int m = 1;
/*     */ 
/* 266 */     while (k > 0)
/*     */     {
/* 268 */       if (this.leftOverFromPreviousRead > 0)
/*     */       {
/* 270 */         System.arraycopy(this.buffer, this.nextPacketOffset, this.buffer, 0, this.leftOverFromPreviousRead);
/*     */ 
/* 274 */         i = this.leftOverFromPreviousRead;
/*     */ 
/* 276 */         if (i >= 8)
/*     */         {
/* 279 */           processHeader();
/* 280 */           m = 0;
/*     */ 
/* 282 */           if (this.length >= this.leftOverFromPreviousRead)
/*     */           {
/* 284 */             k = this.length - this.leftOverFromPreviousRead;
/* 285 */             this.leftOverFromPreviousRead = 0;
/* 286 */             this.nextPacketOffset = 0;
/*     */           }
/*     */           else
/*     */           {
/* 290 */             this.leftOverFromPreviousRead -= this.length;
/* 291 */             k = 0;
/* 292 */             this.nextPacketOffset = this.length;
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 298 */           k -= i;
/* 299 */           this.leftOverFromPreviousRead -= i;
/*     */ 
/* 303 */           this.nextPacketOffset = 0;
/*     */         }
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 309 */         if (k > 0)
/*     */         {
/* 311 */           if ((j = this.sAtts.ntInputStream.read(this.buffer, i, k)) <= 0)
/*     */           {
/* 314 */             throw new NetException(0);
/*     */           }
/* 316 */           i += j;
/*     */         }
/*     */ 
/* 319 */         if ((m != 0) && (i >= 8))
/*     */         {
/* 321 */           m = 0;
/*     */ 
/* 323 */           processHeader();
/* 324 */           k = this.length;
/*     */ 
/* 326 */           if (i > this.length)
/*     */           {
/* 330 */             this.leftOverFromPreviousRead = (i - this.length);
/* 331 */             k = 0;
/* 332 */             this.nextPacketOffset = this.length;
/*     */           }
/*     */           else
/*     */           {
/* 336 */             this.leftOverFromPreviousRead = 0;
/* 337 */             this.nextPacketOffset = 0;
/* 338 */             k -= i;
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 344 */           k -= j;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (InterruptedIOException localInterruptedIOException)
/*     */       {
/* 350 */         throw new NetException(504);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   void processHeader()
/*     */     throws IOException, NetException
/*     */   {
/* 377 */     this.length = (this.buffer[0] & 0xFF);
/* 378 */     this.length <<= 8;
/* 379 */     this.length |= this.buffer[1] & 0xFF;
/*     */ 
/* 381 */     this.type = this.buffer[4];
/* 382 */     this.flags = this.buffer[5];
/*     */ 
/* 385 */     if ((this.sAtts.isLargeSDU) && ((this.type == 6) || (this.type == 12) || (this.type == 15))) {
/* 386 */       this.length = toUb4(this.buffer, 0);
/*     */     }
/*     */ 
/* 390 */     if (this.type > 19)
/* 391 */       throw new NetException(204);
/* 392 */     if ((this.length > 2097152) || (this.length > this.sdu))
/* 393 */       throw new NetException(203);
/* 394 */     if (this.length < 8)
/* 395 */       throw new NetException(207);
/*     */   }
/*     */ 
/*     */   protected void send()
/*     */     throws IOException
/*     */   {
/* 415 */     synchronized (this.sAtts.ntOutputStream)
/*     */     {
/* 419 */       this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void extractData()
/*     */     throws IOException, NetException
/*     */   {
/* 440 */     if (this.dataLen <= 0)
/*     */     {
/* 442 */       this.data = new String();
/*     */     }
/* 444 */     else if (this.length > this.dataOff)
/*     */     {
/* 447 */       this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
/*     */     }
/*     */     else
/*     */     {
/* 454 */       byte[] arrayOfByte1 = new byte[this.dataLen + 10];
/* 455 */       byte[] arrayOfByte2 = new byte[this.dataLen];
/*     */ 
/* 457 */       int i = readLocal(arrayOfByte1, 0, this.dataLen + 10);
/*     */ 
/* 459 */       if (i != 0)
/*     */       {
/* 462 */         if (i >= 10)
/*     */         {
/* 464 */           i -= 10;
/* 465 */           System.arraycopy(arrayOfByte1, 10, arrayOfByte2, 0, i);
/*     */         }
/*     */         else
/*     */         {
/* 469 */           throw new NetException(207);
/*     */         }
/*     */       }
/*     */ 
/* 473 */       if (i < this.dataLen)
/*     */       {
/* 481 */         if (this.sAtts.nsInputStream.read(arrayOfByte2, i, this.dataLen - i) < 0)
/*     */         {
/* 484 */           throw new NetException(0);
/*     */         }
/*     */       }
/* 486 */       this.data = new String(arrayOfByte2, 0);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected String getData()
/*     */   {
/* 498 */     return this.data;
/*     */   }
/*     */ 
/*     */   void setFlags(int paramInt)
/*     */     throws NetException
/*     */   {
/* 504 */     this.flags = paramInt;
/* 505 */     this.buffer[5] = ((byte)this.flags);
/*     */   }
/*     */ 
/*     */   void reinitialize(SessionAtts paramSessionAtts)
/*     */     throws NetException
/*     */   {
/* 511 */     this.sAtts = paramSessionAtts;
/*     */   }
/*     */ 
/*     */   public static final int toUb2(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 516 */     int i = 0;
/* 517 */     i = paramArrayOfByte[paramInt] & 0xFF;
/* 518 */     i <<= 8;
/* 519 */     i |= paramArrayOfByte[(paramInt + 1)] & 0xFF;
/*     */ 
/* 521 */     return i;
/*     */   }
/*     */ 
/*     */   public static int toUb4(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 533 */     int i = 0;
/* 534 */     for (int j = 0; j < 4; j++) {
/* 535 */       int k = (3 - j) * 8;
/* 536 */       i += ((paramArrayOfByte[(j + paramInt)] & 0xFF) << k);
/*     */     }
/* 538 */     return i;
/*     */   }
/*     */ 
/*     */   public static final void setUb2ToBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 543 */     paramArrayOfByte[paramInt1] = ((byte)(paramInt2 << 8 & 0xFF));
/* 544 */     paramArrayOfByte[(paramInt1 + 1)] = ((byte)(paramInt2 & 0xFF));
/*     */   }
/*     */ 
/*     */   int available()
/*     */   {
/* 549 */     return this.leftOverFromPreviousRead;
/*     */   }
/*     */ 
/*     */   int readLocal(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws NetException
/*     */   {
/* 559 */     int i = 0;
/* 560 */     if (this.leftOverFromPreviousRead > 0)
/*     */     {
/* 562 */       if (this.leftOverFromPreviousRead > paramInt2)
/*     */       {
/* 567 */         i = paramInt2;
/* 568 */         System.arraycopy(this.buffer, this.nextPacketOffset, paramArrayOfByte, paramInt1, i);
/*     */ 
/* 571 */         this.leftOverFromPreviousRead -= i;
/*     */ 
/* 573 */         this.nextPacketOffset += i;
/*     */       }
/*     */       else
/*     */       {
/* 579 */         i = this.leftOverFromPreviousRead;
/* 580 */         System.arraycopy(this.buffer, this.nextPacketOffset, paramArrayOfByte, paramInt1, i);
/*     */ 
/* 583 */         this.leftOverFromPreviousRead -= i;
/* 584 */         this.nextPacketOffset = 0;
/*     */       }
/*     */     }
/*     */ 
/* 588 */     return i;
/*     */   }
/*     */ 
/*     */   protected String dumpBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 597 */     if (this.sb == null)
/*     */     {
/* 599 */       this.sb = new StringBuilder(16384);
/* 600 */       this.tmpBuf = new StringBuilder(80);
/*     */     }
/* 602 */     return dumpBytes(paramArrayOfByte, paramInt1, paramInt2, 8, this.sb, this.tmpBuf);
/*     */   }
/*     */ 
/*     */   public String dumpBytes(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int paramInt3, StringBuilder paramStringBuilder1, StringBuilder paramStringBuilder2)
/*     */   {
/* 617 */     if (paramArrayOfByte == null) {
/* 618 */       return "NULL";
/*     */     }
/* 620 */     paramStringBuilder1.delete(0, paramStringBuilder1.length());
/* 621 */     paramStringBuilder2.delete(0, paramStringBuilder2.length());
/*     */ 
/* 624 */     int j = paramInt1 + paramInt2;
/* 625 */     int k = paramInt1;
/*     */ 
/* 627 */     int m = 0;
/* 628 */     int n = 0;
/* 629 */     for (; k < j; k++) {
/* 630 */       int i = paramArrayOfByte[k] & 0xFF;
/* 631 */       paramStringBuilder1.append(toHex[i]);
/* 632 */       paramStringBuilder2.append(toChar[i]);
/*     */ 
/* 634 */       n++;
/*     */ 
/* 637 */       if (n == paramInt3) {
/* 638 */         paramStringBuilder1.append("     |");
/* 639 */         paramStringBuilder1.append(paramStringBuilder2.substring(0, paramStringBuilder2.length()));
/* 640 */         paramStringBuilder1.append("|\n");
/* 641 */         paramStringBuilder2.delete(0, paramStringBuilder2.length());
/* 642 */         n = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 647 */     if (n > 0) {
/* 648 */       int i1 = paramInt3 - n - 1;
/*     */ 
/* 650 */       for (int i2 = 0; i2 <= i1; i2++) {
/* 651 */         paramStringBuilder1.append("   ");
/*     */       }
/* 653 */       paramStringBuilder1.append("     |");
/* 654 */       paramStringBuilder1.append(paramStringBuilder2.substring(0, paramStringBuilder2.length()));
/* 655 */       for (i2 = 0; i2 <= i1; i2++)
/* 656 */         paramStringBuilder1.append(" ");
/* 657 */       paramStringBuilder1.append("|\n");
/* 658 */       paramStringBuilder2.delete(0, paramStringBuilder2.length());
/*     */     }
/*     */ 
/* 662 */     return paramStringBuilder1.substring(0, paramStringBuilder1.length());
/*     */   }
/*     */ 
/*     */   protected void dump(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 720 */     int i = 0;
/* 721 */     System.out.println("Packet dump");
/* 722 */     System.out.println(new StringBuilder().append("buffer.length=").append(paramArrayOfByte.length).toString());
/* 723 */     System.out.println(new StringBuilder().append("offset       =").append(paramInt1).toString());
/* 724 */     System.out.println(new StringBuilder().append("len          =").append(paramInt2).toString());
/*     */ 
/* 726 */     for (int j = paramInt1; j < paramInt2; j += 8)
/*     */     {
/* 728 */       System.out.print("|");
/* 729 */       for (int k = 0; (k < 8) && (i < paramInt2 - 1); k++)
/*     */       {
/* 732 */         i = j + k;
/* 733 */         RepConversion.printInHex(paramArrayOfByte[i]);
/* 734 */         System.out.print(" ");
/*     */       }
/*     */ 
/* 737 */       System.out.println("|");
/*     */     }
/* 739 */     System.out.println("finish dump");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.Packet
 * JD-Core Version:    0.6.2
 */