/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ 
/*     */ public class NetOutputStream extends OutputStream
/*     */   implements SQLnetDef
/*     */ {
/*     */   protected DataPacket daPkt;
/*     */   protected DataDescriptorPacket ddPkt;
/*     */   protected SessionAtts sAtts;
/*  63 */   private byte[] tmpBuf = new byte[1];
/*     */ 
/*     */   public NetOutputStream()
/*     */   {
/*     */   }
/*     */ 
/*     */   public NetOutputStream(SessionAtts paramSessionAtts)
/*     */   {
/*  74 */     this.sAtts = paramSessionAtts;
/*  75 */     this.daPkt = new DataPacket(paramSessionAtts);
/*  76 */     this.ddPkt = new DataDescriptorPacket(paramSessionAtts);
/*     */   }
/*     */ 
/*     */   public NetOutputStream(SessionAtts paramSessionAtts, int paramInt)
/*     */   {
/*  84 */     this.sAtts = paramSessionAtts;
/*  85 */     this.daPkt = new DataPacket(paramSessionAtts, paramInt);
/*  86 */     this.ddPkt = new DataDescriptorPacket(paramSessionAtts);
/*     */   }
/*     */ 
/*     */   public void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/*  92 */     int i = paramInt2;
/*     */ 
/*  94 */     boolean bool = false;
/*  95 */     while (i > 0)
/*     */     {
/*     */       int j;
/*  97 */       if (i > 1703910) {
/*  98 */         j = 1703910;
/*     */       }
/*     */       else {
/* 101 */         j = i;
/* 102 */         bool = true;
/*     */       }
/* 104 */       this.ddPkt.send(j, bool);
/* 105 */       synchronized (this.sAtts.ntOutputStream)
/*     */       {
/* 108 */         this.sAtts.ntOutputStream.write(paramArrayOfByte, paramInt1, j);
/*     */       }
/* 110 */       paramInt1 += j;
/* 111 */       i -= j;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void write(int paramInt)
/*     */     throws IOException
/*     */   {
/* 123 */     this.tmpBuf[0] = ((byte)paramInt);
/* 124 */     write(this.tmpBuf);
/*     */   }
/*     */ 
/*     */   public void write(byte[] paramArrayOfByte)
/*     */     throws IOException
/*     */   {
/* 136 */     write(paramArrayOfByte, 0, paramArrayOfByte.length);
/*     */   }
/*     */ 
/*     */   public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 151 */     int i = 0;
/* 152 */     int j = 0;
/*     */ 
/* 167 */     while (paramInt2 > i)
/*     */     {
/* 170 */       i += this.daPkt.putDataInBuffer(paramArrayOfByte, paramInt1 + i, paramInt2 - i);
/*     */ 
/* 175 */       if (this.daPkt.isBufferFull)
/*     */       {
/* 177 */         j = paramInt2 > i ? 32 : 0;
/*     */ 
/* 180 */         this.daPkt.send(j);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 205 */     return this.daPkt.availableBytesToSend;
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */     throws IOException
/*     */   {
/* 214 */     if (this.daPkt.availableBytesToSend > 0)
/* 215 */       this.daPkt.send(0);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws IOException
/*     */   {
/* 233 */     this.daPkt.send(64);
/*     */   }
/*     */ 
/*     */   void poolEnabled(boolean paramBoolean)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 247 */     if (paramBoolean)
/* 248 */       this.daPkt.setFlags(1);
/*     */   }
/*     */ 
/*     */   void reinitialize(SessionAtts paramSessionAtts)
/*     */     throws NetException
/*     */   {
/* 254 */     this.sAtts = paramSessionAtts;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NetOutputStream
 * JD-Core Version:    0.6.2
 */