/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ 
/*     */ public class NetInputStream extends InputStream
/*     */   implements SQLnetDef
/*     */ {
/*     */   protected DataPacket daPkt;
/*     */   protected DataDescriptorPacket ddPkt;
/*     */   protected MarkerPacket mkPkt;
/*     */   protected SessionAtts sAtts;
/*  64 */   private byte[] tmpBuf = new byte[1];
/*     */ 
/*     */   public NetInputStream()
/*     */   {
/*     */   }
/*     */ 
/*     */   public NetInputStream(SessionAtts paramSessionAtts)
/*     */   {
/*  75 */     this.sAtts = paramSessionAtts;
/*  76 */     this.daPkt = new DataPacket(paramSessionAtts);
/*  77 */     this.ddPkt = new DataDescriptorPacket(this.daPkt, paramSessionAtts);
/*     */   }
/*     */ 
/*     */   public int read()
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/*  89 */     return read(this.tmpBuf) < 0 ? -1 : this.tmpBuf[0] & 0xFF;
/*     */   }
/*     */ 
/*     */   public int readB1()
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/*  98 */     return read();
/*     */   }
/*     */ 
/*     */   public long readLongLSB(int paramInt)
/*     */     throws BreakNetException, NetException, IOException
/*     */   {
/* 106 */     long l = 0L;
/* 107 */     int i = 0;
/*     */ 
/* 109 */     if ((paramInt & 0x80) > 0)
/*     */     {
/* 111 */       paramInt &= 127;
/* 112 */       i = 1;
/*     */     }
/* 114 */     if ((this.sAtts.anoActive) || (this.daPkt.availableBytesToRead < paramInt))
/*     */     {
/* 116 */       int j = paramInt; for (int k = 0; j > 0; k++)
/*     */       {
/* 118 */         l |= (read() & 0xFF) << 8 * k;
/*     */ 
/* 116 */         j--;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 123 */       l = this.daPkt.readLongLSB(paramInt);
/*     */     }
/*     */ 
/* 126 */     return (i != 0 ? -1 : 1) * l;
/*     */   }
/*     */ 
/*     */   public long readLongMSB(int paramInt)
/*     */     throws BreakNetException, NetException, IOException
/*     */   {
/* 134 */     long l = 0L;
/* 135 */     int i = 0;
/*     */ 
/* 138 */     if ((paramInt & 0x80) > 0)
/*     */     {
/* 140 */       paramInt &= 127;
/* 141 */       i = 1;
/*     */     }
/*     */ 
/* 144 */     if ((this.sAtts.anoActive) || (this.daPkt.availableBytesToRead < paramInt))
/*     */     {
/* 146 */       for (int j = paramInt; j > 0; j--)
/*     */       {
/* 148 */         l |= (read() & 0xFF) << 8 * (j - 1);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 153 */       l = this.daPkt.readLongMSB(paramInt);
/*     */     }
/*     */ 
/* 156 */     return (i != 0 ? -1 : 1) * l;
/*     */   }
/*     */ 
/*     */   public int read(byte[] paramArrayOfByte)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 171 */     return read(paramArrayOfByte, 0, paramArrayOfByte.length);
/*     */   }
/*     */ 
/*     */   public boolean readZeroCopyIO(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 185 */     boolean bool = false;
/*     */ 
/* 187 */     if (this.sAtts.nsOutputStream.available() > 0) {
/* 188 */       this.sAtts.nsOutputStream.flush();
/*     */     }
/*     */ 
/* 191 */     this.ddPkt.receive();
/* 192 */     int i = this.ddPkt.totalDataLength;
/* 193 */     if ((this.ddPkt.descriptorFLaG & 0x1) != 0) {
/* 194 */       bool = true;
/*     */     }
/*     */ 
/* 197 */     if (paramArrayOfByte.length < paramInt + i)
/*     */     {
/* 200 */       throw new IOException("Assertion Failed");
/*     */     }
/*     */ 
/* 203 */     int j = this.ddPkt.packet.readLocal(paramArrayOfByte, paramInt, i);
/*     */ 
/* 206 */     while (j < i)
/*     */     {
/*     */       try
/*     */       {
/* 210 */         if (j += this.sAtts.ntInputStream.read(paramArrayOfByte, j + paramInt, i - j) <= 0)
/*     */         {
/* 213 */           throw new NetException(0);
/*     */         }
/*     */       }
/*     */       catch (InterruptedIOException localInterruptedIOException) {
/* 217 */         throw new NetException(504);
/*     */       }
/*     */     }
/* 220 */     paramArrayOfInt[0] = j;
/* 221 */     return bool;
/*     */   }
/*     */ 
/*     */   public int read(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 238 */     int i = 0;
/*     */     try
/*     */     {
/*     */       do
/*     */       {
/* 247 */         while ((this.daPkt == null) || (this.daPkt.availableBytesToRead <= 0) || (this.daPkt.type == 7))
/*     */         {
/* 249 */           getNextPacket();
/*     */         }
/*     */ 
/* 252 */         i += this.daPkt.getDataFromBuffer(paramArrayOfByte, paramInt1 + i, paramInt2 - i);
/*     */       }
/* 254 */       while (i < paramInt2);
/*     */     }
/*     */     catch (NetException localNetException) {
/* 257 */       if (localNetException.getErrorNumber() == 0) {
/* 258 */         return -1;
/*     */       }
/* 260 */       throw localNetException;
/*     */     }
/* 262 */     return i;
/*     */   }
/*     */ 
/*     */   public int available()
/*     */     throws IOException
/*     */   {
/* 274 */     return this.daPkt.availableBytesToRead;
/*     */   }
/*     */ 
/*     */   protected void getNextPacket()
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 297 */     if (this.sAtts.dataEOF) {
/* 298 */       throw new NetException(202);
/*     */     }
/*     */ 
/* 301 */     if (this.sAtts.nsOutputStream.available() > 0) {
/* 302 */       this.sAtts.nsOutputStream.flush();
/*     */     }
/*     */ 
/* 305 */     this.daPkt.receive();
/*     */ 
/* 309 */     switch (this.daPkt.type)
/*     */     {
/*     */     case 6:
/* 312 */       this.daPkt.availableBytesToRead = this.daPkt.dataLen;
/* 313 */       break;
/*     */     case 12:
/* 315 */       this.mkPkt = new MarkerPacket(this.daPkt);
/*     */ 
/* 318 */       this.daPkt.availableBytesToRead = 0;
/* 319 */       this.sAtts.onBreakReset = this.mkPkt.isBreakPkt();
/* 320 */       processMarker();
/* 321 */       throw new BreakNetException(500);
/*     */     case 7:
/* 323 */       this.daPkt.availableBytesToRead = this.daPkt.dataLen;
/* 324 */       break;
/*     */     default:
/* 327 */       throw new NetException(205);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processMarker()
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/*     */   }
/*     */ 
/*     */   void poolEnabled(boolean paramBoolean)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 360 */     if (paramBoolean)
/* 361 */       this.daPkt.setFlags(1);
/*     */   }
/*     */ 
/*     */   void reinitialize(SessionAtts paramSessionAtts)
/*     */     throws NetException
/*     */   {
/* 367 */     this.sAtts = paramSessionAtts;
/*     */   }
/*     */ 
/*     */   Packet getCurrentPacket()
/*     */     throws IOException, NetException
/*     */   {
/* 377 */     return this.daPkt;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NetInputStream
 * JD-Core Version:    0.6.2
 */