/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.NTAdapter;
/*     */ 
/*     */ public class NSProtocolStream extends NSProtocol
/*     */ {
/*     */   private MarkerPacket mkPkt;
/*     */   private DataPacket probePacket;
/*     */   private Packet packet;
/* 538 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public NSProtocolStream()
/*     */   {
/* 116 */     this.sAtts = new SessionAtts(this, 2097152, 2097152, false, false);
/* 117 */     this.sAtts.connected = false;
/*     */   }
/*     */ 
/*     */   void negotiateConnection(NVFactory paramNVFactory, NVNavigator paramNVNavigator, boolean paramBoolean1, boolean paramBoolean2)
/*     */     throws IOException, NetException
/*     */   {
/* 134 */     NVPair localNVPair1 = null;
/* 135 */     String str1 = null;
/*     */     while (true)
/*     */     {
/* 143 */       Object localObject = null;
/* 144 */       localConnectPacket = new ConnectPacket(this.sAtts, !paramBoolean1, paramBoolean2);
/*     */ 
/* 147 */       this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
/*     */       try
/*     */       {
/* 151 */         localConnectPacket.send();
/*     */ 
/* 153 */         this.packet.receive();
/*     */       }
/*     */       catch (InterruptedIOException localInterruptedIOException)
/*     */       {
/* 159 */         throw localInterruptedIOException;
/*     */       }
/*     */       catch (IOException localIOException)
/*     */       {
/* 166 */         this.packet.type = 4;
/* 167 */         localObject = localIOException;
/*     */       }
/*     */ 
/* 175 */       switch (this.packet.type)
/*     */       {
/*     */       case 2:
/* 180 */         localAcceptPacket = new AcceptPacket(this.packet);
/*     */ 
/* 182 */         break;
/*     */       case 5:
/* 189 */         localRedirectPacket = new RedirectPacket(this.packet);
/*     */ 
/* 198 */         ConnOption localConnOption = this.sAtts.cOption;
/* 199 */         this.addrRes.connection_redirected = true;
/*     */ 
/* 201 */         this.sAtts.cOption.nt.disconnect();
/* 202 */         String str2 = localRedirectPacket.getData();
/* 203 */         String str3 = str2;
/* 204 */         String str4 = null;
/*     */ 
/* 209 */         if (((localRedirectPacket.flags & 0x2) == 2) && (str2.indexOf(0) != -1)) {
/* 210 */           str3 = str2.substring(0, str2.indexOf(0));
/* 211 */           this.sAtts.redirecting = true;
/* 212 */           str4 = str2.substring(str2.indexOf(0) + 1, str2.length());
/*     */         }
/* 214 */         this.sAtts = establishConnection(str3);
/*     */ 
/* 221 */         this.sAtts.cOption.restoreFromOrigCoption(localConnOption);
/*     */ 
/* 225 */         if (this.sAtts.redirecting) {
/* 226 */           this.sAtts.cOption.conn_data.setLength(0);
/* 227 */           this.sAtts.cOption.conn_data.append(str4); } break;
/*     */       case 4:
/* 233 */         localRefusePacket = new RefusePacket(this.packet);
/*     */ 
/* 236 */         this.sAtts.cOption.nt.disconnect();
/* 237 */         this.sAtts.cOption = null;
/*     */ 
/* 240 */         establishConnection(null);
/*     */ 
/* 245 */         if (this.sAtts.cOption == null)
/*     */         {
/* 249 */           if (localObject != null) {
/* 250 */             throw localObject;
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 255 */             localNVPair1 = paramNVNavigator.findNVPairRecurse(paramNVFactory.createNVPair(localRefusePacket.getData()), "ERROR");
/*     */ 
/* 257 */             if (localNVPair1 != null)
/*     */             {
/* 259 */               NVPair localNVPair2 = paramNVNavigator.findNVPairRecurse(localNVPair1, "CODE");
/* 260 */               if (localNVPair2 != null)
/* 261 */                 str1 = localNVPair2.valueToString();
/*     */             }
/*     */           }
/*     */           catch (NLException localNLException)
/*     */           {
/* 266 */             System.err.println(localNLException.getMessage());
/*     */           }
/*     */ 
/* 272 */           throw new NetException(str1 == null ? 206 : Integer.parseInt(str1), "");
/*     */         }
/*     */         break;
/*     */       case 11:
/* 276 */         if ((this.packet.flags & 0x8) == 8)
/*     */         {
/* 280 */           this.sAtts.renegotiateSSLSession(); } break;
/*     */       case 3:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       case 9:
/*     */       case 10:
/*     */       default:
/* 284 */         this.sAtts.cOption.nt.disconnect();
/* 285 */         throw new NetException(205);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 291 */     setNetStreams();
/*     */ 
/* 294 */     this.packet = null;
/* 295 */     ConnectPacket localConnectPacket = null;
/* 296 */     AcceptPacket localAcceptPacket = null;
/* 297 */     RedirectPacket localRedirectPacket = null;
/* 298 */     RefusePacket localRefusePacket = null;
/*     */   }
/*     */ 
/*     */   public void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException, NetException
/*     */   {
/* 308 */     NetOutputStream localNetOutputStream = getNetOutputStream();
/* 309 */     localNetOutputStream.writeZeroCopyIO(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public boolean readZeroCopyIO(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*     */     throws IOException, NetException
/*     */   {
/* 317 */     NetInputStream localNetInputStream = getNetInputStream();
/* 318 */     boolean bool = localNetInputStream.readZeroCopyIO(paramArrayOfByte, paramInt, paramArrayOfInt);
/* 319 */     return bool;
/*     */   }
/*     */ 
/*     */   public void disconnect()
/*     */     throws IOException, NetException
/*     */   {
/* 338 */     if (!this.sAtts.connected)
/* 339 */       throw new NetException(200);
/* 340 */     Object localObject = null;
/*     */     try
/*     */     {
/* 343 */       this.sAtts.nsOutputStream.close();
/*     */     }
/*     */     catch (IOException localIOException) {
/* 346 */       localObject = localIOException;
/*     */     }
/* 348 */     this.sAtts.connected = false;
/*     */ 
/* 352 */     this.sAtts.cOption.nt.disconnect();
/* 353 */     if (localObject != null)
/* 354 */       throw localObject;
/*     */   }
/*     */ 
/*     */   public void sendReset()
/*     */     throws IOException, NetException
/*     */   {
/* 381 */     if (!this.sAtts.connected) {
/* 382 */       throw new NetException(200);
/*     */     }
/*     */ 
/* 385 */     sendMarker(2);
/*     */ 
/* 387 */     while (this.sAtts.onBreakReset)
/*     */     {
/* 391 */       Packet localPacket = ((NetInputStream)this.sAtts.getInputStream()).getCurrentPacket();
/* 392 */       localPacket.receive();
/*     */ 
/* 394 */       if (localPacket.type == 12)
/*     */       {
/* 396 */         this.mkPkt = new MarkerPacket(localPacket);
/* 397 */         if (this.mkPkt.data == 2)
/* 398 */           this.sAtts.onBreakReset = false;
/*     */       }
/*     */     }
/* 401 */     this.mkPkt = null;
/*     */   }
/*     */ 
/*     */   public NetInputStream getNetInputStream()
/*     */     throws NetException
/*     */   {
/* 420 */     if (!this.sAtts.connected) {
/* 421 */       throw new NetException(200);
/*     */     }
/* 423 */     return this.sAtts.nsInputStream;
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */     throws NetException
/*     */   {
/* 429 */     return getNetInputStream();
/*     */   }
/*     */ 
/*     */   public NetOutputStream getNetOutputStream()
/*     */     throws NetException
/*     */   {
/* 447 */     if (!this.sAtts.connected) {
/* 448 */       throw new NetException(200);
/*     */     }
/* 450 */     return this.sAtts.nsOutputStream;
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */     throws NetException
/*     */   {
/* 456 */     return getNetOutputStream();
/*     */   }
/*     */ 
/*     */   void initializeSessionAttributes() throws NetException, IOException
/*     */   {
/* 461 */     this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
/* 462 */     this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
/*     */ 
/* 468 */     this.sAtts.dataEOF = false;
/*     */ 
/* 472 */     if (this.sAtts.attemptingReconnect)
/*     */     {
/* 475 */       this.sAtts.nsOutputStream.reinitialize(this.sAtts);
/* 476 */       this.sAtts.nsInputStream.reinitialize(this.sAtts);
/* 477 */       if (this.mkPkt != null)
/* 478 */         this.mkPkt.reinitialize(this.sAtts);
/*     */     } else {
/* 480 */       this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
/* 481 */       this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void setNetStreams()
/*     */     throws NetException, IOException
/*     */   {
/* 498 */     this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
/*     */ 
/* 504 */     this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
/*     */   }
/*     */ 
/*     */   protected void sendMarker(int paramInt)
/*     */     throws IOException, NetException
/*     */   {
/* 512 */     if (!this.sAtts.connected) {
/* 513 */       throw new NetException(200);
/*     */     }
/* 515 */     this.mkPkt = new MarkerPacket(this.sAtts, paramInt);
/*     */ 
/* 518 */     this.mkPkt.send();
/* 519 */     this.mkPkt = null;
/*     */   }
/*     */ 
/*     */   void sendProbePacket()
/*     */     throws IOException
/*     */   {
/* 528 */     if (this.probePacket == null)
/* 529 */       this.probePacket = new DataPacket(this.sAtts, 26);
/*     */     else {
/* 531 */       this.probePacket.reinitialize(this.sAtts);
/*     */     }
/* 533 */     this.probePacket.send();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NSProtocolStream
 * JD-Core Version:    0.6.2
 */