/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InterruptedIOException;
/*     */ import java.io.OutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.channels.SocketChannel;
/*     */ import oracle.net.jdbc.nl.NLException;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.jdbc.nl.NVPair;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.NTAdapter;
/*     */ 
/*     */ public class NSProtocolNIO extends NSProtocol
/*     */ {
/*  44 */   private static final byte[] ANO_NEGOTIATION_SEND = { -34, -83, -66, -17, 0, -110, 10, 32, 0, 0, 0, 4, 0, 0, 4, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 0, 0, 0, 8, 0, 1, 9, 9, 9, 9, 9, 9, 9, 9, 0, 18, 0, 1, -34, -83, -66, -17, 0, 3, 0, 0, 0, 4, 0, 4, 0, 1, 0, 2, 0, 3, 0, 1, 0, 3, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 0, 0, 0, 2, 0, 3, -32, -31, 0, 2, 0, 6, -4, -1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 0, 0, 0, 12, 0, 1, 0, 1, 8, 10, 6, 3, 2, 11, 12, 15, 16, 17, 0, 3, 0, 2, 0, 0, 0, 0, 0, 4, 0, 5, 10, 32, 0, 0, 0, 3, 0, 1, 0, 1, 3 };
/*     */   private NIONSDataChannel probePacket;
/* 452 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public NSProtocolNIO(boolean paramBoolean)
/*     */   {
/*  76 */     this.sAtts = new SessionAtts(this, 2097152, 2097152, true, paramBoolean);
/*  77 */     this.ACTIVATE_ANO_NIO = false;
/*     */   }
/*     */ 
/*     */   void negotiateConnection(NVFactory paramNVFactory, NVNavigator paramNVNavigator, boolean paramBoolean1, boolean paramBoolean2)
/*     */     throws IOException, NetException
/*     */   {
/*  89 */     NIOConnectPacket localNIOConnectPacket = new NIOConnectPacket(this.sAtts);
/*     */ 
/*  94 */     NVPair localNVPair1 = null;
/*  95 */     String str1 = null;
/*     */     while (true)
/*     */     {
/* 103 */       Object localObject = null;
/* 104 */       NIOPacket localNIOPacket = null;
/* 105 */       int i = 0;
/*     */       try
/*     */       {
/* 108 */         localNIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !paramBoolean1, paramBoolean2, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
/*     */ 
/* 118 */         localNIOPacket = NIOPacket.readNIOPacket(this.sAtts);
/*     */ 
/* 120 */         i = localNIOPacket.header.type;
/*     */       }
/*     */       catch (InterruptedIOException localInterruptedIOException)
/*     */       {
/* 125 */         throw localInterruptedIOException;
/*     */       }
/*     */       catch (IOException localIOException)
/*     */       {
/* 131 */         i = 4;
/* 132 */         localObject = localIOException;
/*     */       }
/*     */ 
/* 138 */       switch (i)
/*     */       {
/*     */       case 2:
/* 143 */         NIOAcceptPacket localNIOAcceptPacket = (NIOAcceptPacket)localNIOPacket;
/* 144 */         this.sAtts.setNegotiatedSDUAndTDU(localNIOAcceptPacket.sduSize, localNIOAcceptPacket.tduSize);
/* 145 */         this.sAtts.setNegotiatedOptions(localNIOAcceptPacket.options);
/* 146 */         break;
/*     */       case 5:
/* 153 */         NIORedirectPacket localNIORedirectPacket = (NIORedirectPacket)localNIOPacket;
/*     */ 
/* 162 */         ConnOption localConnOption = this.sAtts.cOption;
/* 163 */         this.addrRes.connection_redirected = true;
/*     */ 
/* 165 */         this.sAtts.cOption.nt.disconnect();
/* 166 */         String str2 = localNIORedirectPacket.redirectData;
/* 167 */         String str3 = null;
/*     */ 
/* 172 */         if (((localNIORedirectPacket.header.flags & 0x2) == 2) && (localNIORedirectPacket.redirectData.indexOf(0) != -1)) {
/* 173 */           str2 = localNIORedirectPacket.redirectData.substring(0, localNIORedirectPacket.redirectData.indexOf(0));
/* 174 */           this.sAtts.redirecting = true;
/* 175 */           str3 = localNIORedirectPacket.redirectData.substring(localNIORedirectPacket.redirectData.indexOf(0) + 1, localNIORedirectPacket.redirectData.length());
/*     */         }
/* 177 */         establishConnection(str2);
/*     */ 
/* 184 */         this.sAtts.cOption.restoreFromOrigCoption(localConnOption);
/*     */ 
/* 188 */         if (!this.sAtts.redirecting) break;
/* 189 */         this.sAtts.cOption.conn_data.setLength(0);
/* 190 */         this.sAtts.cOption.conn_data.append(str3); break;
/*     */       case 4:
/* 201 */         this.sAtts.cOption.nt.disconnect();
/* 202 */         this.sAtts.cOption = null;
/*     */ 
/* 205 */         establishConnection(null);
/*     */ 
/* 210 */         if (this.sAtts.cOption != null)
/*     */         {
/*     */           break;
/*     */         }
/* 214 */         if (localObject != null) {
/* 215 */           throw localObject;
/*     */         }
/*     */ 
/* 218 */         if (localNIOPacket != null)
/*     */         {
/* 220 */           NIORefusePacket localNIORefusePacket = (NIORefusePacket)localNIOPacket;
/*     */           try
/*     */           {
/* 225 */             localNVPair1 = paramNVNavigator.findNVPairRecurse(paramNVFactory.createNVPair(localNIORefusePacket.refuseData), "ERROR");
/*     */ 
/* 227 */             if (localNVPair1 != null)
/*     */             {
/* 229 */               NVPair localNVPair2 = paramNVNavigator.findNVPairRecurse(localNVPair1, "CODE");
/* 230 */               if (localNVPair2 != null)
/* 231 */                 str1 = localNVPair2.valueToString();
/*     */             }
/*     */           }
/*     */           catch (NLException localNLException)
/*     */           {
/* 236 */             System.err.println(localNLException.getMessage());
/*     */           }
/*     */ 
/* 242 */           throw new NetException(str1 == null ? 206 : Integer.parseInt(str1), "");
/*     */         }
/*     */ 
/*     */       case 11:
/* 247 */         break;
/*     */       case 3:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       case 9:
/* 249 */       case 10: } this.sAtts.cOption.nt.disconnect();
/* 250 */       throw new NetException(205);
/*     */     }
/*     */ 
/* 255 */     this.sAtts.payloadDataBuffer.put(ANO_NEGOTIATION_SEND);
/* 256 */     this.sAtts.dataChannel.writeDataToSocketChannel();
/* 257 */     this.sAtts.dataChannel.readDataFromSocketChannel();
/*     */   }
/*     */ 
/*     */   public void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 266 */     this.sAtts.dataChannel.writeDataToSocketChannel();
/* 267 */     int i = paramInt2;
/*     */ 
/* 269 */     boolean bool = false;
/* 270 */     while (i > 0)
/*     */     {
/*     */       int j;
/* 272 */       if (i >= 1703910) {
/* 273 */         j = 1703910;
/*     */       }
/*     */       else {
/* 276 */         j = i;
/* 277 */         bool = true;
/*     */       }
/* 279 */       this.sAtts.ddPacket.writeToSocketChannel(j, bool);
/*     */ 
/* 282 */       ByteBuffer localByteBuffer = ByteBuffer.wrap(paramArrayOfByte, paramInt1, j);
/* 283 */       while (localByteBuffer.hasRemaining()) {
/* 284 */         this.sAtts.socketChannel.write(localByteBuffer);
/*     */       }
/* 286 */       paramInt1 += j;
/* 287 */       i -= j;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean readZeroCopyIO(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
/*     */     throws IOException
/*     */   {
/* 297 */     boolean bool = false;
/*     */ 
/* 299 */     this.sAtts.ddPacket.readFromSocketChannel(true);
/* 300 */     this.sAtts.ddPacket.readPayloadBuffer();
/* 301 */     int i = this.sAtts.ddPacket.totalDataLength;
/* 302 */     if ((this.sAtts.ddPacket.descriptorFLaG & 0x1) != 0) {
/* 303 */       bool = true;
/*     */     }
/*     */ 
/* 306 */     if (paramArrayOfByte.length < paramInt + i)
/*     */     {
/* 309 */       throw new IOException("Assertion Failed");
/*     */     }
/*     */ 
/* 312 */     int j = 0;
/*     */ 
/* 314 */     ByteBuffer localByteBuffer = this.sAtts.buffer;
/* 315 */     while (j < i)
/*     */     {
/* 317 */       localByteBuffer.clear();
/* 318 */       localByteBuffer.limit(Math.min(localByteBuffer.capacity(), i - j));
/* 319 */       while (localByteBuffer.hasRemaining())
/* 320 */         this.sAtts.socketChannel.read(localByteBuffer);
/* 321 */       localByteBuffer.get(paramArrayOfByte, paramInt + j, localByteBuffer.limit());
/* 322 */       j += localByteBuffer.limit();
/*     */     }
/* 324 */     paramArrayOfInt[0] = j;
/* 325 */     return bool;
/*     */   }
/*     */ 
/*     */   public void disconnect()
/*     */     throws IOException, NetException
/*     */   {
/* 340 */     if (!this.sAtts.connected)
/* 341 */       throw new NetException(200);
/* 342 */     Object localObject = null;
/* 343 */     this.sAtts.connected = false;
/*     */ 
/* 347 */     this.sAtts.cOption.nt.disconnect();
/* 348 */     if (localObject != null)
/* 349 */       throw localObject;
/*     */   }
/*     */ 
/*     */   public void sendReset()
/*     */     throws IOException, NetException
/*     */   {
/* 374 */     if (!this.sAtts.connected) {
/* 375 */       throw new NetException(200);
/*     */     }
/*     */ 
/* 378 */     sendMarker(2);
/*     */ 
/* 380 */     while (this.sAtts.onBreakReset)
/*     */     {
/* 382 */       this.sAtts.markerPacket.readFromSocketChannel(true, false);
/* 383 */       this.sAtts.markerPacket.readPayloadBuffer();
/*     */ 
/* 385 */       if (this.sAtts.markerPacket.isResetPkt())
/* 386 */         this.sAtts.onBreakReset = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public NetInputStream getNetInputStream()
/*     */     throws NetException, IOException
/*     */   {
/* 396 */     throw new UnsupportedOperationException("Unsupported operation in NIO");
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */     throws NetException, IOException
/*     */   {
/* 402 */     return getNetInputStream();
/*     */   }
/*     */ 
/*     */   public NetOutputStream getNetOutputStream()
/*     */     throws NetException, IOException
/*     */   {
/* 409 */     throw new UnsupportedOperationException("Unsupported operation in NIO");
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream()
/*     */     throws NetException, IOException
/*     */   {
/* 415 */     return getNetOutputStream();
/*     */   }
/*     */ 
/*     */   void initializeSessionAttributes() throws NetException, IOException
/*     */   {
/* 420 */     this.sAtts.socketChannel = this.sAtts.nt.getSocketChannel();
/* 421 */     this.sAtts.initializeBuffer(this.sAtts.getSDU());
/*     */   }
/*     */ 
/*     */   protected void sendMarker(int paramInt)
/*     */     throws IOException, NetException
/*     */   {
/* 429 */     if (!this.sAtts.connected)
/* 430 */       throw new NetException(200);
/* 431 */     this.sAtts.markerPacket.writeToSocketChannel(paramInt);
/*     */   }
/*     */ 
/*     */   void sendProbePacket()
/*     */     throws IOException
/*     */   {
/* 441 */     if (this.probePacket == null)
/* 442 */       this.probePacket = new NIONSDataChannel(this.sAtts);
/*     */     else {
/* 444 */       this.probePacket.reinitialize(this.sAtts);
/*     */     }
/* 446 */     byte[] arrayOfByte = new byte[26];
/* 447 */     this.probePacket.writeDataToSocketChannel(arrayOfByte);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NSProtocolNIO
 * JD-Core Version:    0.6.2
 */