/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.SocketException;
/*     */ import java.util.Properties;
/*     */ import oracle.net.ano.Ano;
/*     */ import oracle.net.jdbc.nl.NVFactory;
/*     */ import oracle.net.jdbc.nl.NVNavigator;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.NTAdapter;
/*     */ import oracle.net.resolver.AddrResolution;
/*     */ 
/*     */ public abstract class NSProtocol
/*     */   implements Communication, SQLnetDef
/*     */ {
/*     */   protected AddrResolution addrRes;
/*     */   protected SessionAtts sAtts;
/*     */   private static final boolean ACTIVATE_ANO = true;
/* 133 */   boolean ACTIVATE_ANO_NIO = true;
/*     */ 
/* 685 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public SessionAtts getSessionAttributes()
/*     */   {
/* 141 */     return this.sAtts;
/*     */   }
/*     */ 
/*     */   public void connect(String paramString, Properties paramProperties)
/*     */     throws IOException, NetException
/*     */   {
/* 191 */     if (this.sAtts.connected) {
/* 192 */       throw new NetException(201);
/*     */     }
/* 194 */     if (paramString == null) {
/* 195 */       throw new NetException(208);
/*     */     }
/*     */ 
/* 201 */     NVFactory localNVFactory = new NVFactory();
/* 202 */     NVNavigator localNVNavigator = new NVNavigator();
/* 203 */     Object localObject1 = null;
/* 204 */     Object localObject2 = null;
/*     */ 
/* 206 */     this.addrRes = new AddrResolution(paramString, paramProperties);
/*     */ 
/* 208 */     String str1 = (String)paramProperties.get("DISABLE_OOB");
/* 209 */     boolean bool1 = (str1 != null) && ("true".equals(str1));
/*     */ 
/* 211 */     String str2 = (String)paramProperties.get("USE_ZERO_COPY_IO");
/* 212 */     boolean bool2 = true;
/* 213 */     if ((str2 != null) && ("false".equals(str2))) {
/* 214 */       bool2 = false;
/*     */     }
/* 216 */     this.sAtts.traceId = ((String)paramProperties.get("T4CConnection.hashCode"));
/*     */ 
/* 218 */     if (this.addrRes.connection_revised)
/*     */     {
/* 221 */       paramString = this.addrRes.getTNSAddress();
/* 222 */       paramProperties = this.addrRes.getUp();
/*     */     }
/*     */ 
/* 225 */     this.sAtts.profile = new ClientProfile(paramProperties);
/*     */ 
/* 229 */     establishConnection(paramString);
/*     */ 
/* 236 */     Object localObject3 = null;
/*     */ 
/* 239 */     if (this.ACTIVATE_ANO_NIO)
/*     */     {
/*     */       try
/*     */       {
/* 243 */         localObject3 = Class.forName("oracle.net.ano.Ano").newInstance();
/* 244 */         this.sAtts.anoEnabled = true;
/*     */       }
/*     */       catch (Exception localException1)
/*     */       {
/* 250 */         this.sAtts.anoEnabled = false;
/*     */       }
/*     */ 
/* 254 */       if (localObject3 != null)
/*     */       {
/* 256 */         ((Ano)localObject3).init(this.sAtts);
/* 257 */         this.sAtts.ano = ((Ano)localObject3);
/* 258 */         this.sAtts.anoEnabled = true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 263 */     negotiateConnection(localNVFactory, localNVNavigator, bool1, bool2);
/*     */ 
/* 270 */     this.sAtts.connected = true;
/*     */ 
/* 275 */     this.sAtts.nt.setReadTimeoutIfRequired(paramProperties);
/*     */ 
/* 280 */     String str3 = (String)this.sAtts.nt.getOption(6);
/*     */ 
/* 283 */     if ((str3 != null) && (str3.equalsIgnoreCase("false"))) {
/* 284 */       throw new NetException(405);
/*     */     }
/*     */ 
/* 288 */     if ((this.ACTIVATE_ANO_NIO) && (!this.sAtts.noAnoServices))
/*     */     {
/* 291 */       if (this.sAtts.ano != null) {
/* 292 */         this.sAtts.ano.negotiation(this.addrRes.connection_redirected);
/*     */ 
/* 295 */         String str4 = (String)this.sAtts.nt.getOption(2);
/*     */ 
/* 298 */         if ((str4 != null) && (str4.equals("TRUE")))
/*     */         {
/*     */           try
/*     */           {
/* 303 */             Method localMethod = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", (Class[])null);
/*     */ 
/* 305 */             if (localMethod.invoke(this.sAtts.ano, (Object[])null) != null) {
/* 306 */               throw new NetException(406);
/*     */             }
/*     */           }
/*     */           catch (Exception localException2)
/*     */           {
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 317 */     this.addrRes.connection_redirected = false;
/*     */   }
/*     */ 
/*     */   abstract void negotiateConnection(NVFactory paramNVFactory, NVNavigator paramNVNavigator, boolean paramBoolean1, boolean paramBoolean2)
/*     */     throws IOException, NetException;
/*     */ 
/*     */   public void sendBreak()
/*     */     throws IOException, NetException
/*     */   {
/* 350 */     if ((this.sAtts.negotiatedOptions & 0x400) == 1024)
/*     */     {
/* 353 */       this.sAtts.nt.sendUrgentByte(33);
/* 354 */       if ((this.sAtts.negotiatedOptions & 0x800) != 2048)
/*     */       {
/* 356 */         sendMarker(1);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 361 */       sendMarker(1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void sendInterrupt()
/*     */     throws IOException, NetException
/*     */   {
/* 382 */     if ((this.sAtts.negotiatedOptions & 0x400) == 1024)
/*     */     {
/* 385 */       this.sAtts.nt.sendUrgentByte(33);
/* 386 */       if ((this.sAtts.negotiatedOptions & 0x800) != 2048)
/*     */       {
/* 388 */         sendMarker(3);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 393 */       sendMarker(3);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void sendMarker(int paramInt)
/*     */     throws IOException, NetException;
/*     */ 
/*     */   public void setOption(int paramInt, Object paramObject)
/*     */     throws NetException, IOException
/*     */   {
/* 413 */     if ((paramInt > 0) && (paramInt < 10))
/*     */     {
/* 416 */       NTAdapter localNTAdapter = this.sAtts.getNTAdapter();
/* 417 */       localNTAdapter.setOption(paramInt, paramObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getOption(int paramInt)
/*     */     throws NetException, IOException
/*     */   {
/* 430 */     if ((paramInt > 0) && (paramInt < 10))
/*     */     {
/* 433 */       NTAdapter localNTAdapter = this.sAtts.getNTAdapter();
/* 434 */       return localNTAdapter.getOption(paramInt);
/*     */     }
/* 436 */     return null;
/*     */   }
/*     */ 
/*     */   public void abort()
/*     */     throws NetException, IOException
/*     */   {
/* 449 */     NTAdapter localNTAdapter = this.sAtts.getNTAdapter();
/* 450 */     if (localNTAdapter != null)
/* 451 */       localNTAdapter.abort();
/*     */   }
/*     */ 
/*     */   public String getEncryptionName()
/*     */   {
/* 457 */     String str = null;
/* 458 */     NTAdapter localNTAdapter = this.sAtts.getNTAdapter();
/*     */     try
/*     */     {
/* 462 */       str = (String)localNTAdapter.getOption(5);
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/* 468 */     if ((str == null) && (this.sAtts.ano != null))
/*     */     {
/* 470 */       str = this.sAtts.ano.getEncryptionName();
/*     */     }
/*     */ 
/* 473 */     if (str == null)
/* 474 */       str = "";
/* 475 */     return str;
/*     */   }
/*     */ 
/*     */   public String getDataIntegrityName()
/*     */   {
/* 480 */     String str = "";
/* 481 */     if (this.sAtts.ano != null)
/*     */     {
/* 483 */       str = this.sAtts.ano.getDataIntegrityName();
/*     */     }
/* 485 */     return str;
/*     */   }
/*     */ 
/*     */   public String getAuthenticationAdaptorName()
/*     */   {
/* 490 */     String str = "";
/* 491 */     if (this.sAtts.ano != null)
/*     */     {
/* 493 */       str = this.sAtts.ano.getAuthenticationAdaptorName();
/*     */     }
/* 495 */     return str;
/*     */   }
/*     */ 
/*     */   public void reconnectIfRequired(boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/* 507 */     long l1 = System.currentTimeMillis();
/* 508 */     long l2 = l1 - this.sAtts.timestampLastIO;
/*     */ 
/* 510 */     if (l2 > this.sAtts.timeout)
/* 511 */       reconnect(paramBoolean);
/*     */   }
/*     */ 
/*     */   public void setO3logSessionKey(byte[] paramArrayOfByte)
/*     */     throws NetException
/*     */   {
/* 526 */     if ((paramArrayOfByte != null) && (this.ACTIVATE_ANO_NIO))
/*     */     {
/* 528 */       this.sAtts.ano.setO3logSessionKey(paramArrayOfByte);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void reconnect(boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/*     */     try
/*     */     {
/* 543 */       String str = new String(this.sAtts.reconnectAddress);
/* 544 */       this.sAtts.attemptingReconnect = true;
/* 545 */       ConnOption localConnOption = this.sAtts.cOption;
/* 546 */       this.addrRes.connection_redirected = true;
/*     */ 
/* 548 */       this.sAtts.cOption.nt.disconnect();
/*     */ 
/* 550 */       establishConnection(str);
/*     */ 
/* 557 */       this.sAtts.cOption.restoreFromOrigCoption(localConnOption);
/*     */ 
/* 564 */       if (paramBoolean)
/*     */       {
/* 566 */         sendProbePacket();
/*     */       }
/*     */     } finally {
/* 569 */       this.sAtts.attemptingReconnect = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   SessionAtts establishConnection(String paramString)
/*     */     throws NetException, IOException
/*     */   {
/* 594 */     this.sAtts.cOption = this.addrRes.resolveAndExecute(paramString);
/*     */ 
/* 600 */     if (this.sAtts.cOption == null)
/* 601 */       return null;
/* 602 */     this.sAtts.nt = this.sAtts.cOption.nt;
/*     */ 
/* 607 */     this.sAtts.setTDU(this.sAtts.cOption.tdu);
/*     */ 
/* 610 */     this.sAtts.setSDU(this.sAtts.cOption.sdu);
/*     */ 
/* 612 */     initializeSessionAttributes();
/*     */ 
/* 616 */     return this.sAtts;
/*     */   }
/*     */ 
/*     */   abstract void initializeSessionAttributes()
/*     */     throws NetException, IOException;
/*     */ 
/*     */   abstract void sendProbePacket()
/*     */     throws IOException;
/*     */ 
/*     */   public boolean isConnectionSocketKeepAlive()
/*     */     throws SocketException
/*     */   {
/* 640 */     return this.addrRes.isConnectionSocketKeepAlive();
/*     */   }
/*     */ 
/*     */   public int getSocketReadTimeout()
/*     */     throws NetException, IOException
/*     */   {
/* 650 */     String str = (String)getOption(3);
/* 651 */     int i = (str == null) || ("".equals(str)) ? 0 : Integer.parseInt(str);
/* 652 */     return i;
/*     */   }
/*     */ 
/*     */   public void setSocketReadTimeout(int paramInt)
/*     */     throws NetException, IOException
/*     */   {
/* 662 */     String str = Integer.toString(paramInt);
/* 663 */     setOption(3, str);
/*     */   }
/*     */ 
/*     */   public String getConnectionString()
/*     */   {
/* 668 */     return this.addrRes.getTNSAddress();
/*     */   }
/*     */ 
/*     */   public int getNegotiatedSDU()
/*     */     throws NetException
/*     */   {
/* 678 */     if (!this.sAtts.connected)
/* 679 */       throw new NetException(200);
/* 680 */     return this.sAtts.negotiatedSDU;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NSProtocol
 * JD-Core Version:    0.6.2
 */