/*    */ package oracle.net.ns;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.nio.ByteBuffer;
/*    */ import java.nio.charset.Charset;
/*    */ 
/*    */ final class NIORefusePacket extends NIOPacket
/*    */ {
/*    */   int userReason;
/*    */   int systemReason;
/*    */   String refuseData;
/*    */ 
/*    */   NIORefusePacket(NIOHeader paramNIOHeader, SessionAtts paramSessionAtts)
/*    */     throws IOException
/*    */   {
/* 52 */     super(paramNIOHeader, paramSessionAtts);
/*    */   }
/*    */ 
/*    */   void readPayloadBuffer()
/*    */     throws IOException, NetException
/*    */   {
/* 58 */     this.userReason = this.session.payloadBuffer.get();
/* 59 */     this.systemReason = this.session.payloadBuffer.get();
/* 60 */     int i = this.session.payloadBuffer.getShort();
/*    */ 
/* 62 */     if (i > 0)
/*    */     {
/* 64 */       byte[] arrayOfByte = null;
/* 65 */       if (this.session.payloadBuffer.limit() > this.session.payloadBuffer.position())
/*    */       {
/* 67 */         arrayOfByte = new byte[i];
/*    */ 
/* 69 */         this.session.payloadBuffer.get(arrayOfByte);
/*    */       }
/*    */       else
/*    */       {
/* 75 */         arrayOfByte = this.session.dataChannel.readPayloadDataFromSocketChannel(i);
/*    */       }
/* 77 */       this.refuseData = new String(arrayOfByte, Charset.forName("US-ASCII"));
/*    */     }
/*    */     else {
/* 80 */       this.refuseData = "";
/*    */     }
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIORefusePacket
 * JD-Core Version:    0.6.2
 */