/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.channels.SocketChannel;
/*     */ 
/*     */ abstract class NIOPacket
/*     */ {
/*     */   final NIOHeader header;
/*     */   public SessionAtts session;
/*     */ 
/*     */   NIOPacket(SessionAtts paramSessionAtts)
/*     */   {
/*  48 */     this.session = paramSessionAtts;
/*  49 */     this.header = new NIOHeader(paramSessionAtts);
/*     */   }
/*     */ 
/*     */   NIOPacket(NIOHeader paramNIOHeader, SessionAtts paramSessionAtts)
/*     */     throws IOException
/*     */   {
/*  60 */     this.header = paramNIOHeader;
/*  61 */     this.session = paramSessionAtts;
/*     */   }
/*     */ 
/*     */   abstract void readPayloadBuffer()
/*     */     throws IOException;
/*     */ 
/*     */   final void readFromSocketChannel(boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/*  78 */     readFromSocketChannel(paramBoolean, true);
/*     */   }
/*     */ 
/*     */   final void readFromSocketChannel(boolean paramBoolean1, boolean paramBoolean2)
/*     */     throws IOException
/*     */   {
/*  91 */     if (paramBoolean1)
/*  92 */       this.header.readHeaderBuffer();
/*  93 */     this.session.payloadBuffer.clear();
/*     */ 
/*  95 */     this.session.payloadBuffer.limit(this.header.length - 8);
/*  96 */     while (this.session.payloadBuffer.hasRemaining()) {
/*  97 */       this.session.socketChannel.read(this.session.payloadBuffer);
/*     */     }
/*  99 */     this.session.payloadBuffer.rewind();
/*     */ 
/* 103 */     if ((paramBoolean2) && (this.header.type == 12))
/*     */     {
/* 105 */       this.session.markerPacket.readPayloadBuffer();
/* 106 */       processMarker();
/* 107 */       this.session.onBreakReset = this.session.markerPacket.isBreakPkt();
/* 108 */       throw new BreakNetException(500);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processMarker()
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/*     */   }
/*     */ 
/*     */   final void writeToSocketChannel()
/*     */     throws IOException
/*     */   {
/* 129 */     this.header.length = (this.session.payloadBuffer.position() + 8);
/* 130 */     this.header.fillHeaderBuffer();
/* 131 */     this.session.buffer.clear();
/* 132 */     this.session.buffer.limit(this.session.payloadBuffer.position() + 8);
/*     */ 
/* 134 */     while (this.session.buffer.hasRemaining()) {
/* 135 */       this.session.socketChannel.write(this.session.buffer);
/*     */     }
/* 137 */     this.session.payloadBuffer.clear();
/*     */   }
/*     */ 
/*     */   static NIOPacket readNIOPacket(SessionAtts paramSessionAtts)
/*     */     throws IOException
/*     */   {
/* 149 */     Object localObject = null;
/* 150 */     NIOHeader localNIOHeader = new NIOHeader(paramSessionAtts);
/* 151 */     localNIOHeader.readHeaderBuffer();
/*     */ 
/* 153 */     switch (localNIOHeader.type)
/*     */     {
/*     */     case 2:
/* 156 */       localObject = new NIOAcceptPacket(localNIOHeader, paramSessionAtts);
/* 157 */       break;
/*     */     case 5:
/* 159 */       localObject = new NIORedirectPacket(localNIOHeader, paramSessionAtts);
/* 160 */       break;
/*     */     case 4:
/* 162 */       localObject = new NIORefusePacket(localNIOHeader, paramSessionAtts);
/* 163 */       break;
/*     */     case 11:
/* 165 */       localObject = new NIOResendPacket(localNIOHeader, paramSessionAtts);
/* 166 */       break;
/*     */     case 12:
/* 168 */       localObject = new NIOMarkerPacket(localNIOHeader, paramSessionAtts);
/*     */     case 3:
/*     */     case 6:
/*     */     case 7:
/*     */     case 8:
/*     */     case 9:
/* 171 */     case 10: } ((NIOPacket)localObject).readFromSocketChannel(false);
/* 172 */     ((NIOPacket)localObject).readPayloadBuffer();
/* 173 */     return localObject;
/*     */   }
/*     */ 
/*     */   void reinitialize(SessionAtts paramSessionAtts)
/*     */     throws NetException
/*     */   {
/* 183 */     this.session = paramSessionAtts;
/*     */   }
/*     */ 
/*     */   void addFlags(int paramInt)
/*     */     throws NetException
/*     */   {
/* 192 */     this.header.flags |= paramInt;
/*     */   }
/*     */ 
/*     */   void setPoolEnabled(boolean paramBoolean)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 204 */     if (paramBoolean)
/* 205 */       addFlags(1);
/*     */   }
/*     */ 
/*     */   void setLargeSDU(boolean paramBoolean)
/*     */     throws IOException, NetException, BreakNetException
/*     */   {
/* 217 */     if (paramBoolean)
/* 218 */       addFlags(32);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIOPacket
 * JD-Core Version:    0.6.2
 */