/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ 
/*     */ public class NIONSDataChannel extends NIOPacket
/*     */ {
/*     */   int sessionIdSize;
/*     */ 
/*     */   public NIONSDataChannel(SessionAtts paramSessionAtts)
/*     */   {
/*  40 */     super(paramSessionAtts);
/*  41 */     this.header.type = 6;
/*  42 */     this.sessionIdSize = (paramSessionAtts.poolEnabled ? 16 : 0);
/*     */   }
/*     */ 
/*     */   public void readDataFromSocketChannel()
/*     */     throws IOException
/*     */   {
/*  59 */     this.session.payloadDataBuffer.position(this.session.payloadDataBuffer.limit());
/*     */ 
/*  62 */     readFromSocketChannel(true);
/*     */ 
/*  64 */     this.session.payloadDataBuffer.clear();
/*  65 */     this.session.payloadDataBuffer.limit(this.session.payloadBuffer.limit() - 2);
/*     */   }
/*     */ 
/*     */   public void writeDataToSocketChannel()
/*     */     throws IOException
/*     */   {
/*  77 */     writeDataToSocketChannel(0);
/*     */   }
/*     */ 
/*     */   public void writeDataToSocketChannel(int paramInt)
/*     */     throws IOException
/*     */   {
/*  89 */     if (this.session.payloadDataBuffer.position() > 0)
/*     */     {
/*  91 */       this.session.payloadBuffer.clear();
/*  92 */       this.session.payloadBuffer.position(this.session.payloadDataBuffer.position() + 2);
/*  93 */       this.session.payloadBuffer.put(0, (byte)(paramInt / 256));
/*  94 */       this.session.payloadBuffer.put(1, (byte)(paramInt % 256));
/*  95 */       writeToSocketChannel();
/*     */     }
/*     */ 
/*  99 */     this.session.payloadDataBuffer.clear();
/*     */   }
/*     */ 
/*     */   public ByteBuffer getDataBuffer()
/*     */   {
/* 109 */     return this.session.payloadDataBuffer;
/*     */   }
/*     */ 
/*     */   byte[] readPayloadDataFromSocketChannel(int paramInt)
/*     */     throws IOException
/*     */   {
/* 123 */     byte[] arrayOfByte = new byte[paramInt];
/* 124 */     int i = 0;
/* 125 */     int j = 0;
/* 126 */     while (i < paramInt)
/*     */     {
/* 128 */       readDataFromSocketChannel();
/* 129 */       j = this.session.payloadDataBuffer.limit();
/* 130 */       this.session.payloadDataBuffer.get(arrayOfByte, i, j);
/* 131 */       i += j;
/*     */     }
/* 133 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   void writeDataToSocketChannel(byte[] paramArrayOfByte)
/*     */     throws IOException
/*     */   {
/* 144 */     int i = 0;
/* 145 */     int j = 0;
/* 146 */     int k = 0;
/* 147 */     while (i < paramArrayOfByte.length)
/*     */     {
/* 149 */       j = this.session.payloadDataBuffer.limit() - this.session.payloadDataBuffer.position();
/* 150 */       if (j > paramArrayOfByte.length - i)
/* 151 */         j = paramArrayOfByte.length - i;
/* 152 */       k = paramArrayOfByte.length > j ? 32 : 0;
/* 153 */       this.session.payloadDataBuffer.put(paramArrayOfByte, i, j);
/* 154 */       writeDataToSocketChannel(k);
/* 155 */       i += j;
/*     */     }
/*     */   }
/*     */ 
/*     */   void readPayloadBuffer() throws IOException {
/* 160 */     throw new UnsupportedOperationException("Data Byte buffers are not duplicated and accessed directly by the upper layer");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIONSDataChannel
 * JD-Core Version:    0.6.2
 */