/*    */ package oracle.net.ns;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.nio.ByteBuffer;
/*    */ import java.nio.channels.SocketChannel;
/*    */ 
/*    */ final class NIOHeader
/*    */ {
/*    */   int length;
/*    */   int packetChecksum;
/*    */   int flags;
/*    */   int headerChecksum;
/*    */   int type;
/*    */   final SessionAtts session;
/*    */ 
/*    */   NIOHeader(SessionAtts paramSessionAtts)
/*    */   {
/* 51 */     this.session = paramSessionAtts;
/*    */   }
/*    */ 
/*    */   final void readHeaderBuffer()
/*    */     throws IOException
/*    */   {
/* 61 */     this.session.headerBuffer.clear();
/* 62 */     while (this.session.headerBuffer.hasRemaining()) {
/* 63 */       this.session.socketChannel.read(this.session.headerBuffer);
/*    */     }
/* 65 */     this.session.headerBuffer.rewind();
/*    */ 
/* 67 */     if ((this.session.isLargeSDU) && ((this.type == 6) || (this.type == 12))) {
/* 68 */       this.length = (this.session.headerBuffer.getInt() & 0xFFFFFFFF);
/*    */     }
/*    */     else {
/* 71 */       this.length = (this.session.headerBuffer.getShort() & 0xFFFF);
/* 72 */       this.packetChecksum = (this.session.headerBuffer.getShort() & 0xFFFF);
/*    */     }
/* 74 */     this.type = (this.session.headerBuffer.get() & 0xFF);
/* 75 */     this.flags = (this.session.headerBuffer.get() & 0xFF);
/* 76 */     this.headerChecksum = (this.session.headerBuffer.getShort() & 0xFFFF);
/*    */   }
/*    */ 
/*    */   final void fillHeaderBuffer()
/*    */     throws IOException
/*    */   {
/* 85 */     this.session.headerBuffer.clear();
/*    */ 
/* 87 */     if (((this.session.isLargeSDU) && ((this.type == 6) || (this.type == 12))) || (this.type == 15)) {
/* 88 */       this.session.headerBuffer.putInt(this.length);
/*    */     }
/*    */     else {
/* 91 */       this.session.headerBuffer.putShort((short)this.length);
/* 92 */       this.session.headerBuffer.putShort((short)0);
/*    */     }
/* 94 */     this.session.headerBuffer.put((byte)this.type);
/* 95 */     this.session.headerBuffer.put((byte)this.flags);
/* 96 */     this.session.headerBuffer.putShort((short)0);
/*    */   }
/*    */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIOHeader
 * JD-Core Version:    0.6.2
 */