/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.ByteOrder;
/*     */ import java.nio.channels.SocketChannel;
/*     */ 
/*     */ public final class NIODataDescriptorPacket extends NIOPacket
/*     */   implements SQLnetDef
/*     */ {
/*     */   int totalDataLength;
/*     */   int descriptorFLaG;
/*  41 */   int[] sdd = new int[26];
/*     */ 
/*  45 */   boolean useLongDescriptor = false;
/*     */ 
/*  47 */   private static final byte[] STANDARD_SDD_MAX_DD = { 0, 72, 0, 0, 15, 0, 0, 0, 0, 0, 0, 2, 0, 25, -1, -26, 0, 0, 0, 26, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };
/*     */ 
/* 161 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   NIODataDescriptorPacket(SessionAtts paramSessionAtts)
/*     */   {
/*  68 */     super(paramSessionAtts);
/*  69 */     this.header.type = 15;
/*     */   }
/*     */ 
/*     */   void readPayloadBuffer()
/*     */     throws IOException
/*     */   {
/*  76 */     ByteOrder localByteOrder = this.session.buffer.order();
/*  77 */     this.session.buffer.order(ByteOrder.BIG_ENDIAN);
/*  78 */     this.descriptorFLaG = this.session.payloadBuffer.getInt();
/*  79 */     if ((this.descriptorFLaG & 0x2) != 0)
/*  80 */       this.useLongDescriptor = false;
/*     */     else {
/*  82 */       this.useLongDescriptor = true;
/*     */     }
/*     */ 
/*  85 */     this.totalDataLength = this.session.payloadBuffer.getInt();
/*     */ 
/*  88 */     this.session.buffer.order(localByteOrder);
/*     */   }
/*     */ 
/*     */   final void writeToSocketChannel(int paramInt, boolean paramBoolean)
/*     */     throws IOException
/*     */   {
/* 116 */     if ((paramInt == 1703910) && (!paramBoolean))
/*     */     {
/* 121 */       this.session.buffer.clear();
/* 122 */       this.session.buffer.put(STANDARD_SDD_MAX_DD, 0, STANDARD_SDD_MAX_DD.length);
/* 123 */       this.session.buffer.rewind();
/* 124 */     }while (this.session.buffer.hasRemaining()) {
/* 125 */       this.session.socketChannel.write(this.session.buffer); continue;
/*     */ 
/* 130 */       this.useLongDescriptor = false;
/* 131 */       this.descriptorFLaG = 2;
/* 132 */       if (paramBoolean) {
/* 133 */         this.descriptorFLaG |= 1;
/*     */       }
/* 135 */       int i = 0;
/* 136 */       int j = paramInt;
/* 137 */       while (j > 0)
/*     */       {
/* 139 */         if (j > 65535)
/* 140 */           this.sdd[i] = 65535;
/*     */         else
/* 142 */           this.sdd[i] = j;
/* 143 */         j -= this.sdd[i];
/* 144 */         i++;
/*     */       }
/* 146 */       this.session.payloadBuffer.clear();
/* 147 */       this.session.payloadBuffer.putInt(this.descriptorFLaG);
/* 148 */       this.session.payloadBuffer.putInt(paramInt);
/* 149 */       this.session.payloadBuffer.putInt(i);
/* 150 */       for (int k = 0; k < i; k++)
/* 151 */         this.session.payloadBuffer.putShort((short)this.sdd[k]);
/* 152 */       for (k = i; k < 26; k++) {
/* 153 */         this.session.payloadBuffer.putShort((short)0);
/*     */       }
/* 155 */       writeToSocketChannel();
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIODataDescriptorPacket
 * JD-Core Version:    0.6.2
 */