/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.ByteOrder;
/*     */ 
/*     */ final class NIOConnectPacket extends NIOPacket
/*     */ {
/*     */   static final int ntCharacteristics = 20376;
/*     */ 
/*     */   NIOConnectPacket(SessionAtts paramSessionAtts)
/*     */   {
/*  64 */     super(paramSessionAtts);
/*     */   }
/*     */ 
/*     */   final void writeToSocketChannel(String paramString, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, int paramInt1, int paramInt2, int paramInt3)
/*     */     throws IOException
/*     */   {
/*  90 */     if (paramInt1 < 512)
/*  91 */       paramInt1 = 512;
/*  92 */     if (paramInt2 < 255)
/*  93 */       paramInt2 = 255;
/*  94 */     if (paramInt1 > 2097152)
/*  95 */       paramInt1 = 2097152;
/*  96 */     if (paramInt2 > 2097152)
/*  97 */       paramInt2 = 2097152;
/*  98 */     if (paramInt2 < paramInt1) {
/*  99 */       paramInt2 = paramInt1;
/*     */     }
/*     */ 
/* 102 */     int i = paramString == null ? 0 : paramString.length();
/*     */ 
/* 105 */     int j = i <= 230 ? 0 : 1;
/*     */ 
/* 111 */     this.session.payloadBuffer.clear();
/* 112 */     this.session.payloadBuffer.order(ByteOrder.BIG_ENDIAN);
/*     */ 
/* 116 */     this.session.payloadBuffer.putShort((short)315);
/* 117 */     this.session.payloadBuffer.putShort((short)300);
/*     */ 
/* 119 */     int k = 0;
/* 120 */     if ((paramBoolean1) && (paramBoolean3))
/* 121 */       k = 3585;
/* 122 */     if (paramBoolean2)
/* 123 */       k |= 64;
/* 124 */     this.session.payloadBuffer.putShort((short)k);
/* 125 */     if (paramInt1 < 65535) {
/* 126 */       this.session.payloadBuffer.putShort((short)paramInt1);
/*     */     }
/*     */     else {
/* 129 */       this.session.payloadBuffer.putShort((short)-1);
/*     */     }
/* 131 */     if (paramInt2 < 65535) {
/* 132 */       this.session.payloadBuffer.putShort((short)paramInt2);
/*     */     }
/*     */     else {
/* 135 */       this.session.payloadBuffer.putShort((short)-1);
/*     */     }
/* 137 */     this.session.payloadBuffer.putShort((short)20376);
/* 138 */     this.session.payloadBuffer.putShort((short)0);
/* 139 */     this.session.payloadBuffer.putShort((short)1);
/* 140 */     this.session.payloadBuffer.putShort((short)i);
/* 141 */     this.session.payloadBuffer.putShort((short)70);
/* 142 */     this.session.payloadBuffer.putInt(0);
/* 143 */     this.session.payloadBuffer.putShort((short)paramInt3);
/*     */ 
/* 147 */     this.session.payloadBuffer.position(42);
/* 148 */     this.session.payloadBuffer.putShort((short)0);
/* 149 */     this.session.payloadBuffer.putShort((short)0);
/* 150 */     this.session.payloadBuffer.putShort((short)0);
/* 151 */     this.session.payloadBuffer.putShort((short)0);
/*     */ 
/* 154 */     this.session.payloadBuffer.putInt(paramInt1);
/* 155 */     this.session.payloadBuffer.putInt(paramInt2);
/*     */ 
/* 157 */     this.session.payloadBuffer.position(62);
/*     */ 
/* 159 */     if ((j == 0) && (i > 0)) {
/* 160 */       this.session.payloadBuffer.put(paramString.getBytes());
/*     */     }
/* 162 */     this.header.type = 1;
/* 163 */     this.header.flags = (this.session.redirecting ? 2 : 0);
/*     */ 
/* 166 */     this.session.redirecting = false;
/* 167 */     writeToSocketChannel();
/*     */ 
/* 169 */     if (j != 0)
/*     */     {
/* 171 */       byte[] arrayOfByte = paramString.getBytes();
/* 172 */       this.session.dataChannel.writeDataToSocketChannel(arrayOfByte);
/*     */     }
/*     */   }
/*     */ 
/*     */   void readPayloadBuffer()
/*     */     throws IOException
/*     */   {
/* 180 */     throw new UnsupportedOperationException("Attempting to read from a one way packet sent by client");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIOConnectPacket
 * JD-Core Version:    0.6.2
 */