/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.nio.ByteBuffer;
/*     */ import java.nio.charset.Charset;
/*     */ 
/*     */ final class NIOAcceptPacket extends NIOPacket
/*     */ {
/*     */   protected int version;
/*     */   protected int options;
/*     */   protected int sduSize;
/*     */   protected int tduSize;
/*     */   protected int myHWByteOrder;
/*     */   protected int flag0;
/*     */   protected int flag1;
/*     */   String connectData;
/*     */ 
/*     */   NIOAcceptPacket(NIOHeader paramNIOHeader, SessionAtts paramSessionAtts)
/*     */     throws IOException
/*     */   {
/*  63 */     super(paramNIOHeader, paramSessionAtts);
/*     */   }
/*     */ 
/*     */   void readPayloadBuffer()
/*     */     throws IOException, NetException
/*     */   {
/*  69 */     int i = 0;
/*  70 */     int j = 0;
/*  71 */     this.version = this.session.payloadBuffer.getShort();
/*  72 */     this.options = this.session.payloadBuffer.getShort();
/*  73 */     this.sduSize = (this.session.payloadBuffer.getShort() & 0xFFFF);
/*     */ 
/*  75 */     this.tduSize = (this.session.payloadBuffer.getShort() & 0xFFFF);
/*     */ 
/*  77 */     this.myHWByteOrder = this.session.payloadBuffer.getShort();
/*  78 */     int k = this.session.payloadBuffer.getShort();
/*  79 */     int m = this.session.payloadBuffer.getShort();
/*  80 */     this.flag0 = this.session.payloadBuffer.get();
/*  81 */     this.flag1 = this.session.payloadBuffer.get();
/*     */ 
/*  83 */     this.session.timeout = this.session.payloadBuffer.getShort();
/*  84 */     this.session.tick = this.session.payloadBuffer.getShort();
/*     */ 
/*  86 */     i = this.session.payloadBuffer.getShort();
/*  87 */     j = this.session.payloadBuffer.getShort();
/*     */ 
/*  96 */     this.session.timeout -= this.session.tick;
/*  97 */     this.session.timeout *= 10;
/*     */ 
/*  99 */     if (i > 0)
/*     */     {
/* 101 */       this.session.reconnectAddress = new byte[i];
/* 102 */       this.session.payloadBuffer.position(j - 8);
/* 103 */       this.session.payloadBuffer.get(this.session.reconnectAddress, 0, i);
/*     */     }
/*     */ 
/* 107 */     if (this.version >= 315) {
/* 108 */       this.sduSize = this.session.payloadBuffer.getInt(24);
/* 109 */       this.tduSize = this.session.payloadBuffer.getInt(28);
/* 110 */       this.session.isLargeSDU = true;
/* 111 */       this.session.dataChannel.setLargeSDU(true);
/* 112 */       this.session.markerPacket.setLargeSDU(true);
/*     */     }
/*     */ 
/* 115 */     if (this.session.timeout > 0)
/*     */     {
/* 118 */       int n = k + m - 8;
/* 119 */       this.session.poolEnabled = true;
/* 120 */       this.session.sessionId = new byte[16];
/* 121 */       this.session.payloadBuffer.position(n);
/* 122 */       this.session.payloadBuffer.get(this.session.sessionId, 0, 16);
/* 123 */       this.session.dataChannel.setPoolEnabled(true);
/* 124 */       this.session.timestampLastIO = System.currentTimeMillis();
/*     */     }
/*     */ 
/* 127 */     if (k > 0)
/*     */     {
/* 129 */       byte[] arrayOfByte = null;
/* 130 */       if (this.session.payloadBuffer.hasRemaining())
/*     */       {
/* 132 */         arrayOfByte = new byte[k];
/*     */ 
/* 134 */         this.session.payloadBuffer.position(m);
/* 135 */         this.session.payloadBuffer.get(arrayOfByte);
/*     */       }
/*     */       else
/*     */       {
/* 141 */         arrayOfByte = this.session.dataChannel.readPayloadDataFromSocketChannel(k);
/*     */       }
/* 143 */       this.connectData = new String(arrayOfByte, Charset.forName("US-ASCII"));
/*     */     }
/*     */ 
/* 147 */     if (this.tduSize < this.sduSize)
/* 148 */       this.session.setNegotiatedSDUAndTDU(this.tduSize, this.tduSize);
/*     */     else {
/* 150 */       this.session.setNegotiatedSDUAndTDU(this.sduSize, this.tduSize);
/*     */     }
/* 152 */     this.session.setNegotiatedOptions(this.options);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.NIOAcceptPacket
 * JD-Core Version:    0.6.2
 */