/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import java.net.SocketException;
/*     */ 
/*     */ public class DataPacket extends Packet
/*     */   implements SQLnetDef
/*     */ {
/*     */   static final boolean DEBUG2 = false;
/*     */   protected int pktOffset;
/*     */   protected int dataFlags;
/*  59 */   protected boolean isBufferFull = false;
/*  60 */   protected boolean isBufferEmpty = false;
/*  61 */   protected int availableBytesToSend = 0;
/*  62 */   protected int availableBytesToRead = 0;
/*  63 */   protected int sessionIdSize = 0;
/*     */ 
/* 411 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public DataPacket(SessionAtts paramSessionAtts, int paramInt)
/*     */   {
/*  70 */     super(paramSessionAtts, paramInt, 6, (paramSessionAtts.poolEnabled ? 1 : 0) | (paramSessionAtts.isLargeSDU ? 32 : 0));
/*     */ 
/*  74 */     initialize(paramInt);
/*     */   }
/*     */ 
/*     */   public DataPacket(SessionAtts paramSessionAtts)
/*     */   {
/*  87 */     this(paramSessionAtts, paramSessionAtts.getSDU());
/*     */   }
/*     */ 
/*     */   protected void receive()
/*     */     throws IOException, NetException
/*     */   {
/* 105 */     super.receive();
/*     */ 
/* 107 */     this.dataOff = (this.pktOffset = 10);
/* 108 */     this.dataLen = (this.length - this.dataOff - (this.sAtts.poolEnabled ? 16 : 0));
/* 109 */     this.dataFlags = (this.buffer[8] & 0xFF);
/* 110 */     this.dataFlags <<= 8;
/* 111 */     this.dataFlags |= this.buffer[9] & 0xFF;
/*     */ 
/* 115 */     if ((this.type == 6) && ((this.dataFlags & 0x40) != 0)) {
/* 116 */       this.sAtts.dataEOF = true;
/*     */     }
/*     */ 
/* 119 */     if ((this.type == 6) && (0 == this.dataLen))
/*     */     {
/* 121 */       this.type = 7;
/*     */     }
/*     */ 
/* 125 */     if (this.sAtts.poolEnabled)
/* 126 */       this.sAtts.timestampLastIO = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   protected void send()
/*     */     throws IOException
/*     */   {
/* 136 */     send(0);
/*     */   }
/*     */ 
/*     */   protected void send(int paramInt)
/*     */     throws IOException
/*     */   {
/* 146 */     this.buffer[8] = ((byte)(paramInt / 256));
/* 147 */     this.buffer[9] = ((byte)(paramInt % 256));
/*     */ 
/* 151 */     setBufferLength(this.pktOffset);
/*     */ 
/* 153 */     synchronized (this.sAtts.ntOutputStream)
/*     */     {
/* 157 */       if (this.sAtts.poolEnabled)
/*     */       {
/* 160 */         int j = 20;
/*     */         int i;
/*     */         do
/*     */         {
/* 164 */           i = 0;
/*     */           try
/*     */           {
/* 169 */             this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
/*     */           }
/*     */           catch (SocketException localSocketException)
/*     */           {
/* 185 */             if (localSocketException.getMessage().startsWith("Connection reset")) { j--; if (j > 0)
/*     */               {
/* 188 */                 if (!this.sAtts.attemptingReconnect)
/*     */                 {
/* 194 */                   this.sAtts.ns.reconnectIfRequired(false);
/*     */                 }
/*     */ 
/* 197 */                 i = 1; continue;
/*     */               }
/*     */             }
/*     */ 
/* 201 */             throw localSocketException;
/*     */           }
/*     */         }
/* 204 */         while (i != 0);
/*     */       }
/*     */       else
/*     */       {
/* 209 */         this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 214 */     this.pktOffset = 10;
/* 215 */     this.availableBytesToSend = 0;
/* 216 */     this.isBufferFull = false;
/* 217 */     if (this.sAtts.poolEnabled)
/* 218 */       this.sAtts.timestampLastIO = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   protected int putDataInBuffer(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws IOException
/*     */   {
/* 229 */     int i = this.buffer.length - this.sessionIdSize - this.pktOffset <= paramInt2 ? this.buffer.length - this.sessionIdSize - this.pktOffset : paramInt2;
/*     */ 
/* 248 */     if (i > 0)
/*     */     {
/* 250 */       System.arraycopy(paramArrayOfByte, paramInt1, this.buffer, this.pktOffset, i);
/* 251 */       this.pktOffset += i;
/*     */ 
/* 253 */       this.isBufferFull = (this.pktOffset == this.buffer.length - this.sessionIdSize);
/*     */ 
/* 255 */       this.availableBytesToSend = (this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0);
/*     */     }
/*     */ 
/* 270 */     return i;
/*     */   }
/*     */ 
/*     */   public long readLongLSB(int paramInt)
/*     */     throws BreakNetException, NetException, IOException
/*     */   {
/* 278 */     long l = 0L;
/*     */ 
/* 280 */     int i = paramInt; for (int j = 0; i > 0; this.availableBytesToRead -= 1) {
/* 281 */       l |= (this.buffer[this.pktOffset] & 0xFF) << 8 * j;
/*     */ 
/* 280 */       i--; j++; this.pktOffset += 1;
/*     */     }
/*     */ 
/* 283 */     return l;
/*     */   }
/*     */ 
/*     */   public long readLongMSB(int paramInt)
/*     */     throws BreakNetException, NetException, IOException
/*     */   {
/* 290 */     long l = 0L;
/*     */ 
/* 292 */     for (int i = paramInt; i > 0; this.availableBytesToRead -= 1) {
/* 293 */       l |= (this.buffer[this.pktOffset] & 0xFF) << 8 * (i - 1);
/*     */ 
/* 292 */       i--; this.pktOffset += 1;
/*     */     }
/*     */ 
/* 295 */     return l;
/*     */   }
/*     */ 
/*     */   protected int getDataFromBuffer(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws NetException
/*     */   {
/* 305 */     int i = this.availableBytesToRead <= paramInt2 ? this.availableBytesToRead : paramInt2;
/*     */ 
/* 322 */     if (i > 0)
/*     */     {
/* 324 */       System.arraycopy(this.buffer, this.pktOffset, paramArrayOfByte, paramInt1, i);
/* 325 */       this.pktOffset += i;
/*     */ 
/* 327 */       this.isBufferEmpty = (this.pktOffset == this.length);
/*     */ 
/* 329 */       this.availableBytesToRead -= i;
/*     */     }
/*     */ 
/* 343 */     return i;
/*     */   }
/*     */ 
/*     */   protected void setBufferLength(int paramInt)
/*     */     throws NetException
/*     */   {
/* 371 */     if (this.sAtts.poolEnabled)
/*     */     {
/* 379 */       System.arraycopy(this.sAtts.sessionId, 0, this.buffer, this.pktOffset, 16);
/*     */ 
/* 381 */       paramInt += 16;
/* 382 */       this.pktOffset += 16;
/*     */     }
/*     */ 
/* 388 */     if (this.sAtts.isLargeSDU) {
/* 389 */       this.buffer[3] = ((byte)(paramInt & 0xFF));
/* 390 */       this.buffer[2] = ((byte)(paramInt >> 8 & 0xFF));
/* 391 */       this.buffer[1] = ((byte)(paramInt >> 16 & 0xFF));
/* 392 */       this.buffer[0] = ((byte)(paramInt >> 24 & 0xFF));
/*     */     }
/*     */     else {
/* 395 */       this.buffer[0] = ((byte)(paramInt / 256));
/* 396 */       this.buffer[1] = ((byte)(paramInt % 256));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initialize(int paramInt)
/*     */   {
/* 404 */     this.dataOff = (this.pktOffset = 10);
/* 405 */     this.dataLen = (paramInt - this.dataOff);
/* 406 */     this.dataFlags = 0;
/* 407 */     this.sessionIdSize = (this.sAtts.poolEnabled ? 16 : 0);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.DataPacket
 * JD-Core Version:    0.6.2
 */