/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import oracle.net.nt.ConnOption;
/*     */ import oracle.net.nt.NTAdapter;
/*     */ 
/*     */ public class ConnectPacket extends Packet
/*     */   implements SQLnetDef
/*     */ {
/*     */   private boolean connDataOflow;
/*     */   private byte[] connBytes;
/*     */ 
/*     */   public ConnectPacket(SessionAtts paramSessionAtts, boolean paramBoolean1, boolean paramBoolean2)
/*     */     throws IOException
/*     */   {
/*  71 */     super(paramSessionAtts);
/*     */ 
/*  74 */     this.data = paramSessionAtts.cOption.conn_data.toString();
/*     */ 
/*  76 */     if (this.data != null)
/*     */     {
/*  78 */       this.connBytes = this.data.getBytes();
/*  79 */       this.dataLen = this.connBytes.length;
/*     */     }
/*     */     else
/*     */     {
/*  83 */       this.connBytes = null;
/*  84 */       this.dataLen = 0;
/*     */     }
/*     */ 
/*  88 */     this.connDataOflow = (this.dataLen > 230);
/*     */ 
/* 110 */     int i = !this.connDataOflow ? 70 + this.dataLen : 70;
/*     */ 
/* 113 */     createBuffer(i, 1, paramSessionAtts.redirecting ? 2 : 0);
/*     */ 
/* 116 */     paramSessionAtts.redirecting = false;
/*     */ 
/* 119 */     this.buffer[8] = 1;
/*     */ 
/* 123 */     this.buffer[9] = 59;
/* 124 */     this.buffer[10] = 1;
/* 125 */     this.buffer[11] = 44;
/*     */ 
/* 127 */     int j = 1;
/*     */ 
/* 129 */     if ((paramBoolean1) && (paramSessionAtts.nt.isCharacteristicUrgentSupported()))
/*     */     {
/* 131 */       j |= 3072;
/*     */     }
/*     */ 
/* 144 */     if (paramBoolean2) {
/* 145 */       j |= 64;
/*     */     }
/* 147 */     this.buffer[12] = ((byte)(j >> 8 & 0xFF));
/* 148 */     this.buffer[13] = ((byte)(j & 0xFF));
/* 149 */     if (this.sdu < 65535) {
/* 150 */       this.buffer[14] = ((byte)(this.sdu / 256));
/* 151 */       this.buffer[15] = ((byte)(this.sdu % 256));
/*     */     }
/*     */     else {
/* 154 */       this.buffer[14] = -1;
/* 155 */       this.buffer[15] = -1;
/*     */     }
/* 157 */     if (this.tdu < 65535) {
/* 158 */       this.buffer[16] = ((byte)(this.tdu / 256));
/* 159 */       this.buffer[17] = ((byte)(this.tdu % 256));
/*     */     }
/*     */     else {
/* 162 */       this.buffer[16] = -1;
/* 163 */       this.buffer[17] = -1;
/*     */     }
/*     */ 
/* 167 */     this.buffer[18] = 79;
/* 168 */     this.buffer[19] = -104;
/*     */ 
/* 170 */     this.buffer[22] = 0;
/* 171 */     this.buffer[23] = 1;
/* 172 */     this.buffer[24] = ((byte)(this.dataLen / 256));
/* 173 */     this.buffer[25] = ((byte)(this.dataLen % 256));
/* 174 */     this.buffer[27] = 70;
/*     */ 
/* 176 */     if (!paramSessionAtts.anoEnabled)
/*     */     {
/*     */       int tmp441_440 = 4; this.buffer[33] = tmp441_440; this.buffer[32] = tmp441_440;
/*     */     }
/*     */     else
/*     */     {
/*     */       byte tmp464_463 = ((byte)paramSessionAtts.getANOFlags()); this.buffer[33] = tmp464_463; this.buffer[32] = tmp464_463;
/*     */     }
/*     */     byte[] tmp473_468 = this.buffer; tmp473_468[32] = ((byte)(tmp473_468[32] | 0x80));
/*     */     byte[] tmp487_482 = this.buffer; tmp487_482[33] = ((byte)(tmp487_482[33] | 0x80));
/*     */ 
/* 194 */     setUb2ToBytes(this.buffer, 50, 0);
/* 195 */     setUb2ToBytes(this.buffer, 52, 0);
/* 196 */     setUb2ToBytes(this.buffer, 54, 0);
/* 197 */     setUb2ToBytes(this.buffer, 56, 0);
/*     */ 
/* 200 */     this.buffer[61] = ((byte)(this.sdu & 0xFF));
/* 201 */     this.buffer[60] = ((byte)(this.sdu >> 8 & 0xFF));
/* 202 */     this.buffer[59] = ((byte)(this.sdu >> 16 & 0xFF));
/* 203 */     this.buffer[58] = ((byte)(this.sdu >> 24 & 0xFF));
/* 204 */     this.buffer[65] = ((byte)(this.tdu & 0xFF));
/* 205 */     this.buffer[64] = ((byte)(this.tdu >> 8 & 0xFF));
/* 206 */     this.buffer[63] = ((byte)(this.tdu >> 16 & 0xFF));
/* 207 */     this.buffer[62] = ((byte)(this.tdu >> 24 & 0xFF));
/*     */ 
/* 210 */     if ((!this.connDataOflow) && (this.connBytes != null) && (this.connBytes.length > 0))
/*     */     {
/* 212 */       System.arraycopy(this.connBytes, 0, this.buffer, 70, this.connBytes.length);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void send()
/*     */     throws IOException
/*     */   {
/* 241 */     super.send();
/*     */ 
/* 247 */     if (this.connDataOflow)
/*     */     {
/* 249 */       byte[] arrayOfByte = new byte[this.connBytes.length];
/*     */ 
/* 258 */       System.arraycopy(this.connBytes, 0, arrayOfByte, 0, this.connBytes.length);
/*     */ 
/* 260 */       this.sAtts.nsOutputStream.write(arrayOfByte);
/* 261 */       this.sAtts.nsOutputStream.flush();
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.ConnectPacket
 * JD-Core Version:    0.6.2
 */