package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Properties;

public abstract interface Communication
{
  public abstract void connect(String paramString, Properties paramProperties)
    throws IOException, NetException;

  public abstract SessionAtts getSessionAttributes();

  public abstract void disconnect()
    throws IOException, NetException;

  public abstract void sendBreak()
    throws IOException, NetException;

  public abstract void sendInterrupt()
    throws IOException, NetException;

  public abstract void sendReset()
    throws IOException, NetException;

  public abstract NetInputStream getNetInputStream()
    throws NetException, IOException;

  public abstract InputStream getInputStream()
    throws NetException, IOException;

  public abstract NetOutputStream getNetOutputStream()
    throws NetException, IOException;

  public abstract OutputStream getOutputStream()
    throws NetException, IOException;

  public abstract void setO3logSessionKey(byte[] paramArrayOfByte)
    throws NetException, NetException;

  public abstract void setOption(int paramInt, Object paramObject)
    throws NetException, IOException;

  public abstract Object getOption(int paramInt)
    throws NetException, IOException;

  public abstract void abort()
    throws NetException, IOException;

  public abstract String getEncryptionName();

  public abstract String getDataIntegrityName();

  public abstract String getAuthenticationAdaptorName();

  public abstract boolean readZeroCopyIO(byte[] paramArrayOfByte, int paramInt, int[] paramArrayOfInt)
    throws IOException;

  public abstract void writeZeroCopyIO(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException;

  public abstract boolean isConnectionSocketKeepAlive()
    throws SocketException;

  public abstract int getSocketReadTimeout()
    throws NetException, IOException;

  public abstract void setSocketReadTimeout(int paramInt)
    throws NetException, IOException;

  public abstract String getConnectionString();

  public abstract int getNegotiatedSDU()
    throws NetException;
}

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.Communication
 * JD-Core Version:    0.6.2
 */