/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class ClientProfile extends Properties
/*     */ {
/*     */   private static final String profile_name = "ora-net-profile";
/*     */   private static final String shared_profile_name = "ora-shared-profile";
/*     */ 
/*     */   public ClientProfile()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClientProfile(Properties paramProperties)
/*     */   {
/*  79 */     if (paramProperties.containsKey("oracle.net.profile"))
/*     */     {
/*  81 */       put("oracle.net.profile", paramProperties.getProperty("oracle.net.profile"));
/*     */     }
/*     */ 
/*  87 */     put("oracle.net.authentication_services", paramProperties.getProperty("oracle.net.authentication_services", "()"));
/*     */ 
/*  90 */     put("oracle.net.encryption_client", paramProperties.getProperty("oracle.net.encryption_client", "ACCEPTED"));
/*     */ 
/*  93 */     put("oracle.net.encryption_types_client", paramProperties.getProperty("oracle.net.encryption_types_client", "()"));
/*     */ 
/*  96 */     put("oracle.net.crypto_checksum_client", paramProperties.getProperty("oracle.net.crypto_checksum_client", "ACCEPTED"));
/*     */ 
/*  99 */     put("oracle.net.crypto_checksum_types_client", paramProperties.getProperty("oracle.net.crypto_checksum_types_client", "()"));
/*     */ 
/* 102 */     put("oracle.net.crypto_seed", paramProperties.getProperty("oracle.net.crypto_seed", ""));
/*     */ 
/* 106 */     put("oracle.net.kerberos5_mutual_authentication", paramProperties.getProperty("oracle.net.kerberos5_mutual_authentication", "false"));
/*     */ 
/* 109 */     if (paramProperties.getProperty("oracle.net.kerberos5_cc_name") != null)
/* 110 */       put("oracle.net.kerberos5_cc_name", paramProperties.getProperty("oracle.net.kerberos5_cc_name"));
/*     */   }
/*     */ 
/*     */   public String[] getAuthenticationServices()
/*     */   {
/* 125 */     return getServices((String)get("oracle.net.authentication_services"));
/*     */   }
/*     */ 
/*     */   public String[] getEncryptionServices()
/*     */   {
/* 130 */     return getServices((String)get("oracle.net.encryption_types_client"));
/*     */   }
/*     */ 
/*     */   public String[] getDataIntegrityServices()
/*     */   {
/* 135 */     return getServices((String)get("oracle.net.crypto_checksum_types_client"));
/*     */   }
/*     */ 
/*     */   public String getEncryptionLevel()
/*     */   {
/* 140 */     return (String)get("oracle.net.encryption_client");
/*     */   }
/*     */ 
/*     */   public int getEncryptionLevelNum()
/*     */   {
/* 147 */     return translateAnoValue(getEncryptionLevel());
/*     */   }
/*     */ 
/*     */   public String getDataIntegrityLevel()
/*     */   {
/* 152 */     return (String)get("oracle.net.crypto_checksum_client");
/*     */   }
/*     */ 
/*     */   public int getDataIntegrityLevelNum()
/*     */   {
/* 157 */     return translateAnoValue(getDataIntegrityLevel());
/*     */   }
/*     */ 
/*     */   public void print()
/*     */   {
/* 165 */     System.out.println(" ----------------------------------------");
/* 166 */     System.out.println(" Displaying the content of ClientProfile ");
/* 167 */     System.out.println(" List:");
/* 168 */     list(System.out);
/* 169 */     Enumeration localEnumeration = propertyNames();
/* 170 */     System.out.println("Enumeration has elements ? " + localEnumeration.hasMoreElements());
/* 171 */     for (int i = 0; localEnumeration.hasMoreElements(); i++)
/*     */     {
/* 173 */       String str = (String)localEnumeration.nextElement();
/* 174 */       System.out.println("Key " + i + " = " + str);
/* 175 */       System.out.println("Value = " + getProperty(str));
/*     */     }
/* 177 */     System.out.println(" ----------------------------------------");
/*     */   }
/*     */ 
/*     */   private String[] getServices(String paramString)
/*     */   {
/* 190 */     String str = removeParenths(paramString);
/* 191 */     StringTokenizer localStringTokenizer = new StringTokenizer(str, ",");
/* 192 */     int i = localStringTokenizer.countTokens();
/* 193 */     String[] arrayOfString = new String[i];
/* 194 */     for (int j = 0; j < i; j++) {
/* 195 */       arrayOfString[j] = localStringTokenizer.nextToken().trim();
/*     */     }
/* 197 */     return arrayOfString;
/*     */   }
/*     */ 
/*     */   private String removeParenths(String paramString)
/*     */   {
/* 203 */     int i = paramString.indexOf(40);
/* 204 */     int j = i == -1 ? 0 : i + 1;
/* 205 */     int k = paramString.lastIndexOf(41);
/* 206 */     int m = k == -1 ? paramString.length() : k;
/*     */ 
/* 208 */     String str = paramString.substring(j, m);
/*     */ 
/* 210 */     return str.trim();
/*     */   }
/*     */ 
/*     */   private int translateAnoValue(String paramString)
/*     */   {
/* 215 */     int i = 0;
/* 216 */     if (paramString.equalsIgnoreCase("ACCEPTED"))
/* 217 */       i = 0;
/* 218 */     else if (paramString.equalsIgnoreCase("REQUESTED"))
/* 219 */       i = 2;
/* 220 */     else if (paramString.equalsIgnoreCase("REQUIRED"))
/* 221 */       i = 3;
/* 222 */     else if (paramString.equalsIgnoreCase("REJECTED"))
/* 223 */       i = 1;
/* 224 */     return i;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.ClientProfile
 * JD-Core Version:    0.6.2
 */