/*     */ package oracle.net.ns;
/*     */ 
/*     */ import java.io.IOException;
/*     */ 
/*     */ public class AcceptPacket extends Packet
/*     */   implements SQLnetDef
/*     */ {
/*     */   protected int version;
/*     */   protected int options;
/*     */   protected int sduSize;
/*     */   protected int tduSize;
/*     */   protected int myHWByteOrder;
/*     */   protected int flag0;
/*     */   protected int flag1;
/*     */ 
/*     */   public AcceptPacket(Packet paramPacket)
/*     */     throws IOException, NetException
/*     */   {
/*  71 */     super(paramPacket);
/*     */ 
/*  74 */     this.version = (this.buffer[8] & 0xFF);
/*  75 */     this.version <<= 8;
/*  76 */     this.version |= this.buffer[9] & 0xFF;
/*     */ 
/*  78 */     this.options = (this.buffer[10] & 0xFF);
/*  79 */     this.options <<= 8;
/*  80 */     this.options |= this.buffer[11] & 0xFF;
/*     */ 
/*  82 */     this.sduSize = (this.buffer[12] & 0xFF);
/*  83 */     this.sduSize <<= 8;
/*  84 */     this.sduSize |= this.buffer[13] & 0xFF;
/*     */ 
/*  86 */     this.tduSize = (this.buffer[14] & 0xFF);
/*  87 */     this.tduSize <<= 8;
/*  88 */     this.tduSize |= this.buffer[15] & 0xFF;
/*     */ 
/*  90 */     this.myHWByteOrder = (this.buffer[16] & 0xFF);
/*  91 */     this.myHWByteOrder <<= 8;
/*  92 */     this.myHWByteOrder |= this.buffer[17] & 0xFF;
/*     */ 
/*  94 */     this.dataLen = (this.buffer[18] & 0xFF);
/*  95 */     this.dataLen <<= 8;
/*  96 */     this.dataLen |= this.buffer[19] & 0xFF;
/*     */ 
/*  98 */     this.dataOff = (this.buffer[20] & 0xFF);
/*  99 */     this.dataOff <<= 8;
/* 100 */     this.dataOff |= this.buffer[21] & 0xFF;
/*     */ 
/* 102 */     this.flag0 = this.buffer[22];
/* 103 */     this.flag1 = this.buffer[23];
/* 104 */     this.sAtts.noAnoServices = ((this.flag1 & 0x8) == 8);
/* 105 */     if (!this.sAtts.noAnoServices) {
/* 106 */       this.sAtts.noAnoServices = ((this.flag0 & 0x4) == 4);
/*     */     }
/* 108 */     this.sAtts.timeout = toUb2(this.buffer, 24);
/*     */ 
/* 110 */     this.sAtts.tick = toUb2(this.buffer, 26);
/* 111 */     this.sAtts.timeout -= this.sAtts.tick;
/* 112 */     this.sAtts.timeout *= 10;
/*     */ 
/* 114 */     int i = toUb2(this.buffer, 28);
/* 115 */     int j = toUb2(this.buffer, 30);
/* 116 */     if (i > 0)
/*     */     {
/* 118 */       this.sAtts.reconnectAddress = new byte[i];
/* 119 */       System.arraycopy(this.buffer, j, this.sAtts.reconnectAddress, 0, i);
/*     */     }
/*     */ 
/* 124 */     if (this.version >= 315) {
/* 125 */       this.sduSize = toUb4(this.buffer, 32);
/* 126 */       this.tduSize = toUb4(this.buffer, 36);
/* 127 */       this.sAtts.isLargeSDU = true;
/*     */     }
/*     */ 
/* 130 */     if (this.sAtts.timeout > 0)
/*     */     {
/* 133 */       int k = this.dataLen + this.dataOff;
/* 134 */       this.sAtts.poolEnabled = true;
/* 135 */       this.sAtts.sessionId = new byte[16];
/* 136 */       System.arraycopy(this.buffer, k, this.sAtts.sessionId, 0, 16);
/* 137 */       this.sAtts.nsInputStream.poolEnabled(true);
/* 138 */       this.sAtts.nsOutputStream.poolEnabled(true);
/* 139 */       this.sAtts.timestampLastIO = System.currentTimeMillis();
/*     */     }
/*     */ 
/* 142 */     extractData();
/*     */ 
/* 146 */     this.sAtts.setSDU(this.sduSize);
/* 147 */     this.sAtts.setTDU(this.tduSize);
/*     */ 
/* 150 */     this.sAtts.negotiatedSDU = this.sdu;
/*     */ 
/* 152 */     if (this.tduSize < this.sduSize) {
/* 153 */       this.sAtts.setSDU(this.tduSize);
/*     */     }
/* 155 */     this.sAtts.setNegotiatedOptions(this.options);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 162 */     return new StringBuilder().append("version=").append(this.version).append(", options=").append(this.options).append(", sduSize=").append(this.sduSize).append(", tduSize=").append(this.tduSize).append("\nmyHWByteOrder=").append(this.myHWByteOrder).append(", dataLen=").append(this.dataLen).append(", flag0=").append(this.flag0).append(", flag1=").append(this.flag1).append("\n").append(this.sAtts.poolEnabled ? new StringBuilder().append("timeout=").append(this.sAtts.timeout).append(",re-connect: ").append(this.sAtts.reconnectAddress).append("\n(byte)Dumping session-id:\n").append(dumpBytes(this.sAtts.sessionId, 0, 16)).toString() : "").append("\n\n").toString();
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.ns.AcceptPacket
 * JD-Core Version:    0.6.2
 */