/*     */ package oracle.net.jndi;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import java.util.Vector;
/*     */ import javax.naming.NamingEnumeration;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.directory.Attribute;
/*     */ import javax.naming.directory.Attributes;
/*     */ import javax.naming.directory.DirContext;
/*     */ import javax.naming.directory.InitialDirContext;
/*     */ import oracle.net.ns.NetException;
/*     */ 
/*     */ public class JndiAttrs
/*     */ {
/*     */   private Properties env;
/*     */   private static final String nFactory = "java.naming.factory.initial";
/*     */   private static final String nProvider = "java.naming.provider.url";
/*     */   private static final String nProfile = "ora-net-profile";
/*     */   private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
/*     */   private static final String ldap_read_timeout = "com.sun.jndi.ldap.read.timeout";
/*     */   private static final String ldap_connect_timeout = "com.sun.jndi.ldap.connect.timeout";
/*     */   DirContext ctx;
/*     */ 
/*     */   public JndiAttrs(Properties paramProperties)
/*     */     throws NetException
/*     */   {
/*  73 */     String str = null;
/*     */ 
/*  75 */     this.env = new Properties();
/*     */ 
/*  77 */     if (paramProperties.containsKey("java.naming.factory.initial"))
/*  78 */       this.env.put("java.naming.factory.initial", paramProperties.getProperty("java.naming.factory.initial"));
/*     */     else {
/*  80 */       this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
/*     */     }
/*  82 */     if (paramProperties.containsKey("java.naming.provider.url"))
/*     */     {
/*  84 */       str = paramProperties.getProperty("java.naming.provider.url");
/*     */ 
/*  88 */       if (str.startsWith("ldaps"))
/*     */       {
/*  90 */         this.env.put("java.naming.ldap.factory.socket", "oracle.net.jndi.CustomSSLSocketFactory");
/*     */ 
/*  92 */         this.env.put("java.naming.security.protocol", "ssl");
/*  93 */         str = "ldap:" + str.substring(6);
/*     */       }
/*  95 */       this.env.put("java.naming.provider.url", str);
/*     */     }
/*     */ 
/*  98 */     if (paramProperties.containsKey("oracle.net.profile"))
/*  99 */       this.env.put("ora-net-profile", paramProperties.getProperty("oracle.net.profile"));
/*     */     try
/*     */     {
/* 102 */       Class localClass1 = Class.forName("javax.naming.directory.InitialDirContext");
/*     */ 
/* 106 */       if (this.env.get("java.naming.factory.initial") == null)
/*     */       {
/* 108 */         this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
/*     */       }
/*     */ 
/* 111 */       if (this.env.get("java.naming.provider.url") == null)
/* 112 */         this.env.put("java.naming.provider.url", str);
/*     */     }
/*     */     catch (Exception localException1)
/*     */     {
/* 116 */       throw new NetException(110, localException1.toString());
/*     */     }
/*     */ 
/* 122 */     if (paramProperties.containsKey("com.sun.jndi.ldap.connect.timeout"))
/* 123 */       this.env.put("com.sun.jndi.ldap.connect.timeout", paramProperties.getProperty("com.sun.jndi.ldap.connect.timeout"));
/* 124 */     if (paramProperties.containsKey("com.sun.jndi.ldap.read.timeout"))
/* 125 */       this.env.put("com.sun.jndi.ldap.read.timeout", paramProperties.getProperty("com.sun.jndi.ldap.read.timeout"));
/*     */     Object localObject;
/* 135 */     if ((localObject = paramProperties.get("java.naming.security.authentication")) != null)
/*     */     {
/* 137 */       this.env.put("java.naming.security.authentication", localObject);
/*     */     }
/*     */ 
/* 140 */     if ((localObject = paramProperties.get("java.naming.security.principal")) != null)
/*     */     {
/* 142 */       this.env.put("java.naming.security.principal", localObject);
/*     */     }
/*     */ 
/* 145 */     if ((localObject = paramProperties.get("java.naming.security.credentials")) != null)
/*     */     {
/* 147 */       this.env.put("java.naming.security.credentials", localObject);
/*     */     }
/*     */ 
/* 150 */     for (int i = 0; i < 3; i++)
/*     */       try
/*     */       {
/* 153 */         this.ctx = new InitialDirContext(this.env);
/*     */       }
/*     */       catch (NamingException localNamingException)
/*     */       {
/* 157 */         Class localClass2 = null;
/*     */         try {
/* 159 */           localClass2 = Class.forName("javax.net.ssl.SSLException");
/*     */         }
/*     */         catch (Exception localException2)
/*     */         {
/* 163 */           throw new NetException(108, localNamingException.toString());
/*     */         }
/*     */ 
/* 166 */         if ((!localClass2.isInstance(localNamingException.getRootCause())) || (i >= 3))
/*     */         {
/* 169 */           throw new NetException(108, localNamingException.toString());
/*     */         }
/*     */       }
/*     */   }
/*     */ 
/*     */   public Vector getProfileAttrs(String paramString)
/*     */     throws NetException
/*     */   {
/* 185 */     String str = "cn=";
/* 186 */     Attributes localAttributes = null;
/*     */     try {
/* 188 */       str = str.concat(paramString);
/* 189 */       localAttributes = this.ctx.getAttributes(str);
/*     */     } catch (NamingException localNamingException) {
/* 191 */       throw new NetException(108, localNamingException.toString());
/*     */     }
/*     */ 
/* 195 */     return setAttrs(localAttributes);
/*     */   }
/*     */ 
/*     */   public Vector getAttrs(String paramString, String[] paramArrayOfString)
/*     */     throws NetException
/*     */   {
/* 208 */     String str = "cn=";
/* 209 */     Attributes localAttributes = null;
/*     */     try {
/* 211 */       if (!paramString.startsWith(str))
/* 212 */         str = str.concat(paramString);
/*     */       else
/* 214 */         str = paramString;
/* 215 */       localAttributes = this.ctx.getAttributes(str, paramArrayOfString);
/*     */     }
/*     */     catch (NamingException localNamingException) {
/* 218 */       throw new NetException(108, localNamingException.toString());
/*     */     }
/*     */ 
/* 222 */     return setAttrs(localAttributes);
/*     */   }
/*     */ 
/*     */   private Vector setAttrs(Attributes paramAttributes)
/*     */     throws NetException
/*     */   {
/* 231 */     Vector localVector = new Vector(1, 1);
/*     */ 
/* 233 */     if (paramAttributes == null) {
/* 234 */       System.out.println("No attributes");
/*     */     }
/*     */     else {
/*     */       try
/*     */       {
/* 239 */         NamingEnumeration localNamingEnumeration1 = paramAttributes.getAll();
/* 240 */         while ((localNamingEnumeration1 != null) && (localNamingEnumeration1.hasMoreElements())) {
/* 241 */           Attribute localAttribute = (Attribute)localNamingEnumeration1.next();
/*     */ 
/* 243 */           NamingEnumeration localNamingEnumeration2 = localAttribute.getAll();
/* 244 */           while (localNamingEnumeration2.hasMoreElements())
/* 245 */             localVector.addElement(localNamingEnumeration2.nextElement());
/*     */         }
/*     */       }
/*     */       catch (NamingException localNamingException) {
/* 249 */         throw new NetException(108, localNamingException.toString());
/*     */       }
/*     */     }
/*     */ 
/* 253 */     return localVector;
/*     */   }
/*     */ 
/*     */   public void setEnv(String paramString1, String paramString2)
/*     */   {
/* 262 */     this.env.put(paramString1, paramString2);
/*     */   }
/*     */ 
/*     */   public void close()
/*     */     throws NetException
/*     */   {
/*     */     try
/*     */     {
/* 272 */       if (null != this.ctx)
/* 273 */         this.ctx.close();
/*     */     }
/*     */     catch (NamingException localNamingException) {
/* 276 */       throw new NetException(108, localNamingException.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public final String getLdapUrlUsed()
/*     */     throws NetException
/*     */   {
/* 287 */     String str = null;
/*     */     try
/*     */     {
/* 290 */       str = (String)this.ctx.getEnvironment().get("java.naming.provider.url");
/*     */     }
/*     */     catch (NamingException localNamingException)
/*     */     {
/* 294 */       throw new NetException(108, localNamingException.toString());
/*     */     }
/*     */ 
/* 297 */     return str;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.jndi.JndiAttrs
 * JD-Core Version:    0.6.2
 */