package oracle.net.jdbc.nl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NLParamParser
{
  private String filename;
  private Hashtable ht;
  private Vector linebuffer;
  private int filePermissions = 0;
  private int Commentcnt = 0;
  private int nvStringcnt = 0;
  private int Groupcnt = 0;
  private boolean hasComments = false;
  private boolean hasGroups = false;
  private String[] errstr;
  private int errstrcnt;
  public static final byte IGNORE_NONE = 0;
  public static final byte IGNORE_NL_EXCEPTION = 1;
  public static final byte IGNORE_FILE_EXCEPTION = 2;
  public static final byte NLPASUCC = 1;
  public static final byte NLPAOVWR = 2;
  public static final byte NLPAFAIL = -1;
  private static boolean DEBUG = false;

  public static NLParamParser createEmptyParamParser()
  {
    return new NLParamParser();
  }

  private NLParamParser()
  {
    this.filename = null;
    this.ht = new Hashtable(128);
  }

  public NLParamParser(String paramString)
    throws IOException, NLException
  {
    this(paramString, (byte)2);
  }

  public NLParamParser(String paramString, byte paramByte)
    throws NLException, IOException
  {
    this.filename = paramString;
    this.ht = new Hashtable(128);
    FileReader localFileReader = null;
    BufferedReader localBufferedReader = null;
    try
    {
      localFileReader = new FileReader(paramString);
      localBufferedReader = new BufferedReader(localFileReader);
      initializeNlpa(localBufferedReader, paramByte);
    }
    catch (FileNotFoundException localFileNotFoundException)
    {
      if ((paramByte & 0x2) == 0)
        throw new FileNotFoundException(paramString);
    }
    finally
    {
      if (localFileReader != null)
        localFileReader.close();
      if (localBufferedReader != null)
        localBufferedReader.close();
    }
  }

  public NLParamParser(Reader paramReader)
    throws IOException, NLException
  {
    this(paramReader, (byte)0);
  }

  public NLParamParser(Reader paramReader, byte paramByte)
    throws IOException, NLException
  {
    BufferedReader localBufferedReader = new BufferedReader(paramReader);
    this.filename = null;
    this.ht = new Hashtable(128);
    initializeNlpa(localBufferedReader, paramByte);
  }

  private void initializeNlpa(BufferedReader paramBufferedReader, byte paramByte)
    throws IOException, NLException
  {
    this.linebuffer = new Vector(100, 50);
    this.errstr = new String[50];
    try
    {
      while (true)
      {
        String str1 = paramBufferedReader.readLine();
        if (str1 == null)
          break;
        this.linebuffer.addElement(str1);
      }
    }
    catch (IOException localIOException)
    {
      if ((paramByte & 0x2) == 0)
        throw new IOException("Unable to read a line from : " + this.filename);
    }
    String str2 = "";
    String str4 = System.getProperty("line.separator");
    String str5 = "";
    String str6 = "";
    for (int i = 0; i < this.linebuffer.size(); i++)
    {
      String str3 = (String)this.linebuffer.elementAt(i);
      if (str3.length() != 0)
        if (str3.charAt(0) == '#')
        {
          if ((str3.indexOf(".ORA Configuration ") != -1) || (str3.indexOf(" Network Configuration File: ") != -1) || (str3.indexOf("Generated by") != -1))
          {
            if (DEBUG)
              System.out.println(str3 + ": this comment ignored");
          }
          else if (str5.length() != 0)
          {
            str6 = str6 + str3 + str4;
          }
          else
          {
            str5 = "COMMENT#" + this.Commentcnt;
            str6 = str3 + str4;
            if (!this.hasComments)
              this.hasComments = true;
          }
        }
        else if ((str3.charAt(0) == ' ') || (str3.charAt(0) == '\t') || (str3.charAt(0) == ')'))
        {
          if (str6.length() == 0)
          {
            if (str2.length() == 0)
              str3 = eatNLPWS(str3);
            str3 = checkNLPforComments(str3);
            if (str3.length() != 0)
              str2 = str2 + str3 + str4;
          }
          else if ((str2.length() == 0) && (str6.length() != 0))
          {
            str3 = eatNLPWS(str3);
            str3 = checkNLPforComments(str3);
            if ((str3.length() != 0) && ((paramByte & 0x1) == 0))
              throw new NLException("InvalidChar-04611", "");
          }
          else if ((str2.length() != 0) && (str6.length() != 0))
          {
            str5 = "";
            str6 = "";
            str3 = checkNLPforComments(str3);
            str2 = str2 + str3 + str4;
          }
        }
        else if ((str2.length() == 0) && (str6.length() == 0))
        {
          str3 = checkNLPforComments(str3);
          str2 = str2 + str3 + str4;
        }
        else if ((str2.length() == 0) && (str6.length() != 0))
        {
          str6 = modifyCommentString(str6);
          try
          {
            addNLPListElement(str5 + "=" + str6);
          }
          catch (NLException localNLException3)
          {
            this.errstr[(this.errstrcnt++)] = str2;
            if ((paramByte & 0x1) == 0)
              throw localNLException3;
          }
          str5 = "";
          str6 = "";
          this.Commentcnt += 1;
          str3 = checkNLPforComments(str3);
          str2 = str2 + str3 + str4;
        }
        else if ((str2.length() != 0) && (str6.length() == 0))
        {
          try
          {
            addNLPListElement(str2);
          }
          catch (NLException localNLException4)
          {
            this.errstr[(this.errstrcnt++)] = str2;
            if ((paramByte & 0x1) == 0)
              throw localNLException4;
          }
          str2 = "";
          str3 = checkNLPforComments(str3);
          str2 = str2 + str3 + str4;
        }
        else if ((str2.length() != 0) && (str6.length() != 0))
        {
          try
          {
            addNLPListElement(str2);
          }
          catch (NLException localNLException5)
          {
            this.errstr[(this.errstrcnt++)] = str2;
            if ((paramByte & 0x1) == 0)
              throw localNLException5;
          }
          str2 = "";
          str3 = checkNLPforComments(str3);
          str2 = str2 + str3 + str4;
          str6 = modifyCommentString(str6);
          try
          {
            addNLPListElement(str5 + "=" + str6);
          }
          catch (NLException localNLException6)
          {
            this.errstr[(this.errstrcnt++)] = str2;
            if ((paramByte & 0x1) == 0)
              throw localNLException6;
          }
          str5 = "";
          str6 = "";
          this.Commentcnt += 1;
        }
    }
    if (str2.length() != 0)
    {
      try
      {
        addNLPListElement(str2);
      }
      catch (NLException localNLException1)
      {
        this.errstr[(this.errstrcnt++)] = str2;
        if ((paramByte & 0x1) == 0)
          throw localNLException1;
      }
      str2 = "";
    }
    if (str6.length() != 0)
    {
      str6 = modifyCommentString(str6);
      try
      {
        addNLPListElement(str5 + "=" + str6);
      }
      catch (NLException localNLException2)
      {
        this.errstr[(this.errstrcnt++)] = str2;
        if ((paramByte & 0x1) == 0)
          throw localNLException2;
      }
      str5 = "";
      str6 = "";
      this.Commentcnt += 1;
    }
  }

  private String modifyCommentString(String paramString)
  {
    String str = "";
    int i = 0;
    for (int j = 0; j < paramString.length(); j++)
    {
      int k = paramString.charAt(j);
      switch (k)
      {
      case 40:
        str = str + "\\(";
        break;
      case 61:
        str = str + "\\=";
        break;
      case 41:
        str = str + "\\)";
        break;
      case 44:
        str = str + "\\,";
        break;
      case 92:
        str = str + "\\\\";
        break;
      default:
        str = str + paramString.charAt(j);
      }
    }
    return str;
  }

  private String checkNLPforComments(String paramString)
  {
    StringBuffer localStringBuffer = new StringBuffer(paramString.length());
    int i = 0;
    for (int j = 0; j < paramString.length(); j++)
    {
      char c = paramString.charAt(j);
      if (c == '#')
      {
        if (j != 0)
        {
          if (paramString.charAt(j - 1) != '\\')
            break;
          localStringBuffer.append(c);
        }
        else
        {
          return "";
        }
      }
      else
        localStringBuffer.append(c);
    }
    return localStringBuffer.toString();
  }

  private String eatNLPWS(String paramString)
  {
    StringBuffer localStringBuffer = new StringBuffer(paramString.length());
    int i = 0;
    int j = 0;
    while (j == 0)
    {
      int k = paramString.charAt(i++);
      if ((k != 32) || (k != 9))
      {
        j = 1;
        for (int m = i - 1; paramString.charAt(m) == '\n'; m++)
          localStringBuffer.append(paramString.charAt(m));
      }
      else if (k == 10)
      {
        return "";
      }
    }
    return localStringBuffer.toString();
  }

  public void saveNLParams()
    throws IOException
  {
    if (this.filename == null)
      return;
    FileWriter localFileWriter = null;
    try
    {
      localFileWriter = new FileWriter(this.filename);
      String str = "unknown";
      StringTokenizer localStringTokenizer = new StringTokenizer(this.filename, File.separator);
      while (localStringTokenizer.hasMoreTokens())
        str = localStringTokenizer.nextToken();
      writeToStream(localFileWriter, str, this.filename);
    }
    finally
    {
      if (localFileWriter != null)
        localFileWriter.close();
    }
  }

  public void writeToStream(Writer paramWriter, String paramString1, String paramString2)
  {
    PrintWriter localPrintWriter = null;
    localPrintWriter = new PrintWriter(new BufferedWriter(paramWriter));
    localPrintWriter.println("# " + paramString1 + " Network Configuration File: " + paramString2 + "");
    localPrintWriter.println("# Generated by Oracle configuration tools.");
    localPrintWriter.println("");
    if (this.hasGroups)
      saveNLPGroups(localPrintWriter);
    Enumeration localEnumeration = this.ht.elements();
    while (localEnumeration.hasMoreElements())
    {
      NVPair localNVPair = (NVPair)localEnumeration.nextElement();
      String str2 = localNVPair.toString(0, true);
      if (DEBUG)
        System.out.println("The initial stringified NVPair is:\n" + str2);
      if (!str2.equals(""))
      {
        char[] arrayOfChar = new char[str2.length() - 2];
        str2.getChars(1, str2.length() - 1, arrayOfChar, 0);
        String str1 = new String(arrayOfChar);
        if (DEBUG)
          System.out.println("The modified NV String is:\n" + str1);
        localPrintWriter.println(str1);
        localPrintWriter.println("");
        arrayOfChar = null;
      }
    }
    localPrintWriter.close();
  }

  public void saveNLParams(String paramString)
    throws FileNotFoundException, IOException
  {
    String str = this.filename;
    this.filename = paramString;
    saveNLParams();
    this.filename = str;
  }

  public String getFilename()
  {
    return this.filename;
  }

  public boolean configuredInFile()
  {
    return this.filename != null;
  }

  public int getNLPListSize()
  {
    this.nvStringcnt = 0;
    Enumeration localEnumeration = this.ht.keys();
    while (localEnumeration.hasMoreElements())
    {
      String str = (String)localEnumeration.nextElement();
      if (str.indexOf("COMMENT") == -1)
        this.nvStringcnt += 1;
    }
    return this.nvStringcnt;
  }

  public boolean inErrorList(String paramString)
  {
    boolean bool = false;
    if (DEBUG)
      System.out.println("Entering inErrorList():");
    for (int i = 0; ((!bool) || (i < this.errstrcnt)) && (this.errstrcnt != 0); i++)
      if (this.errstr[i].indexOf(paramString) != -1)
        bool = true;
    return bool;
  }

  public NVPair getNLPListElement(String paramString)
  {
    String str = paramString.toUpperCase();
    return (NVPair)this.ht.get(str);
  }

  public String[] getNLPAllNames()
  {
    int i = getNLPListSize();
    String[] arrayOfString = new String[i];
    int j = 0;
    Enumeration localEnumeration = this.ht.keys();
    while (localEnumeration.hasMoreElements())
    {
      String str = (String)localEnumeration.nextElement();
      if (str.indexOf("COMMENT") == -1)
        arrayOfString[(j++)] = str;
    }
    return arrayOfString;
  }

  public String[] getNLPAllElements()
  {
    int i = getNLPListSize();
    String[] arrayOfString = new String[i];
    int j = 0;
    Enumeration localEnumeration = this.ht.elements();
    while (localEnumeration.hasMoreElements())
    {
      NVPair localNVPair = (NVPair)localEnumeration.nextElement();
      if (localNVPair.getName().indexOf("COMMENT") == -1)
      {
        String str = localNVPair.toString();
        arrayOfString[(j++)] = str;
      }
    }
    return arrayOfString;
  }

  public byte addNLPListElement(String paramString, Object paramObject)
  {
    try
    {
      Object localObject = this.ht.put(paramString, paramObject);
      return localObject != null ? 2 : 1;
    }
    catch (NullPointerException localNullPointerException)
    {
      if (DEBUG)
        System.out.println(localNullPointerException.getMessage());
    }
    return -1;
  }

  public void addNLPGroupProfile(String[] paramArrayOfString)
  {
    String str = new String("GROUP#" + this.Groupcnt++);
    String[] arrayOfString = paramArrayOfString;
    if (!this.hasGroups)
      this.hasGroups = true;
    addNLPListElement(str, arrayOfString);
  }

  private String[] getNLPGroupProfile(String paramString)
  {
    String str = paramString.toUpperCase();
    return (String[])this.ht.get(str);
  }

  private void saveNLPGroups(PrintWriter paramPrintWriter)
  {
    for (int i = 0; i < this.Groupcnt; i++)
    {
      String str1 = new String("GROUP#" + i);
      String[] arrayOfString = getNLPGroupProfile(str1);
      for (int j = 0; j < arrayOfString.length; j++)
      {
        String str2 = null;
        String str3 = null;
        NVPair localNVPair1 = null;
        if (DEBUG)
          System.out.println("Current Value in Group Profile: " + arrayOfString[j]);
        if (arrayOfString[j] != null)
        {
          localNVPair1 = getNLPListElement(arrayOfString[j]);
          if (localNVPair1 != null)
          {
            str2 = localNVPair1.toString(0, true);
            if (DEBUG)
              System.out.println("Parameter Value = " + str2);
            char[] arrayOfChar = new char[str2.length() - 2];
            str2.getChars(1, str2.length() - 1, arrayOfChar, 0);
            str3 = new String(arrayOfChar);
            paramPrintWriter.println(str3);
            paramPrintWriter.println("");
            NVPair localNVPair2 = removeNLPListElement(arrayOfString[j]);
            if ((localNVPair2 == null) && (DEBUG))
              System.out.println("saveNLPGroups(): Could notremove param from Hashtable");
            arrayOfChar = null;
            str3 = null;
          }
          else if (DEBUG)
          {
            System.out.println("No such Parameter in the Table");
          }
        }
      }
      removeNLPGroupProfile(str1);
    }
  }

  public void addNLPListElement(String paramString)
    throws NLException
  {
    char[] arrayOfChar = new char[paramString.length() + 2];
    String str1 = "";
    if (DEBUG)
    {
      System.out.println("Entering Method addNLPListElement\n");
      System.out.println("String to add is: " + paramString + "");
    }
    paramString.getChars(0, paramString.length(), arrayOfChar, 1);
    if (arrayOfChar[1] == '(')
    {
      str1 = paramString;
    }
    else
    {
      arrayOfChar[0] = '(';
      localObject = System.getProperty("os.name");
      if ((((String)localObject).equals("Windows NT")) || (((String)localObject).equals("Windows 95")))
      {
        if ((arrayOfChar[(arrayOfChar.length - 2)] == '/') || (arrayOfChar[(arrayOfChar.length - 2)] == '\\'))
          arrayOfChar[(arrayOfChar.length - 2)] = ')';
        else
          arrayOfChar[(arrayOfChar.length - 1)] = ')';
      }
      else if (arrayOfChar[(arrayOfChar.length - 2)] == '\\')
        arrayOfChar[(arrayOfChar.length - 2)] = ')';
      else
        arrayOfChar[(arrayOfChar.length - 1)] = ')';
      str1 = new String(arrayOfChar);
      if (DEBUG)
        System.out.println("The modified NV String is: " + str1 + "");
    }
    Object localObject = new NVFactory();
    NVPair localNVPair = ((NVFactory)localObject).createNVPair(str1);
    if (localNVPair.getRHSType() == NVPair.RHS_NONE)
      throw new NLException("NullRHS-04612", localNVPair.getName());
    String str2 = localNVPair.getName();
    String str3 = str2.toUpperCase();
    localNVPair.setName(str3);
    if (DEBUG)
      System.out.println("The final NV String is: " + localNVPair.toString() + "");
    int i = addNLPListElement(str3, localNVPair);
    switch (i)
    {
    case 2:
      if (DEBUG)
        System.out.println("The value for the Name: " + str2 + " was overwritten\n");
      break;
    case -1:
      if (DEBUG)
        System.out.println("The value for the Name: " + str2 + " could not be inserted\n");
      break;
    }
  }

  public NVPair removeNLPListElement(String paramString)
  {
    String str = paramString.toUpperCase();
    if (DEBUG)
      System.out.println("Trying to remove: " + str + " from Table");
    Object localObject = this.ht.remove(str);
    return localObject != null ? (NVPair)localObject : null;
  }

  public void removeNLPGroupProfile(String paramString)
  {
    String str = paramString.toUpperCase();
    if (DEBUG)
      System.out.println("Trying to remove: " + str + " GroupName from Table");
    Object localObject = this.ht.remove(str);
  }

  public void removeNLPAllElements()
  {
    this.ht.clear();
  }

  public String toString()
  {
    String str1 = "";
    Enumeration localEnumeration = this.ht.elements();
    while (localEnumeration.hasMoreElements())
    {
      NVPair localNVPair = (NVPair)localEnumeration.nextElement();
      String str2 = localNVPair.toString();
      str1 = str1 + str2 + "\n";
    }
    return str1;
  }

  public boolean fileHasComments()
  {
    return this.hasComments;
  }

  public void println()
  {
    System.out.println(toString());
  }

  public void setFilePermissions(int paramInt)
  {
    this.filePermissions = paramInt;
  }
}

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.net.jdbc.nl.NLParamParser
 * JD-Core Version:    0.6.2
 */