/*     */ package oracle.jpub.runtime;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.ARRAY;
/*     */ import oracle.sql.BFILE;
/*     */ import oracle.sql.BLOB;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CLOB;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.CustomDatum;
/*     */ import oracle.sql.CustomDatumFactory;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.NUMBER;
/*     */ import oracle.sql.OPAQUE;
/*     */ import oracle.sql.ORAData;
/*     */ import oracle.sql.ORADataFactory;
/*     */ import oracle.sql.RAW;
/*     */ import oracle.sql.REF;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ public class Util
/*     */ {
/*  30 */   static short lastCsId = 870;
/*  31 */   static CharacterSet lastCS = CharacterSet.make(870);
/*     */ 
/* 368 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public static Object convertToObject(Datum paramDatum, int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/*  39 */     Object localObject = _convertToObject(paramDatum, paramInt, paramObject);
/*  40 */     return localObject;
/*     */   }
/*     */ 
/*     */   public static Object _convertToObject(Datum paramDatum, int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/*  48 */     if (paramDatum == null) {
/*  49 */       return null;
/*     */     }
/*  51 */     if ((paramDatum instanceof STRUCT))
/*     */     {
/*  53 */       if ((paramObject instanceof ORADataFactory))
/*     */       {
/*  55 */         return ((ORADataFactory)paramObject).create(paramDatum, 2002);
/*     */       }
/*     */ 
/*  59 */       return ((CustomDatumFactory)paramObject).create(paramDatum, 2002);
/*     */     }
/*     */ 
/*  63 */     if ((paramDatum instanceof REF))
/*     */     {
/*  65 */       if ((paramObject instanceof ORADataFactory))
/*     */       {
/*  67 */         return ((ORADataFactory)paramObject).create(paramDatum, 2006);
/*     */       }
/*     */ 
/*  71 */       return ((CustomDatumFactory)paramObject).create(paramDatum, 2006);
/*     */     }
/*     */ 
/*  75 */     if ((paramDatum instanceof ARRAY))
/*     */     {
/*  77 */       if ((paramObject instanceof ORADataFactory))
/*     */       {
/*  79 */         return ((ORADataFactory)paramObject).create(paramDatum, 2003);
/*     */       }
/*     */ 
/*  83 */       return ((CustomDatumFactory)paramObject).create(paramDatum, 2003);
/*     */     }
/*     */ 
/*  87 */     if ((paramDatum instanceof OPAQUE))
/*     */     {
/*  89 */       if ((paramObject instanceof ORADataFactory))
/*     */       {
/*  91 */         return ((ORADataFactory)paramObject).create(paramDatum, 2007);
/*     */       }
/*     */ 
/*  95 */       return ((CustomDatumFactory)paramObject).create(paramDatum, 2007);
/*     */     }
/*     */ 
/*  99 */     if (paramObject != null)
/*     */     {
/* 101 */       if ((paramObject instanceof ORADataFactory))
/*     */       {
/* 103 */         return ((ORADataFactory)paramObject).create(paramDatum, paramInt);
/*     */       }
/*     */ 
/* 107 */       return ((CustomDatumFactory)paramObject).create(paramDatum, paramInt);
/*     */     }
/*     */ 
/* 111 */     if ((paramDatum instanceof NUMBER))
/*     */     {
/* 113 */       if ((paramInt == 2) || (paramInt == 3)) {
/* 114 */         return ((NUMBER)paramDatum).bigDecimalValue();
/*     */       }
/* 116 */       if ((paramInt == 8) || (paramInt == 6)) {
/* 117 */         return Double.valueOf(((NUMBER)paramDatum).doubleValue());
/*     */       }
/* 119 */       if ((paramInt == 4) || (paramInt == 5)) {
/* 120 */         return Integer.valueOf(((NUMBER)paramDatum).intValue());
/*     */       }
/* 122 */       if (paramInt == 7) {
/* 123 */         return Float.valueOf(((NUMBER)paramDatum).floatValue());
/*     */       }
/* 125 */       if (paramInt == 16) {
/* 126 */         return Boolean.valueOf(((NUMBER)paramDatum).booleanValue());
/*     */       }
/*     */ 
/* 129 */       SQLException localSQLException = DatabaseError.createSqlException(null, 48, " type: " + paramInt);
/* 130 */       localSQLException.fillInStackTrace();
/* 131 */       throw localSQLException;
/*     */     }
/*     */ 
/* 135 */     return paramDatum.toJdbc();
/*     */   }
/*     */ 
/*     */   public static Datum convertToOracle(Object paramObject, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 143 */     return convertToOracle(paramObject, paramConnection, false);
/*     */   }
/*     */ 
/*     */   public static Datum convertToOracle(Object paramObject, Connection paramConnection, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 153 */     Datum localDatum = _convertToOracle(paramObject, paramConnection, paramBoolean);
/*     */ 
/* 155 */     return localDatum;
/*     */   }
/*     */ 
/*     */   private static Datum _convertToOracle(Object paramObject, Connection paramConnection, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 164 */     if (paramObject == null) {
/* 165 */       return null;
/*     */     }
/* 167 */     if ((paramObject instanceof ORAData)) {
/* 168 */       return ((ORAData)paramObject).toDatum(paramConnection);
/*     */     }
/* 170 */     if ((paramObject instanceof CustomDatum))
/* 171 */       return ((CustomDatum)paramObject).toDatum((oracle.jdbc.driver.OracleConnection)paramConnection);
/*     */     short s;
/* 173 */     if ((paramObject instanceof String))
/*     */     {
/* 175 */       s = paramBoolean ? ((oracle.jdbc.internal.OracleConnection)paramConnection).getNCharSet() : (paramConnection == null) || (!(paramConnection instanceof oracle.jdbc.internal.OracleConnection)) ? 870 : ((oracle.jdbc.internal.OracleConnection)paramConnection).getDbCsId();
/*     */ 
/* 182 */       if (s != lastCsId)
/*     */       {
/* 184 */         lastCsId = s;
/* 185 */         lastCS = CharacterSet.make(lastCsId);
/*     */       }
/*     */ 
/* 188 */       return new CHAR((String)paramObject, lastCS);
/*     */     }
/*     */ 
/* 191 */     if ((paramObject instanceof Character))
/*     */     {
/* 193 */       s = (paramConnection == null) || (!(paramConnection instanceof oracle.jdbc.internal.OracleConnection)) ? 870 : ((oracle.jdbc.internal.OracleConnection)paramConnection).getDbCsId();
/*     */ 
/* 198 */       if (s != lastCsId)
/*     */       {
/* 200 */         lastCsId = s;
/* 201 */         lastCS = CharacterSet.make(lastCsId);
/*     */       }
/*     */ 
/* 204 */       return new CHAR(((Character)paramObject).toString(), lastCS);
/*     */     }
/*     */ 
/* 207 */     if ((paramObject instanceof BigDecimal)) {
/* 208 */       return new NUMBER((BigDecimal)paramObject);
/*     */     }
/* 210 */     if ((paramObject instanceof BigInteger)) {
/* 211 */       return new NUMBER((BigInteger)paramObject);
/*     */     }
/* 213 */     if ((paramObject instanceof Double)) {
/* 214 */       return new NUMBER(((Double)paramObject).doubleValue());
/*     */     }
/* 216 */     if ((paramObject instanceof Float)) {
/* 217 */       return new NUMBER(((Float)paramObject).floatValue());
/*     */     }
/* 219 */     if ((paramObject instanceof Integer)) {
/* 220 */       return new NUMBER(((Integer)paramObject).intValue());
/*     */     }
/* 222 */     if ((paramObject instanceof Boolean)) {
/* 223 */       return new NUMBER(((Boolean)paramObject).booleanValue());
/*     */     }
/* 225 */     if ((paramObject instanceof Short)) {
/* 226 */       return new NUMBER(((Short)paramObject).shortValue());
/*     */     }
/* 228 */     if ((paramObject instanceof Byte)) {
/* 229 */       return new NUMBER(((Byte)paramObject).byteValue());
/*     */     }
/* 231 */     if ((paramObject instanceof Long)) {
/* 232 */       return new NUMBER(((Long)paramObject).longValue());
/*     */     }
/* 234 */     if ((paramObject instanceof Timestamp)) {
/* 235 */       return new TIMESTAMP((Timestamp)paramObject);
/*     */     }
/* 237 */     if ((paramObject instanceof java.sql.Date)) {
/* 238 */       return new DATE((java.sql.Date)paramObject);
/*     */     }
/* 240 */     if ((paramObject instanceof java.util.Date)) {
/* 241 */       return new DATE(new java.sql.Date(((java.util.Date)paramObject).getTime()));
/*     */     }
/* 243 */     if ((paramObject instanceof byte[])) {
/* 244 */       return new RAW((byte[])paramObject);
/*     */     }
/* 246 */     if ((paramObject instanceof Datum)) {
/* 247 */       return (Datum)paramObject;
/*     */     }
/*     */ 
/* 254 */     SQLException localSQLException = DatabaseError.createSqlException(null, 48);
/* 255 */     localSQLException.fillInStackTrace();
/* 256 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   static boolean isMutable(Datum paramDatum, ORADataFactory paramORADataFactory)
/*     */   {
/* 264 */     if (paramDatum == null) {
/* 265 */       return false;
/*     */     }
/*     */ 
/* 281 */     return ((paramDatum instanceof BFILE)) || ((paramDatum instanceof BLOB)) || ((paramDatum instanceof CLOB)) || ((paramORADataFactory != null) && (((paramDatum instanceof STRUCT)) || ((paramDatum instanceof OPAQUE)) || ((paramDatum instanceof ARRAY))));
/*     */   }
/*     */ 
/*     */   static boolean isMutable(Datum paramDatum, CustomDatumFactory paramCustomDatumFactory)
/*     */   {
/* 294 */     if (paramDatum == null) {
/* 295 */       return false;
/*     */     }
/*     */ 
/* 311 */     return ((paramDatum instanceof BFILE)) || ((paramDatum instanceof BLOB)) || ((paramDatum instanceof CLOB)) || ((paramCustomDatumFactory != null) && (((paramDatum instanceof STRUCT)) || ((paramDatum instanceof OPAQUE)) || ((paramDatum instanceof ARRAY))));
/*     */   }
/*     */ 
/*     */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 332 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jpub.runtime.Util
 * JD-Core Version:    0.6.2
 */