/*     */ package oracle.jpub.runtime;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ import oracle.jdbc.OracleArray;
/*     */ import oracle.jdbc.OracleBfile;
/*     */ import oracle.jdbc.OracleBlob;
/*     */ import oracle.jdbc.OracleClob;
/*     */ import oracle.jdbc.OracleData;
/*     */ import oracle.jdbc.OracleDataFactory;
/*     */ import oracle.jdbc.OracleOpaque;
/*     */ import oracle.jdbc.OracleRef;
/*     */ import oracle.jdbc.OracleStruct;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.CHAR;
/*     */ import oracle.sql.CharacterSet;
/*     */ import oracle.sql.DATE;
/*     */ import oracle.sql.NUMBER;
/*     */ import oracle.sql.RAW;
/*     */ import oracle.sql.TIMESTAMP;
/*     */ 
/*     */ public class OracleDataUtil
/*     */ {
/*  31 */   static short lastCsId = 870;
/*  32 */   static CharacterSet lastCS = CharacterSet.make(870);
/*     */ 
/* 262 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public static Object convertToObject(Object paramObject, int paramInt, OracleDataFactory paramOracleDataFactory)
/*     */     throws SQLException
/*     */   {
/*  40 */     Object localObject = _convertToObject(paramObject, paramInt, paramOracleDataFactory);
/*  41 */     return localObject;
/*     */   }
/*     */ 
/*     */   public static Object _convertToObject(Object paramObject, int paramInt, OracleDataFactory paramOracleDataFactory)
/*     */     throws SQLException
/*     */   {
/*  49 */     if (paramObject == null) {
/*  50 */       return null;
/*     */     }
/*  52 */     if ((paramObject instanceof OracleStruct))
/*     */     {
/*  54 */       return paramOracleDataFactory.create(paramObject, 2002);
/*     */     }
/*     */ 
/*  57 */     if ((paramObject instanceof OracleRef))
/*     */     {
/*  59 */       return paramOracleDataFactory.create(paramObject, 2006);
/*     */     }
/*     */ 
/*  62 */     if ((paramObject instanceof OracleArray))
/*     */     {
/*  64 */       return paramOracleDataFactory.create(paramObject, 2003);
/*     */     }
/*     */ 
/*  67 */     if ((paramObject instanceof OracleOpaque))
/*     */     {
/*  69 */       return paramOracleDataFactory.create(paramObject, 2007);
/*     */     }
/*     */ 
/*  72 */     if (paramOracleDataFactory != null)
/*     */     {
/*  74 */       return paramOracleDataFactory.create(paramObject, paramInt);
/*     */     }
/*     */ 
/*  77 */     if ((paramObject instanceof NUMBER))
/*     */     {
/*  79 */       if ((paramInt == 2) || (paramInt == 3)) {
/*  80 */         return ((NUMBER)paramObject).bigDecimalValue();
/*     */       }
/*  82 */       if ((paramInt == 8) || (paramInt == 6)) {
/*  83 */         return Double.valueOf(((NUMBER)paramObject).doubleValue());
/*     */       }
/*  85 */       if ((paramInt == 4) || (paramInt == 5)) {
/*  86 */         return Integer.valueOf(((NUMBER)paramObject).intValue());
/*     */       }
/*  88 */       if (paramInt == 7) {
/*  89 */         return Float.valueOf(((NUMBER)paramObject).floatValue());
/*     */       }
/*  91 */       if (paramInt == 16) {
/*  92 */         return Boolean.valueOf(((NUMBER)paramObject).booleanValue());
/*     */       }
/*     */ 
/*  95 */       SQLException localSQLException = DatabaseError.createSqlException(null, 48, " type: " + paramInt);
/*  96 */       localSQLException.fillInStackTrace();
/*  97 */       throw localSQLException;
/*     */     }
/*     */ 
/* 101 */     return paramObject;
/*     */   }
/*     */ 
/*     */   public static Object convertToOracle(Object paramObject, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 109 */     return convertToOracle(paramObject, paramConnection, false);
/*     */   }
/*     */ 
/*     */   public static Object convertToOracle(Object paramObject, Connection paramConnection, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 119 */     Object localObject = _convertToOracle(paramObject, paramConnection, paramBoolean);
/*     */ 
/* 121 */     return localObject;
/*     */   }
/*     */ 
/*     */   private static Object _convertToOracle(Object paramObject, Connection paramConnection, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 130 */     if (paramObject == null) {
/* 131 */       return null;
/*     */     }
/* 133 */     if ((paramObject instanceof OracleData))
/* 134 */       return ((OracleData)paramObject).toJDBCObject((oracle.jdbc.driver.OracleConnection)paramConnection);
/*     */     short s;
/* 136 */     if ((paramObject instanceof String))
/*     */     {
/* 138 */       s = paramBoolean ? ((oracle.jdbc.internal.OracleConnection)paramConnection).getNCharSet() : (paramConnection == null) || (!(paramConnection instanceof oracle.jdbc.internal.OracleConnection)) ? 870 : ((oracle.jdbc.internal.OracleConnection)paramConnection).getDbCsId();
/*     */ 
/* 145 */       if (s != lastCsId)
/*     */       {
/* 147 */         lastCsId = s;
/* 148 */         lastCS = CharacterSet.make(lastCsId);
/*     */       }
/*     */ 
/* 151 */       return new CHAR((String)paramObject, lastCS);
/*     */     }
/*     */ 
/* 154 */     if ((paramObject instanceof Character))
/*     */     {
/* 156 */       s = (paramConnection == null) || (!(paramConnection instanceof oracle.jdbc.internal.OracleConnection)) ? 870 : ((oracle.jdbc.internal.OracleConnection)paramConnection).getDbCsId();
/*     */ 
/* 161 */       if (s != lastCsId)
/*     */       {
/* 163 */         lastCsId = s;
/* 164 */         lastCS = CharacterSet.make(lastCsId);
/*     */       }
/*     */ 
/* 167 */       return new CHAR(((Character)paramObject).toString(), lastCS);
/*     */     }
/*     */ 
/* 170 */     if ((paramObject instanceof BigDecimal)) {
/* 171 */       return new NUMBER((BigDecimal)paramObject);
/*     */     }
/* 173 */     if ((paramObject instanceof BigInteger)) {
/* 174 */       return new NUMBER((BigInteger)paramObject);
/*     */     }
/* 176 */     if ((paramObject instanceof Double)) {
/* 177 */       return new NUMBER(((Double)paramObject).doubleValue());
/*     */     }
/* 179 */     if ((paramObject instanceof Float)) {
/* 180 */       return new NUMBER(((Float)paramObject).floatValue());
/*     */     }
/* 182 */     if ((paramObject instanceof Integer)) {
/* 183 */       return new NUMBER(((Integer)paramObject).intValue());
/*     */     }
/* 185 */     if ((paramObject instanceof Boolean)) {
/* 186 */       return new NUMBER(((Boolean)paramObject).booleanValue());
/*     */     }
/* 188 */     if ((paramObject instanceof Short)) {
/* 189 */       return new NUMBER(((Short)paramObject).shortValue());
/*     */     }
/* 191 */     if ((paramObject instanceof Byte)) {
/* 192 */       return new NUMBER(((Byte)paramObject).byteValue());
/*     */     }
/* 194 */     if ((paramObject instanceof Long)) {
/* 195 */       return new NUMBER(((Long)paramObject).longValue());
/*     */     }
/* 197 */     if ((paramObject instanceof Timestamp)) {
/* 198 */       return new TIMESTAMP((Timestamp)paramObject);
/*     */     }
/* 200 */     if ((paramObject instanceof java.sql.Date)) {
/* 201 */       return new DATE((java.sql.Date)paramObject);
/*     */     }
/* 203 */     if ((paramObject instanceof java.util.Date)) {
/* 204 */       return new DATE(new java.sql.Date(((java.util.Date)paramObject).getTime()));
/*     */     }
/* 206 */     if ((paramObject instanceof byte[])) {
/* 207 */       return new RAW((byte[])paramObject);
/*     */     }
/* 209 */     if ((paramObject instanceof OracleData)) {
/* 210 */       return paramObject;
/*     */     }
/*     */ 
/* 217 */     SQLException localSQLException = DatabaseError.createSqlException(null, 48);
/* 218 */     localSQLException.fillInStackTrace();
/* 219 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   static boolean isMutable(Object paramObject, OracleDataFactory paramOracleDataFactory)
/*     */   {
/* 227 */     if (paramObject == null) {
/* 228 */       return false;
/*     */     }
/* 230 */     return ((paramObject instanceof OracleBfile)) || ((paramObject instanceof OracleBlob)) || ((paramObject instanceof OracleClob)) || ((paramOracleDataFactory != null) && (((paramObject instanceof OracleStruct)) || ((paramObject instanceof OracleOpaque)) || ((paramObject instanceof OracleArray))));
/*     */   }
/*     */ 
/*     */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 251 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jpub.runtime.OracleDataUtil
 * JD-Core Version:    0.6.2
 */