/*     */ package oracle.jpub.runtime;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleDataFactory;
/*     */ import oracle.jdbc.OracleStruct;
/*     */ 
/*     */ public class OracleDataMutableStruct
/*     */ {
/*     */   int length;
/*     */   OracleStruct pickled;
/*     */   Object[] jdbcObjects;
/*     */   Object[] attributes;
/*     */   OracleDataFactory[] oracleDataFactories;
/*     */   int[] sqlTypes;
/*     */   boolean pickledCorrect;
/*     */   boolean[] isNChar;
/* 367 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleDataMutableStruct(OracleStruct paramOracleStruct, int[] paramArrayOfInt, OracleDataFactory[] paramArrayOfOracleDataFactory)
/*     */   {
/*  51 */     this.length = paramArrayOfOracleDataFactory.length;
/*  52 */     this.pickled = paramOracleStruct;
/*  53 */     this.oracleDataFactories = paramArrayOfOracleDataFactory;
/*  54 */     this.sqlTypes = paramArrayOfInt;
/*  55 */     initNChar(paramArrayOfInt.length);
/*  56 */     this.pickledCorrect = true;
/*     */   }
/*     */ 
/*     */   public OracleDataMutableStruct(Object[] paramArrayOfObject, int[] paramArrayOfInt, OracleDataFactory[] paramArrayOfOracleDataFactory)
/*     */   {
/*  64 */     this.length = paramArrayOfOracleDataFactory.length;
/*  65 */     this.attributes = paramArrayOfObject;
/*  66 */     this.oracleDataFactories = paramArrayOfOracleDataFactory;
/*  67 */     this.sqlTypes = paramArrayOfInt;
/*  68 */     initNChar(paramArrayOfInt.length);
/*  69 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   public OracleDataMutableStruct(OracleDataMutableStruct paramOracleDataMutableStruct, int[] paramArrayOfInt, OracleDataFactory[] paramArrayOfOracleDataFactory)
/*     */   {
/*  76 */     this.length = paramArrayOfOracleDataFactory.length;
/*  77 */     this.oracleDataFactories = paramArrayOfOracleDataFactory;
/*  78 */     this.sqlTypes = paramArrayOfInt;
/*  79 */     initNChar(paramArrayOfInt.length);
/*  80 */     this.pickled = paramOracleDataMutableStruct.pickled;
/*  81 */     this.pickledCorrect = paramOracleDataMutableStruct.pickledCorrect;
/*  82 */     this.jdbcObjects = paramOracleDataMutableStruct.jdbcObjects;
/*  83 */     this.attributes = paramOracleDataMutableStruct.attributes;
/*     */   }
/*     */ 
/*     */   public Object toJDBCObject(Connection paramConnection, String paramString)
/*     */     throws SQLException
/*     */   {
/*  91 */     if (!this.pickledCorrect)
/*     */     {
/*  95 */       this.pickled = ((OracleStruct)paramConnection.createStruct(paramString, getJDBCObjectAttributes(paramConnection)));
/*  96 */       this.pickledCorrect = true;
/*     */     }
/*     */ 
/*  99 */     return this.pickled;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 106 */     Object localObject1 = getLazyAttributes()[paramInt];
/*     */ 
/* 108 */     if (localObject1 == null)
/*     */     {
/* 110 */       Object localObject2 = getLazyJDBCObjects()[paramInt];
/*     */ 
/* 112 */       if (this.oracleDataFactories != null)
/*     */       {
/* 114 */         localObject1 = OracleDataUtil.convertToObject(localObject2, this.sqlTypes[paramInt], this.oracleDataFactories[paramInt]);
/* 115 */         this.attributes[paramInt] = localObject1;
/*     */ 
/* 117 */         if (OracleDataUtil.isMutable(localObject2, this.oracleDataFactories[paramInt]))
/* 118 */           resetJDBCObject(paramInt);
/*     */       }
/*     */     }
/* 121 */     return localObject1;
/*     */   }
/*     */ 
/*     */   public Object getOracleAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     Object localObject1;
/* 130 */     if (this.oracleDataFactories[paramInt] == null)
/*     */     {
/* 132 */       localObject1 = getJDBCObjectAttribute(paramInt, null);
/*     */ 
/* 134 */       Object localObject2 = getLazyJDBCObjects()[paramInt];
/*     */ 
/* 136 */       if (OracleDataUtil.isMutable(localObject2, this.oracleDataFactories[paramInt]))
/* 137 */         this.pickledCorrect = false;
/*     */     }
/*     */     else {
/* 140 */       localObject1 = getAttribute(paramInt);
/* 141 */     }return localObject1;
/*     */   }
/*     */ 
/*     */   public Object[] getAttributes()
/*     */     throws SQLException
/*     */   {
/* 148 */     for (int i = 0; i < this.length; i++)
/*     */     {
/* 150 */       getAttribute(i);
/*     */     }
/* 152 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public Object[] getOracleAttributes()
/*     */     throws SQLException
/*     */   {
/* 159 */     Object[] arrayOfObject = new Object[this.length];
/*     */ 
/* 161 */     for (int i = 0; i < this.length; i++)
/*     */     {
/* 163 */       arrayOfObject[i] = getOracleAttribute(i);
/*     */     }
/* 165 */     return arrayOfObject;
/*     */   }
/*     */ 
/*     */   public void setAttribute(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 181 */     if (paramObject == null)
/*     */     {
/* 183 */       getLazyJDBCObjects();
/*     */     }
/*     */ 
/* 186 */     resetJDBCObject(paramInt);
/*     */ 
/* 188 */     getLazyAttributes()[paramInt] = paramObject;
/*     */   }
/*     */ 
/*     */   public void setDoubleAttribute(int paramInt, double paramDouble)
/*     */     throws SQLException
/*     */   {
/* 195 */     setAttribute(paramInt, Double.valueOf(paramDouble));
/*     */   }
/*     */ 
/*     */   public void setFloatAttribute(int paramInt, float paramFloat)
/*     */     throws SQLException
/*     */   {
/* 202 */     setAttribute(paramInt, Float.valueOf(paramFloat));
/*     */   }
/*     */ 
/*     */   public void setIntAttribute(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 209 */     setAttribute(paramInt1, Integer.valueOf(paramInt2));
/*     */   }
/*     */ 
/*     */   public void setOracleAttribute(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 216 */     if (this.oracleDataFactories != null)
/*     */     {
/* 218 */       if (this.oracleDataFactories[paramInt] == null)
/* 219 */         setJDBCObjectAttribute(paramInt, paramObject);
/*     */       else
/* 221 */         setAttribute(paramInt, paramObject);
/*     */     }
/*     */   }
/*     */ 
/*     */   Object getJDBCObjectAttribute(int paramInt, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 229 */     Object localObject1 = getLazyJDBCObjects()[paramInt];
/*     */ 
/* 231 */     if (localObject1 == null)
/*     */     {
/* 233 */       Object localObject2 = getLazyAttributes()[paramInt];
/*     */ 
/* 235 */       localObject1 = OracleDataUtil.convertToOracle(localObject2, paramConnection, isNChar(paramInt));
/* 236 */       this.jdbcObjects[paramInt] = localObject1;
/*     */     }
/* 238 */     return localObject1;
/*     */   }
/*     */ 
/*     */   void setJDBCObjectAttribute(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 245 */     resetAttribute(paramInt);
/*     */ 
/* 247 */     getLazyJDBCObjects()[paramInt] = paramObject;
/* 248 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   Object[] getJDBCObjectAttributes(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 255 */     for (int i = 0; i < this.length; i++)
/*     */     {
/* 257 */       getJDBCObjectAttribute(i, paramConnection);
/*     */     }
/*     */ 
/* 260 */     return (Object[])this.jdbcObjects.clone();
/*     */   }
/*     */ 
/*     */   void resetAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 267 */     if (this.attributes != null)
/*     */     {
/* 269 */       this.attributes[paramInt] = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   void resetJDBCObject(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 277 */     if (this.jdbcObjects != null)
/*     */     {
/* 279 */       this.jdbcObjects[paramInt] = null;
/*     */     }
/*     */ 
/* 282 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   Object[] getLazyAttributes()
/*     */   {
/* 289 */     if (this.attributes == null)
/*     */     {
/* 291 */       this.attributes = new Object[this.length];
/*     */     }
/*     */ 
/* 294 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   Object[] getLazyJDBCObjects()
/*     */     throws SQLException
/*     */   {
/* 301 */     if (this.jdbcObjects == null)
/*     */     {
/* 305 */       if (this.pickled != null)
/*     */       {
/* 309 */         this.jdbcObjects = this.pickled.getAttributes();
/* 310 */         this.pickledCorrect = true;
/*     */ 
/* 316 */         if (this.attributes != null)
/*     */         {
/* 318 */           for (int i = 0; i < this.length; i++)
/*     */           {
/* 320 */             if (this.attributes[i] != null)
/*     */             {
/* 322 */               this.jdbcObjects[i] = null;
/* 323 */               this.pickledCorrect = false;
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 330 */         this.jdbcObjects = new Object[this.length];
/*     */       }
/*     */     }
/* 333 */     return this.jdbcObjects;
/*     */   }
/*     */ 
/*     */   private void initNChar(int paramInt)
/*     */   {
/* 340 */     this.isNChar = new boolean[paramInt];
/* 341 */     for (int i = 0; i < paramInt; i++)
/* 342 */       this.isNChar[i] = false;
/*     */   }
/*     */ 
/*     */   public void setNChar(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 349 */     this.isNChar[paramInt] = true;
/*     */   }
/*     */ 
/*     */   public boolean isNChar(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 355 */     int i = this.isNChar[paramInt];
/* 356 */     return i;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jpub.runtime.OracleDataMutableStruct
 * JD-Core Version:    0.6.2
 */