/*      */ package oracle.jpub.runtime;
/*      */ 
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Connection;
/*      */ import java.sql.Date;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Timestamp;
/*      */ import oracle.jdbc.OracleArray;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BINARY_DOUBLE;
/*      */ import oracle.sql.BINARY_FLOAT;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ public class OracleDataMutableArray
/*      */ {
/*      */   int length;
/*      */   Object[] elements;
/*      */   Object[] jdbcObjects;
/*      */   OracleArray pickled;
/*      */   boolean pickledCorrect;
/*      */   int sqlType;
/*      */   OracleDataFactory oracleDataFactory;
/*      */   boolean isNChar;
/* 1012 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleDataMutableArray(int paramInt, OracleArray paramOracleArray, OracleDataFactory paramOracleDataFactory)
/*      */   {
/*   54 */     this.length = -1;
/*   55 */     this.elements = null;
/*   56 */     this.jdbcObjects = null;
/*   57 */     this.pickled = paramOracleArray;
/*   58 */     this.pickledCorrect = true;
/*   59 */     this.isNChar = false;
/*   60 */     this.sqlType = paramInt;
/*   61 */     this.oracleDataFactory = paramOracleDataFactory;
/*      */   }
/*      */ 
/*      */   public OracleDataMutableArray(int paramInt, Object[] paramArrayOfObject, OracleDataFactory paramOracleDataFactory)
/*      */   {
/*   68 */     this.sqlType = paramInt;
/*   69 */     this.oracleDataFactory = paramOracleDataFactory;
/*   70 */     this.isNChar = false;
/*      */ 
/*   72 */     setJDBCObjectArray(paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public OracleDataMutableArray(int paramInt, double[] paramArrayOfDouble, OracleDataFactory paramOracleDataFactory)
/*      */   {
/*   79 */     this.sqlType = paramInt;
/*   80 */     this.oracleDataFactory = paramOracleDataFactory;
/*   81 */     this.isNChar = false;
/*      */ 
/*   83 */     setArray(paramArrayOfDouble);
/*      */   }
/*      */ 
/*      */   public OracleDataMutableArray(int paramInt, int[] paramArrayOfInt, OracleDataFactory paramOracleDataFactory)
/*      */   {
/*   90 */     this.sqlType = paramInt;
/*   91 */     this.oracleDataFactory = paramOracleDataFactory;
/*   92 */     this.isNChar = false;
/*      */ 
/*   94 */     setArray(paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public OracleDataMutableArray(int paramInt, float[] paramArrayOfFloat, OracleDataFactory paramOracleDataFactory)
/*      */   {
/*  101 */     this.sqlType = paramInt;
/*  102 */     this.oracleDataFactory = paramOracleDataFactory;
/*  103 */     this.isNChar = false;
/*      */ 
/*  105 */     setArray(paramArrayOfFloat);
/*      */   }
/*      */ 
/*      */   public OracleDataMutableArray(int paramInt, short[] paramArrayOfShort, OracleDataFactory paramOracleDataFactory)
/*      */   {
/*  112 */     this.sqlType = paramInt;
/*  113 */     this.oracleDataFactory = paramOracleDataFactory;
/*  114 */     this.isNChar = false;
/*      */ 
/*  116 */     setArray(paramArrayOfShort);
/*      */   }
/*      */ 
/*      */   public Object toJDBCObject(Connection paramConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/*  124 */     if (!this.pickledCorrect)
/*      */     {
/*  127 */       this.pickled = ((OracleArray)((oracle.jdbc.OracleConnection)paramConnection).createOracleArray(paramString, getJDBCObjectArray(paramConnection)));
/*  128 */       this.pickledCorrect = true;
/*      */     }
/*  130 */     return this.pickled;
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray()
/*      */     throws SQLException
/*      */   {
/*  138 */     return getOracleArray(0L, 2147483647);
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  149 */     int i = sliceLength(paramLong, paramInt);
/*      */ 
/*  151 */     if (i < 0) {
/*  152 */       return null;
/*      */     }
/*  154 */     Object localObject = null;
/*      */ 
/*  156 */     switch (this.sqlType)
/*      */     {
/*      */     case -13:
/*  160 */       localObject = new BFILE[i];
/*      */ 
/*  162 */       break;
/*      */     case 2004:
/*  165 */       localObject = new BLOB[i];
/*      */ 
/*  167 */       break;
/*      */     case 1:
/*      */     case 12:
/*  172 */       localObject = new CHAR[i];
/*      */ 
/*  174 */       break;
/*      */     case 2005:
/*  177 */       localObject = new CLOB[i];
/*      */ 
/*  179 */       break;
/*      */     case 91:
/*  182 */       localObject = new DATE[i];
/*      */ 
/*  184 */       break;
/*      */     case 93:
/*  187 */       localObject = new TIMESTAMP[i];
/*      */ 
/*  189 */       break;
/*      */     case -101:
/*  192 */       localObject = new TIMESTAMPTZ[i];
/*      */ 
/*  194 */       break;
/*      */     case -102:
/*  197 */       localObject = new TIMESTAMPLTZ[i];
/*      */ 
/*  199 */       break;
/*      */     case -104:
/*  202 */       localObject = new INTERVALDS[i];
/*      */ 
/*  204 */       break;
/*      */     case -103:
/*  207 */       localObject = new INTERVALYM[i];
/*      */ 
/*  209 */       break;
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*  224 */       localObject = new NUMBER[i];
/*      */ 
/*  226 */       break;
/*      */     case -2:
/*  229 */       localObject = new RAW[i];
/*      */ 
/*  231 */       break;
/*      */     case 100:
/*  234 */       localObject = new BINARY_FLOAT[i];
/*      */ 
/*  236 */       break;
/*      */     case 101:
/*  239 */       localObject = new BINARY_DOUBLE[i];
/*      */ 
/*  241 */       break;
/*      */     case 0:
/*      */     case 2002:
/*      */     case 2003:
/*      */     case 2006:
/*      */     case 2007:
/*  252 */       localObject = new OracleData[i];
/*      */ 
/*  254 */       break;
/*      */     default:
/*  258 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 48);
/*  259 */       localSQLException.fillInStackTrace();
/*  260 */       throw localSQLException;
/*      */     }
/*      */ 
/*  264 */     return getOracleArray(paramLong, (Object[])localObject);
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray(long paramLong, Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  271 */     if (paramArrayOfObject == null) {
/*  272 */       return null;
/*      */     }
/*  274 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  275 */     int j = (int)paramLong;
/*      */ 
/*  277 */     if (i != paramArrayOfObject.length)
/*  278 */       return null;
/*      */     int k;
/*  280 */     if ((this.sqlType == 2002) || (this.sqlType == 2007) || (this.sqlType == 2003) || (this.sqlType == 2006) || (this.sqlType == 0))
/*      */     {
/*  284 */       if (this.oracleDataFactory != null)
/*      */       {
/*  286 */         for (k = 0; k < i; k++) {
/*  287 */           paramArrayOfObject[k] = this.oracleDataFactory.create(getJDBCObjectElement(j++, null), this.sqlType);
/*      */         }
/*      */       }
/*      */     }
/*      */     else {
/*  292 */       for (k = 0; k < i; k++)
/*  293 */         paramArrayOfObject[k] = getJDBCObjectElement(j++, null);
/*      */     }
/*  295 */     return paramArrayOfObject;
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  302 */     return getOracleArray(0L, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray()
/*      */     throws SQLException
/*      */   {
/*  309 */     return getObjectArray(0L, 2147483647);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  316 */     int i = sliceLength(paramLong, paramInt);
/*      */ 
/*  318 */     if (i < 0)
/*  319 */       return null;
/*      */     Object localObject;
/*  323 */     switch (this.sqlType)
/*      */     {
/*      */     case 1:
/*      */     case 12:
/*  329 */       localObject = new String[i];
/*      */ 
/*  331 */       break;
/*      */     case 91:
/*  334 */       localObject = new Date[i];
/*      */ 
/*  336 */       break;
/*      */     case 93:
/*  339 */       localObject = new Timestamp[i];
/*      */ 
/*  341 */       break;
/*      */     case 2:
/*      */     case 3:
/*  346 */       localObject = new BigDecimal[i];
/*      */ 
/*  348 */       break;
/*      */     case 6:
/*      */     case 8:
/*  353 */       localObject = new Double[i];
/*      */ 
/*  355 */       break;
/*      */     case 4:
/*      */     case 5:
/*  360 */       localObject = new Integer[i];
/*      */ 
/*  362 */       break;
/*      */     case 7:
/*  365 */       localObject = new Float[i];
/*      */ 
/*  367 */       break;
/*      */     case -2:
/*  370 */       localObject = new byte[i][];
/*      */ 
/*  372 */       break;
/*      */     default:
/*  375 */       return getOracleArray(paramLong, paramInt);
/*      */     }
/*      */ 
/*  378 */     return getObjectArray(paramLong, (Object[])localObject);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray(long paramLong, Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  385 */     if (paramArrayOfObject == null) {
/*  386 */       return null;
/*      */     }
/*  388 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  389 */     int j = (int)paramLong;
/*      */ 
/*  391 */     if (i != paramArrayOfObject.length) {
/*  392 */       return null;
/*      */     }
/*  394 */     switch (this.sqlType)
/*      */     {
/*      */     case -2:
/*      */     case 1:
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*      */     case 12:
/*      */     case 91:
/*      */     case 93:
/*  410 */       for (int k = 0; k < i; k++) {
/*  411 */         paramArrayOfObject[k] = getObjectElement(j++);
/*      */       }
/*  413 */       return paramArrayOfObject;
/*      */     }
/*      */ 
/*  417 */     return getOracleArray(paramLong, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  425 */     return getObjectArray(0L, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Object getArray()
/*      */     throws SQLException
/*      */   {
/*  432 */     return getArray(0L, 2147483647);
/*      */   }
/*      */ 
/*      */   public Object getArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  439 */     int i = sliceLength(paramLong, paramInt);
/*  440 */     int j = (int)paramLong;
/*      */ 
/*  442 */     if (i < 0)
/*  443 */       return null;
/*      */     Object localObject;
/*      */     int k;
/*  445 */     switch (this.sqlType)
/*      */     {
/*      */     case 6:
/*      */     case 8:
/*      */     case 101:
/*  454 */       localObject = new double[i];
/*      */ 
/*  456 */       for (k = 0; k < i; k++) {
/*  457 */         localObject[k] = ((Double)getObjectElement(j++)).doubleValue();
/*      */       }
/*  459 */       return localObject;
/*      */     case 100:
/*  464 */       localObject = new float[i];
/*      */ 
/*  466 */       for (k = 0; k < i; k++) {
/*  467 */         localObject[k] = ((Float)getObjectElement(j++)).floatValue();
/*      */       }
/*  469 */       return localObject;
/*      */     case 4:
/*  474 */       localObject = new int[i];
/*      */ 
/*  476 */       for (k = 0; k < i; k++) {
/*  477 */         localObject[k] = ((Integer)getObjectElement(j++)).intValue();
/*      */       }
/*  479 */       return localObject;
/*      */     case 5:
/*  484 */       localObject = new short[i];
/*      */ 
/*  486 */       for (k = 0; k < i; k++) {
/*  487 */         localObject[k] = ((short)((Integer)getObjectElement(j++)).intValue());
/*      */       }
/*  489 */       return localObject;
/*      */     case 7:
/*  494 */       localObject = new float[i];
/*      */ 
/*  496 */       for (k = 0; k < i; k++) {
/*  497 */         localObject[k] = ((Float)getObjectElement(j++)).floatValue();
/*      */       }
/*  499 */       return localObject;
/*      */     }
/*      */ 
/*  503 */     return getObjectArray(paramLong, paramInt);
/*      */   }
/*      */ 
/*      */   public void setOracleArray(Object[] paramArrayOfObject)
/*      */   {
/*  511 */     if (this.oracleDataFactory == null)
/*  512 */       setJDBCObjectArray((Object[])paramArrayOfObject);
/*      */     else
/*  514 */       setObjectArray(paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setOracleArray(Object[] paramArrayOfObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  521 */     if (this.oracleDataFactory == null)
/*  522 */       setJDBCObjectArray((Object[])paramArrayOfObject, paramLong);
/*      */     else
/*  524 */       setObjectArray(paramArrayOfObject, paramLong);
/*      */   }
/*      */ 
/*      */   public void setObjectArray(Object[] paramArrayOfObject)
/*      */   {
/*  531 */     if (paramArrayOfObject == null) {
/*  532 */       setNullArray();
/*      */     }
/*      */     else {
/*  535 */       setArrayGeneric(paramArrayOfObject.length);
/*      */ 
/*  537 */       this.elements = new Object[this.length];
/*      */ 
/*  539 */       for (int i = 0; i < this.length; i++)
/*  540 */         this.elements[i] = paramArrayOfObject[i];
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObjectArray(Object[] paramArrayOfObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  548 */     if (paramArrayOfObject == null) {
/*  549 */       return;
/*      */     }
/*  551 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  552 */     int j = (int)paramLong;
/*      */ 
/*  554 */     for (int k = 0; k < i; k++)
/*      */     {
/*  556 */       setObjectElement(paramArrayOfObject[k], j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(double[] paramArrayOfDouble)
/*      */   {
/*  564 */     if (paramArrayOfDouble == null) {
/*  565 */       setNullArray();
/*      */     }
/*      */     else {
/*  568 */       setArrayGeneric(paramArrayOfDouble.length);
/*      */ 
/*  570 */       this.elements = new Object[this.length];
/*      */ 
/*  572 */       for (int i = 0; i < this.length; i++)
/*  573 */         this.elements[i] = Double.valueOf(paramArrayOfDouble[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(double[] paramArrayOfDouble, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  581 */     if (paramArrayOfDouble == null) {
/*  582 */       return;
/*      */     }
/*  584 */     int i = sliceLength(paramLong, paramArrayOfDouble.length);
/*  585 */     int j = (int)paramLong;
/*      */ 
/*  587 */     for (int k = 0; k < i; k++)
/*      */     {
/*  589 */       setObjectElement(Double.valueOf(paramArrayOfDouble[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(int[] paramArrayOfInt)
/*      */   {
/*  597 */     if (paramArrayOfInt == null) {
/*  598 */       setNullArray();
/*      */     }
/*      */     else {
/*  601 */       setArrayGeneric(paramArrayOfInt.length);
/*      */ 
/*  603 */       this.elements = new Object[this.length];
/*      */ 
/*  605 */       for (int i = 0; i < this.length; i++)
/*  606 */         this.elements[i] = Integer.valueOf(paramArrayOfInt[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(int[] paramArrayOfInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  614 */     if (paramArrayOfInt == null) {
/*  615 */       return;
/*      */     }
/*  617 */     int i = sliceLength(paramLong, paramArrayOfInt.length);
/*  618 */     int j = (int)paramLong;
/*      */ 
/*  620 */     for (int k = 0; k < i; k++)
/*      */     {
/*  622 */       setObjectElement(Integer.valueOf(paramArrayOfInt[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(float[] paramArrayOfFloat)
/*      */   {
/*  630 */     if (paramArrayOfFloat == null) {
/*  631 */       setNullArray();
/*      */     }
/*      */     else {
/*  634 */       setArrayGeneric(paramArrayOfFloat.length);
/*      */ 
/*  636 */       this.elements = new Object[this.length];
/*      */ 
/*  638 */       for (int i = 0; i < this.length; i++)
/*  639 */         this.elements[i] = Float.valueOf(paramArrayOfFloat[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(float[] paramArrayOfFloat, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  647 */     if (paramArrayOfFloat == null) {
/*  648 */       return;
/*      */     }
/*  650 */     int i = sliceLength(paramLong, paramArrayOfFloat.length);
/*  651 */     int j = (int)paramLong;
/*      */ 
/*  653 */     for (int k = 0; k < i; k++)
/*      */     {
/*  655 */       setObjectElement(Float.valueOf(paramArrayOfFloat[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(short[] paramArrayOfShort)
/*      */   {
/*  663 */     if (paramArrayOfShort == null) {
/*  664 */       setNullArray();
/*      */     }
/*      */     else {
/*  667 */       setArrayGeneric(paramArrayOfShort.length);
/*      */ 
/*  669 */       this.elements = new Object[this.length];
/*      */ 
/*  671 */       for (int i = 0; i < this.length; i++)
/*  672 */         this.elements[i] = Integer.valueOf(paramArrayOfShort[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(short[] paramArrayOfShort, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  680 */     if (paramArrayOfShort == null) {
/*  681 */       return;
/*      */     }
/*  683 */     int i = sliceLength(paramLong, paramArrayOfShort.length);
/*  684 */     int j = (int)paramLong;
/*      */ 
/*  686 */     for (int k = 0; k < i; k++)
/*      */     {
/*  688 */       setObjectElement(Integer.valueOf(paramArrayOfShort[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObjectElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  696 */     Object localObject1 = getLazyArray()[((int)paramLong)];
/*      */ 
/*  698 */     if (localObject1 == null)
/*      */     {
/*  700 */       if (this.oracleDataFactory != null)
/*      */       {
/*  702 */         Object localObject2 = getLazyOracleArray()[((int)paramLong)];
/*      */ 
/*  704 */         localObject1 = OracleDataUtil.convertToObject(localObject2, this.sqlType, this.oracleDataFactory);
/*  705 */         this.elements[((int)paramLong)] = localObject1;
/*      */ 
/*  707 */         if (OracleDataUtil.isMutable(localObject2, this.oracleDataFactory)) {
/*  708 */           resetOracleElement(paramLong);
/*      */         }
/*      */       }
/*      */     }
/*  712 */     return localObject1;
/*      */   }
/*      */ 
/*      */   public Object getOracleElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  719 */     if (this.oracleDataFactory == null)
/*      */     {
/*  721 */       Object localObject = getJDBCObjectElement(paramLong, null);
/*      */ 
/*  723 */       if (OracleDataUtil.isMutable(localObject, this.oracleDataFactory)) {
/*  724 */         this.pickledCorrect = false;
/*      */       }
/*  726 */       return localObject;
/*      */     }
/*      */ 
/*  729 */     return getObjectElement(paramLong);
/*      */   }
/*      */ 
/*      */   public void setObjectElement(Object paramObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  745 */     if (paramObject == null)
/*      */     {
/*  747 */       getLazyOracleArray();
/*      */     }
/*      */ 
/*  750 */     resetOracleElement(paramLong);
/*      */ 
/*  752 */     getLazyArray()[((int)paramLong)] = paramObject;
/*      */   }
/*      */ 
/*      */   public void setOracleElement(Object paramObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  759 */     if (this.oracleDataFactory == null)
/*  760 */       setJDBCObjectElement(paramObject, paramLong);
/*      */     else
/*  762 */       setObjectElement(paramObject, paramLong);
/*      */   }
/*      */ 
/*      */   public String getBaseTypeName()
/*      */     throws SQLException
/*      */   {
/*  769 */     return this.pickled.getBaseTypeName();
/*      */   }
/*      */ 
/*      */   public int getBaseType()
/*      */     throws SQLException
/*      */   {
/*  776 */     return this.pickled.getBaseType();
/*      */   }
/*      */ 
/*      */   Object[] getJDBCObjectArray(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  783 */     if (this.length < 0) {
/*  784 */       getLazyOracleArray();
/*      */     }
/*  786 */     if (this.jdbcObjects == null) {
/*  787 */       return null;
/*      */     }
/*  789 */     Object[] arrayOfObject = new Object[this.length];
/*      */ 
/*  791 */     for (int i = 0; i < this.length; i++) {
/*  792 */       arrayOfObject[i] = getJDBCObjectElement(i, paramConnection);
/*      */     }
/*  794 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   void setJDBCObjectArray(Object[] paramArrayOfObject)
/*      */   {
/*  801 */     if (paramArrayOfObject == null) {
/*  802 */       setNullArray();
/*      */     }
/*      */     else {
/*  805 */       this.length = paramArrayOfObject.length;
/*  806 */       this.elements = null;
/*  807 */       this.jdbcObjects = ((Object[])paramArrayOfObject.clone());
/*  808 */       this.pickled = null;
/*  809 */       this.pickledCorrect = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   void setJDBCObjectArray(Object[] paramArrayOfObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  817 */     if (paramArrayOfObject == null) {
/*  818 */       return;
/*      */     }
/*  820 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  821 */     int j = (int)paramLong;
/*      */ 
/*  823 */     for (int k = 0; k < i; k++)
/*      */     {
/*  825 */       setJDBCObjectElement(paramArrayOfObject[k], j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   Object getJDBCObjectElement(long paramLong, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  833 */     Object localObject1 = getLazyOracleArray()[((int)paramLong)];
/*      */ 
/*  835 */     if (localObject1 == null)
/*      */     {
/*  837 */       Object localObject2 = getLazyArray()[((int)paramLong)];
/*      */ 
/*  839 */       localObject1 = OracleDataUtil.convertToOracle(localObject2, paramConnection, this.isNChar);
/*  840 */       this.jdbcObjects[((int)paramLong)] = localObject1;
/*      */     }
/*  842 */     return localObject1;
/*      */   }
/*      */ 
/*      */   void setJDBCObjectElement(Object paramObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  849 */     resetElement(paramLong);
/*      */ 
/*  851 */     getLazyOracleArray()[((int)paramLong)] = paramObject;
/*  852 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   void resetElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  859 */     if (this.elements != null)
/*      */     {
/*  861 */       this.elements[((int)paramLong)] = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void setNullArray()
/*      */   {
/*  869 */     this.length = -1;
/*  870 */     this.elements = null;
/*  871 */     this.jdbcObjects = null;
/*  872 */     this.pickled = null;
/*  873 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   void setArrayGeneric(int paramInt)
/*      */   {
/*  880 */     this.length = paramInt;
/*  881 */     this.jdbcObjects = new Object[paramInt];
/*  882 */     this.pickled = null;
/*  883 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   public int length()
/*      */     throws SQLException
/*      */   {
/*  890 */     if (this.length < 0) {
/*  891 */       getLazyOracleArray();
/*      */     }
/*  893 */     return this.length;
/*      */   }
/*      */ 
/*      */   public int sliceLength(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  900 */     if (this.length < 0) {
/*  901 */       getLazyOracleArray();
/*      */     }
/*  903 */     if (paramLong < 0L) {
/*  904 */       return (int)paramLong;
/*      */     }
/*  906 */     return Math.min(this.length - (int)paramLong, paramInt);
/*      */   }
/*      */ 
/*      */   void resetOracleElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  913 */     if (this.jdbcObjects != null)
/*      */     {
/*  915 */       this.jdbcObjects[((int)paramLong)] = null;
/*      */     }
/*      */ 
/*  923 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   Object[] getLazyArray()
/*      */     throws SQLException
/*      */   {
/*  930 */     if (this.length == -1) {
/*  931 */       getLazyOracleArray();
/*      */     }
/*  933 */     if (this.elements == null)
/*      */     {
/*  935 */       this.elements = new Object[this.length];
/*      */     }
/*      */ 
/*  938 */     return this.elements;
/*      */   }
/*      */ 
/*      */   Object[] getLazyOracleArray()
/*      */     throws SQLException
/*      */   {
/*  945 */     if (this.jdbcObjects == null)
/*      */     {
/*  949 */       if (this.pickled != null)
/*      */       {
/*  953 */         this.jdbcObjects = ((Object[])this.pickled.getArray());
/*  954 */         this.length = this.jdbcObjects.length;
/*  955 */         this.pickledCorrect = true;
/*      */ 
/*  961 */         if (this.elements != null)
/*      */         {
/*  963 */           for (int i = 0; i < this.length; i++)
/*      */           {
/*  965 */             if (this.elements[i] != null)
/*      */             {
/*  967 */               this.jdbcObjects[i] = null;
/*  968 */               this.pickledCorrect = false;
/*      */             }
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*  975 */       else if (this.length >= 0) {
/*  976 */         this.jdbcObjects = new Object[this.length];
/*      */       }
/*      */     }
/*  979 */     return this.jdbcObjects;
/*      */   }
/*      */ 
/*      */   public void setNChar()
/*      */   {
/*  986 */     this.isNChar = true;
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1001 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jpub.runtime.OracleDataMutableArray
 * JD-Core Version:    0.6.2
 */