/*     */ package oracle.jpub.runtime;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.CustomDatumFactory;
/*     */ import oracle.sql.Datum;
/*     */ import oracle.sql.ORADataFactory;
/*     */ import oracle.sql.STRUCT;
/*     */ import oracle.sql.StructDescriptor;
/*     */ 
/*     */ public class MutableStruct
/*     */ {
/*     */   int length;
/*     */   STRUCT pickled;
/*     */   Datum[] datums;
/*     */   Object[] attributes;
/*     */   CustomDatumFactory[] old_factories;
/*     */   ORADataFactory[] factories;
/*     */   int[] sqlTypes;
/*     */   boolean pickledCorrect;
/*     */   boolean[] isNChar;
/* 449 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public MutableStruct(STRUCT paramSTRUCT, int[] paramArrayOfInt, ORADataFactory[] paramArrayOfORADataFactory)
/*     */   {
/*  54 */     this.length = paramArrayOfORADataFactory.length;
/*  55 */     this.pickled = paramSTRUCT;
/*  56 */     this.factories = paramArrayOfORADataFactory;
/*  57 */     this.sqlTypes = paramArrayOfInt;
/*  58 */     initNChar(paramArrayOfInt.length);
/*  59 */     this.pickledCorrect = true;
/*     */   }
/*     */ 
/*     */   public MutableStruct(Object[] paramArrayOfObject, int[] paramArrayOfInt, ORADataFactory[] paramArrayOfORADataFactory)
/*     */   {
/*  67 */     this.length = paramArrayOfORADataFactory.length;
/*  68 */     this.attributes = paramArrayOfObject;
/*  69 */     this.factories = paramArrayOfORADataFactory;
/*  70 */     this.sqlTypes = paramArrayOfInt;
/*  71 */     initNChar(paramArrayOfInt.length);
/*  72 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   public MutableStruct(STRUCT paramSTRUCT, int[] paramArrayOfInt, CustomDatumFactory[] paramArrayOfCustomDatumFactory)
/*     */   {
/*  79 */     this.length = paramArrayOfCustomDatumFactory.length;
/*  80 */     this.pickled = paramSTRUCT;
/*  81 */     this.old_factories = paramArrayOfCustomDatumFactory;
/*  82 */     this.sqlTypes = paramArrayOfInt;
/*  83 */     initNChar(paramArrayOfInt.length);
/*  84 */     this.pickledCorrect = true;
/*     */   }
/*     */ 
/*     */   public MutableStruct(Object[] paramArrayOfObject, int[] paramArrayOfInt, CustomDatumFactory[] paramArrayOfCustomDatumFactory)
/*     */   {
/*  92 */     this.length = paramArrayOfCustomDatumFactory.length;
/*  93 */     this.attributes = paramArrayOfObject;
/*  94 */     this.old_factories = paramArrayOfCustomDatumFactory;
/*  95 */     this.sqlTypes = paramArrayOfInt;
/*  96 */     initNChar(paramArrayOfInt.length);
/*  97 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(Connection paramConnection, String paramString)
/*     */     throws SQLException
/*     */   {
/* 106 */     if (!this.pickledCorrect)
/*     */     {
/* 110 */       this.pickled = new STRUCT(StructDescriptor.createDescriptor(paramString, paramConnection), paramConnection, getDatumAttributes(paramConnection));
/*     */ 
/* 112 */       this.pickledCorrect = true;
/*     */     }
/*     */ 
/* 115 */     return this.pickled;
/*     */   }
/*     */ 
/*     */   public Datum toDatum(oracle.jdbc.OracleConnection paramOracleConnection, String paramString)
/*     */     throws SQLException
/*     */   {
/* 123 */     return toDatum(paramOracleConnection, paramString);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public Datum toDatum(oracle.jdbc.driver.OracleConnection paramOracleConnection, String paramString)
/*     */     throws SQLException
/*     */   {
/* 134 */     return toDatum(paramOracleConnection, paramString);
/*     */   }
/*     */ 
/*     */   public Object getAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 142 */     Object localObject = getLazyAttributes()[paramInt];
/*     */ 
/* 144 */     if (localObject == null)
/*     */     {
/* 146 */       Datum localDatum = getLazyDatums()[paramInt];
/*     */ 
/* 148 */       if (this.old_factories == null)
/*     */       {
/* 150 */         localObject = Util.convertToObject(localDatum, this.sqlTypes[paramInt], this.factories[paramInt]);
/* 151 */         this.attributes[paramInt] = localObject;
/*     */ 
/* 153 */         if (Util.isMutable(localDatum, this.factories[paramInt]))
/* 154 */           resetDatum(paramInt);
/*     */       }
/*     */       else
/*     */       {
/* 158 */         localObject = Util.convertToObject(localDatum, this.sqlTypes[paramInt], this.old_factories[paramInt]);
/* 159 */         this.attributes[paramInt] = localObject;
/*     */ 
/* 161 */         if (Util.isMutable(localDatum, this.old_factories[paramInt]))
/* 162 */           resetDatum(paramInt);
/*     */       }
/*     */     }
/* 165 */     return localObject;
/*     */   }
/*     */ 
/*     */   public Object getOracleAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     Object localObject;
/*     */     Datum localDatum;
/* 174 */     if (this.old_factories == null)
/*     */     {
/* 176 */       if (this.factories[paramInt] == null)
/*     */       {
/* 178 */         localObject = getDatumAttribute(paramInt, null);
/*     */ 
/* 180 */         localDatum = getLazyDatums()[paramInt];
/*     */ 
/* 182 */         if (Util.isMutable(localDatum, this.factories[paramInt]))
/* 183 */           this.pickledCorrect = false;
/*     */       }
/*     */       else {
/* 186 */         localObject = getAttribute(paramInt);
/*     */       }
/*     */ 
/*     */     }
/* 190 */     else if (this.old_factories[paramInt] == null)
/*     */     {
/* 192 */       localObject = getDatumAttribute(paramInt, null);
/*     */ 
/* 194 */       localDatum = getLazyDatums()[paramInt];
/*     */ 
/* 196 */       if (Util.isMutable(localDatum, this.old_factories[paramInt]))
/* 197 */         this.pickledCorrect = false;
/*     */     }
/*     */     else {
/* 200 */       localObject = getAttribute(paramInt);
/*     */     }
/* 202 */     return localObject;
/*     */   }
/*     */ 
/*     */   public Object[] getAttributes()
/*     */     throws SQLException
/*     */   {
/* 209 */     for (int i = 0; i < this.length; i++)
/*     */     {
/* 211 */       getAttribute(i);
/*     */     }
/* 213 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public Object[] getOracleAttributes()
/*     */     throws SQLException
/*     */   {
/* 220 */     Object[] arrayOfObject = new Object[this.length];
/*     */ 
/* 222 */     for (int i = 0; i < this.length; i++)
/*     */     {
/* 224 */       arrayOfObject[i] = getOracleAttribute(i);
/*     */     }
/* 226 */     return arrayOfObject;
/*     */   }
/*     */ 
/*     */   public void setAttribute(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 242 */     if (paramObject == null)
/*     */     {
/* 244 */       getLazyDatums();
/*     */     }
/*     */ 
/* 247 */     resetDatum(paramInt);
/*     */ 
/* 249 */     getLazyAttributes()[paramInt] = paramObject;
/*     */   }
/*     */ 
/*     */   public void setDoubleAttribute(int paramInt, double paramDouble)
/*     */     throws SQLException
/*     */   {
/* 256 */     setAttribute(paramInt, Double.valueOf(paramDouble));
/*     */   }
/*     */ 
/*     */   public void setFloatAttribute(int paramInt, float paramFloat)
/*     */     throws SQLException
/*     */   {
/* 263 */     setAttribute(paramInt, Float.valueOf(paramFloat));
/*     */   }
/*     */ 
/*     */   public void setIntAttribute(int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 270 */     setAttribute(paramInt1, Integer.valueOf(paramInt2));
/*     */   }
/*     */ 
/*     */   public void setOracleAttribute(int paramInt, Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 277 */     if (this.old_factories == null)
/*     */     {
/* 279 */       if (this.factories[paramInt] == null)
/* 280 */         setDatumAttribute(paramInt, (Datum)paramObject);
/*     */       else {
/* 282 */         setAttribute(paramInt, paramObject);
/*     */       }
/*     */ 
/*     */     }
/* 286 */     else if (this.old_factories[paramInt] == null)
/* 287 */       setDatumAttribute(paramInt, (Datum)paramObject);
/*     */     else
/* 289 */       setAttribute(paramInt, paramObject);
/*     */   }
/*     */ 
/*     */   Datum getDatumAttribute(int paramInt, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 297 */     Datum localDatum = getLazyDatums()[paramInt];
/*     */ 
/* 299 */     if (localDatum == null)
/*     */     {
/* 301 */       Object localObject = getLazyAttributes()[paramInt];
/*     */ 
/* 303 */       localDatum = Util.convertToOracle(localObject, paramConnection, isNChar(paramInt));
/* 304 */       this.datums[paramInt] = localDatum;
/*     */     }
/* 306 */     return localDatum;
/*     */   }
/*     */ 
/*     */   void setDatumAttribute(int paramInt, Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 313 */     resetAttribute(paramInt);
/*     */ 
/* 315 */     getLazyDatums()[paramInt] = paramDatum;
/* 316 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   Datum[] getDatumAttributes(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 323 */     for (int i = 0; i < this.length; i++)
/*     */     {
/* 325 */       getDatumAttribute(i, paramConnection);
/*     */     }
/*     */ 
/* 328 */     return (Datum[])this.datums.clone();
/*     */   }
/*     */ 
/*     */   void resetAttribute(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 335 */     if (this.attributes != null)
/*     */     {
/* 337 */       this.attributes[paramInt] = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   void resetDatum(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 345 */     if (this.datums != null)
/*     */     {
/* 347 */       this.datums[paramInt] = null;
/*     */     }
/*     */ 
/* 355 */     this.pickledCorrect = false;
/*     */   }
/*     */ 
/*     */   Object[] getLazyAttributes()
/*     */   {
/* 362 */     if (this.attributes == null)
/*     */     {
/* 364 */       this.attributes = new Object[this.length];
/*     */     }
/*     */ 
/* 367 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   Datum[] getLazyDatums()
/*     */     throws SQLException
/*     */   {
/* 374 */     if (this.datums == null)
/*     */     {
/* 378 */       if (this.pickled != null)
/*     */       {
/* 382 */         this.datums = this.pickled.getOracleAttributes();
/* 383 */         this.pickledCorrect = true;
/*     */ 
/* 389 */         if (this.attributes != null)
/*     */         {
/* 391 */           for (int i = 0; i < this.length; i++)
/*     */           {
/* 393 */             if (this.attributes[i] != null)
/*     */             {
/* 395 */               this.datums[i] = null;
/* 396 */               this.pickledCorrect = false;
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 403 */         this.datums = new Datum[this.length];
/*     */       }
/*     */     }
/* 406 */     return this.datums;
/*     */   }
/*     */ 
/*     */   private void initNChar(int paramInt)
/*     */   {
/* 413 */     this.isNChar = new boolean[paramInt];
/* 414 */     for (int i = 0; i < paramInt; i++)
/* 415 */       this.isNChar[i] = false;
/*     */   }
/*     */ 
/*     */   public void setNChar(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 422 */     this.isNChar[paramInt] = true;
/*     */   }
/*     */ 
/*     */   public boolean isNChar(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 428 */     int i = this.isNChar[paramInt];
/* 429 */     return i;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jpub.runtime.MutableStruct
 * JD-Core Version:    0.6.2
 */