/*      */ package oracle.jpub.runtime;
/*      */ 
/*      */ import java.math.BigDecimal;
/*      */ import java.sql.Connection;
/*      */ import java.sql.Date;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Timestamp;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.sql.ARRAY;
/*      */ import oracle.sql.ArrayDescriptor;
/*      */ import oracle.sql.BFILE;
/*      */ import oracle.sql.BINARY_DOUBLE;
/*      */ import oracle.sql.BINARY_FLOAT;
/*      */ import oracle.sql.BLOB;
/*      */ import oracle.sql.CHAR;
/*      */ import oracle.sql.CLOB;
/*      */ import oracle.sql.CustomDatum;
/*      */ import oracle.sql.CustomDatumFactory;
/*      */ import oracle.sql.DATE;
/*      */ import oracle.sql.Datum;
/*      */ import oracle.sql.INTERVALDS;
/*      */ import oracle.sql.INTERVALYM;
/*      */ import oracle.sql.NCLOB;
/*      */ import oracle.sql.NUMBER;
/*      */ import oracle.sql.ORAData;
/*      */ import oracle.sql.ORADataFactory;
/*      */ import oracle.sql.RAW;
/*      */ import oracle.sql.TIMESTAMP;
/*      */ import oracle.sql.TIMESTAMPLTZ;
/*      */ import oracle.sql.TIMESTAMPTZ;
/*      */ 
/*      */ public class MutableArray
/*      */ {
/*      */   int length;
/*      */   Object[] elements;
/*      */   Datum[] datums;
/*      */   ARRAY pickled;
/*      */   boolean pickledCorrect;
/*      */   int sqlType;
/*      */   ORADataFactory factory;
/*      */   CustomDatumFactory old_factory;
/*      */   boolean isNChar;
/* 1199 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public MutableArray(int paramInt, ARRAY paramARRAY, ORADataFactory paramORADataFactory)
/*      */   {
/*   73 */     this.length = -1;
/*   74 */     this.elements = null;
/*   75 */     this.datums = null;
/*   76 */     this.pickled = paramARRAY;
/*   77 */     this.pickledCorrect = true;
/*   78 */     this.isNChar = false;
/*   79 */     this.sqlType = paramInt;
/*   80 */     this.factory = paramORADataFactory;
/*      */   }
/*      */ 
/*      */   public MutableArray(int paramInt, Datum[] paramArrayOfDatum, ORADataFactory paramORADataFactory)
/*      */   {
/*   87 */     this.sqlType = paramInt;
/*   88 */     this.factory = paramORADataFactory;
/*   89 */     this.isNChar = false;
/*      */ 
/*   91 */     setDatumArray(paramArrayOfDatum);
/*      */   }
/*      */ 
/*      */   public MutableArray(int paramInt, Object[] paramArrayOfObject, ORADataFactory paramORADataFactory)
/*      */   {
/*   98 */     this.sqlType = paramInt;
/*   99 */     this.factory = paramORADataFactory;
/*  100 */     this.isNChar = false;
/*      */ 
/*  102 */     setObjectArray(paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public MutableArray(int paramInt, double[] paramArrayOfDouble, ORADataFactory paramORADataFactory)
/*      */   {
/*  109 */     this.sqlType = paramInt;
/*  110 */     this.factory = paramORADataFactory;
/*  111 */     this.isNChar = false;
/*      */ 
/*  113 */     setArray(paramArrayOfDouble);
/*      */   }
/*      */ 
/*      */   public MutableArray(int paramInt, int[] paramArrayOfInt, ORADataFactory paramORADataFactory)
/*      */   {
/*  120 */     this.sqlType = paramInt;
/*  121 */     this.factory = paramORADataFactory;
/*  122 */     this.isNChar = false;
/*      */ 
/*  124 */     setArray(paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public MutableArray(int paramInt, float[] paramArrayOfFloat, ORADataFactory paramORADataFactory)
/*      */   {
/*  131 */     this.sqlType = paramInt;
/*  132 */     this.factory = paramORADataFactory;
/*  133 */     this.isNChar = false;
/*      */ 
/*  135 */     setArray(paramArrayOfFloat);
/*      */   }
/*      */ 
/*      */   public MutableArray(int paramInt, short[] paramArrayOfShort, ORADataFactory paramORADataFactory)
/*      */   {
/*  142 */     this.sqlType = paramInt;
/*  143 */     this.factory = paramORADataFactory;
/*  144 */     this.isNChar = false;
/*      */ 
/*  146 */     setArray(paramArrayOfShort);
/*      */   }
/*      */ 
/*      */   public MutableArray(ARRAY paramARRAY, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  153 */     this.length = -1;
/*  154 */     this.elements = null;
/*  155 */     this.datums = null;
/*  156 */     this.pickled = paramARRAY;
/*  157 */     this.pickledCorrect = true;
/*  158 */     this.sqlType = paramInt;
/*  159 */     this.old_factory = paramCustomDatumFactory;
/*  160 */     this.isNChar = false;
/*      */   }
/*      */ 
/*      */   public MutableArray(Datum[] paramArrayOfDatum, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  167 */     this.sqlType = paramInt;
/*  168 */     this.old_factory = paramCustomDatumFactory;
/*  169 */     this.isNChar = false;
/*      */ 
/*  171 */     setDatumArray(paramArrayOfDatum);
/*      */   }
/*      */ 
/*      */   public MutableArray(Object[] paramArrayOfObject, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  178 */     this.sqlType = paramInt;
/*  179 */     this.old_factory = paramCustomDatumFactory;
/*  180 */     this.isNChar = false;
/*      */ 
/*  182 */     setObjectArray(paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public MutableArray(double[] paramArrayOfDouble, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  189 */     this.sqlType = paramInt;
/*  190 */     this.old_factory = paramCustomDatumFactory;
/*  191 */     this.isNChar = false;
/*      */ 
/*  193 */     setArray(paramArrayOfDouble);
/*      */   }
/*      */ 
/*      */   public MutableArray(int[] paramArrayOfInt, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  200 */     this.sqlType = paramInt;
/*  201 */     this.old_factory = paramCustomDatumFactory;
/*  202 */     this.isNChar = false;
/*      */ 
/*  204 */     setArray(paramArrayOfInt);
/*      */   }
/*      */ 
/*      */   public MutableArray(float[] paramArrayOfFloat, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  211 */     this.sqlType = paramInt;
/*  212 */     this.old_factory = paramCustomDatumFactory;
/*  213 */     this.isNChar = false;
/*      */ 
/*  215 */     setArray(paramArrayOfFloat);
/*      */   }
/*      */ 
/*      */   public MutableArray(short[] paramArrayOfShort, int paramInt, CustomDatumFactory paramCustomDatumFactory)
/*      */   {
/*  222 */     this.sqlType = paramInt;
/*  223 */     this.old_factory = paramCustomDatumFactory;
/*  224 */     this.isNChar = false;
/*      */ 
/*  226 */     setArray(paramArrayOfShort);
/*      */   }
/*      */ 
/*      */   public Datum toDatum(Connection paramConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/*  235 */     if (!this.pickledCorrect)
/*      */     {
/*  239 */       this.pickled = new ARRAY(ArrayDescriptor.createDescriptor(paramString, paramConnection), paramConnection, getDatumArray(paramConnection));
/*      */ 
/*  241 */       this.pickledCorrect = true;
/*      */     }
/*  243 */     return this.pickled;
/*      */   }
/*      */ 
/*      */   public Datum toDatum(oracle.jdbc.OracleConnection paramOracleConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/*  251 */     return toDatum(paramOracleConnection, paramString);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Datum toDatum(oracle.jdbc.driver.OracleConnection paramOracleConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/*  262 */     return toDatum(paramOracleConnection, paramString);
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray()
/*      */     throws SQLException
/*      */   {
/*  270 */     return getOracleArray(0L, 2147483647);
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  281 */     int i = sliceLength(paramLong, paramInt);
/*      */ 
/*  283 */     if (i < 0) {
/*  284 */       return null;
/*      */     }
/*  286 */     Object localObject = null;
/*      */ 
/*  288 */     switch (this.sqlType)
/*      */     {
/*      */     case -13:
/*  292 */       localObject = new BFILE[i];
/*      */ 
/*  294 */       break;
/*      */     case 2004:
/*  297 */       localObject = new BLOB[i];
/*      */ 
/*  299 */       break;
/*      */     case 1:
/*      */     case 12:
/*  304 */       localObject = new CHAR[i];
/*      */ 
/*  306 */       break;
/*      */     case 2005:
/*  309 */       localObject = new CLOB[i];
/*      */ 
/*  311 */       break;
/*      */     case 91:
/*  314 */       localObject = new DATE[i];
/*      */ 
/*  316 */       break;
/*      */     case 93:
/*  319 */       localObject = new TIMESTAMP[i];
/*      */ 
/*  321 */       break;
/*      */     case -101:
/*  324 */       localObject = new TIMESTAMPTZ[i];
/*      */ 
/*  326 */       break;
/*      */     case -102:
/*  329 */       localObject = new TIMESTAMPLTZ[i];
/*      */ 
/*  331 */       break;
/*      */     case -104:
/*  334 */       localObject = new INTERVALDS[i];
/*      */ 
/*  336 */       break;
/*      */     case -103:
/*  339 */       localObject = new INTERVALYM[i];
/*      */ 
/*  341 */       break;
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*  356 */       localObject = new NUMBER[i];
/*      */ 
/*  358 */       break;
/*      */     case -2:
/*  361 */       localObject = new RAW[i];
/*      */ 
/*  363 */       break;
/*      */     case 100:
/*  366 */       localObject = new BINARY_FLOAT[i];
/*      */ 
/*  368 */       break;
/*      */     case 101:
/*  371 */       localObject = new BINARY_DOUBLE[i];
/*      */ 
/*  373 */       break;
/*      */     case 0:
/*      */     case 2002:
/*      */     case 2003:
/*      */     case 2006:
/*      */     case 2007:
/*  384 */       if (this.old_factory == null)
/*      */       {
/*  386 */         localObject = new ORAData[i];
/*      */       }
/*      */       else
/*      */       {
/*  390 */         localObject = new CustomDatum[i];
/*      */       }
/*      */ 
/*  393 */       break;
/*      */     case -15:
/*      */     case -9:
/*  397 */       setNChar();
/*  398 */       localObject = new CHAR[i];
/*  399 */       break;
/*      */     case 2011:
/*  402 */       localObject = new NCLOB[i];
/*  403 */       break;
/*      */     default:
/*  407 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 48);
/*  408 */       localSQLException.fillInStackTrace();
/*  409 */       throw localSQLException;
/*      */     }
/*      */ 
/*  413 */     return getOracleArray(paramLong, (Object[])localObject);
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray(long paramLong, Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  420 */     if (paramArrayOfObject == null) {
/*  421 */       return null;
/*      */     }
/*  423 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  424 */     int j = (int)paramLong;
/*      */ 
/*  426 */     if (i != paramArrayOfObject.length)
/*  427 */       return null;
/*      */     int k;
/*  429 */     if ((this.sqlType == 2002) || (this.sqlType == 2007) || (this.sqlType == 2003) || (this.sqlType == 2006) || (this.sqlType == 0))
/*      */     {
/*  433 */       if (this.old_factory == null)
/*      */       {
/*  435 */         for (k = 0; k < i; k++) {
/*  436 */           paramArrayOfObject[k] = this.factory.create(getDatumElement(j++, null), this.sqlType);
/*      */         }
/*      */       }
/*      */       else {
/*  440 */         for (k = 0; k < i; k++) {
/*  441 */           paramArrayOfObject[k] = this.old_factory.create(getDatumElement(j++, null), this.sqlType);
/*      */         }
/*      */       }
/*      */     }
/*      */     else {
/*  446 */       for (k = 0; k < i; k++)
/*  447 */         paramArrayOfObject[k] = getDatumElement(j++, null);
/*      */     }
/*  449 */     return paramArrayOfObject;
/*      */   }
/*      */ 
/*      */   public Object[] getOracleArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  456 */     return getOracleArray(0L, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray()
/*      */     throws SQLException
/*      */   {
/*  463 */     return getObjectArray(0L, 2147483647);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  469 */     int i = sliceLength(paramLong, paramInt);
/*      */ 
/*  471 */     if (i < 0)
/*  472 */       return null;
/*      */     Object localObject;
/*  477 */     switch (this.sqlType)
/*      */     {
/*      */     case -15:
/*      */     case -9:
/*      */     case 1:
/*      */     case 12:
/*  483 */       localObject = new String[i];
/*  484 */       break;
/*      */     case 91:
/*  487 */       localObject = new Date[i];
/*  488 */       break;
/*      */     case 93:
/*  491 */       localObject = new Timestamp[i];
/*  492 */       break;
/*      */     case 2:
/*      */     case 3:
/*  496 */       localObject = new BigDecimal[i];
/*  497 */       break;
/*      */     case 6:
/*      */     case 8:
/*  501 */       localObject = new Double[i];
/*  502 */       break;
/*      */     case 4:
/*      */     case 5:
/*  506 */       localObject = new Integer[i];
/*  507 */       break;
/*      */     case 7:
/*  510 */       localObject = new Float[i];
/*  511 */       break;
/*      */     case -2:
/*  514 */       localObject = new byte[i][];
/*  515 */       break;
/*      */     default:
/*  518 */       return getOracleArray(paramLong, paramInt);
/*      */     }
/*      */ 
/*  521 */     return getObjectArray(paramLong, (Object[])localObject);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray(long paramLong, Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  528 */     if (paramArrayOfObject == null) {
/*  529 */       return null;
/*      */     }
/*  531 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  532 */     int j = (int)paramLong;
/*      */ 
/*  534 */     if (i != paramArrayOfObject.length) {
/*  535 */       return null;
/*      */     }
/*  537 */     switch (this.sqlType)
/*      */     {
/*      */     case -15:
/*      */     case -9:
/*      */     case -2:
/*      */     case 1:
/*      */     case 2:
/*      */     case 3:
/*      */     case 4:
/*      */     case 5:
/*      */     case 6:
/*      */     case 7:
/*      */     case 8:
/*      */     case 12:
/*      */     case 91:
/*      */     case 93:
/*  555 */       for (int k = 0; k < i; k++) {
/*  556 */         paramArrayOfObject[k] = getObjectElement(j++);
/*      */       }
/*  558 */       return paramArrayOfObject;
/*      */     }
/*      */ 
/*  562 */     return getOracleArray(paramLong, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Object[] getObjectArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  570 */     return getObjectArray(0L, paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Object getArray()
/*      */     throws SQLException
/*      */   {
/*  577 */     return getArray(0L, 2147483647);
/*      */   }
/*      */ 
/*      */   public Object getArray(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  584 */     int i = sliceLength(paramLong, paramInt);
/*  585 */     int j = (int)paramLong;
/*      */ 
/*  587 */     if (i < 0)
/*  588 */       return null;
/*      */     Object localObject;
/*      */     int k;
/*  590 */     switch (this.sqlType)
/*      */     {
/*      */     case 6:
/*      */     case 8:
/*      */     case 101:
/*  599 */       localObject = new double[i];
/*      */ 
/*  601 */       for (k = 0; k < i; k++) {
/*  602 */         localObject[k] = ((Double)getObjectElement(j++)).doubleValue();
/*      */       }
/*  604 */       return localObject;
/*      */     case 100:
/*  609 */       localObject = new float[i];
/*      */ 
/*  611 */       for (k = 0; k < i; k++) {
/*  612 */         localObject[k] = ((Float)getObjectElement(j++)).floatValue();
/*      */       }
/*  614 */       return localObject;
/*      */     case 4:
/*  619 */       localObject = new int[i];
/*      */ 
/*  621 */       for (k = 0; k < i; k++) {
/*  622 */         localObject[k] = ((Integer)getObjectElement(j++)).intValue();
/*      */       }
/*  624 */       return localObject;
/*      */     case 5:
/*  629 */       localObject = new short[i];
/*      */ 
/*  631 */       for (k = 0; k < i; k++) {
/*  632 */         localObject[k] = ((short)((Integer)getObjectElement(j++)).intValue());
/*      */       }
/*  634 */       return localObject;
/*      */     case 7:
/*  639 */       localObject = new float[i];
/*      */ 
/*  641 */       for (k = 0; k < i; k++) {
/*  642 */         localObject[k] = ((Float)getObjectElement(j++)).floatValue();
/*      */       }
/*  644 */       return localObject;
/*      */     }
/*      */ 
/*  648 */     return getObjectArray(paramLong, paramInt);
/*      */   }
/*      */ 
/*      */   public void setOracleArray(Object[] paramArrayOfObject)
/*      */   {
/*  656 */     if ((this.factory == null) && (this.old_factory == null))
/*  657 */       setDatumArray((Datum[])paramArrayOfObject);
/*      */     else
/*  659 */       setObjectArray(paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public void setOracleArray(Object[] paramArrayOfObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  666 */     if ((this.factory == null) && (this.old_factory == null))
/*  667 */       setDatumArray((Datum[])paramArrayOfObject, paramLong);
/*      */     else
/*  669 */       setObjectArray(paramArrayOfObject, paramLong);
/*      */   }
/*      */ 
/*      */   public void setObjectArray(Object[] paramArrayOfObject)
/*      */   {
/*  676 */     if (paramArrayOfObject == null) {
/*  677 */       setNullArray();
/*      */     }
/*      */     else {
/*  680 */       setArrayGeneric(paramArrayOfObject.length);
/*      */ 
/*  682 */       this.elements = new Object[this.length];
/*      */ 
/*  684 */       for (int i = 0; i < this.length; i++)
/*  685 */         this.elements[i] = paramArrayOfObject[i];
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObjectArray(Object[] paramArrayOfObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  693 */     if (paramArrayOfObject == null) {
/*  694 */       return;
/*      */     }
/*  696 */     int i = sliceLength(paramLong, paramArrayOfObject.length);
/*  697 */     int j = (int)paramLong;
/*      */ 
/*  699 */     for (int k = 0; k < i; k++)
/*      */     {
/*  701 */       setObjectElement(paramArrayOfObject[k], j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(double[] paramArrayOfDouble)
/*      */   {
/*  709 */     if (paramArrayOfDouble == null) {
/*  710 */       setNullArray();
/*      */     }
/*      */     else {
/*  713 */       setArrayGeneric(paramArrayOfDouble.length);
/*      */ 
/*  715 */       this.elements = new Object[this.length];
/*      */ 
/*  717 */       for (int i = 0; i < this.length; i++)
/*  718 */         this.elements[i] = Double.valueOf(paramArrayOfDouble[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(double[] paramArrayOfDouble, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  726 */     if (paramArrayOfDouble == null) {
/*  727 */       return;
/*      */     }
/*  729 */     int i = sliceLength(paramLong, paramArrayOfDouble.length);
/*  730 */     int j = (int)paramLong;
/*      */ 
/*  732 */     for (int k = 0; k < i; k++)
/*      */     {
/*  734 */       setObjectElement(Double.valueOf(paramArrayOfDouble[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(int[] paramArrayOfInt)
/*      */   {
/*  742 */     if (paramArrayOfInt == null) {
/*  743 */       setNullArray();
/*      */     }
/*      */     else {
/*  746 */       setArrayGeneric(paramArrayOfInt.length);
/*      */ 
/*  748 */       this.elements = new Object[this.length];
/*      */ 
/*  750 */       for (int i = 0; i < this.length; i++)
/*  751 */         this.elements[i] = Integer.valueOf(paramArrayOfInt[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(int[] paramArrayOfInt, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  759 */     if (paramArrayOfInt == null) {
/*  760 */       return;
/*      */     }
/*  762 */     int i = sliceLength(paramLong, paramArrayOfInt.length);
/*  763 */     int j = (int)paramLong;
/*      */ 
/*  765 */     for (int k = 0; k < i; k++)
/*      */     {
/*  767 */       setObjectElement(Integer.valueOf(paramArrayOfInt[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(float[] paramArrayOfFloat)
/*      */   {
/*  775 */     if (paramArrayOfFloat == null) {
/*  776 */       setNullArray();
/*      */     }
/*      */     else {
/*  779 */       setArrayGeneric(paramArrayOfFloat.length);
/*      */ 
/*  781 */       this.elements = new Object[this.length];
/*      */ 
/*  783 */       for (int i = 0; i < this.length; i++)
/*  784 */         this.elements[i] = Float.valueOf(paramArrayOfFloat[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(float[] paramArrayOfFloat, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  792 */     if (paramArrayOfFloat == null) {
/*  793 */       return;
/*      */     }
/*  795 */     int i = sliceLength(paramLong, paramArrayOfFloat.length);
/*  796 */     int j = (int)paramLong;
/*      */ 
/*  798 */     for (int k = 0; k < i; k++)
/*      */     {
/*  800 */       setObjectElement(Float.valueOf(paramArrayOfFloat[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(short[] paramArrayOfShort)
/*      */   {
/*  808 */     if (paramArrayOfShort == null) {
/*  809 */       setNullArray();
/*      */     }
/*      */     else {
/*  812 */       setArrayGeneric(paramArrayOfShort.length);
/*      */ 
/*  814 */       this.elements = new Object[this.length];
/*      */ 
/*  816 */       for (int i = 0; i < this.length; i++)
/*  817 */         this.elements[i] = Integer.valueOf(paramArrayOfShort[i]);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setArray(short[] paramArrayOfShort, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  825 */     if (paramArrayOfShort == null) {
/*  826 */       return;
/*      */     }
/*  828 */     int i = sliceLength(paramLong, paramArrayOfShort.length);
/*  829 */     int j = (int)paramLong;
/*      */ 
/*  831 */     for (int k = 0; k < i; k++)
/*      */     {
/*  833 */       setObjectElement(Integer.valueOf(paramArrayOfShort[k]), j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object getObjectElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  841 */     Object localObject = getLazyArray()[((int)paramLong)];
/*      */ 
/*  843 */     if (localObject == null)
/*      */     {
/*      */       Datum localDatum;
/*  845 */       if (this.old_factory == null)
/*      */       {
/*  847 */         localDatum = getLazyOracleArray()[((int)paramLong)];
/*      */ 
/*  849 */         localObject = Util.convertToObject(localDatum, this.sqlType, this.factory);
/*  850 */         this.elements[((int)paramLong)] = localObject;
/*      */ 
/*  852 */         if (Util.isMutable(localDatum, this.factory))
/*  853 */           resetOracleElement(paramLong);
/*      */       }
/*      */       else
/*      */       {
/*  857 */         localDatum = getLazyOracleArray()[((int)paramLong)];
/*      */ 
/*  859 */         localObject = Util.convertToObject(localDatum, this.sqlType, this.old_factory);
/*  860 */         this.elements[((int)paramLong)] = localObject;
/*      */ 
/*  862 */         if (Util.isMutable(localDatum, this.old_factory)) {
/*  863 */           resetOracleElement(paramLong);
/*      */         }
/*      */       }
/*      */     }
/*  867 */     return localObject;
/*      */   }
/*      */ 
/*      */   public Object getOracleElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  874 */     if ((this.factory == null) && (this.old_factory == null))
/*      */     {
/*  876 */       Datum localDatum = getDatumElement(paramLong, null);
/*      */ 
/*  878 */       if (Util.isMutable(localDatum, this.factory)) {
/*  879 */         this.pickledCorrect = false;
/*      */       }
/*  881 */       return localDatum;
/*      */     }
/*      */ 
/*  884 */     return getObjectElement(paramLong);
/*      */   }
/*      */ 
/*      */   public void setObjectElement(Object paramObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  900 */     if (paramObject == null)
/*      */     {
/*  902 */       getLazyOracleArray();
/*      */     }
/*      */ 
/*  905 */     resetOracleElement(paramLong);
/*      */ 
/*  907 */     getLazyArray()[((int)paramLong)] = paramObject;
/*      */   }
/*      */ 
/*      */   public void setOracleElement(Object paramObject, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  914 */     if ((this.factory == null) && (this.old_factory == null))
/*  915 */       setDatumElement((Datum)paramObject, paramLong);
/*      */     else
/*  917 */       setObjectElement(paramObject, paramLong);
/*      */   }
/*      */ 
/*      */   public String getBaseTypeName()
/*      */     throws SQLException
/*      */   {
/*  924 */     return this.pickled.getBaseTypeName();
/*      */   }
/*      */ 
/*      */   public int getBaseType()
/*      */     throws SQLException
/*      */   {
/*  931 */     return this.pickled.getBaseType();
/*      */   }
/*      */ 
/*      */   public ArrayDescriptor getDescriptor()
/*      */     throws SQLException
/*      */   {
/*  938 */     return this.pickled.getDescriptor();
/*      */   }
/*      */ 
/*      */   Datum[] getDatumArray(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  945 */     if (this.length < 0) {
/*  946 */       getLazyOracleArray();
/*      */     }
/*  948 */     if (this.datums == null) {
/*  949 */       return null;
/*      */     }
/*  951 */     Datum[] arrayOfDatum = new Datum[this.length];
/*      */ 
/*  953 */     for (int i = 0; i < this.length; i++) {
/*  954 */       arrayOfDatum[i] = getDatumElement(i, paramConnection);
/*      */     }
/*  956 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   void setDatumArray(Datum[] paramArrayOfDatum)
/*      */   {
/*  963 */     if (paramArrayOfDatum == null) {
/*  964 */       setNullArray();
/*      */     }
/*      */     else {
/*  967 */       this.length = paramArrayOfDatum.length;
/*  968 */       this.elements = null;
/*  969 */       this.datums = ((Datum[])paramArrayOfDatum.clone());
/*  970 */       this.pickled = null;
/*  971 */       this.pickledCorrect = false;
/*      */     }
/*      */   }
/*      */ 
/*      */   void setDatumArray(Datum[] paramArrayOfDatum, long paramLong)
/*      */     throws SQLException
/*      */   {
/*  979 */     if (paramArrayOfDatum == null) {
/*  980 */       return;
/*      */     }
/*  982 */     int i = sliceLength(paramLong, paramArrayOfDatum.length);
/*  983 */     int j = (int)paramLong;
/*      */ 
/*  985 */     for (int k = 0; k < i; k++)
/*      */     {
/*  987 */       setDatumElement(paramArrayOfDatum[k], j++);
/*      */     }
/*      */   }
/*      */ 
/*      */   Datum getDatumElement(long paramLong, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  995 */     Datum localDatum = getLazyOracleArray()[((int)paramLong)];
/*      */ 
/*  997 */     if (localDatum == null)
/*      */     {
/*  999 */       Object localObject = getLazyArray()[((int)paramLong)];
/*      */ 
/* 1005 */       localDatum = Util.convertToOracle(localObject, paramConnection, this.isNChar);
/* 1006 */       this.datums[((int)paramLong)] = localDatum;
/*      */     }
/* 1008 */     return localDatum;
/*      */   }
/*      */ 
/*      */   void setDatumElement(Datum paramDatum, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1015 */     resetElement(paramLong);
/*      */ 
/* 1017 */     getLazyOracleArray()[((int)paramLong)] = paramDatum;
/* 1018 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   void resetElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1025 */     if (this.elements != null)
/*      */     {
/* 1027 */       this.elements[((int)paramLong)] = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   void setNullArray()
/*      */   {
/* 1035 */     this.length = -1;
/* 1036 */     this.elements = null;
/* 1037 */     this.datums = null;
/* 1038 */     this.pickled = null;
/* 1039 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   void setArrayGeneric(int paramInt)
/*      */   {
/* 1046 */     this.length = paramInt;
/* 1047 */     this.datums = new Datum[paramInt];
/* 1048 */     this.pickled = null;
/* 1049 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   public int length()
/*      */     throws SQLException
/*      */   {
/* 1056 */     if (this.length < 0) {
/* 1057 */       getLazyOracleArray();
/*      */     }
/* 1059 */     return this.length;
/*      */   }
/*      */ 
/*      */   public int sliceLength(long paramLong, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1066 */     if (this.length < 0) {
/* 1067 */       getLazyOracleArray();
/*      */     }
/* 1069 */     if (paramLong < 0L) {
/* 1070 */       return (int)paramLong;
/*      */     }
/* 1072 */     return Math.min(this.length - (int)paramLong, paramInt);
/*      */   }
/*      */ 
/*      */   void resetOracleElement(long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1079 */     if (this.datums != null)
/*      */     {
/* 1081 */       this.datums[((int)paramLong)] = null;
/*      */     }
/*      */ 
/* 1089 */     this.pickledCorrect = false;
/*      */   }
/*      */ 
/*      */   Object[] getLazyArray()
/*      */     throws SQLException
/*      */   {
/* 1096 */     if (this.length == -1) {
/* 1097 */       getLazyOracleArray();
/*      */     }
/* 1099 */     if (this.elements == null)
/*      */     {
/* 1101 */       this.elements = new Object[this.length];
/*      */     }
/*      */ 
/* 1104 */     return this.elements;
/*      */   }
/*      */ 
/*      */   Datum[] getLazyOracleArray()
/*      */     throws SQLException
/*      */   {
/* 1111 */     if (this.datums == null)
/*      */     {
/* 1115 */       if (this.pickled != null)
/*      */       {
/* 1119 */         this.datums = ((Datum[])this.pickled.getOracleArray());
/* 1120 */         this.length = this.datums.length;
/* 1121 */         this.pickledCorrect = true;
/*      */ 
/* 1127 */         if (this.elements != null)
/*      */         {
/* 1129 */           for (int i = 0; i < this.length; i++)
/*      */           {
/* 1131 */             if (this.elements[i] != null)
/*      */             {
/* 1133 */               this.datums[i] = null;
/* 1134 */               this.pickledCorrect = false;
/*      */             }
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/* 1141 */       else if (this.length >= 0) {
/* 1142 */         this.datums = new Datum[this.length];
/*      */       }
/*      */     }
/* 1145 */     return this.datums;
/*      */   }
/*      */ 
/*      */   public void setNChar()
/*      */   {
/* 1152 */     this.isNChar = true;
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1167 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.jpub.runtime.MutableArray
 * JD-Core Version:    0.6.2
 */